/*
 * Decompiled with CFR 0.152.
 */
package apple.applescript;

import apple.applescript.AppleScriptEngineFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;

public class AppleScriptEngine
implements ScriptEngine {
    private final ScriptEngineFactory factory;
    private ScriptContext context;

    private static native void initNative();

    private static native long createContextFrom(Object var0);

    private static native Object createObjectFrom(long var0);

    private static native void disposeContext(long var0);

    private static native long evalScript(String var0, long var1);

    private static native long evalScriptFromURL(String var0, long var1);

    static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec("/usr/bin/osascript");
        }
    }

    static void TRACE(String str) {
    }

    protected static String getEngine() {
        AppleScriptEngine.TRACE("getEngine()");
        return "AppleScriptEngine";
    }

    protected static String getEngineVersion() {
        AppleScriptEngine.TRACE("getEngineVersion()");
        return "1.1";
    }

    protected static String getName() {
        AppleScriptEngine.TRACE("getName()");
        return "AppleScriptEngine";
    }

    protected static String getLanguage() {
        AppleScriptEngine.TRACE("getLanguage()");
        return "AppleScript";
    }

    public AppleScriptEngine() {
        AppleScriptEngine.TRACE("<ctor>()");
        this.factory = AppleScriptEngineFactory.getFactory();
        this.setContext(new SimpleScriptContext());
        this.put("javax.script.argv", "");
        this.init();
    }

    public AppleScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.setContext(new SimpleScriptContext());
        this.put("javax.script.argv", "");
        this.init();
    }

    private void init() {
        AppleScriptEngine.TRACE("init()");
        this.put("javax.script.filename", "");
        this.put("javax.script.engine", AppleScriptEngine.getEngine());
        this.put("javax.script.engine_version", AppleScriptEngine.getEngineVersion());
        this.put("javax.script.name", AppleScriptEngine.getName());
        this.put("javax.script.language", AppleScriptEngine.getLanguage());
        this.put("javax.script.language_version", this.getLanguageVersion());
        this.put("THREADING", null);
    }

    protected String getLanguageVersion() {
        AppleScriptEngine.TRACE("AppleScriptEngine.getLanguageVersion()");
        try {
            Object result = this.eval("get the version of AppleScript");
            if (result instanceof String) {
                return (String)result;
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return "unknown";
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
        this.context = context;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        Bindings tmp = this.getContext().getBindings(100);
        this.getContext().setBindings(bindings, 100);
        Object retval = this.eval(reader);
        this.getContext().setBindings(tmp, 100);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Object object;
        int data;
        AppleScriptEngine.checkSecurity();
        File tmpfile = Files.createTempFile("AppleScriptEngine.", ".scpt", new FileAttribute[0]).toFile();
        FileWriter tmpwrite = new FileWriter(tmpfile);
        while ((data = reader.read()) != -1) {
            tmpwrite.write(data);
        }
        tmpwrite.close();
        long contextptr = this.scriptContextToNSDictionary(context);
        try {
            long retCtx = AppleScriptEngine.evalScriptFromURL("file://" + tmpfile.getCanonicalPath(), contextptr);
            Object retVal = retCtx == 0L ? null : AppleScriptEngine.createObjectFrom(retCtx);
            AppleScriptEngine.disposeContext(retCtx);
            object = retVal;
        }
        catch (Throwable throwable) {
            try {
                AppleScriptEngine.disposeContext(contextptr);
                tmpfile.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw new ScriptException(e);
            }
        }
        AppleScriptEngine.disposeContext(contextptr);
        tmpfile.delete();
        return object;
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.getContext());
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        Bindings tmp = this.getContext().getBindings(100);
        this.getContext().setBindings(bindings, 100);
        Object retval = this.eval(script);
        this.getContext().setBindings(tmp, 100);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        AppleScriptEngine.checkSecurity();
        long ctxPtr = this.scriptContextToNSDictionary(context);
        try {
            long retCtx = AppleScriptEngine.evalScript(script, ctxPtr);
            Object retVal = retCtx == 0L ? null : AppleScriptEngine.createObjectFrom(retCtx);
            AppleScriptEngine.disposeContext(retCtx);
            Object object = retVal;
            return object;
        }
        finally {
            AppleScriptEngine.disposeContext(ctxPtr);
        }
    }

    private long scriptContextToNSDictionary(ScriptContext context) throws ScriptException {
        HashMap contextAsMap = new HashMap();
        for (Map.Entry e : context.getBindings(100).entrySet()) {
            contextAsMap.put(((String)e.getKey()).replaceAll("\\.", "_"), e.getValue());
        }
        return AppleScriptEngine.createContextFrom(contextAsMap);
    }

    static {
        System.loadLibrary("AppleScriptEngine");
        AppleScriptEngine.initNative();
        AppleScriptEngine.TRACE("<static-init>");
    }
}

