/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class JRSUIControl {
    private static final int INCOHERENT = 2;
    private static final int NOT_INIT = 1;
    private static final int SUCCESS = 0;
    private static final int NULL_PTR = -1;
    private static final int NULL_CG_REF = -2;
    private static int nativeJRSInitialized = 1;
    private static final int NIO_BUFFER_SIZE = 128;
    private static final ThreadLocal<ThreadLocalByteBuffer> threadLocal = new ThreadLocal();
    private final HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue> nativeMap;
    private final HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue> changes;
    private long cfDictionaryPtr;
    private long priorEncodedProperties;
    private long currentEncodedProperties;
    private final boolean flipped;

    private static native int initNativeJRSUI();

    private static native long getPtrOfBuffer(ByteBuffer var0);

    private static native long getCFDictionary(boolean var0);

    private static native void disposeCFDictionary(long var0);

    private static native int syncChanges(long var0, long var2);

    private static native int paintToCGContext(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14);

    private static native int paintChangesToCGContext(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, long var16);

    private static native int paintImage(int[] var0, int var1, int var2, long var3, long var5, long var7, double var9, double var11, double var13, double var15);

    private static native int paintChangesImage(int[] var0, int var1, int var2, long var3, long var5, long var7, double var9, double var11, double var13, double var15, long var17);

    private static native int getNativeHitPart(long var0, long var2, long var4, double var6, double var8, double var10, double var12, double var14, double var16);

    private static native void getNativePartBounds(double[] var0, long var1, long var3, long var5, double var7, double var9, double var11, double var13, int var15);

    private static native double getNativeScrollBarOffsetChange(long var0, long var2, long var4, double var6, double var8, double var10, double var12, int var14, int var15, int var16);

    public static void initJRSUI() {
        if (nativeJRSInitialized == 0) {
            return;
        }
        nativeJRSInitialized = JRSUIControl.initNativeJRSUI();
        if (nativeJRSInitialized != 0) {
            throw new RuntimeException("JRSUI could not be initialized (" + nativeJRSInitialized + ").");
        }
    }

    private static ThreadLocalByteBuffer getThreadLocalBuffer() {
        ThreadLocalByteBuffer byteBuffer = threadLocal.get();
        if (byteBuffer != null) {
            return byteBuffer;
        }
        byteBuffer = new ThreadLocalByteBuffer();
        threadLocal.set(byteBuffer);
        return byteBuffer;
    }

    public JRSUIControl(boolean flipped) {
        this.flipped = flipped;
        this.cfDictionaryPtr = JRSUIControl.getCFDictionary(flipped);
        if (this.cfDictionaryPtr == 0L) {
            throw new RuntimeException("Unable to create native representation");
        }
        this.nativeMap = new HashMap();
        this.changes = new HashMap();
    }

    JRSUIControl(JRSUIControl other) {
        this.flipped = other.flipped;
        this.cfDictionaryPtr = JRSUIControl.getCFDictionary(this.flipped);
        if (this.cfDictionaryPtr == 0L) {
            throw new RuntimeException("Unable to create native representation");
        }
        this.nativeMap = new HashMap();
        this.changes = new HashMap<JRSUIConstants.Key, JRSUIConstants.DoubleValue>(other.nativeMap);
        this.changes.putAll(other.changes);
    }

    protected final synchronized void finalize() throws Throwable {
        if (this.cfDictionaryPtr == 0L) {
            return;
        }
        JRSUIControl.disposeCFDictionary(this.cfDictionaryPtr);
        this.cfDictionaryPtr = 0L;
    }

    private BufferState loadBufferWithChanges(ThreadLocalByteBuffer localByteBuffer) {
        ByteBuffer buffer = localByteBuffer.buffer;
        buffer.rewind();
        for (JRSUIConstants.Key key : new HashSet<JRSUIConstants.Key>(this.changes.keySet())) {
            int changeIndex = buffer.position();
            JRSUIConstants.DoubleValue value = this.changes.get(key);
            try {
                buffer.putLong(key.getConstantPtr());
                buffer.put(value.getTypeCode());
                value.putValueInBuffer(buffer);
            }
            catch (BufferOverflowException e) {
                return this.handleBufferOverflow(buffer, changeIndex);
            }
            catch (RuntimeException e) {
                System.err.println(this);
                throw e;
            }
            if (buffer.position() >= 120) {
                return this.handleBufferOverflow(buffer, changeIndex);
            }
            this.changes.remove(key);
            this.nativeMap.put(key, value);
        }
        buffer.putLong(0L);
        return BufferState.ALL_CHANGES_IN_BUFFER;
    }

    private BufferState handleBufferOverflow(ByteBuffer buffer, int changeIndex) {
        if (changeIndex == 0) {
            buffer.putLong(0, 0L);
            return BufferState.CHANGE_WONT_FIT_IN_BUFFER;
        }
        buffer.putLong(changeIndex, 0L);
        return BufferState.SOME_CHANGES_IN_BUFFER;
    }

    private synchronized void set(JRSUIConstants.Key key, JRSUIConstants.DoubleValue value) {
        JRSUIConstants.DoubleValue existingValue = this.nativeMap.get(key);
        if (existingValue != null && existingValue.equals(value)) {
            this.changes.remove(key);
            return;
        }
        this.changes.put(key, value);
    }

    public void set(JRSUIState state) {
        state.apply(this);
    }

    void setEncodedState(long state) {
        this.currentEncodedProperties = state;
    }

    void set(JRSUIConstants.Key key, double value) {
        this.set(key, new JRSUIConstants.DoubleValue(value));
    }

    public void paint(int[] data, int imgW, int imgH, double x, double y, double w, double h) {
        this.paintImage(data, imgW, imgH, x, y, w, h);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    private synchronized int paintImage(int[] data, int imgW, int imgH, double x, double y, double w, double h) {
        if (this.changes.isEmpty()) {
            return JRSUIControl.paintImage(data, imgW, imgH, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h);
        }
        ThreadLocalByteBuffer localByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(localByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            return JRSUIControl.paintChangesImage(data, imgW, imgH, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, localByteBuffer.ptr);
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int status = JRSUIControl.syncChanges(this.cfDictionaryPtr, localByteBuffer.ptr);
            if (status != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(localByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
        return JRSUIControl.paintChangesImage(data, imgW, imgH, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, localByteBuffer.ptr);
    }

    public void paint(long cgContext, double x, double y, double w, double h) {
        this.paintToCGContext(cgContext, x, y, w, h);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    private synchronized int paintToCGContext(long cgContext, double x, double y, double w, double h) {
        if (this.changes.isEmpty()) {
            return JRSUIControl.paintToCGContext(cgContext, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h);
        }
        ThreadLocalByteBuffer localByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(localByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            return JRSUIControl.paintChangesToCGContext(cgContext, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, localByteBuffer.ptr);
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int status = JRSUIControl.syncChanges(this.cfDictionaryPtr, localByteBuffer.ptr);
            if (status != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(localByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
        return JRSUIControl.paintChangesToCGContext(cgContext, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, localByteBuffer.ptr);
    }

    JRSUIConstants.Hit getHitForPoint(double x, double y, double w, double h, double hitX, double hitY) {
        this.sync();
        JRSUIConstants.Hit hit = JRSUIConstants.getHit(JRSUIControl.getNativeHitPart(this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, hitX, 2.0 * y + h - hitY));
        this.priorEncodedProperties = this.currentEncodedProperties;
        return hit;
    }

    void getPartBounds(double[] rect, double x, double y, double w, double h, int part) {
        if (rect == null) {
            throw new NullPointerException("Cannot load null rect");
        }
        if (rect.length != 4) {
            throw new IllegalArgumentException("Rect must have four elements");
        }
        this.sync();
        JRSUIControl.getNativePartBounds(rect, this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, part);
        this.priorEncodedProperties = this.currentEncodedProperties;
    }

    double getScrollBarOffsetChange(double x, double y, double w, double h, int offset, int visibleAmount, int extent) {
        this.sync();
        double offsetChange = JRSUIControl.getNativeScrollBarOffsetChange(this.cfDictionaryPtr, this.priorEncodedProperties, this.currentEncodedProperties, x, y, w, h, offset, visibleAmount, extent);
        this.priorEncodedProperties = this.currentEncodedProperties;
        return offsetChange;
    }

    private void sync() {
        if (this.changes.isEmpty()) {
            return;
        }
        ThreadLocalByteBuffer localByteBuffer = JRSUIControl.getThreadLocalBuffer();
        BufferState bufferState = this.loadBufferWithChanges(localByteBuffer);
        if (bufferState == BufferState.ALL_CHANGES_IN_BUFFER) {
            int status = JRSUIControl.syncChanges(this.cfDictionaryPtr, localByteBuffer.ptr);
            if (status != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            return;
        }
        while (bufferState == BufferState.SOME_CHANGES_IN_BUFFER) {
            int status = JRSUIControl.syncChanges(this.cfDictionaryPtr, localByteBuffer.ptr);
            if (status != 0) {
                throw new RuntimeException("JRSUI failed to sync changes into the native buffer: " + this);
            }
            bufferState = this.loadBufferWithChanges(localByteBuffer);
        }
        if (bufferState == BufferState.CHANGE_WONT_FIT_IN_BUFFER) {
            throw new RuntimeException("JRSUI failed to sync changes to the native buffer, because some change was too big: " + this);
        }
    }

    public int hashCode() {
        int bits = (int)(this.currentEncodedProperties ^ this.currentEncodedProperties >>> 32);
        bits ^= this.nativeMap.hashCode();
        return bits ^= this.changes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JRSUIControl)) {
            return false;
        }
        JRSUIControl other = (JRSUIControl)obj;
        if (this.currentEncodedProperties != other.currentEncodedProperties) {
            return false;
        }
        if (!this.nativeMap.equals(other.nativeMap)) {
            return false;
        }
        return this.changes.equals(other.changes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JRSUIControl[inNative:");
        builder.append(Arrays.toString(this.nativeMap.entrySet().toArray()));
        builder.append(", changes:");
        builder.append(Arrays.toString(this.changes.entrySet().toArray()));
        builder.append("]");
        return builder.toString();
    }

    static enum BufferState {
        NO_CHANGE,
        ALL_CHANGES_IN_BUFFER,
        SOME_CHANGES_IN_BUFFER,
        CHANGE_WONT_FIT_IN_BUFFER;

    }

    private static class ThreadLocalByteBuffer {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(128);
        final long ptr;

        public ThreadLocalByteBuffer() {
            this.buffer.order(ByteOrder.nativeOrder());
            this.ptr = JRSUIControl.getPtrOfBuffer(this.buffer);
        }
    }
}

