/*
 * Decompiled with CFR 0.152.
 */
package apple.launcher;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import sun.misc.Launcher;

class JavaAppLauncher
implements Runnable {
    static final String kJavaFailureMainClassNotSpecified = "MainClassNotSpecified";
    static final String kJavaFailureMainClassNotFound = "CannotLoadMainClass";
    static final String kJavaFailureMainClassHasNoMain = "NoMainMethod";
    static final String kJavaFailureMainClassMainNotStatic = "MainNotStatic";
    static final String kJavaFailureMainThrewException = "MainThrewException";
    static final String kJavaFailureMainInitializerException = "MainInitializerException";
    final boolean verbose;
    final Map<String, ?> javaDictionary;

    private static native <T> T nativeConvertAndRelease(long var0);

    private static native void nativeInvokeNonPublic(Class<? extends Method> var0, Method var1, String[] var2);

    static void launch(long javaDictionaryPtr, boolean verbose) {
        Map javaDictionary = (Map)JavaAppLauncher.nativeConvertAndRelease(javaDictionaryPtr);
        new JavaAppLauncher(javaDictionary, verbose).run();
    }

    JavaAppLauncher(Map<String, ?> javaDictionary, boolean verbose) {
        this.verbose = verbose;
        this.javaDictionary = javaDictionary;
    }

    @Override
    public void run() {
        block6: {
            Method m = this.loadMainMethod(this.getMainMethod());
            String methodName = m.getDeclaringClass().getName() + ".main(String[])";
            try {
                this.log("Calling " + methodName + " method");
                m.invoke(null, new Object[]{this.getArguments()});
                this.log(methodName + " has returned");
            }
            catch (IllegalAccessException x) {
                try {
                    JavaAppLauncher.nativeInvokeNonPublic(m.getClass(), m, this.getArguments());
                }
                catch (Throwable excpt) {
                    JavaAppLauncher.logError(methodName + " threw an exception:");
                    if (excpt instanceof UnsatisfiedLinkError && excpt.getMessage().equals("nativeInvokeNonPublic")) {
                        JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, "nativeInvokeNonPublic not registered");
                        break block6;
                    }
                    excpt.printStackTrace();
                    JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, excpt.toString());
                }
            }
            catch (InvocationTargetException invokeExcpt) {
                JavaAppLauncher.logError(methodName + " threw an exception:");
                invokeExcpt.getTargetException().printStackTrace();
                JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainThrewException, invokeExcpt.getTargetException().toString());
            }
        }
    }

    Method loadMainMethod(String mainClassName) {
        try {
            Class<?> mainClass = Class.forName(mainClassName, true, Launcher.getLauncher().getClassLoader());
            Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
            if ((mainMethod.getModifiers() & 8) == 0) {
                JavaAppLauncher.logError("The main(String[]) method of class " + mainClassName + " is not static!");
                JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassMainNotStatic, mainClassName);
            }
            return mainMethod;
        }
        catch (ExceptionInInitializerError x) {
            JavaAppLauncher.logError("The main class \"" + mainClassName + "\" had a static initializer throw an exception.");
            x.getException().printStackTrace();
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainInitializerException, x.getException().toString());
        }
        catch (ClassNotFoundException x) {
            JavaAppLauncher.logError("The main class \"" + mainClassName + "\" could not be found.");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassNotFound, mainClassName);
        }
        catch (NoSuchMethodException x) {
            JavaAppLauncher.logError("The main class \"" + mainClassName + "\" has no static main(String[]) method.");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassHasNoMain, mainClassName);
        }
        catch (NullPointerException x) {
            JavaAppLauncher.logError("No main class specified");
            JavaAppLauncher.showFailureAlertAndKill(kJavaFailureMainClassNotSpecified, null);
        }
        return null;
    }

    String getMainMethod() {
        Object javaMain;
        Object javaJar = this.javaDictionary.get("Jar");
        if (javaJar != null) {
            if (!(javaJar instanceof String)) {
                JavaAppLauncher.logError("'Jar' key in 'Java' sub-dictionary of Info.plist requires a string value");
                return null;
            }
            String jarPath = (String)javaJar;
            if (jarPath.length() == 0) {
                this.log("'Jar' key of sub-dictionary 'Java' of Info.plist key is empty");
            } else {
                String main = this.getMainFromManifest(jarPath);
                if (main == null) {
                    JavaAppLauncher.logError("jar file '" + jarPath + "' does not have Main-Class: attribute in its manifest");
                    return null;
                }
                this.log("Main class " + main + " found in jar manifest");
                return main;
            }
        }
        if (!((javaMain = this.javaDictionary.get("MainClass")) instanceof String)) {
            JavaAppLauncher.logError("'MainClass' key in 'Java' sub-dictionary of Info.plist requires a string value");
            return null;
        }
        String main = (String)javaMain;
        if (main.length() == 0) {
            this.log("'MainClass' key of sub-dictionary 'Java' of Info.plist key is empty");
            return null;
        }
        this.log("Main class " + (String)javaMain + " found via 'MainClass' key of sub-dictionary 'Java' of Info.plist key");
        return (String)javaMain;
    }

    String[] getArguments() {
        Object javaArguments = this.javaDictionary.get("Arguments");
        if (javaArguments == null) {
            this.log("No arguments for main(String[]) specified");
            return new String[0];
        }
        if (javaArguments instanceof List) {
            List args = (List)javaArguments;
            int count = args.size();
            this.log("Arguments to main(String[" + count + "]):");
            String[] result = new String[count];
            for (int i = 0; i < count; ++i) {
                Object element = args.get(i);
                if (element instanceof String) {
                    result[i] = (String)element;
                } else {
                    JavaAppLauncher.logError("Found non-string in array");
                }
                this.log("   arg[" + i + "]=" + result[i]);
            }
            return result;
        }
        JavaAppLauncher.logError("'Arguments' key in 'Java' sub-dictionary of Info.plist requires a string value or an array of strings");
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getMainFromManifest(String jarpath) {
        JarFile jar2 = null;
        try {
            jar2 = new JarFile(jarpath);
            Manifest man = jar2.getManifest();
            Attributes attr = man.getMainAttributes();
            String string = attr.getValue("Main-Class");
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (jar2 != null) {
                try {
                    jar2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    void log(String s) {
        if (!this.verbose) {
            return;
        }
        System.out.println("[LaunchRunner] " + s);
    }

    static void logError(String s) {
        System.err.println("[LaunchRunner Error] " + s);
    }

    static void showFailureAlertAndKill(String msg, String arg) {
        if (arg == null) {
            arg = "<<null>>";
        }
        JOptionPane.showMessageDialog(null, JavaAppLauncher.getMessage(msg, arg), "", 0);
        System.exit(-1);
    }

    static String getMessage(String msgKey, Object ... args) {
        String msg = ResourceBundle.getBundle("appLauncherErrors").getString(msgKey);
        return MessageFormat.format(msg, args);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osx");
                return null;
            }
        });
    }
}

