/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitStrategy;
import com.apple.eawt._AppDockIconHandler;
import com.apple.eawt._AppEventHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._AppMiscHandlers;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.beans.Beans;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JMenuBar;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CPlatformWindow;

public class Application {
    static Application sApplication = null;
    final _AppEventHandler eventHandler = _AppEventHandler.getInstance();
    final _AppMenuBarHandler menuBarHandler = _AppMenuBarHandler.getInstance();
    final _AppDockIconHandler iconHandler = new _AppDockIconHandler();

    private static native void nativeInitializeApplicationDelegate();

    private static void checkSecurity() {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        security.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
    }

    public static Application getApplication() {
        Application.checkSecurity();
        return sApplication;
    }

    @Deprecated
    public Application() {
        Application.checkSecurity();
    }

    public void addAppEventListener(AppEventListener listener) {
        this.eventHandler.addListener(listener);
    }

    public void removeAppEventListener(AppEventListener listener) {
        this.eventHandler.removeListener(listener);
    }

    public void setAboutHandler(AboutHandler aboutHandler) {
        this.eventHandler.aboutDispatcher.setHandler(aboutHandler);
    }

    public void setPreferencesHandler(PreferencesHandler preferencesHandler) {
        this.eventHandler.preferencesDispatcher.setHandler(preferencesHandler);
    }

    public void setOpenFileHandler(OpenFilesHandler openFileHandler) {
        this.eventHandler.openFilesDispatcher.setHandler(openFileHandler);
    }

    public void setPrintFileHandler(PrintFilesHandler printFileHandler) {
        this.eventHandler.printFilesDispatcher.setHandler(printFileHandler);
    }

    public void setOpenURIHandler(OpenURIHandler openURIHandler) {
        this.eventHandler.openURIDispatcher.setHandler(openURIHandler);
    }

    public void setQuitHandler(QuitHandler quitHandler) {
        this.eventHandler.quitDispatcher.setHandler(quitHandler);
    }

    public void setQuitStrategy(QuitStrategy strategy) {
        this.eventHandler.setDefaultQuitStrategy(strategy);
    }

    public void enableSuddenTermination() {
        _AppMiscHandlers.enableSuddenTermination();
    }

    public void disableSuddenTermination() {
        _AppMiscHandlers.disableSuddenTermination();
    }

    public void requestForeground(boolean allWindows) {
        _AppMiscHandlers.requestActivation(allWindows);
    }

    public void requestUserAttention(boolean critical) {
        _AppMiscHandlers.requestUserAttention(critical);
    }

    public void openHelpViewer() {
        _AppMiscHandlers.openHelpViewer();
    }

    public void setDockMenu(PopupMenu menu) {
        this.iconHandler.setDockMenu(menu);
    }

    public PopupMenu getDockMenu() {
        return this.iconHandler.getDockMenu();
    }

    public void setDockIconImage(Image image) {
        this.iconHandler.setDockIconImage(image);
    }

    public Image getDockIconImage() {
        return this.iconHandler.getDockIconImage();
    }

    public void setDockIconBadge(String badge) {
        this.iconHandler.setDockIconBadge(badge);
    }

    public void setDefaultMenuBar(JMenuBar menuBar) {
        this.menuBarHandler.setDefaultMenuBar(menuBar);
    }

    public void requestToggleFullScreen(Window window) {
        ComponentPeer peer = window.getPeer();
        if (!(peer instanceof LWWindowPeer)) {
            return;
        }
        PlatformWindow platformWindow = ((LWWindowPeer)peer).getPlatformWindow();
        if (!(platformWindow instanceof CPlatformWindow)) {
            return;
        }
        ((CPlatformWindow)platformWindow).toggleFullScreen();
    }

    @Deprecated
    public void addApplicationListener(ApplicationListener listener) {
        this.eventHandler.legacyHandler.addLegacyAppListener(listener);
    }

    @Deprecated
    public void removeApplicationListener(ApplicationListener listener) {
        this.eventHandler.legacyHandler.removeLegacyAppListener(listener);
    }

    @Deprecated
    public void setEnabledPreferencesMenu(boolean enable) {
        this.menuBarHandler.setPreferencesMenuItemVisible(true);
        this.menuBarHandler.setPreferencesMenuItemEnabled(enable);
    }

    @Deprecated
    public void setEnabledAboutMenu(boolean enable) {
        this.menuBarHandler.setAboutMenuItemEnabled(enable);
    }

    @Deprecated
    public boolean getEnabledPreferencesMenu() {
        return this.menuBarHandler.isPreferencesMenuItemEnabled();
    }

    @Deprecated
    public boolean getEnabledAboutMenu() {
        return this.menuBarHandler.isAboutMenuItemEnabled();
    }

    @Deprecated
    public boolean isAboutMenuItemPresent() {
        return this.menuBarHandler.isAboutMenuItemVisible();
    }

    @Deprecated
    public void addAboutMenuItem() {
        this.menuBarHandler.setAboutMenuItemVisible(true);
    }

    @Deprecated
    public void removeAboutMenuItem() {
        this.menuBarHandler.setAboutMenuItemVisible(false);
    }

    @Deprecated
    public boolean isPreferencesMenuItemPresent() {
        return this.menuBarHandler.isPreferencesMenuItemVisible();
    }

    @Deprecated
    public void addPreferencesMenuItem() {
        this.menuBarHandler.setPreferencesMenuItemVisible(true);
    }

    @Deprecated
    public void removePreferencesMenuItem() {
        this.menuBarHandler.setPreferencesMenuItemVisible(false);
    }

    @Deprecated
    public static Point getMouseLocationOnScreen() {
        return MouseInfo.getPointerInfo().getLocation();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
        Application.checkSecurity();
        if (!Beans.isDesignTime()) {
            Application.nativeInitializeApplicationDelegate();
        }
        sApplication = new Application();
    }
}

