/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.FullScreenHandler;
import com.apple.eawt.FullScreenListener;
import java.awt.Window;
import javax.swing.RootPaneContainer;

public final class FullScreenUtilities {
    FullScreenUtilities() {
    }

    public static void setWindowCanFullScreen(Window window, boolean canFullScreen) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't mark a non-RootPaneContainer as full screen-able");
        }
        RootPaneContainer rpc = (RootPaneContainer)((Object)window);
        rpc.getRootPane().putClientProperty("apple.awt.fullscreenable", canFullScreen);
    }

    public static void addFullScreenListenerTo(Window window, FullScreenListener listener) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't attach FullScreenListener to a non-RootPaneContainer");
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        FullScreenHandler.addFullScreenListenerTo((RootPaneContainer)((Object)window), listener);
    }

    public static void removeFullScreenListenerFrom(Window window, FullScreenListener listener) {
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Can't remove FullScreenListener from non-RootPaneContainer");
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        FullScreenHandler.removeFullScreenListenerFrom((RootPaneContainer)((Object)window), listener);
    }
}

