/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppForegroundListener;
import com.apple.eawt.AppHiddenListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt.QuitStrategy;
import com.apple.eawt.ScreenSleepListener;
import com.apple.eawt.SystemSleepListener;
import com.apple.eawt.UserSessionListener;
import com.apple.eawt._AppEventLegacyHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._OpenAppHandler;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

class _AppEventHandler {
    private static final int NOTIFY_ABOUT = 1;
    private static final int NOTIFY_PREFS = 2;
    private static final int NOTIFY_OPEN_APP = 3;
    private static final int NOTIFY_REOPEN_APP = 4;
    private static final int NOTIFY_QUIT = 5;
    private static final int NOTIFY_SHUTDOWN = 6;
    private static final int NOTIFY_ACTIVE_APP_GAINED = 7;
    private static final int NOTIFY_ACTIVE_APP_LOST = 8;
    private static final int NOTIFY_APP_HIDDEN = 9;
    private static final int NOTIFY_APP_SHOWN = 10;
    private static final int NOTIFY_USER_SESSION_ACTIVE = 11;
    private static final int NOTIFY_USER_SESSION_INACTIVE = 12;
    private static final int NOTIFY_SCREEN_SLEEP = 13;
    private static final int NOTIFY_SCREEN_WAKE = 14;
    private static final int NOTIFY_SYSTEM_SLEEP = 15;
    private static final int NOTIFY_SYSTEM_WAKE = 16;
    private static final int REGISTER_USER_SESSION = 1;
    private static final int REGISTER_SCREEN_SLEEP = 2;
    private static final int REGISTER_SYSTEM_SLEEP = 3;
    static final _AppEventHandler instance = new _AppEventHandler();
    final _AboutDispatcher aboutDispatcher = new _AboutDispatcher();
    final _PreferencesDispatcher preferencesDispatcher = new _PreferencesDispatcher();
    final _OpenFileDispatcher openFilesDispatcher = new _OpenFileDispatcher();
    final _PrintFileDispatcher printFilesDispatcher = new _PrintFileDispatcher();
    final _OpenURIDispatcher openURIDispatcher = new _OpenURIDispatcher();
    final _QuitDispatcher quitDispatcher = new _QuitDispatcher();
    final _OpenAppDispatcher openAppDispatcher = new _OpenAppDispatcher();
    final _AppReOpenedDispatcher reOpenAppDispatcher = new _AppReOpenedDispatcher();
    final _AppForegroundDispatcher foregroundAppDispatcher = new _AppForegroundDispatcher();
    final _HiddenAppDispatcher hiddenAppDispatcher = new _HiddenAppDispatcher();
    final _UserSessionDispatcher userSessionDispatcher = new _UserSessionDispatcher();
    final _ScreenSleepDispatcher screenSleepDispatcher = new _ScreenSleepDispatcher();
    final _SystemSleepDispatcher systemSleepDispatcher = new _SystemSleepDispatcher();
    final _AppEventLegacyHandler legacyHandler = new _AppEventLegacyHandler(this);
    QuitStrategy defaultQuitAction = QuitStrategy.SYSTEM_EXIT_0;
    QuitResponse currentQuitResponse;

    private static native void nativeOpenCocoaAboutWindow();

    private static native void nativeReplyToAppShouldTerminate(boolean var0);

    private static native void nativeRegisterForNotification(int var0);

    static _AppEventHandler getInstance() {
        return instance;
    }

    _AppEventHandler() {
        String strategyProp = System.getProperty("apple.eawt.quitStrategy");
        if (strategyProp == null) {
            return;
        }
        if ("CLOSE_ALL_WINDOWS".equals(strategyProp)) {
            this.setDefaultQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        } else if ("SYSTEM_EXIT_O".equals(strategyProp)) {
            this.setDefaultQuitStrategy(QuitStrategy.SYSTEM_EXIT_0);
        } else {
            System.err.println("unrecognized apple.eawt.quitStrategy: " + strategyProp);
        }
    }

    void addListener(AppEventListener listener) {
        if (listener instanceof AppReOpenedListener) {
            this.reOpenAppDispatcher.addListener((AppReOpenedListener)listener);
        }
        if (listener instanceof AppForegroundListener) {
            this.foregroundAppDispatcher.addListener((AppForegroundListener)listener);
        }
        if (listener instanceof AppHiddenListener) {
            this.hiddenAppDispatcher.addListener((AppHiddenListener)listener);
        }
        if (listener instanceof UserSessionListener) {
            this.userSessionDispatcher.addListener((UserSessionListener)listener);
        }
        if (listener instanceof ScreenSleepListener) {
            this.screenSleepDispatcher.addListener((ScreenSleepListener)listener);
        }
        if (listener instanceof SystemSleepListener) {
            this.systemSleepDispatcher.addListener((SystemSleepListener)listener);
        }
    }

    void removeListener(AppEventListener listener) {
        if (listener instanceof AppReOpenedListener) {
            this.reOpenAppDispatcher.removeListener((AppReOpenedListener)listener);
        }
        if (listener instanceof AppForegroundListener) {
            this.foregroundAppDispatcher.removeListener((AppForegroundListener)listener);
        }
        if (listener instanceof AppHiddenListener) {
            this.hiddenAppDispatcher.removeListener((AppHiddenListener)listener);
        }
        if (listener instanceof UserSessionListener) {
            this.userSessionDispatcher.removeListener((UserSessionListener)listener);
        }
        if (listener instanceof ScreenSleepListener) {
            this.screenSleepDispatcher.removeListener((ScreenSleepListener)listener);
        }
        if (listener instanceof SystemSleepListener) {
            this.systemSleepDispatcher.removeListener((SystemSleepListener)listener);
        }
    }

    void openCocoaAboutWindow() {
        _AppEventHandler.nativeOpenCocoaAboutWindow();
    }

    void setDefaultQuitStrategy(QuitStrategy defaultQuitAction) {
        this.defaultQuitAction = defaultQuitAction;
    }

    synchronized QuitResponse obtainQuitResponse() {
        if (this.currentQuitResponse != null) {
            return this.currentQuitResponse;
        }
        this.currentQuitResponse = new QuitResponse(this);
        return this.currentQuitResponse;
    }

    synchronized void cancelQuit() {
        this.currentQuitResponse = null;
        _AppEventHandler.nativeReplyToAppShouldTerminate(false);
    }

    synchronized void performQuit() {
        this.currentQuitResponse = null;
        try {
            if (this.defaultQuitAction == QuitStrategy.SYSTEM_EXIT_0) {
                System.exit(0);
            }
            if (this.defaultQuitAction != QuitStrategy.CLOSE_ALL_WINDOWS) {
                throw new RuntimeException("Unknown quit action");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Frame[] allFrames = Frame.getFrames();
                    for (int i = allFrames.length - 1; i >= 0; --i) {
                        Frame frame = allFrames[i];
                        frame.dispatchEvent(new WindowEvent(frame, 201));
                    }
                }
            });
        }
        finally {
            _AppEventHandler.nativeReplyToAppShouldTerminate(false);
        }
    }

    private static void handlePrintFiles(List<String> filenames) {
        _AppEventHandler.instance.printFilesDispatcher.dispatch(new _NativeEvent(filenames));
    }

    private static void handleOpenFiles(List<String> filenames, String searchTerm) {
        _AppEventHandler.instance.openFilesDispatcher.dispatch(new _NativeEvent(filenames, searchTerm));
    }

    private static void handleOpenURI(String uri) {
        _AppEventHandler.instance.openURIDispatcher.dispatch(new _NativeEvent(uri));
    }

    private static void handleNativeNotification(int code) {
        switch (code) {
            case 1: {
                _AppEventHandler.instance.aboutDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 2: {
                _AppEventHandler.instance.preferencesDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 3: {
                _AppEventHandler.instance.openAppDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 4: {
                _AppEventHandler.instance.reOpenAppDispatcher.dispatch(new _NativeEvent(new Object[0]), new Object[0]);
                break;
            }
            case 5: {
                _AppEventHandler.instance.quitDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                _AppEventHandler.instance.foregroundAppDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 8: {
                _AppEventHandler.instance.foregroundAppDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 9: {
                _AppEventHandler.instance.hiddenAppDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 10: {
                _AppEventHandler.instance.hiddenAppDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 11: {
                _AppEventHandler.instance.userSessionDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 12: {
                _AppEventHandler.instance.userSessionDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 13: {
                _AppEventHandler.instance.screenSleepDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 14: {
                _AppEventHandler.instance.screenSleepDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 15: {
                _AppEventHandler.instance.systemSleepDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 16: {
                _AppEventHandler.instance.systemSleepDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            default: {
                System.err.println("EAWT unknown native notification: " + code);
            }
        }
    }

    abstract class _QueuingAppEventDispatcher<H>
    extends _AppEventDispatcher<H> {
        List<_NativeEvent> queuedEvents;

        _QueuingAppEventDispatcher() {
            this.queuedEvents = new LinkedList<_NativeEvent>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch(_NativeEvent event) {
            _QueuingAppEventDispatcher _QueuingAppEventDispatcher2 = this;
            synchronized (_QueuingAppEventDispatcher2) {
                if (this.queuedEvents != null) {
                    this.queuedEvents.add(event);
                    return;
                }
            }
            super.dispatch(event);
        }

        @Override
        synchronized void setHandler(H handler) {
            this._handler = handler;
            this.setHandlerContext(AppContext.getAppContext());
            if (this.queuedEvents != null) {
                List<_NativeEvent> localQueuedEvents = this.queuedEvents;
                this.queuedEvents = null;
                if (localQueuedEvents.size() != 0) {
                    for (_NativeEvent arg : localQueuedEvents) {
                        this.dispatch(arg);
                    }
                }
            }
            if (handler == _AppEventHandler.this.legacyHandler) {
                return;
            }
            _AppEventHandler.this.legacyHandler.blockLegacyAPI();
        }
    }

    abstract class _AppEventDispatcher<H> {
        H _handler;
        AppContext handlerContext;

        _AppEventDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(final _NativeEvent event) {
            AppContext localHandlerContext;
            H localHandler;
            _AppEventDispatcher _AppEventDispatcher2 = this;
            synchronized (_AppEventDispatcher2) {
                localHandler = this._handler;
                localHandlerContext = this.handlerContext;
            }
            if (localHandler == null) {
                this.performDefaultAction(event);
            } else {
                SunToolkit.invokeLaterOnAppContext(localHandlerContext, new Runnable(){

                    @Override
                    public void run() {
                        _AppEventDispatcher.this.performUsing(localHandler, event);
                    }
                });
            }
        }

        synchronized void setHandler(H handler) {
            this._handler = handler;
            this.setHandlerContext(AppContext.getAppContext());
            if (handler == _AppEventHandler.this.legacyHandler) {
                return;
            }
            _AppEventHandler.this.legacyHandler.blockLegacyAPI();
        }

        void performDefaultAction(_NativeEvent event) {
        }

        abstract void performUsing(H var1, _NativeEvent var2);

        protected void setHandlerContext(AppContext ctx) {
            if (ctx == null) {
                throw new RuntimeException("Attempting to set a handler from a thread group without AppContext");
            }
            this.handlerContext = ctx;
        }
    }

    abstract class _BooleanAppEventMultiplexor<L, E>
    extends _AppEventMultiplexor<L> {
        _BooleanAppEventMultiplexor() {
        }

        @Override
        void performOnListener(L listener, _NativeEvent event) {
            boolean isTrue = Boolean.TRUE.equals(event.get(0));
            E e = this.createEvent(isTrue);
            if (isTrue) {
                this.performTrueEventOn(listener, e);
            } else {
                this.performFalseEventOn(listener, e);
            }
        }

        abstract E createEvent(boolean var1);

        abstract void performTrueEventOn(L var1, E var2);

        abstract void performFalseEventOn(L var1, E var2);
    }

    abstract class _AppEventMultiplexor<L> {
        private final Map<L, AppContext> listenerToAppContext = new IdentityHashMap<L, AppContext>();
        boolean nativeListenerRegistered;

        _AppEventMultiplexor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(final _NativeEvent event, Object ... args) {
            ArrayList<Map.Entry<L, AppContext>> localEntries;
            _AppEventMultiplexor _AppEventMultiplexor2 = this;
            synchronized (_AppEventMultiplexor2) {
                if (this.listenerToAppContext.size() == 0) {
                    return;
                }
                localEntries = new ArrayList<Map.Entry<L, AppContext>>(this.listenerToAppContext.size());
                localEntries.addAll(this.listenerToAppContext.entrySet());
            }
            for (Map.Entry entry : localEntries) {
                final Object listener = entry.getKey();
                AppContext listenerContext = (AppContext)entry.getValue();
                SunToolkit.invokeLaterOnAppContext(listenerContext, new Runnable(){

                    @Override
                    public void run() {
                        _AppEventMultiplexor.this.performOnListener(listener, event);
                    }
                });
            }
        }

        synchronized void addListener(L listener) {
            this.setListenerContext(listener, AppContext.getAppContext());
            if (!this.nativeListenerRegistered) {
                this.registerNativeListener();
                this.nativeListenerRegistered = true;
            }
        }

        synchronized void removeListener(L listener) {
            this.listenerToAppContext.remove(listener);
        }

        abstract void performOnListener(L var1, _NativeEvent var2);

        void registerNativeListener() {
        }

        private void setListenerContext(L listener, AppContext listenerContext) {
            if (listenerContext == null) {
                throw new RuntimeException("Attempting to add a listener from a thread group without AppContext");
            }
            this.listenerToAppContext.put(listener, AppContext.getAppContext());
        }
    }

    static class _NativeEvent {
        Object[] args;

        public _NativeEvent(Object ... args) {
            this.args = args;
        }

        <T> T get(int i) {
            if (this.args == null) {
                return null;
            }
            return (T)this.args[i];
        }
    }

    class _QuitDispatcher
    extends _AppEventDispatcher<QuitHandler> {
        _QuitDispatcher() {
        }

        @Override
        void performDefaultAction(_NativeEvent event) {
            _AppEventHandler.this.obtainQuitResponse().performQuit();
        }

        @Override
        void performUsing(QuitHandler handler, _NativeEvent event) {
            QuitResponse response = _AppEventHandler.this.obtainQuitResponse();
            handler.handleQuitRequestWith(new AppEvent.QuitEvent(), response);
        }
    }

    class _OpenURIDispatcher
    extends _QueuingAppEventDispatcher<OpenURIHandler> {
        _OpenURIDispatcher() {
        }

        @Override
        void performUsing(OpenURIHandler handler, _NativeEvent event) {
            String urlString = (String)event.get(0);
            try {
                handler.openURI(new AppEvent.OpenURIEvent(new URI(urlString)));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class _PrintFileDispatcher
    extends _QueuingAppEventDispatcher<PrintFilesHandler> {
        _PrintFileDispatcher() {
        }

        @Override
        void performUsing(PrintFilesHandler handler, _NativeEvent event) {
            List fileNameList = (List)event.get(0);
            ArrayList<File> files = new ArrayList<File>(fileNameList.size());
            for (String fileName : fileNameList) {
                files.add(new File(fileName));
            }
            handler.printFiles(new AppEvent.PrintFilesEvent(files));
        }
    }

    class _OpenFileDispatcher
    extends _QueuingAppEventDispatcher<OpenFilesHandler> {
        _OpenFileDispatcher() {
        }

        @Override
        void performUsing(OpenFilesHandler handler, _NativeEvent event) {
            List fileNameList = (List)event.get(0);
            ArrayList<File> files = new ArrayList<File>(fileNameList.size());
            for (String fileName : fileNameList) {
                files.add(new File(fileName));
            }
            String searchTerm = (String)event.get(1);
            handler.openFiles(new AppEvent.OpenFilesEvent(files, searchTerm));
        }
    }

    class _SystemSleepDispatcher
    extends _BooleanAppEventMultiplexor<SystemSleepListener, AppEvent.SystemSleepEvent> {
        _SystemSleepDispatcher() {
        }

        @Override
        AppEvent.SystemSleepEvent createEvent(boolean isTrue) {
            return new AppEvent.SystemSleepEvent();
        }

        @Override
        void performFalseEventOn(SystemSleepListener listener, AppEvent.SystemSleepEvent e) {
            listener.systemAwoke(e);
        }

        @Override
        void performTrueEventOn(SystemSleepListener listener, AppEvent.SystemSleepEvent e) {
            listener.systemAboutToSleep(e);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(3);
        }
    }

    class _ScreenSleepDispatcher
    extends _BooleanAppEventMultiplexor<ScreenSleepListener, AppEvent.ScreenSleepEvent> {
        _ScreenSleepDispatcher() {
        }

        @Override
        AppEvent.ScreenSleepEvent createEvent(boolean isTrue) {
            return new AppEvent.ScreenSleepEvent();
        }

        @Override
        void performFalseEventOn(ScreenSleepListener listener, AppEvent.ScreenSleepEvent e) {
            listener.screenAwoke(e);
        }

        @Override
        void performTrueEventOn(ScreenSleepListener listener, AppEvent.ScreenSleepEvent e) {
            listener.screenAboutToSleep(e);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(2);
        }
    }

    class _UserSessionDispatcher
    extends _BooleanAppEventMultiplexor<UserSessionListener, AppEvent.UserSessionEvent> {
        _UserSessionDispatcher() {
        }

        @Override
        AppEvent.UserSessionEvent createEvent(boolean isTrue) {
            return new AppEvent.UserSessionEvent();
        }

        @Override
        void performFalseEventOn(UserSessionListener listener, AppEvent.UserSessionEvent e) {
            listener.userSessionDeactivated(e);
        }

        @Override
        void performTrueEventOn(UserSessionListener listener, AppEvent.UserSessionEvent e) {
            listener.userSessionActivated(e);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(1);
        }
    }

    class _HiddenAppDispatcher
    extends _BooleanAppEventMultiplexor<AppHiddenListener, AppEvent.AppHiddenEvent> {
        _HiddenAppDispatcher() {
        }

        @Override
        AppEvent.AppHiddenEvent createEvent(boolean isTrue) {
            return new AppEvent.AppHiddenEvent();
        }

        @Override
        void performFalseEventOn(AppHiddenListener listener, AppEvent.AppHiddenEvent e) {
            listener.appUnhidden(e);
        }

        @Override
        void performTrueEventOn(AppHiddenListener listener, AppEvent.AppHiddenEvent e) {
            listener.appHidden(e);
        }
    }

    class _AppForegroundDispatcher
    extends _BooleanAppEventMultiplexor<AppForegroundListener, AppEvent.AppForegroundEvent> {
        _AppForegroundDispatcher() {
        }

        @Override
        AppEvent.AppForegroundEvent createEvent(boolean isTrue) {
            return new AppEvent.AppForegroundEvent();
        }

        @Override
        void performFalseEventOn(AppForegroundListener listener, AppEvent.AppForegroundEvent e) {
            listener.appMovedToBackground(e);
        }

        @Override
        void performTrueEventOn(AppForegroundListener listener, AppEvent.AppForegroundEvent e) {
            listener.appRaisedToForeground(e);
        }
    }

    class _AppReOpenedDispatcher
    extends _AppEventMultiplexor<AppReOpenedListener> {
        _AppReOpenedDispatcher() {
        }

        @Override
        void performOnListener(AppReOpenedListener listener, _NativeEvent event) {
            AppEvent.AppReOpenedEvent e = new AppEvent.AppReOpenedEvent();
            listener.appReOpened(e);
        }
    }

    class _OpenAppDispatcher
    extends _QueuingAppEventDispatcher<_OpenAppHandler> {
        _OpenAppDispatcher() {
        }

        @Override
        void performUsing(_OpenAppHandler handler, _NativeEvent event) {
            handler.handleOpenApp();
        }
    }

    class _PreferencesDispatcher
    extends _AppEventDispatcher<PreferencesHandler> {
        _PreferencesDispatcher() {
        }

        @Override
        synchronized void setHandler(PreferencesHandler handler) {
            super.setHandler(handler);
            _AppMenuBarHandler.getInstance().setPreferencesMenuItemVisible(handler != null);
            _AppMenuBarHandler.getInstance().setPreferencesMenuItemEnabled(handler != null);
        }

        @Override
        void performUsing(PreferencesHandler handler, _NativeEvent event) {
            handler.handlePreferences(new AppEvent.PreferencesEvent());
        }
    }

    class _AboutDispatcher
    extends _AppEventDispatcher<AboutHandler> {
        _AboutDispatcher() {
        }

        @Override
        void performDefaultAction(_NativeEvent event) {
            _AppEventHandler.this.openCocoaAboutWindow();
        }

        @Override
        void performUsing(AboutHandler handler, _NativeEvent event) {
            handler.handleAbout(new AppEvent.AboutEvent());
        }
    }
}

