/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt._AppEventHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._OpenAppHandler;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

class _AppEventLegacyHandler
implements AboutHandler,
PreferencesHandler,
_OpenAppHandler,
AppReOpenedListener,
OpenFilesHandler,
PrintFilesHandler,
QuitHandler {
    final _AppEventHandler parent;
    final Vector<ApplicationListener> legacyAppListeners = new Vector();
    boolean blockLegacyAPI;
    boolean initializedParentDispatchers;

    _AppEventLegacyHandler(_AppEventHandler parent) {
        this.parent = parent;
    }

    void blockLegacyAPI() {
        this.blockLegacyAPI = true;
    }

    void checkIfLegacyAPIBlocked() {
        if (!this.blockLegacyAPI) {
            return;
        }
        throw new IllegalStateException("Cannot add com.apple.eawt.ApplicationListener after installing an app event handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLegacyAppListener(ApplicationListener listener) {
        this.checkIfLegacyAPIBlocked();
        if (!this.initializedParentDispatchers) {
            _AppMenuBarHandler menuBarHandler = Application.getApplication().menuBarHandler;
            boolean prefsMenuAlreadyExplicitlySet = menuBarHandler.prefsMenuItemExplicitlySet;
            this.parent.aboutDispatcher.setHandler(this);
            this.parent.preferencesDispatcher.setHandler(this);
            if (!prefsMenuAlreadyExplicitlySet) {
                menuBarHandler.setPreferencesMenuItemVisible(false);
            }
            this.parent.openAppDispatcher.setHandler(this);
            this.parent.reOpenAppDispatcher.addListener(this);
            this.parent.openFilesDispatcher.setHandler(this);
            this.parent.printFilesDispatcher.setHandler(this);
            this.parent.quitDispatcher.setHandler(this);
            this.initializedParentDispatchers = true;
        }
        Vector<ApplicationListener> vector = this.legacyAppListeners;
        synchronized (vector) {
            this.legacyAppListeners.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLegacyAppListener(ApplicationListener listener) {
        this.checkIfLegacyAPIBlocked();
        Vector<ApplicationListener> vector = this.legacyAppListeners;
        synchronized (vector) {
            this.legacyAppListeners.removeElement(listener);
        }
    }

    @Override
    public void handleAbout(AppEvent.AboutEvent e) {
        final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener listener) {
                listener.handleAbout(ae);
            }
        });
        if (ae.isHandled()) {
            return;
        }
        this.parent.openCocoaAboutWindow();
    }

    @Override
    public void handlePreferences(AppEvent.PreferencesEvent e) {
        final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener listener) {
                listener.handlePreferences(ae);
            }
        });
    }

    @Override
    public void handleOpenApp() {
        final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener listener) {
                listener.handleOpenApplication(ae);
            }
        });
    }

    @Override
    public void appReOpened(AppEvent.AppReOpenedEvent e) {
        final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener listener) {
                listener.handleReOpenApplication(ae);
            }
        });
    }

    @Override
    public void openFiles(AppEvent.OpenFilesEvent e) {
        List<File> files = e.getFiles();
        for (File file : files) {
            final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit(), file.getAbsolutePath());
            this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

                @Override
                public void dispatchEvent(ApplicationListener listener) {
                    listener.handleOpenFile(ae);
                }
            });
        }
    }

    @Override
    public void printFiles(AppEvent.PrintFilesEvent e) {
        List<File> files = e.getFiles();
        for (File file : files) {
            final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit(), file.getAbsolutePath());
            this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

                @Override
                public void dispatchEvent(ApplicationListener listener) {
                    listener.handlePrintFile(ae);
                }
            });
        }
    }

    @Override
    public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse response) {
        final ApplicationEvent ae = new ApplicationEvent(Toolkit.getDefaultToolkit());
        this.sendEventToEachListenerUntilHandled(ae, new EventDispatcher(){

            @Override
            public void dispatchEvent(ApplicationListener listener) {
                listener.handleQuit(ae);
            }
        });
        if (ae.isHandled()) {
            this.parent.performQuit();
        } else {
            this.parent.cancelQuit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEventToEachListenerUntilHandled(ApplicationEvent event, EventDispatcher dispatcher) {
        Vector<ApplicationListener> vector = this.legacyAppListeners;
        synchronized (vector) {
            if (this.legacyAppListeners.size() == 0) {
                return;
            }
            Enumeration<ApplicationListener> e = this.legacyAppListeners.elements();
            while (e.hasMoreElements() && !event.isHandled()) {
                dispatcher.dispatchEvent(e.nextElement());
            }
        }
    }

    static interface EventDispatcher {
        public void dispatchEvent(ApplicationListener var1);
    }
}

