/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FileManager {
    public static final short kOnAppropriateDisk = -32767;
    public static final short kSystemDomain = -32766;
    public static final short kLocalDomain = -32765;
    public static final short kNetworkDomain = -32764;
    public static final short kUserDomain = -32763;

    public static int OSTypeToInt(String type) {
        int result = 0;
        byte[] b = new byte[]{0, 0, 0, 0};
        int len = type.length();
        if (len > 0) {
            if (len > 4) {
                len = 4;
            }
            type.getBytes(0, len, b, 4 - len);
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                result <<= 8;
            }
            result |= b[i] & 0xFF;
        }
        return result;
    }

    public static void setFileTypeAndCreator(String filename, int type, int creator) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(filename);
        }
        FileManager._setFileTypeAndCreator(filename, type, creator);
    }

    private static native void _setFileTypeAndCreator(String var0, int var1, int var2) throws IOException;

    public static void setFileType(String filename, int type) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(filename);
        }
        FileManager._setFileType(filename, type);
    }

    private static native void _setFileType(String var0, int var1) throws IOException;

    public static void setFileCreator(String filename, int creator) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(filename);
        }
        FileManager._setFileCreator(filename, creator);
    }

    private static native void _setFileCreator(String var0, int var1) throws IOException;

    public static int getFileType(String filename) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(filename);
        }
        return FileManager._getFileType(filename);
    }

    private static native int _getFileType(String var0) throws IOException;

    public static int getFileCreator(String filename) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(filename);
        }
        return FileManager._getFileCreator(filename);
    }

    private static native int _getFileCreator(String var0) throws IOException;

    public static String findFolder(int folderType) throws FileNotFoundException {
        return FileManager.findFolder((short)-32767, folderType);
    }

    public static String findFolder(short domain, int folderType) throws FileNotFoundException {
        return FileManager.findFolder(domain, folderType, false);
    }

    public static String findFolder(short domain, int folderType, boolean createIfNeeded) throws FileNotFoundException {
        String foundFolder;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canExamineFileSystem"));
        }
        if ((foundFolder = FileManager._findFolder(domain, folderType, createIfNeeded)) == null) {
            throw new FileNotFoundException("Can't find folder: " + Integer.toHexString(folderType));
        }
        return foundFolder;
    }

    private static native String _findFolder(short var0, int var1, boolean var2);

    @Deprecated
    public static void openURL(String url) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canOpenURLs"));
        }
        FileManager._openURL(url);
    }

    private static native void _openURL(String var0) throws IOException;

    public static String getResource(String resourceName) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(resourceName, null, null);
    }

    public static String getResource(String resourceName, String subDirName) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(resourceName, subDirName, null);
    }

    public static String getResource(String resourceName, String subDirName, String type) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(resourceName, subDirName, type);
    }

    private static native String getNativeResourceFromBundle(String var0, String var1, String var2) throws FileNotFoundException;

    private static String getResourceFromBundle(String resourceName, String subDirName, String type) throws FileNotFoundException {
        String resourceFromBundle;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canReadBundle"));
        }
        if ((resourceFromBundle = FileManager.getNativeResourceFromBundle(resourceName, subDirName, type)) == null) {
            throw new FileNotFoundException(resourceName);
        }
        return resourceFromBundle;
    }

    public static String getPathToApplicationBundle() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("canReadBundle"));
        }
        return FileManager.getNativePathToApplicationBundle();
    }

    private static native String getNativePathToApplicationBundle();

    public static boolean moveToTrash(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        String fileName = file.getAbsolutePath();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(fileName);
        }
        return FileManager._moveToTrash(fileName);
    }

    private static native boolean _moveToTrash(String var0);

    public static boolean revealInFinder(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        String fileName = file.getAbsolutePath();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(fileName);
        }
        return FileManager._revealInFinder(fileName);
    }

    private static native boolean _revealInFinder(String var0);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osx");
                return null;
            }
        });
    }
}

