/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class AquaBorder
implements Border,
UIResource {
    protected final AquaPainter<? extends JRSUIState> painter;
    protected final AquaUtilControlSize.SizeDescriptor sizeDescriptor;
    protected AquaUtilControlSize.SizeVariant sizeVariant;

    protected AquaBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        this.sizeDescriptor = sizeDescriptor;
        this.sizeVariant = sizeDescriptor.get(JRSUIConstants.Size.REGULAR);
        this.painter = this.createPainter();
    }

    protected AquaPainter<? extends JRSUIState> createPainter() {
        AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
        ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
        return painter;
    }

    protected AquaBorder(AquaBorder other) {
        this.sizeDescriptor = other.sizeDescriptor;
        this.sizeVariant = other.sizeVariant;
        this.painter = AquaPainter.create(((JRSUIState)other.painter.state).derive());
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
    }

    protected void setSize(JRSUIConstants.Size size) {
        this.sizeVariant = this.sizeDescriptor.get(size);
        ((JRSUIState)this.painter.state).set(size);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.sizeVariant.margins.clone();
    }

    protected AquaBorder deriveBorderForSize(JRSUIConstants.Size size) {
        try {
            Class<?> clazz = this.getClass();
            AquaBorder border = (AquaBorder)clazz.getConstructor(clazz).newInstance(this);
            border.setSize(size);
            return border;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void repaintBorder(JComponent c) {
        Container p;
        JComponent borderedComponent = c;
        Border border = c.getBorder();
        if (border == null && (p = c.getParent()) instanceof JViewport && (borderedComponent = (JComponent)p.getParent()) != null) {
            border = borderedComponent.getBorder();
        }
        if (border == null || borderedComponent == null) {
            return;
        }
        int width = borderedComponent.getWidth();
        int height = borderedComponent.getHeight();
        Insets i = borderedComponent.getInsets();
        borderedComponent.repaint(0, 0, width, i.top);
        borderedComponent.repaint(0, 0, i.left, height);
        borderedComponent.repaint(0, height - i.bottom, width, i.bottom);
        borderedComponent.repaint(width - i.right, 0, i.right, height);
    }

    protected boolean isFocused(Component c) {
        JViewport vp;
        Component focusable = c;
        if (c instanceof JScrollPane ? (vp = ((JScrollPane)c).getViewport()) != null && (focusable = vp.getView()) instanceof JTextComponent : focusable instanceof JTextComponent && !((JTextComponent)focusable).isEditable()) {
            return false;
        }
        return focusable != null && focusable instanceof JComponent && ((JComponent)focusable).hasFocus();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.painter.paint(g, c, x, y, w, h);
    }

    static class Default
    extends AquaBorder {
        Default() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant()));
        }
    }
}

