/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaComboBoxUI;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

class AquaComboBoxPopup
extends BasicComboPopup {
    static final int FOCUS_RING_PAD_LEFT = 6;
    static final int FOCUS_RING_PAD_RIGHT = 6;
    static final int FOCUS_RING_PAD_BOTTOM = 5;
    protected Component topStrut;
    protected Component bottomStrut;
    protected boolean isPopDown = false;

    public AquaComboBoxPopup(JComboBox cBox) {
        super(cBox);
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorderPainted(false);
        this.setBorder(null);
        this.updateContents(false);
        this.putClientProperty("apple.awt._windowFadeOut", new Integer(150));
    }

    public void updateContents(boolean remove) {
        this.isPopDown = this.isPopdown();
        if (this.isPopDown) {
            if (remove) {
                if (this.topStrut != null) {
                    this.remove(this.topStrut);
                }
                if (this.bottomStrut != null) {
                    this.remove(this.bottomStrut);
                }
            } else {
                this.add(this.scroller);
            }
        } else {
            if (this.topStrut == null) {
                this.topStrut = Box.createVerticalStrut(4);
                this.bottomStrut = Box.createVerticalStrut(4);
            }
            if (remove) {
                this.remove(this.scroller);
            }
            this.add(this.topStrut);
            this.add(this.scroller);
            this.add(this.bottomStrut);
        }
    }

    protected Dimension getBestPopupSizeForRowCount(int maxRowCount) {
        int currentElementCount = this.comboBox.getModel().getSize();
        int rowCount = Math.min(maxRowCount, currentElementCount);
        Dimension popupSize = new Dimension();
        ListCellRenderer renderer = this.list.getCellRenderer();
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.list.getModel().getElementAt(i);
            Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
            Dimension prefSize = c.getPreferredSize();
            popupSize.height += prefSize.height;
            popupSize.width = Math.max(prefSize.width, popupSize.width);
        }
        popupSize.width += 10;
        return popupSize;
    }

    protected boolean shouldScroll() {
        return this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
    }

    protected boolean isPopdown() {
        return this.shouldScroll() || AquaComboBoxUI.isPopdown(this.comboBox);
    }

    @Override
    public void show() {
        int startItemCount = this.comboBox.getItemCount();
        Rectangle popupBounds = this.adjustPopupAndGetBounds();
        if (popupBounds == null) {
            return;
        }
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.show(this.comboBox, popupBounds.x, popupBounds.y);
        int afterShowItemCount = this.comboBox.getItemCount();
        if (afterShowItemCount == 0) {
            this.hide();
            return;
        }
        if (startItemCount != afterShowItemCount) {
            Rectangle newBounds = this.adjustPopupAndGetBounds();
            this.list.setSize(newBounds.width, newBounds.height);
            this.pack();
            Point newLoc = this.comboBox.getLocationOnScreen();
            this.setLocation(newLoc.x + newBounds.x, newLoc.y + newBounds.y);
        }
        this.list.requestFocusInWindow();
    }

    @Override
    protected JList createList() {
        return new JList(this.comboBox.getModel()){

            @Override
            public void processMouseEvent(MouseEvent e) {
                if (e.isMetaDown()) {
                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 4, e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
                }
                super.processMouseEvent(e);
            }
        };
    }

    protected Rectangle adjustPopupAndGetBounds() {
        if (this.isPopDown != this.isPopdown()) {
            this.updateContents(true);
        }
        Dimension popupSize = this.getBestPopupSizeForRowCount(this.comboBox.getMaximumRowCount());
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        if (popupBounds == null) {
            return null;
        }
        Dimension realPopupSize = popupBounds.getSize();
        this.scroller.setMaximumSize(realPopupSize);
        this.scroller.setPreferredSize(realPopupSize);
        this.scroller.setMinimumSize(realPopupSize);
        this.list.invalidate();
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
        }
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        return popupBounds;
    }

    Rectangle getBestScreenBounds(Point p) {
        Rectangle gcBounds;
        GraphicsConfiguration[] gc;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle comboBoxBounds = this.comboBox.getBounds();
        if (gs.length == 1) {
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (p.x + comboBoxBounds.width < 0 || p.y + comboBoxBounds.height < 0 || p.x > scrSize.width || p.y > scrSize.height) {
                return null;
            }
            return new Rectangle(0, 22, scrSize.width, scrSize.height - 22);
        }
        for (GraphicsDevice gd : gs) {
            for (GraphicsConfiguration element0 : gc = gd.getConfigurations()) {
                gcBounds = element0.getBounds();
                if (!gcBounds.contains(p)) continue;
                return gcBounds;
            }
        }
        comboBoxBounds.setLocation(p);
        for (GraphicsDevice gd : gs) {
            for (GraphicsConfiguration element0 : gc = gd.getConfigurations()) {
                gcBounds = element0.getBounds();
                if (!gcBounds.intersects(comboBoxBounds)) continue;
                return gcBounds;
            }
        }
        return null;
    }

    @Override
    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        int itemCount = this.comboBox.getModel().getSize();
        boolean isPopdown = this.isPopdown();
        boolean isTableCellEditor = AquaComboBoxUI.isTableCellEditor(this.comboBox);
        if (isPopdown && !isTableCellEditor) {
            py = Math.min(py / 2 + 9, py);
        }
        Point p = new Point(0, 0);
        SwingUtilities.convertPointToScreen(p, this.comboBox);
        Rectangle scrBounds = this.getBestScreenBounds(p);
        if (scrBounds == null) {
            return super.computePopupBounds(px, py, pw, ph);
        }
        Insets comboBoxInsets = this.comboBox.getInsets();
        Rectangle comboBoxBounds = this.comboBox.getBounds();
        if (this.shouldScroll()) {
            pw += 15;
        }
        if (isPopdown) {
            pw += 4;
        }
        int minWidth = comboBoxBounds.width - (comboBoxInsets.left + comboBoxInsets.right);
        pw = Math.max(minWidth, pw);
        boolean leftToRight = AquaUtils.isLeftToRight(this.comboBox);
        if (leftToRight) {
            px += comboBoxInsets.left;
            if (!this.isPopDown) {
                px -= 6;
            }
        } else {
            px = comboBoxBounds.width - pw - comboBoxInsets.right;
            if (!this.isPopDown) {
                px += 6;
            }
        }
        p.x += px;
        p.y += (py -= comboBoxInsets.bottom);
        if (p.x < scrBounds.x) {
            px -= p.x + scrBounds.x;
        }
        if (p.y < scrBounds.y) {
            py -= p.y + scrBounds.y;
        }
        Point top = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(top, this.comboBox);
        int maxWidth = Math.min(scrBounds.width, top.x + scrBounds.x + scrBounds.width) - 2;
        pw = Math.min(maxWidth, pw);
        if (pw < minWidth) {
            px -= minWidth - pw;
            pw = minWidth;
        }
        if (!isPopdown) {
            return this.computePopupBoundsForMenu(px, py, pw -= 6, ph, itemCount, scrBounds);
        }
        if (!isTableCellEditor) {
            pw -= 12;
            if (leftToRight) {
                px += 6;
            }
        }
        Rectangle r = new Rectangle(px, py, pw, ph);
        if (r.y + r.height < top.y + scrBounds.y + scrBounds.height) {
            return r;
        }
        return new Rectangle(px, -r.height + comboBoxInsets.top, r.width, r.height);
    }

    protected Rectangle computePopupBoundsForMenu(int px, int py, int pw, int ph, int itemCount, Rectangle scrBounds) {
        boolean extendsOffscreenAtBottom;
        int offsetIndex;
        Rectangle cellBounds;
        int elementSize = 0;
        if (this.list != null && itemCount > 0 && (cellBounds = this.list.getCellBounds(0, 0)) != null) {
            elementSize = cellBounds.height;
        }
        if ((offsetIndex = this.comboBox.getSelectedIndex()) < 0) {
            offsetIndex = 0;
        }
        this.list.setSelectedIndex(offsetIndex);
        int selectedLocation = elementSize * offsetIndex;
        Point top = new Point(0, scrBounds.y);
        Point bottom = new Point(0, scrBounds.y + scrBounds.height - 20);
        SwingUtilities.convertPointFromScreen(top, this.comboBox);
        SwingUtilities.convertPointFromScreen(bottom, this.comboBox);
        Rectangle popupBounds = new Rectangle(px, py, pw, ph);
        int theRest = ph - selectedLocation;
        boolean extendsOffscreenAtTop = selectedLocation > -top.y;
        boolean bl = extendsOffscreenAtBottom = theRest > bottom.y;
        if (extendsOffscreenAtTop) {
            popupBounds.y = top.y + 1;
            popupBounds.y = popupBounds.y / elementSize * elementSize;
        } else {
            popupBounds.y = extendsOffscreenAtBottom ? bottom.y - popupBounds.height : -selectedLocation;
        }
        int height = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        int diff = (buttonSize - elementSize) / 2 + insets.top;
        popupBounds.y += diff - 5;
        return popupBounds;
    }
}

