/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaComboBoxRendererInternal;
import com.apple.laf.AquaFileSystemModel;
import com.apple.laf.AquaFileView;
import com.apple.laf.AquaGroupBorder;
import com.apple.laf.AquaTableHeaderBorder;
import com.apple.laf.AquaUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.SwingUtilities2;

public class AquaFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int chooseButtonMnemonic = 0;
    private String saveTitleText = null;
    private String openTitleText = null;
    String newFolderTitleText = null;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String newFolderButtonText = null;
    protected String chooseButtonText = null;
    String newFolderErrorText = null;
    String newFolderExistsErrorText = null;
    protected String fileDescriptionText = null;
    protected String directoryDescriptionText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String chooseItemButtonToolTipText = null;
    protected String chooseFolderButtonToolTipText = null;
    protected String directoryComboBoxToolTipText = null;
    protected String filenameTextFieldToolTipText = null;
    protected String filterComboBoxToolTipText = null;
    protected String openDirectoryButtonToolTipText = null;
    protected String cancelOpenButtonToolTipText = null;
    protected String cancelSaveButtonToolTipText = null;
    protected String cancelChooseButtonToolTipText = null;
    protected String cancelNewFolderButtonToolTipText = null;
    protected String desktopName = null;
    String newFolderDialogPrompt = null;
    String newFolderDefaultName = null;
    private String newFileDefaultName = null;
    String createButtonText = null;
    JFileChooser filechooser = null;
    private MouseListener doubleClickListener = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AncestorListener ancestorListener = null;
    private DropTarget dragAndDropTarget = null;
    private final AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private AquaFileSystemModel model;
    final AquaFileView fileView = new AquaFileView(this);
    boolean selectionInProgress = false;
    private JPanel accessoryPanel = null;
    JComboBox directoryComboBox;
    DirectoryComboBoxModel fDirectoryComboBoxModel;
    private final Action directoryComboBoxAction = new DirectoryComboBoxAction();
    JTextField filenameTextField;
    JTableExtension fFileList;
    private FilterComboBoxModel filterComboBoxModel;
    JComboBox filterComboBox;
    private final Action filterComboBoxAction = new FilterComboBoxAction();
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final int PREF_WIDTH = 550;
    private static final int PREF_HEIGHT = 400;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 250;
    private static final int LIST_MIN_WIDTH = 400;
    private static final int LIST_MIN_HEIGHT = 100;
    private static final Dimension LIST_MIN_SIZE = new Dimension(400, 100);
    static String fileNameLabelText = null;
    JLabel fTextFieldLabel = null;
    private static String filesOfTypeLabelText = null;
    private static String newFolderToolTipText = null;
    static String newFolderAccessibleName = null;
    private static final String[] fColumnNames = new String[2];
    JPanel fTextfieldPanel;
    private JPanel fDirectoryPanel;
    private Component fDirectoryPanelSpacer;
    private JPanel fBottomPanel;
    private FCSubpanel fSaveFilePanel = null;
    private FCSubpanel fOpenFilePanel = null;
    private FCSubpanel fOpenDirOrAnyPanel = null;
    private FCSubpanel fCustomFilePanel = null;
    private FCSubpanel fCustomDirOrAnyPanel = null;
    FCSubpanel fSubPanel = null;
    JButton fApproveButton;
    JButton fOpenButton;
    JButton fNewFolderButton;
    private JButton fCancelButton;
    private final ApproveSelectionAction fApproveSelectionAction = new ApproveSelectionAction();
    protected int fSortColumn = 0;
    protected int fPackageIsTraversable = -1;
    protected int fApplicationIsTraversable = -1;
    protected static final int sGlobalPackageIsTraversable;
    protected static final int sGlobalApplicationIsTraversable;
    protected static final String PACKAGE_TRAVERSABLE_PROPERTY = "JFileChooser.packageIsTraversable";
    protected static final String APPLICATION_TRAVERSABLE_PROPERTY = "JFileChooser.appBundleIsTraversable";
    protected static final String[] sTraversableProperties;
    protected static final int kOpenAlways = 0;
    protected static final int kOpenNever = 1;
    protected static final int kOpenConditional = 2;
    AbstractAction[] fButtonActions = new AbstractAction[]{this.fApproveSelectionAction, this.fApproveSelectionAction, new CancelSelectionAction(), new OpenSelectionAction(), null, new NewFolderAction()};
    static final String sDataPrefix = "FileChooser.";
    static final String[] sButtonKinds;
    static final String[] sButtonData;
    static final int kOpen = 0;
    static final int kSave = 1;
    static final int kCancel = 2;
    static final int kOpenDirectory = 3;
    static final int kHelp = 4;
    static final int kNewFolder = 5;

    public static ComponentUI createUI(JComponent c) {
        return new AquaFileChooserUI((JFileChooser)c);
    }

    public AquaFileChooserUI(JFileChooser filechooser) {
    }

    @Override
    public void installUI(JComponent c) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)c;
        this.createModel();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        AquaUtils.enforceComponentOrientation(this.filechooser, ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    protected void installListeners(JFileChooser fc) {
        this.doubleClickListener = this.createDoubleClickListener(fc, this.fFileList);
        this.fFileList.addMouseListener(this.doubleClickListener);
        this.propertyChangeListener = this.createPropertyChangeListener(fc);
        if (this.propertyChangeListener != null) {
            fc.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.model != null) {
            fc.addPropertyChangeListener(this.model);
        }
        this.ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                AquaFileChooserUI.this.setFocusForMode(AquaFileChooserUI.this.getFileChooser());
                AquaFileChooserUI.this.setDefaultButtonForMode(AquaFileChooserUI.this.getFileChooser());
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }
        };
        fc.addAncestorListener(this.ancestorListener);
        fc.registerKeyboardAction(new CancelSelectionAction(), KeyStroke.getKeyStroke(27, 0), 1);
        this.dragAndDropTarget = new DropTarget(fc, 1, new DnDHandler(), true);
        fc.setDropTarget(this.dragAndDropTarget);
    }

    protected void uninstallListeners(JFileChooser fc) {
        if (this.propertyChangeListener != null) {
            fc.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.fFileList.removeMouseListener(this.doubleClickListener);
        fc.removePropertyChangeListener(this.model);
        fc.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        fc.removeAncestorListener(this.ancestorListener);
        fc.setDropTarget(null);
        this.ancestorListener = null;
    }

    protected void installDefaults(JFileChooser fc) {
        this.installIcons(fc);
        this.installStrings(fc);
        this.setPackageIsTraversable(fc.getClientProperty(PACKAGE_TRAVERSABLE_PROPERTY));
        this.setApplicationIsTraversable(fc.getClientProperty(APPLICATION_TRAVERSABLE_PROPERTY));
    }

    protected void installIcons(JFileChooser fc) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
    }

    String getString(String uiKey, String fallback) {
        String result = UIManager.getString(uiKey);
        return result == null ? fallback : result;
    }

    protected void installStrings(JFileChooser fc) {
        this.fileDescriptionText = UIManager.getString("FileChooser.fileDescriptionText");
        this.directoryDescriptionText = UIManager.getString("FileChooser.directoryDescriptionText");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", "Error occurred during folder creation");
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.updateButtonText = UIManager.getString("FileChooser.updateButtonText");
        this.helpButtonText = UIManager.getString("FileChooser.helpButtonText");
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.chooseButtonMnemonic = UIManager.getInt("FileChooser.chooseButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
        this.openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelButtonToolTipText");
        this.updateButtonToolTipText = UIManager.getString("FileChooser.updateButtonToolTipText");
        this.helpButtonToolTipText = UIManager.getString("FileChooser.helpButtonToolTipText");
        this.saveTitleText = this.getString("FileChooser.saveTitleText", this.saveButtonText);
        this.openTitleText = this.getString("FileChooser.openTitleText", this.openButtonText);
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", "That name is already taken");
        this.chooseButtonText = this.getString("FileChooser.chooseButtonText", "Choose");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", "New");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", "New Folder");
        fileNameLabelText = fc.getDialogType() == 1 ? this.getString("FileChooser.saveDialogFileNameLabelText", "Save As:") : this.getString("FileChooser.fileNameLabelText", "Name:");
        filesOfTypeLabelText = this.getString("FileChooser.filesOfTypeLabelText", "Format:");
        this.desktopName = this.getString("FileChooser.desktopName", "Desktop");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", "untitled folder");
        this.newFileDefaultName = this.getString("FileChooser.untitledFileName", "untitled");
        this.createButtonText = this.getString("FileChooser.createButtonText", "Create");
        AquaFileChooserUI.fColumnNames[1] = this.getString("FileChooser.byDateText", "Date Modified");
        AquaFileChooserUI.fColumnNames[0] = this.getString("FileChooser.byNameText", "Name");
        this.chooseItemButtonToolTipText = UIManager.getString("FileChooser.chooseItemButtonToolTipText");
        this.chooseFolderButtonToolTipText = UIManager.getString("FileChooser.chooseFolderButtonToolTipText");
        this.openDirectoryButtonToolTipText = UIManager.getString("FileChooser.openDirectoryButtonToolTipText");
        this.directoryComboBoxToolTipText = UIManager.getString("FileChooser.directoryComboBoxToolTipText");
        this.filenameTextFieldToolTipText = UIManager.getString("FileChooser.filenameTextFieldToolTipText");
        this.filterComboBoxToolTipText = UIManager.getString("FileChooser.filterComboBoxToolTipText");
        this.cancelOpenButtonToolTipText = UIManager.getString("FileChooser.cancelOpenButtonToolTipText");
        this.cancelSaveButtonToolTipText = UIManager.getString("FileChooser.cancelSaveButtonToolTipText");
        this.cancelChooseButtonToolTipText = UIManager.getString("FileChooser.cancelChooseButtonToolTipText");
        this.cancelNewFolderButtonToolTipText = UIManager.getString("FileChooser.cancelNewFolderButtonToolTipText");
        this.newFolderTitleText = UIManager.getString("FileChooser.newFolderTitleText");
        newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        newFolderAccessibleName = this.getString("FileChooser.newFolderAccessibleName", this.newFolderTitleText);
    }

    protected void uninstallDefaults(JFileChooser fc) {
        this.uninstallIcons(fc);
        this.uninstallStrings(fc);
    }

    protected void uninstallIcons(JFileChooser fc) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser fc) {
        this.saveTitleText = null;
        this.openTitleText = null;
        this.newFolderTitleText = null;
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.newFolderButtonText = null;
        this.chooseButtonText = null;
        this.cancelOpenButtonToolTipText = null;
        this.cancelSaveButtonToolTipText = null;
        this.cancelChooseButtonToolTipText = null;
        this.cancelNewFolderButtonToolTipText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.chooseItemButtonToolTipText = null;
        this.chooseFolderButtonToolTipText = null;
        this.openDirectoryButtonToolTipText = null;
        this.directoryComboBoxToolTipText = null;
        this.filenameTextFieldToolTipText = null;
        this.filterComboBoxToolTipText = null;
        this.newFolderDefaultName = null;
        this.newFileDefaultName = null;
        this.desktopName = null;
    }

    protected void createModel() {
    }

    AquaFileSystemModel getModel() {
        return this.model;
    }

    protected PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("SelectedFileChangedProperty")) {
                    File f = (File)e.getNewValue();
                    if (f != null) {
                        if (!AquaFileChooserUI.this.selectionInProgress && AquaFileChooserUI.this.getModel().contains(f)) {
                            AquaFileChooserUI.this.fFileList.setSelectedIndex(AquaFileChooserUI.this.getModel().indexOf(f));
                        }
                        if (!f.isDirectory()) {
                            AquaFileChooserUI.this.setFileName(AquaFileChooserUI.this.getFileChooser().getName(f));
                        }
                    }
                    AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
                } else if (prop.equals("SelectedFilesChangedProperty")) {
                    File[] files;
                    JFileChooser fileChooser = AquaFileChooserUI.this.getFileChooser();
                    if (!fileChooser.isDirectorySelectionEnabled() && (files = (File[])e.getNewValue()) != null) {
                        for (int selectedRow : AquaFileChooserUI.this.fFileList.getSelectedRows()) {
                            File file = (File)AquaFileChooserUI.this.fFileList.getValueAt(selectedRow, 0);
                            if (!fileChooser.isTraversable(file)) continue;
                            AquaFileChooserUI.this.fFileList.removeSelectedIndex(selectedRow);
                        }
                    }
                } else if (prop.equals("directoryChanged")) {
                    AquaFileChooserUI.this.fFileList.clearSelection();
                    File currentDirectory = AquaFileChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (currentDirectory != null) {
                        AquaFileChooserUI.this.fDirectoryComboBoxModel.addItem(currentDirectory);
                        AquaFileChooserUI.this.getAction(5).setEnabled(currentDirectory.canWrite());
                    }
                    AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
                } else if (prop.equals("fileSelectionChanged")) {
                    AquaFileChooserUI.this.fFileList.clearSelection();
                    AquaFileChooserUI.this.setBottomPanelForMode(AquaFileChooserUI.this.getFileChooser());
                } else if (prop == "AccessoryChangedProperty") {
                    if (AquaFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent accessory;
                        if (e.getOldValue() != null) {
                            AquaFileChooserUI.this.getAccessoryPanel().remove((JComponent)e.getOldValue());
                        }
                        if ((accessory = (JComponent)e.getNewValue()) != null) {
                            AquaFileChooserUI.this.getAccessoryPanel().add((Component)accessory, "Center");
                        }
                    }
                } else if (prop == "ApproveButtonTextChangedProperty") {
                    AquaFileChooserUI.this.updateApproveButton(AquaFileChooserUI.this.getFileChooser());
                    AquaFileChooserUI.this.getFileChooser().invalidate();
                } else if (prop == "DialogTypeChangedProperty") {
                    fileNameLabelText = AquaFileChooserUI.this.getFileChooser().getDialogType() == 1 ? AquaFileChooserUI.this.getString("FileChooser.saveDialogFileNameLabelText", "Save As:") : AquaFileChooserUI.this.getString("FileChooser.fileNameLabelText", "Name:");
                    AquaFileChooserUI.this.fTextFieldLabel.setText(fileNameLabelText);
                    AquaFileChooserUI.this.setBottomPanelForMode(AquaFileChooserUI.this.getFileChooser());
                } else if (prop.equals("ApproveButtonMnemonicChangedProperty")) {
                    AquaFileChooserUI.this.getApproveButton(AquaFileChooserUI.this.getFileChooser()).setMnemonic(AquaFileChooserUI.this.getApproveButtonMnemonic(AquaFileChooserUI.this.getFileChooser()));
                } else if (prop.equals(AquaFileChooserUI.PACKAGE_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.setPackageIsTraversable(e.getNewValue());
                } else if (prop.equals(AquaFileChooserUI.APPLICATION_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.setApplicationIsTraversable(e.getNewValue());
                } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
                    if (AquaFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                        AquaFileChooserUI.this.fFileList.getSelectionModel().setSelectionMode(2);
                    } else {
                        AquaFileChooserUI.this.fFileList.getSelectionModel().setSelectionMode(0);
                    }
                } else if (prop.equals("ControlButtonsAreShownChangedProperty")) {
                    AquaFileChooserUI.this.doControlButtonsChanged(e);
                }
            }
        };
    }

    void setPackageIsTraversable(Object o) {
        int newProp = -1;
        if (o != null && o instanceof String) {
            newProp = AquaFileChooserUI.parseTraversableProperty((String)o);
        }
        this.fPackageIsTraversable = newProp != -1 ? newProp : sGlobalPackageIsTraversable;
    }

    void setApplicationIsTraversable(Object o) {
        int newProp = -1;
        if (o != null && o instanceof String) {
            newProp = AquaFileChooserUI.parseTraversableProperty((String)o);
        }
        this.fApplicationIsTraversable = newProp != -1 ? newProp : sGlobalApplicationIsTraversable;
    }

    void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.fBottomPanel.add(this.fDirectoryPanelSpacer);
            this.fBottomPanel.add(this.fDirectoryPanel);
        } else {
            this.fBottomPanel.remove(this.fDirectoryPanelSpacer);
            this.fBottomPanel.remove(this.fDirectoryPanel);
        }
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    public void setDirectoryName(String dirname) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, final File f) {
        if (f == null) {
            this.fFileList.requestFocusInWindow();
            this.fFileList.ensureIndexIsVisible(-1);
            return;
        }
        this.getModel().runWhenDone(new Runnable(){

            @Override
            public void run() {
                AquaFileChooserUI.this.fFileList.requestFocusInWindow();
                AquaFileChooserUI.this.fFileList.ensureIndexIsVisible(AquaFileChooserUI.this.getModel().indexOf(f));
            }
        });
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.fApproveButton;
    }

    public int getApproveButtonMnemonic(JFileChooser fc) {
        return this.fSubPanel.getApproveButtonMnemonic(fc);
    }

    public String getApproveButtonToolTipText(JFileChooser fc) {
        return this.fSubPanel.getApproveButtonToolTipText(fc);
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        return this.fSubPanel.getApproveButtonText(fc);
    }

    protected String getCancelButtonToolTipText(JFileChooser fc) {
        return this.fSubPanel.getCancelButtonToolTipText(fc);
    }

    boolean isSelectableInList(File f) {
        return this.fSubPanel.isSelectableInList(this.getFileChooser(), f);
    }

    boolean isSelectableForMode(JFileChooser fc, File f) {
        if (f == null) {
            return false;
        }
        int mode = fc.getFileSelectionMode();
        if (mode == 2) {
            return true;
        }
        boolean traversable = fc.isTraversable(f);
        if (mode == 1) {
            return traversable;
        }
        return !traversable;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new SelectionListener();
    }

    protected boolean openDirectory(File f) {
        if (this.getFileChooser().isTraversable(f)) {
            this.fFileList.clearSelection();
            File original = this.fileView.resolveAlias(f);
            this.getFileChooser().setCurrentDirectory(original);
            this.updateButtonState(this.getFileChooser());
            return true;
        }
        return false;
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc, JTableExtension list) {
        return new DoubleClickListener(list);
    }

    @Override
    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return this.acceptAllFileFilter;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public String getDialogTitle(JFileChooser fc) {
        if (fc.getDialogTitle() == null) {
            if (this.getFileChooser().getDialogType() == 0) {
                return this.openTitleText;
            }
            if (this.getFileChooser().getDialogType() == 1) {
                return this.saveTitleText;
            }
        }
        return fc.getDialogTitle();
    }

    File getFirstSelectedItem() {
        File selectedFile = null;
        int index = this.fFileList.getSelectedRow();
        if (index >= 0) {
            selectedFile = (File)((AquaFileSystemModel)this.fFileList.getModel()).getElementAt(index);
        }
        return selectedFile;
    }

    File makeFile(JFileChooser fc, String filename) {
        FileSystemView fs;
        File selectedFile = null;
        if (filename != null && !filename.equals("") && !(selectedFile = (fs = fc.getFileSystemView()).createFileObject(filename)).isAbsolute()) {
            selectedFile = fs.createFileObject(fc.getCurrentDirectory(), filename);
        }
        return selectedFile;
    }

    boolean textfieldIsValid() {
        String s = this.getFileName();
        return s != null && !s.equals("");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(550, 400);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(400, 250);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected ListCellRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new AquaComboBoxRendererInternal(this.directoryComboBox){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                File directory = (File)value;
                if (directory == null) {
                    this.setText("");
                    return this;
                }
                JFileChooser chooser = AquaFileChooserUI.this.getFileChooser();
                this.setText(chooser.getName(directory));
                this.setIcon(chooser.getIcon(directory));
                return this;
            }
        };
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected ListCellRenderer createFilterComboBoxRenderer() {
        return new AquaComboBoxRendererInternal(this.filterComboBox){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                FileFilter filter = (FileFilter)value;
                if (filter != null) {
                    this.setText(filter.getDescription());
                }
                return this;
            }
        };
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    private boolean containsFileFilter(Object fileFilter) {
        return Objects.equals(fileFilter, this.getFileChooser().getFileFilter());
    }

    public void installComponents(JFileChooser fc) {
        fc.setLayout(new BoxLayout(fc, 1));
        fc.add(Box.createRigidArea(vstrut10));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        fc.add(topPanel);
        fc.add(Box.createRigidArea(vstrut10));
        this.fTextfieldPanel = new JPanel();
        this.fTextfieldPanel.setLayout(new BorderLayout());
        this.fTextfieldPanel.setVisible(false);
        topPanel.add(this.fTextfieldPanel);
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new BoxLayout(tPanel, 1));
        JPanel labelArea = new JPanel();
        labelArea.setLayout(new FlowLayout(1));
        this.fTextFieldLabel = new JLabel(fileNameLabelText);
        labelArea.add(this.fTextFieldLabel);
        this.filenameTextField = new JTextField();
        this.fTextFieldLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getAction(0));
        this.filenameTextField.addFocusListener(new SaveTextFocusListener());
        Dimension minSize = this.filenameTextField.getMinimumSize();
        Dimension d = new Dimension(250, (int)minSize.getHeight());
        this.filenameTextField.setPreferredSize(d);
        this.filenameTextField.setMaximumSize(d);
        labelArea.add(this.filenameTextField);
        File f = fc.getSelectedFile();
        if (f != null) {
            this.setFileName(fc.getName(f));
        } else if (fc.getDialogType() == 1) {
            this.setFileName(this.newFileDefaultName);
        }
        tPanel.add(labelArea);
        JSeparator sep = new JSeparator(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(((JComponent)this.getParent()).getWidth(), 3);
            }
        };
        tPanel.add(Box.createRigidArea(new Dimension(1, 8)));
        tPanel.add(sep);
        tPanel.add(Box.createRigidArea(new Dimension(1, 7)));
        this.fTextfieldPanel.add((Component)tPanel, "Center");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.fDirectoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.fDirectoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setToolTipText(this.directoryComboBoxToolTipText);
        d = new Dimension(250, (int)this.directoryComboBox.getMinimumSize().getHeight());
        this.directoryComboBox.setPreferredSize(d);
        this.directoryComboBox.setMaximumSize(d);
        topPanel.add(this.directoryComboBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        fc.add(centerPanel);
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        centerPanel.add((Component)this.getAccessoryPanel(), "Before");
        JPanel p = this.createList(fc);
        p.setMinimumSize(LIST_MIN_SIZE);
        centerPanel.add((Component)p, "Center");
        this.fBottomPanel = new JPanel();
        this.fBottomPanel.setLayout(new BoxLayout(this.fBottomPanel, 1));
        fc.add(this.fBottomPanel);
        tPanel = new JPanel();
        tPanel.setLayout(new FlowLayout(1));
        tPanel.setBorder(AquaGroupBorder.getTitlelessBorder());
        JLabel formatLabel = new JLabel(filesOfTypeLabelText);
        tPanel.add(formatLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox<FileFilter>(this.filterComboBoxModel);
        formatLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        d = new Dimension(220, (int)this.filterComboBox.getMinimumSize().getHeight());
        this.filterComboBox.setPreferredSize(d);
        this.filterComboBox.setMaximumSize(d);
        this.filterComboBox.addActionListener(this.filterComboBoxAction);
        this.filterComboBox.setOpaque(false);
        tPanel.add(this.filterComboBox);
        this.fBottomPanel.add(tPanel);
        this.fDirectoryPanel = new JPanel();
        this.fDirectoryPanel.setLayout(new BoxLayout(this.fDirectoryPanel, 3));
        JPanel directoryPanel = new JPanel(new BorderLayout());
        JPanel newFolderButtonPanel = new JPanel(new FlowLayout(3, 0, 0));
        newFolderButtonPanel.add(Box.createHorizontalStrut(20));
        this.fNewFolderButton = this.createNewFolderButton();
        newFolderButtonPanel.add(this.fNewFolderButton);
        directoryPanel.add((Component)newFolderButtonPanel, "Before");
        JPanel approveCancelButtonPanel = new JPanel(new FlowLayout(4, 0, 0));
        this.fOpenButton = this.createButton(3, this.openButtonText);
        approveCancelButtonPanel.add(this.fOpenButton);
        approveCancelButtonPanel.add(Box.createHorizontalStrut(8));
        this.fCancelButton = this.createButton(2, null);
        approveCancelButtonPanel.add(this.fCancelButton);
        approveCancelButtonPanel.add(Box.createHorizontalStrut(8));
        this.fApproveButton = new JButton();
        this.fApproveButton.addActionListener(this.fApproveSelectionAction);
        approveCancelButtonPanel.add(this.fApproveButton);
        approveCancelButtonPanel.add(Box.createHorizontalStrut(20));
        directoryPanel.add((Component)approveCancelButtonPanel, "After");
        this.fDirectoryPanel.add(Box.createVerticalStrut(5));
        this.fDirectoryPanel.add(directoryPanel);
        this.fDirectoryPanel.add(Box.createVerticalStrut(12));
        this.fDirectoryPanelSpacer = Box.createRigidArea(hstrut10);
        if (fc.getControlButtonsAreShown()) {
            this.fBottomPanel.add(this.fDirectoryPanelSpacer);
            this.fBottomPanel.add(this.fDirectoryPanel);
        }
        this.setBottomPanelForMode(fc);
        this.filenameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
    }

    void setDefaultButtonForMode(JFileChooser fc) {
        JButton defaultButton = this.fSubPanel.getDefaultButton(fc);
        JRootPane root = defaultButton.getRootPane();
        if (root != null) {
            root.setDefaultButton(defaultButton);
        }
    }

    void setFocusForMode(JFileChooser fc) {
        JComponent focusComponent = this.fSubPanel.getFocusComponent(fc);
        if (focusComponent != null) {
            focusComponent.requestFocus();
        }
    }

    void updateButtonState(JFileChooser fc) {
        this.fSubPanel.updateButtonState(fc, this.getFirstSelectedItem());
        this.updateApproveButton(fc);
    }

    void updateApproveButton(JFileChooser chooser) {
        this.fApproveButton.setText(this.getApproveButtonText(chooser));
        this.fApproveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        this.fApproveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        this.fCancelButton.setToolTipText(this.getCancelButtonToolTipText(chooser));
    }

    synchronized FCSubpanel getSaveFilePanel() {
        if (this.fSaveFilePanel == null) {
            this.fSaveFilePanel = new SaveFilePanel();
        }
        return this.fSaveFilePanel;
    }

    synchronized FCSubpanel getOpenFilePanel() {
        if (this.fOpenFilePanel == null) {
            this.fOpenFilePanel = new OpenFilePanel();
        }
        return this.fOpenFilePanel;
    }

    synchronized FCSubpanel getOpenDirOrAnyPanel() {
        if (this.fOpenDirOrAnyPanel == null) {
            this.fOpenDirOrAnyPanel = new OpenDirOrAnyPanel();
        }
        return this.fOpenDirOrAnyPanel;
    }

    synchronized FCSubpanel getCustomFilePanel() {
        if (this.fCustomFilePanel == null) {
            this.fCustomFilePanel = new CustomFilePanel();
        }
        return this.fCustomFilePanel;
    }

    synchronized FCSubpanel getCustomDirOrAnyPanel() {
        if (this.fCustomDirOrAnyPanel == null) {
            this.fCustomDirOrAnyPanel = new CustomDirOrAnyPanel();
        }
        return this.fCustomDirOrAnyPanel;
    }

    void setBottomPanelForMode(JFileChooser fc) {
        if (fc.getDialogType() == 1) {
            this.fSubPanel = this.getSaveFilePanel();
        } else if (fc.getDialogType() == 0) {
            this.fSubPanel = fc.getFileSelectionMode() == 0 ? this.getOpenFilePanel() : this.getOpenDirOrAnyPanel();
        } else if (fc.getDialogType() == 2) {
            this.fSubPanel = fc.getFileSelectionMode() == 0 ? this.getCustomFilePanel() : this.getCustomDirOrAnyPanel();
        }
        this.fSubPanel.installPanel(fc, true);
        this.updateApproveButton(fc);
        this.updateButtonState(fc);
        this.setDefaultButtonForMode(fc);
        this.setFocusForMode(fc);
        fc.invalidate();
    }

    JButton createNewFolderButton() {
        JButton b = new JButton(this.newFolderButtonText);
        b.setToolTipText(newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(newFolderAccessibleName);
        b.setHorizontalTextPosition(2);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.addActionListener(this.getAction(5));
        return b;
    }

    JButton createButton(int which, String label) {
        if (label == null) {
            label = UIManager.getString(sDataPrefix + sButtonKinds[which] + sButtonData[0]);
        }
        int mnemonic = UIManager.getInt(sDataPrefix + sButtonKinds[which] + sButtonData[1]);
        String tipText = UIManager.getString(sDataPrefix + sButtonKinds[which] + sButtonData[2]);
        JButton b = new JButton(label);
        b.setMnemonic(mnemonic);
        b.setToolTipText(tipText);
        b.addActionListener(this.getAction(which));
        return b;
    }

    AbstractAction getAction(int which) {
        return this.fButtonActions[which];
    }

    public void uninstallComponents(JFileChooser fc) {
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        this.fFileList = new JTableExtension();
        this.fFileList.setToolTipText(null);
        this.fFileList.addMouseListener(new FileListMouseListener());
        this.model = new AquaFileSystemModel(fc, this.fFileList, fColumnNames);
        MacListSelectionModel listSelectionModel = new MacListSelectionModel(this.model);
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            listSelectionModel.setSelectionMode(2);
        } else {
            listSelectionModel.setSelectionMode(0);
        }
        this.fFileList.setModel(this.model);
        this.fFileList.setSelectionModel(listSelectionModel);
        this.fFileList.getSelectionModel().addListSelectionListener(this.createListSelectionListener(fc));
        fc.addPropertyChangeListener(this.model);
        this.fFileList.addFocusListener(new SaveTextFocusListener());
        JSortingTableHeader th = new JSortingTableHeader(this.fFileList.getColumnModel());
        this.fFileList.setTableHeader(th);
        this.fFileList.setRowMargin(0);
        this.fFileList.setIntercellSpacing(new Dimension(0, 1));
        this.fFileList.setShowVerticalLines(false);
        this.fFileList.setShowHorizontalLines(false);
        Font f = this.fFileList.getFont();
        this.fFileList.setDefaultRenderer(File.class, new FileRenderer(f));
        this.fFileList.setDefaultRenderer(Date.class, new DateRenderer(f));
        FontMetrics fm = this.fFileList.getFontMetrics(f);
        this.fFileList.setRowHeight(Math.max(fm.getHeight(), this.fileIcon.getIconHeight() + 2));
        this.fFileList.registerKeyboardAction(new CancelSelectionAction(), KeyStroke.getKeyStroke(27, 0), 0);
        this.fFileList.registerKeyboardAction(new DefaultButtonAction(), KeyStroke.getKeyStroke(10, 0), 0);
        this.fFileList.setDropTarget(this.dragAndDropTarget);
        JScrollPane scrollpane = new JScrollPane(this.fFileList, 22, 30);
        scrollpane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        scrollpane.setCorner("UPPER_TRAILING_CORNER", new ScrollPaneCornerPanel());
        p.add((Component)scrollpane, "Center");
        return p;
    }

    static int parseTraversableProperty(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < sTraversableProperties.length; ++i) {
            if (!s.equals(sTraversableProperties[i])) continue;
            return i;
        }
        return -1;
    }

    static {
        sTraversableProperties = new String[]{"always", "never", "conditional"};
        Object o = UIManager.get(PACKAGE_TRAVERSABLE_PROPERTY);
        sGlobalPackageIsTraversable = o != null && o instanceof String ? AquaFileChooserUI.parseTraversableProperty((String)o) : 2;
        o = UIManager.get(APPLICATION_TRAVERSABLE_PROPERTY);
        sGlobalApplicationIsTraversable = o != null && o instanceof String ? AquaFileChooserUI.parseTraversableProperty((String)o) : 2;
        sButtonKinds = new String[]{"openButton", "saveButton", "cancelButton", "openDirectoryButton", "helpButton", "newFolderButton"};
        sButtonData = new String[]{"Text", "Mnemonic", "ToolTipText"};
    }

    class JTableExtension
    extends JTable {
        JTableExtension() {
        }

        public void setSelectedIndex(int index) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }

        public void removeSelectedIndex(int index) {
            this.getSelectionModel().removeSelectionInterval(index, index);
        }

        public void ensureIndexIsVisible(int index) {
            Rectangle cellBounds = this.getCellRect(index, 0, false);
            if (cellBounds != null) {
                this.scrollRectToVisible(cellBounds);
            }
        }

        public int locationToIndex(Point location) {
            return this.rowAtPoint(location);
        }
    }

    class MacListSelectionModel
    extends DefaultListSelectionModel {
        AquaFileSystemModel fModel;

        MacListSelectionModel(AquaFileSystemModel model) {
            this.fModel = model;
        }

        boolean isSelectableInListIndex(int index) {
            File file = (File)this.fModel.getValueAt(index, 0);
            return file != null && AquaFileChooserUI.this.isSelectableInList(file);
        }

        void verifySelectionInterval(int index0, int index1, boolean isSetSelection) {
            if (index0 > index1) {
                int tmp = index1;
                index1 = index0;
                index0 = tmp;
            }
            int start = index0;
            while (true) {
                if (start <= index1 && !this.isSelectableInListIndex(start)) {
                    ++start;
                    continue;
                }
                int end = -1;
                int i = start;
                while (i <= index1 && this.isSelectableInListIndex(i)) {
                    end = i++;
                }
                if (end < 0) break;
                if (isSetSelection) {
                    super.setSelectionInterval(start, end);
                    isSetSelection = false;
                } else {
                    super.addSelectionInterval(start, end);
                }
                if ((start = end + 1) > index1) break;
            }
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
            if (this.isSelectableInListIndex(anchorIndex)) {
                super.setAnchorSelectionIndex(anchorIndex);
            }
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
            if (this.isSelectableInListIndex(leadIndex)) {
                super.setLeadSelectionIndex(leadIndex);
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0 || index0 == index1) {
                if (this.isSelectableInListIndex(index1)) {
                    super.setSelectionInterval(index1, index1);
                }
            } else {
                this.verifySelectionInterval(index0, index1, true);
            }
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (index0 == -1 || index1 == -1) {
                return;
            }
            if (index0 == index1) {
                if (this.isSelectableInListIndex(index1)) {
                    super.addSelectionInterval(index1, index1);
                }
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(index0, index1);
                return;
            }
            this.verifySelectionInterval(index0, index1, false);
        }
    }

    class CustomDirOrAnyPanel
    extends DirOrAnyPanel {
        CustomDirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            super.installPanel(fc, controlButtonsAreShown);
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        @Override
        void approveSelection(JFileChooser fc) {
            File f = AquaFileChooserUI.this.makeFile(fc, AquaFileChooserUI.this.getFileName());
            if (f != null) {
                AquaFileChooserUI.this.selectionInProgress = true;
                AquaFileChooserUI.this.getFileChooser().setSelectedFile(f);
                AquaFileChooserUI.this.selectionInProgress = false;
            }
            AquaFileChooserUI.this.getFileChooser().approveSelection();
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            AquaFileChooserUI.this.getApproveButton(fc).setEnabled(f != null || AquaFileChooserUI.this.textfieldIsValid());
            super.updateButtonState(fc, f);
        }
    }

    class OpenDirOrAnyPanel
    extends DirOrAnyPanel {
        OpenDirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            super.installPanel(fc, controlButtonsAreShown);
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(false);
        }

        @Override
        JComponent getFocusComponent(JFileChooser fc) {
            return AquaFileChooserUI.this.fFileList;
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser fc) {
            return AquaFileChooserUI.this.chooseButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser fc) {
            String fallbackText = fc.getFileSelectionMode() == 1 ? AquaFileChooserUI.this.chooseFolderButtonToolTipText : AquaFileChooserUI.this.chooseItemButtonToolTipText;
            return this.getApproveButtonToolTipText(fc, fallbackText);
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            AquaFileChooserUI.this.getApproveButton(fc).setEnabled(f != null);
            super.updateButtonState(fc, f);
        }
    }

    abstract class DirOrAnyPanel
    extends FCSubpanel {
        DirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
        }

        @Override
        JButton getDefaultButton(JFileChooser fc) {
            return AquaFileChooserUI.this.getApproveButton(fc);
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            AquaFileChooserUI.this.fOpenButton.setEnabled(false);
            AquaFileChooserUI.this.setDefaultButtonForMode(fc);
        }
    }

    class OpenFilePanel
    extends FCSubpanel {
        OpenFilePanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(false);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(false);
            AquaFileChooserUI.this.setDefaultButtonForMode(fc);
        }

        boolean inOpenDirectoryMode(JFileChooser fc, File f) {
            return f != null && fc.isTraversable(f);
        }

        @Override
        JComponent getFocusComponent(JFileChooser fc) {
            return AquaFileChooserUI.this.fFileList;
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            boolean enabled = f != null && !fc.isTraversable(f);
            AquaFileChooserUI.this.getApproveButton(fc).setEnabled(enabled);
        }

        @Override
        boolean isSelectableInList(JFileChooser fc, File f) {
            return f != null && fc.accept(f);
        }

        @Override
        String getApproveButtonText(JFileChooser fc) {
            return this.getApproveButtonText(fc, AquaFileChooserUI.this.openButtonText);
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser fc) {
            return AquaFileChooserUI.this.openButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser fc) {
            return this.getApproveButtonToolTipText(fc, AquaFileChooserUI.this.openButtonToolTipText);
        }

        @Override
        String getCancelButtonToolTipText(JFileChooser fc) {
            return AquaFileChooserUI.this.cancelOpenButtonToolTipText;
        }
    }

    class SaveFilePanel
    extends CustomFilePanel {
        SaveFilePanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        @Override
        boolean isSelectableInList(JFileChooser fc, File f) {
            return fc.accept(f) && fc.isTraversable(f);
        }

        @Override
        void approveSelection(JFileChooser fc) {
            File f = AquaFileChooserUI.this.makeFile(fc, AquaFileChooserUI.this.getFileName());
            if (f != null) {
                AquaFileChooserUI.this.selectionInProgress = true;
                AquaFileChooserUI.this.getFileChooser().setSelectedFile(f);
                AquaFileChooserUI.this.selectionInProgress = false;
                AquaFileChooserUI.this.getFileChooser().approveSelection();
            }
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            boolean enabled = AquaFileChooserUI.this.textfieldIsValid();
            AquaFileChooserUI.this.getApproveButton(fc).setEnabled(enabled);
        }

        @Override
        String getApproveButtonText(JFileChooser fc) {
            return this.getApproveButtonText(fc, AquaFileChooserUI.this.saveButtonText);
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser fc) {
            return AquaFileChooserUI.this.saveButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser fc) {
            if (this.inOpenDirectoryMode(fc, AquaFileChooserUI.this.getFirstSelectedItem())) {
                return AquaFileChooserUI.this.openDirectoryButtonToolTipText;
            }
            return this.getApproveButtonToolTipText(fc, AquaFileChooserUI.this.saveButtonToolTipText);
        }

        @Override
        String getCancelButtonToolTipText(JFileChooser fc) {
            return AquaFileChooserUI.this.cancelSaveButtonToolTipText;
        }
    }

    class CustomFilePanel
    extends FCSubpanel {
        CustomFilePanel() {
        }

        @Override
        void installPanel(JFileChooser fc, boolean controlButtonsAreShown) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        boolean inOpenDirectoryMode(JFileChooser fc, File f) {
            boolean selectionIsDirectory;
            boolean bl = selectionIsDirectory = f != null && fc.isTraversable(f);
            if (AquaFileChooserUI.this.fFileList.hasFocus()) {
                return selectionIsDirectory;
            }
            if (AquaFileChooserUI.this.textfieldIsValid()) {
                return false;
            }
            return selectionIsDirectory;
        }

        @Override
        void approveSelection(JFileChooser fc) {
            File f = AquaFileChooserUI.this.getFirstSelectedItem();
            if (this.inOpenDirectoryMode(fc, f)) {
                AquaFileChooserUI.this.openDirectory(f);
            } else {
                f = AquaFileChooserUI.this.makeFile(fc, AquaFileChooserUI.this.getFileName());
                if (f != null) {
                    AquaFileChooserUI.this.selectionInProgress = true;
                    AquaFileChooserUI.this.getFileChooser().setSelectedFile(f);
                    AquaFileChooserUI.this.selectionInProgress = false;
                }
                AquaFileChooserUI.this.getFileChooser().approveSelection();
            }
        }

        @Override
        void updateButtonState(JFileChooser fc, File f) {
            boolean enabled = true;
            if (!this.inOpenDirectoryMode(fc, f)) {
                enabled = f != null || AquaFileChooserUI.this.textfieldIsValid();
            }
            AquaFileChooserUI.this.getApproveButton(fc).setEnabled(enabled);
            AquaFileChooserUI.this.fOpenButton.setEnabled(f != null && fc.isTraversable(f));
            AquaFileChooserUI.this.setDefaultButtonForMode(fc);
        }

        @Override
        boolean isSelectableInList(JFileChooser fc, File f) {
            if (f == null) {
                return false;
            }
            return fc.accept(f);
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser fc) {
            if (this.inOpenDirectoryMode(fc, AquaFileChooserUI.this.getFirstSelectedItem())) {
                return AquaFileChooserUI.this.openDirectoryButtonToolTipText;
            }
            return super.getApproveButtonToolTipText(fc);
        }
    }

    abstract class FCSubpanel {
        FCSubpanel() {
        }

        abstract void installPanel(JFileChooser var1, boolean var2);

        abstract void updateButtonState(JFileChooser var1, File var2);

        boolean isSelectableInList(JFileChooser fc, File f) {
            if (f == null) {
                return false;
            }
            if (fc.getFileSelectionMode() == 1) {
                return fc.isTraversable(f);
            }
            return fc.accept(f);
        }

        void approveSelection(JFileChooser fc) {
            fc.approveSelection();
        }

        JButton getDefaultButton(JFileChooser fc) {
            return AquaFileChooserUI.this.fApproveButton;
        }

        JComponent getFocusComponent(JFileChooser fc) {
            return AquaFileChooserUI.this.filenameTextField;
        }

        String getApproveButtonText(JFileChooser fc) {
            return this.getApproveButtonText(fc, AquaFileChooserUI.this.chooseButtonText);
        }

        String getApproveButtonText(JFileChooser fc, String fallbackText) {
            String buttonText = fc.getApproveButtonText();
            if (buttonText != null) {
                buttonText.trim();
                if (!buttonText.equals("")) {
                    return buttonText;
                }
            }
            return fallbackText;
        }

        int getApproveButtonMnemonic(JFileChooser fc) {
            return fc.getApproveButtonMnemonic();
        }

        String getApproveButtonToolTipText(JFileChooser fc) {
            return this.getApproveButtonToolTipText(fc, null);
        }

        String getApproveButtonToolTipText(JFileChooser fc, String fallbackText) {
            String tooltipText = fc.getApproveButtonToolTipText();
            if (tooltipText != null) {
                tooltipText.trim();
                if (!tooltipText.equals("")) {
                    return tooltipText;
                }
            }
            return fallbackText;
        }

        String getCancelButtonToolTipText(JFileChooser fc) {
            return AquaFileChooserUI.this.cancelChooseButtonToolTipText;
        }
    }

    protected class ScrollPaneCornerPanel
    extends JPanel {
        final Border border = UIManager.getBorder("TableHeader.cellBorder");

        protected ScrollPaneCornerPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.border.paintBorder(this, g, 0, 0, this.getWidth() + 1, this.getHeight());
        }
    }

    protected class FileListMouseListener
    extends MouseAdapter {
        protected FileListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = AquaFileChooserUI.this.fFileList.rowAtPoint(p);
            int column = AquaFileChooserUI.this.fFileList.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            File clickedFile = (File)AquaFileChooserUI.this.fFileList.getValueAt(row, 0);
            if (AquaFileChooserUI.this.isSelectableForMode(AquaFileChooserUI.this.getFileChooser(), clickedFile)) {
                AquaFileChooserUI.this.setFileName(AquaFileChooserUI.this.fileView.getName(clickedFile));
            }
        }
    }

    class JSortingTableHeader
    extends JTableHeader {
        final boolean[] fSortAscending;

        public JSortingTableHeader(TableColumnModel cm) {
            super(cm);
            this.fSortAscending = new boolean[]{true, true};
            this.setReorderingAllowed(true);
        }

        @Override
        public void setDraggedColumn(TableColumn aColumn) {
            if (aColumn != null) {
                int colIndex = aColumn.getModelIndex();
                if (colIndex != AquaFileChooserUI.this.fSortColumn) {
                    AquaFileChooserUI.this.filechooser.firePropertyChange("sortByChanged", AquaFileChooserUI.this.fSortColumn, colIndex);
                    AquaFileChooserUI.this.fSortColumn = colIndex;
                } else {
                    this.fSortAscending[colIndex] = !this.fSortAscending[colIndex];
                    AquaFileChooserUI.this.filechooser.firePropertyChange("sortAscendingChanged", !this.fSortAscending[colIndex], this.fSortAscending[colIndex]);
                }
                this.repaint();
            }
        }

        @Override
        public TableColumn getDraggedColumn() {
            return null;
        }

        @Override
        protected TableCellRenderer createDefaultRenderer() {
            AquaTableCellRenderer label = new AquaTableCellRenderer();
            label.setHorizontalAlignment(2);
            return label;
        }

        class AquaTableCellRenderer
        extends DefaultTableCellRenderer
        implements UIResource {
            AquaTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable localTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (localTable != null && (header = localTable.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(UIManager.getFont("TableHeader.font"));
                }
                this.setText(value == null ? "" : value.toString());
                AquaTableHeaderBorder cellBorder = AquaTableHeaderBorder.getListHeaderBorder();
                cellBorder.setSelected(column == AquaFileChooserUI.this.fSortColumn);
                int horizontalShift = column == 0 ? 35 : 10;
                cellBorder.setHorizontalShift(horizontalShift);
                if (column == AquaFileChooserUI.this.fSortColumn) {
                    cellBorder.setSortOrder(JSortingTableHeader.this.fSortAscending[column] ? 1 : -1);
                } else {
                    cellBorder.setSortOrder(0);
                }
                this.setBorder(cellBorder);
                return this;
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaFileChooserUI.this.getFileChooser().setCurrentDirectory((File)AquaFileChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }

    protected class FilterComboBoxAction
    extends AbstractAction {
        protected FilterComboBoxAction() {
            super("FilterComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedFilter = AquaFileChooserUI.this.filterComboBox.getSelectedItem();
            if (!AquaFileChooserUI.this.containsFileFilter(selectedFilter)) {
                AquaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)selectedFilter);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<FileFilter>
    implements ComboBoxModel<FileFilter>,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = AquaFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.setSelectedItem(e.getNewValue());
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null && !AquaFileChooserUI.this.containsFileFilter(filter)) {
                AquaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = AquaFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    AquaFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return AquaFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public FileFilter getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return AquaFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> fDirectories = new Vector();
        int topIndex = -1;
        int fPathCount = 0;
        File fSelectedDirectory = null;

        public DirectoryComboBoxModel() {
            this.addItem(AquaFileChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        private void removeSelectedDirectory() {
            this.fDirectories.removeAllElements();
            this.fPathCount = 0;
            this.fSelectedDirectory = null;
        }

        void addItem(File directory) {
            File[] roots;
            if (directory == null) {
                return;
            }
            if (this.fSelectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File f = directory.getAbsoluteFile();
            Vector<File> path = new Vector<File>(10);
            while (f.getParent() != null) {
                path.addElement(f);
                f = AquaFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(f.getParent());
            }
            for (File element : roots = AquaFileChooserUI.this.getFileChooser().getFileSystemView().getRoots()) {
                path.addElement(element);
            }
            this.fPathCount = path.size();
            for (int i = 0; i < path.size(); ++i) {
                this.fDirectories.addElement((File)path.elementAt(i));
            }
            this.setSelectedItem(this.fDirectories.elementAt(0));
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.fSelectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.fSelectedDirectory;
        }

        @Override
        public int getSize() {
            return this.fDirectories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.fDirectories.elementAt(index);
        }
    }

    protected class DateRenderer
    extends MacFCTableCellRenderer {
        public DateRenderer(Font f) {
            super(f);
        }

        @Override
        public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean cellHasFocus, int index, int col) {
            super.getTableCellRendererComponent(list, value, isSelected, false, index, col);
            File file = (File)AquaFileChooserUI.this.fFileList.getValueAt(index, 0);
            this.setEnabled(AquaFileChooserUI.this.isSelectableInList(file));
            DateFormat formatter = DateFormat.getDateTimeInstance(0, 3);
            Date date = (Date)value;
            if (date != null) {
                this.setText(formatter.format(date));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    protected class FileRenderer
    extends MacFCTableCellRenderer {
        public FileRenderer(Font f) {
            super(f);
        }

        @Override
        public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean cellHasFocus, int index, int col) {
            super.getTableCellRendererComponent(list, value, isSelected, false, index, col);
            File file = (File)value;
            JFileChooser fc = AquaFileChooserUI.this.getFileChooser();
            this.setText(fc.getName(file));
            this.setIcon(fc.getIcon(file));
            this.setEnabled(AquaFileChooserUI.this.isSelectableInList(file));
            return this;
        }
    }

    protected class MacFCTableCellRenderer
    extends DefaultTableCellRenderer {
        boolean fIsSelected = false;

        public MacFCTableCellRenderer(Font f) {
            this.setFont(f);
            this.setIconTextGap(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean cellHasFocus, int index, int col) {
            super.getTableCellRendererComponent(list, value, isSelected, false, index, col);
            this.fIsSelected = isSelected;
            return this;
        }

        public boolean isSelected() {
            return this.fIsSelected && this.isEnabled();
        }

        protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
            return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        }

        @Override
        protected void paintComponent(Graphics g) {
            Icon disabledIcon;
            String text = this.getText();
            Icon icon = this.getIcon();
            if (icon != null && !this.isEnabled() && (disabledIcon = this.getDisabledIcon()) != null) {
                icon = disabledIcon;
            }
            if (icon == null && text == null) {
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fm = g.getFontMetrics();
            Insets paintViewInsets = this.getInsets(null);
            paintViewInsets.left += 10;
            Rectangle paintViewR = new Rectangle(paintViewInsets.left, paintViewInsets.top, this.getWidth() - (paintViewInsets.left + paintViewInsets.right), this.getHeight() - (paintViewInsets.top + paintViewInsets.bottom));
            Rectangle paintIconR = new Rectangle();
            Rectangle paintTextR = new Rectangle();
            String clippedText = this.layoutCL(this, fm, text, icon, paintViewR, paintIconR, paintTextR);
            if (icon != null) {
                icon.paintIcon(this, g, paintIconR.x + 5, paintIconR.y);
            }
            if (text != null) {
                int textX = paintTextR.x;
                int textY = paintTextR.y + fm.getAscent() + 1;
                if (this.isEnabled()) {
                    Color background = this.getBackground();
                    g.setColor(background);
                    g.fillRect(textX - 1, paintTextR.y, paintTextR.width + 2, fm.getAscent() + 2);
                    g.setColor(this.getForeground());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, g, clippedText, textX, textY);
                } else {
                    Color background = this.getBackground();
                    g.setColor(background);
                    g.fillRect(textX - 1, paintTextR.y, paintTextR.width + 2, fm.getAscent() + 2);
                    g.setColor(background.brighter());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, g, clippedText, textX, textY);
                    g.setColor(background.darker());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, g, clippedText, textX + 1, textY + 1);
                }
            }
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = AquaFileChooserUI.this.getFileChooser();
            fc.setCurrentDirectory(fc.getFileSystemView().createFileObject(AquaFileChooserUI.this.getDirectoryName()));
            fc.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaFileChooserUI.this.getFileChooser().cancelSelection();
        }

        @Override
        public boolean isEnabled() {
            return AquaFileChooserUI.this.getFileChooser().isEnabled();
        }
    }

    protected class OpenSelectionAction
    extends AbstractAction {
        protected OpenSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File selectedFile;
            int index = AquaFileChooserUI.this.fFileList.getSelectedRow();
            if (index >= 0 && (selectedFile = (File)((AquaFileSystemModel)AquaFileChooserUI.this.fFileList.getModel()).getElementAt(index)) != null) {
                AquaFileChooserUI.this.openDirectory(selectedFile);
            }
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaFileChooserUI.this.fSubPanel.approveSelection(AquaFileChooserUI.this.getFileChooser());
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super(newFolderAccessibleName);
        }

        private Object showNewFolderDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] options, Object initialSelectionValue) {
            JOptionPane pane = new JOptionPane(message, messageType, 2, icon, options, null);
            pane.setWantsInput(true);
            pane.setInitialSelectionValue(initialSelectionValue);
            JDialog dialog = pane.createDialog(parentComponent, title);
            pane.selectInitialValue();
            dialog.setVisible(true);
            dialog.dispose();
            Object value = pane.getValue();
            if (value == null || value.equals(AquaFileChooserUI.this.cancelButtonText)) {
                return null;
            }
            return pane.getInputValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = AquaFileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            File newFolder = null;
            Object[] options = new String[]{AquaFileChooserUI.this.createButtonText, AquaFileChooserUI.this.cancelButtonText};
            String filename = (String)this.showNewFolderDialog(fc, AquaFileChooserUI.this.newFolderDialogPrompt, AquaFileChooserUI.this.newFolderTitleText, -1, null, options, AquaFileChooserUI.this.newFolderDefaultName);
            if (filename != null) {
                try {
                    newFolder = fc.getFileSystemView().createFileObject(currentDirectory, filename);
                    if (newFolder.exists()) {
                        JOptionPane.showMessageDialog(fc, AquaFileChooserUI.this.newFolderExistsErrorText, "", 0);
                        return;
                    }
                    newFolder.mkdirs();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(fc, AquaFileChooserUI.this.newFolderErrorText, "", 0);
                    return;
                }
                AquaFileChooserUI.this.openDirectory(newFolder);
            }
        }
    }

    protected class DefaultButtonAction
    extends AbstractAction {
        protected DefaultButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRootPane root = AquaFileChooserUI.this.getFileChooser().getRootPane();
            JFileChooser fc = AquaFileChooserUI.this.getFileChooser();
            JButton owner = root.getDefaultButton();
            if (owner != null && SwingUtilities.getRootPane(owner) == root && owner.isEnabled()) {
                owner.doClick(20);
            } else if (!fc.getControlButtonsAreShown()) {
                JButton defaultButton = AquaFileChooserUI.this.fSubPanel.getDefaultButton(fc);
                if (defaultButton != null) {
                    defaultButton.doClick(20);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class DnDHandler
    extends DropTargetAdapter {
        DnDHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.tryToAcceptDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.tryToAcceptDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.tryToAcceptDrag(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.handleFileDropEvent(dtde);
                return;
            }
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.handleStringDropEvent(dtde);
                return;
            }
        }

        protected void tryToAcceptDrag(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrag(1);
                return;
            }
            dtde.rejectDrag();
        }

        protected void handleFileDropEvent(DropTargetDropEvent dtde) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            try {
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                this.dropFiles(fileList.toArray(new File[fileList.size()]));
                dtde.dropComplete(true);
            }
            catch (Exception e) {
                dtde.dropComplete(false);
            }
        }

        protected void handleStringDropEvent(DropTargetDropEvent dtde) {
            String stringData;
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            try {
                stringData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                dtde.dropComplete(false);
                return;
            }
            try {
                File fileAsPath = new File(stringData);
                if (fileAsPath.exists()) {
                    this.dropFiles(new File[]{fileAsPath});
                    dtde.dropComplete(true);
                    return;
                }
            }
            catch (Exception fileAsPath) {
                // empty catch block
            }
            try {
                File fileAsURI = new File(new URI(stringData));
                if (fileAsURI.exists()) {
                    this.dropFiles(new File[]{fileAsURI});
                    dtde.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dtde.dropComplete(false);
        }

        protected void dropFiles(final File[] files) {
            JFileChooser jfc = AquaFileChooserUI.this.getFileChooser();
            if (files.length == 1) {
                if (files[0].isDirectory()) {
                    jfc.setCurrentDirectory(files[0]);
                    return;
                }
                if (!AquaFileChooserUI.this.isSelectableForMode(jfc, files[0])) {
                    return;
                }
            }
            jfc.setSelectedFiles(files);
            for (File file : files) {
                jfc.ensureFileIsVisible(file);
            }
            AquaFileChooserUI.this.getModel().runWhenDone(new Runnable(){

                @Override
                public void run() {
                    AquaFileSystemModel fileSystemModel = AquaFileChooserUI.this.getModel();
                    for (File element : files) {
                        int index = fileSystemModel.indexOf(element);
                        if (index < 0) continue;
                        AquaFileChooserUI.this.fFileList.addRowSelectionInterval(index, index);
                    }
                }
            });
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JTableExtension list;

        public DoubleClickListener(JTableExtension list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            int index = this.list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            File f = (File)((AquaFileSystemModel)this.list.getModel()).getElementAt(index);
            if (AquaFileChooserUI.this.openDirectory(f)) {
                return;
            }
            if (!AquaFileChooserUI.this.isSelectableInList(f)) {
                return;
            }
            AquaFileChooserUI.this.getFileChooser().approveSelection();
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        void textChanged() {
            AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isSave;
            if (e.getValueIsAdjusting()) {
                return;
            }
            File f = null;
            int selectedRow = AquaFileChooserUI.this.fFileList.getSelectedRow();
            JFileChooser chooser = AquaFileChooserUI.this.getFileChooser();
            boolean bl = isSave = chooser.getDialogType() == 1;
            if (selectedRow >= 0) {
                f = (File)AquaFileChooserUI.this.fFileList.getValueAt(selectedRow, 0);
            }
            AquaFileChooserUI.this.selectionInProgress = true;
            if (!isSave && chooser.isMultiSelectionEnabled()) {
                int[] rows = AquaFileChooserUI.this.fFileList.getSelectedRows();
                int selectableCount = 0;
                if (rows.length > 0) {
                    for (int element : rows) {
                        if (!AquaFileChooserUI.this.isSelectableForMode(chooser, (File)AquaFileChooserUI.this.fFileList.getValueAt(element, 0))) continue;
                        ++selectableCount;
                    }
                }
                if (selectableCount > 0) {
                    File[] files = new File[selectableCount];
                    int si = 0;
                    for (int i = 0; i < rows.length; ++i) {
                        f = (File)AquaFileChooserUI.this.fFileList.getValueAt(rows[i], 0);
                        if (!AquaFileChooserUI.this.isSelectableForMode(chooser, f)) continue;
                        if (AquaFileChooserUI.this.fileView.isAlias(f)) {
                            f = AquaFileChooserUI.this.fileView.resolveAlias(f);
                        }
                        files[si++] = f;
                    }
                    chooser.setSelectedFiles(files);
                } else {
                    chooser.setSelectedFiles(null);
                }
            } else {
                chooser.setSelectedFiles(null);
                chooser.setSelectedFile(f);
            }
            AquaFileChooserUI.this.selectionInProgress = false;
        }
    }
}

