/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;

class AquaFileSystemModel
extends AbstractTableModel
implements PropertyChangeListener {
    private final JTable fFileList;
    private LoadFilesThread loadThread = null;
    private Vector<File> files = null;
    JFileChooser filechooser = null;
    Vector<SortableFile> fileCache = null;
    Object fileCacheLock;
    Vector<File> directories = null;
    int fetchID = 0;
    private final boolean[] fSortAscending = new boolean[]{true, true};
    private boolean fSortNames = true;
    private final String[] fColumnNames;
    public static final String SORT_BY_CHANGED = "sortByChanged";
    public static final String SORT_ASCENDING_CHANGED = "sortAscendingChanged";
    final QuickSortNames sSortNames = new QuickSortNames();
    final QuickSortDates sSortDates = new QuickSortDates();

    public AquaFileSystemModel(JFileChooser filechooser, JTable filelist, String[] colNames) {
        this.fileCacheLock = new Object();
        this.filechooser = filechooser;
        this.fFileList = filelist;
        this.fColumnNames = colNames;
        this.validateFileCache();
        this.updateSelectionMode();
    }

    void updateSelectionMode() {
        boolean b = this.filechooser.isMultiSelectionEnabled() && this.filechooser.getDialogType() != 1;
        this.fFileList.setSelectionMode(b ? 2 : 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "directoryChanged" || prop == "fileViewChanged" || prop == "fileFilterChanged" || prop == "FileHidingChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
            this.updateSelectionMode();
        } else if (prop == "fileSelectionChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        }
        if (prop == SORT_BY_CHANGED) {
            this.fSortNames = (Integer)e.getNewValue() == 0;
            this.invalidateFileCache();
            this.validateFileCache();
            this.fFileList.repaint();
        }
        if (prop == SORT_ASCENDING_CHANGED) {
            int sortColumn = this.fSortNames ? 0 : 1;
            this.fSortAscending[sortColumn] = (Boolean)e.getNewValue();
            this.invalidateFileCache();
            this.validateFileCache();
            this.fFileList.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFileCache() {
        this.files = null;
        this.directories = null;
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                int lastRow = this.fileCache.size();
                this.fileCache = null;
                this.fireTableRowsDeleted(0, lastRow);
            }
        }
    }

    public Vector<File> getDirectories() {
        if (this.directories != null) {
            return this.directories;
        }
        return this.directories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        if (this.files != null) {
            return this.files;
        }
        this.files = new Vector();
        this.directories = new Vector();
        this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
        Object object = this.fileCacheLock;
        synchronized (object) {
            for (int i = 0; i < this.fileCache.size(); ++i) {
                SortableFile sf = this.fileCache.elementAt(i);
                File f = sf.fFile;
                if (this.filechooser.isTraversable(f)) {
                    this.directories.addElement(f);
                    continue;
                }
                this.files.addElement(f);
            }
        }
        return this.files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenDone(Runnable runnable) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.loadThread != null && this.loadThread.isAlive()) {
                this.loadThread.queuedTasks.add(runnable);
                return;
            }
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateFileCache() {
        File currentDirectory = this.filechooser.getCurrentDirectory();
        if (currentDirectory == null) {
            this.invalidateFileCache();
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.invalidateFileCache();
        Object object = this.fileCacheLock;
        synchronized (object) {
            this.fileCache = new Vector(50);
        }
        this.loadThread = new LoadFilesThread(currentDirectory, this.fetchID);
        this.loadThread.start();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return this.fColumnNames[col];
    }

    public Class<? extends Object> getColumnClass(int col) {
        if (col == 0) {
            return File.class;
        }
        return Date.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                return this.fileCache.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(File o) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                return this.fileCache.contains(new SortableFile(o));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(File o) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                boolean isAscending = this.fSortNames ? this.fSortAscending[0] : this.fSortAscending[1];
                int row = this.fileCache.indexOf(new SortableFile(o));
                return isAscending ? row : this.fileCache.size() - row - 1;
            }
            return 0;
        }
    }

    public Object getElementAt(int row) {
        return this.getValueAt(row, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || col < 0) {
            return null;
        }
        boolean isAscending = this.fSortNames ? this.fSortAscending[0] : this.fSortAscending[1];
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                if (!isAscending) {
                    row = this.fileCache.size() - row - 1;
                }
                return this.fileCache.elementAt(row).getValueAt(col);
            }
            return null;
        }
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    protected void sort(Vector<Object> v) {
        if (this.fSortNames) {
            this.sSortNames.quickSort(v, 0, v.size() - 1);
        } else {
            this.sSortDates.quickSort(v, 0, v.size() - 1);
        }
    }

    class DoChangeContents
    implements Runnable {
        private Vector<SortableFile> contentFiles;
        private boolean doFire = true;
        private final Object lock = new Object();
        private final int fid;

        public DoChangeContents(Vector<SortableFile> files, int fid) {
            this.contentFiles = files;
            this.fid = fid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AquaFileSystemModel.this.fetchID == this.fid) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.doFire) {
                        Object object2 = AquaFileSystemModel.this.fileCacheLock;
                        synchronized (object2) {
                            if (AquaFileSystemModel.this.fileCache != null) {
                                for (int i = 0; i < this.contentFiles.size(); ++i) {
                                    AquaFileSystemModel.this.fileCache.addElement(this.contentFiles.elementAt(i));
                                    AquaFileSystemModel.this.fireTableRowsInserted(i, i);
                                }
                            }
                        }
                    }
                    this.contentFiles = null;
                    AquaFileSystemModel.this.directories = null;
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        Vector<Runnable> queuedTasks;
        File currentDirectory;
        int fid;

        public LoadFilesThread(File currentDirectory, int fid) {
            super("Aqua L&F File Loading Thread");
            this.queuedTasks = new Vector();
            this.currentDirectory = null;
            this.currentDirectory = currentDirectory;
            this.fid = fid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Vector<DoChangeContents> runnables = new Vector<DoChangeContents>(10);
            FileSystemView fileSystem = AquaFileSystemModel.this.filechooser.getFileSystemView();
            File[] list = fileSystem.getFiles(this.currentDirectory, AquaFileSystemModel.this.filechooser.isFileHidingEnabled());
            Vector<Object> acceptsList = new Vector<Object>();
            for (File element : list) {
                acceptsList.addElement(new SortableFile(element));
            }
            AquaFileSystemModel.this.sort(acceptsList);
            Vector<SortableFile> chunk = new Vector<SortableFile>(10);
            int listSize = acceptsList.size();
            int i = 0;
            while (i < listSize) {
                for (int j = 0; j < 10 && i < listSize; ++j, ++i) {
                    SortableFile f = (SortableFile)acceptsList.elementAt(i);
                    chunk.addElement(f);
                }
                DoChangeContents runnable = new DoChangeContents(chunk, this.fid);
                runnables.addElement(runnable);
                SwingUtilities.invokeLater(runnable);
                chunk = new Vector(10);
                if (!this.isInterrupted()) continue;
                this.cancelRunnables(runnables);
                return;
            }
            Object object = AquaFileSystemModel.this.fileCacheLock;
            synchronized (object) {
                for (Runnable r : this.queuedTasks) {
                    SwingUtilities.invokeLater(r);
                }
            }
        }

        public void cancelRunnables(Vector<DoChangeContents> runnables) {
            for (int i = 0; i < runnables.size(); ++i) {
                runnables.elementAt(i).cancel();
            }
        }
    }

    class SortableFile {
        File fFile;
        String fName;
        long fDateValue;
        Date fDate;

        SortableFile(File f) {
            this.fFile = f;
            this.fName = this.fFile.getName();
            this.fDateValue = this.fFile.lastModified();
            this.fDate = new Date(this.fDateValue);
        }

        public Object getValueAt(int col) {
            if (col == 0) {
                return this.fFile;
            }
            return this.fDate;
        }

        public boolean equals(Object other) {
            SortableFile otherFile = (SortableFile)other;
            return otherFile.fFile.equals(this.fFile);
        }
    }

    class QuickSortDates
    extends QuickSort {
        QuickSortDates() {
        }

        @Override
        protected boolean lt(SortableFile a, SortableFile b) {
            return a.fDateValue < b.fDateValue;
        }
    }

    class QuickSortNames
    extends QuickSort {
        QuickSortNames() {
        }

        @Override
        protected boolean lt(SortableFile a, SortableFile b) {
            String bLower;
            String aLower = a.fName.toLowerCase();
            return aLower.compareTo(bLower = b.fName.toLowerCase()) < 0;
        }
    }

    abstract class QuickSort {
        QuickSort() {
        }

        final void quickSort(Vector<Object> v, int lo0, int hi0) {
            int lo = lo0;
            int hi = hi0;
            if (hi0 > lo0) {
                SortableFile mid = (SortableFile)v.elementAt((lo0 + hi0) / 2);
                while (lo <= hi) {
                    while (lo < hi0 && this.lt((SortableFile)v.elementAt(lo), mid)) {
                        ++lo;
                    }
                    while (hi > lo0 && this.lt(mid, (SortableFile)v.elementAt(hi))) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(v, lo, hi);
                    ++lo;
                    --hi;
                }
                if (lo0 < hi) {
                    this.quickSort(v, lo0, hi);
                }
                if (lo < hi0) {
                    this.quickSort(v, lo, hi0);
                }
            }
        }

        private final void swap(Vector<Object> a, int i, int j) {
            Object T2 = a.elementAt(i);
            a.setElementAt(a.elementAt(j), i);
            a.setElementAt(T2, j);
        }

        protected abstract boolean lt(SortableFile var1, SortableFile var2);
    }
}

