/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaFileChooserUI;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

class AquaFileView
extends FileView {
    private static final boolean DEBUG = false;
    private static final int UNINITALIZED_LS_INFO = -1;
    static final int kLSItemInfoIsPlainFile = 1;
    static final int kLSItemInfoIsPackage = 2;
    static final int kLSItemInfoIsApplication = 4;
    static final int kLSItemInfoIsContainer = 8;
    static final int kLSItemInfoIsAliasFile = 16;
    static final int kLSItemInfoIsSymlink = 32;
    static final int kLSItemInfoIsInvisible = 64;
    static final int kLSItemInfoIsNativeApp = 128;
    static final int kLSItemInfoIsClassicApp = 256;
    static final int kLSItemInfoAppPrefersNative = 512;
    static final int kLSItemInfoAppPrefersClassic = 1024;
    static final int kLSItemInfoAppIsScriptable = 2048;
    static final int kLSItemInfoIsVolume = 4096;
    static final int kLSItemInfoExtensionIsHidden = 0x100000;
    static final AquaUtils.RecyclableSingleton<String> machineName;
    final int MAX_CACHED_ENTRIES = 256;
    protected final Map<File, FileInfo> cache = new LinkedHashMap<File, FileInfo>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, FileInfo> eldest) {
            return this.size() > 256;
        }
    };
    final AquaFileChooserUI fFileChooserUI;

    private static native String getNativePathToSharedJDKBundle();

    private static native String getNativeMachineName();

    private static native String getNativeDisplayName(byte[] var0, boolean var1);

    private static native int getNativeLSInfo(byte[] var0, boolean var1);

    private static native String getNativePathForResolvedAlias(byte[] var0, boolean var1);

    private static String getMachineName() {
        return machineName.get();
    }

    protected static String getPathToRunningJDKBundle() {
        return "";
    }

    protected static String getPathToSharedJDKBundle() {
        return AquaFileView.getNativePathToSharedJDKBundle();
    }

    FileInfo getFileInfoFor(File file) {
        FileInfo info = this.cache.get(file);
        if (info != null) {
            return info;
        }
        FileInfo newInfo = new FileInfo(file);
        this.cache.put(file, newInfo);
        return newInfo;
    }

    public AquaFileView(AquaFileChooserUI fileChooserUI) {
        this.fFileChooserUI = fileChooserUI;
    }

    String _directoryDescriptionText() {
        return this.fFileChooserUI.directoryDescriptionText;
    }

    String _fileDescriptionText() {
        return this.fFileChooserUI.fileDescriptionText;
    }

    boolean _packageIsTraversable() {
        return this.fFileChooserUI.fPackageIsTraversable == 0;
    }

    boolean _applicationIsTraversable() {
        return this.fFileChooserUI.fApplicationIsTraversable == 0;
    }

    @Override
    public String getName(File f) {
        FileInfo info = this.getFileInfoFor(f);
        if (info.displayName != null) {
            return info.displayName;
        }
        String nativeDisplayName = AquaFileView.getNativeDisplayName(info.pathBytes, info.isDirectory);
        if (nativeDisplayName != null) {
            info.displayName = nativeDisplayName;
            return nativeDisplayName;
        }
        String displayName = f.getName();
        if (f.isDirectory() && this.fFileChooserUI.getFileChooser().getFileSystemView().isRoot(f)) {
            String localMachineName;
            info.displayName = localMachineName = AquaFileView.getMachineName();
            return localMachineName;
        }
        info.displayName = displayName;
        return displayName;
    }

    @Override
    public String getDescription(File f) {
        return f.getName();
    }

    @Override
    public String getTypeDescription(File f) {
        if (f.isDirectory()) {
            return this._directoryDescriptionText();
        }
        return this._fileDescriptionText();
    }

    @Override
    public Icon getIcon(File f) {
        FileInfo info = this.getFileInfoFor(f);
        if (info.icon != null) {
            return info.icon;
        }
        if (f == null) {
            info.icon = AquaIcon.SystemIcon.getDocumentIconUIResource();
        } else {
            AquaIcon.FileIcon fileIcon = new AquaIcon.FileIcon(f);
            info.icon = fileIcon;
            if (!fileIcon.hasIconRef()) {
                info.icon = f.isDirectory() ? (this.fFileChooserUI.getFileChooser().getFileSystemView().isRoot(f) ? AquaIcon.SystemIcon.getComputerIconUIResource() : (f.getParent() == null || f.getParent().equals("/") ? AquaIcon.SystemIcon.getHardDriveIconUIResource() : AquaIcon.SystemIcon.getFolderIconUIResource())) : AquaIcon.SystemIcon.getDocumentIconUIResource();
            }
        }
        return info.icon;
    }

    @Override
    public Boolean isTraversable(File f) {
        if (f.isDirectory()) {
            if (this._packageIsTraversable() && this._applicationIsTraversable()) {
                return Boolean.TRUE;
            }
            if (!this._packageIsTraversable() && !this._applicationIsTraversable() ? this.isPackage(f) || this.isApplication(f) : (!this._applicationIsTraversable() ? this.isApplication(f) : !this._packageIsTraversable() && this.isPackage(f) && !this.isApplication(f))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (this.isAlias(f)) {
            File realFile = this.resolveAlias(f);
            return realFile.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    int getLSInfoFor(File f) {
        FileInfo info = this.getFileInfoFor(f);
        if (info.launchServicesInfo == -1) {
            info.launchServicesInfo = AquaFileView.getNativeLSInfo(info.pathBytes, info.isDirectory);
        }
        return info.launchServicesInfo;
    }

    boolean isAlias(File f) {
        int lsInfo = this.getLSInfoFor(f);
        return (lsInfo & 0x10) != 0 && (lsInfo & 0x20) == 0;
    }

    boolean isApplication(File f) {
        return (this.getLSInfoFor(f) & 4) != 0;
    }

    boolean isPackage(File f) {
        return (this.getLSInfoFor(f) & 2) != 0;
    }

    File resolveAlias(File mFile) {
        if (mFile.exists() && !this.isAlias(mFile)) {
            return mFile;
        }
        LinkedList<String> components = AquaFileView.getPathComponents(mFile);
        if (components == null) {
            return mFile;
        }
        File file = new File("/");
        for (String nextComponent : components) {
            file = new File(file, nextComponent);
            FileInfo info = this.getFileInfoFor(file);
            if (!file.exists()) {
                return mFile;
            }
            if (!this.isAlias(file)) continue;
            String path = AquaFileView.getNativePathForResolvedAlias(info.pathBytes, info.isDirectory);
            if (path == null) {
                return mFile;
            }
            file = new File(path);
        }
        return file;
    }

    private static LinkedList<String> getPathComponents(File mFile) {
        String parent;
        LinkedList<String> componentList = new LinkedList<String>();
        File file = new File(mFile.getAbsolutePath());
        componentList.add(0, file.getName());
        while ((parent = file.getParent()) != null) {
            file = new File(parent);
            componentList.add(0, file.getName());
        }
        return componentList;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osxui");
                return null;
            }
        });
        machineName = new AquaUtils.RecyclableSingleton<String>(){

            @Override
            protected String getInstance() {
                return AquaFileView.getNativeMachineName();
            }
        };
    }

    static class FileInfo {
        final boolean isDirectory;
        final String absolutePath;
        byte[] pathBytes;
        String displayName;
        Icon icon;
        int launchServicesInfo = -1;

        FileInfo(File file) {
            this.isDirectory = file.isDirectory();
            this.absolutePath = file.getAbsolutePath();
            try {
                this.pathBytes = this.absolutePath.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.pathBytes = new byte[0];
            }
        }
    }
}

