/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;

public class AquaHighlighter
extends DefaultHighlighter
implements UIResource {
    static final AquaUtils.RecyclableSingleton<LayeredHighlighter.LayerPainter> instance = new AquaUtils.RecyclableSingleton<LayeredHighlighter.LayerPainter>(){

        @Override
        protected LayeredHighlighter.LayerPainter getInstance() {
            return new AquaHighlightPainter(null);
        }
    };

    protected static LayeredHighlighter.LayerPainter getInstance() {
        return instance.get();
    }

    public static class AquaHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        Color selectionColor;
        Color disabledSelectionColor;

        public AquaHighlightPainter(Color c) {
            super(c);
        }

        @Override
        public Color getColor() {
            return this.selectionColor == null ? super.getColor() : this.selectionColor;
        }

        protected Color getInactiveSelectionColor() {
            if (this.disabledSelectionColor != null) {
                return this.disabledSelectionColor;
            }
            this.disabledSelectionColor = UIManager.getColor("TextComponent.selectionBackgroundInactive");
            return this.disabledSelectionColor;
        }

        void setColor(JTextComponent c) {
            Window owningWindow;
            this.selectionColor = super.getColor();
            if (this.selectionColor == null) {
                this.selectionColor = c.getSelectionColor();
            }
            if ((owningWindow = SwingUtilities.getWindowAncestor(c)) != null && !owningWindow.isActive()) {
                this.selectionColor = this.getInactiveSelectionColor();
            }
            if (!c.hasFocus()) {
                this.selectionColor = this.getInactiveSelectionColor();
            }
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            this.setColor(c);
            super.paint(g, offs0, offs1, bounds, c);
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            this.setColor(c);
            return super.paintLayer(g, offs0, offs1, bounds, c, view);
        }
    }
}

