/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaFonts;
import com.apple.laf.AquaUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;
import sun.swing.SwingUtilities2;

public class AquaInternalFrameDockIconUI
extends DesktopIconUI
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final String CACHED_FRAME_ICON_KEY = "apple.laf.internal.frameIcon";
    protected JInternalFrame.JDesktopIcon fDesktopIcon;
    protected JInternalFrame fFrame;
    protected ScaledImageLabel fIconPane;
    protected DockLabel fDockLabel;
    protected boolean fTrackingIcon = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaInternalFrameDockIconUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.fDesktopIcon = (JInternalFrame.JDesktopIcon)c;
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        this.uninstallListeners();
        this.fDesktopIcon = null;
        this.fFrame = null;
    }

    protected void installComponents() {
        this.fFrame = this.fDesktopIcon.getInternalFrame();
        this.fIconPane = new ScaledImageLabel();
        this.fDesktopIcon.setLayout(new BorderLayout());
        this.fDesktopIcon.add((Component)this.fIconPane, "Center");
    }

    protected void uninstallComponents() {
        this.fDesktopIcon.setLayout(null);
        this.fDesktopIcon.remove(this.fIconPane);
    }

    protected void installListeners() {
        this.fDesktopIcon.addMouseListener(this);
        this.fDesktopIcon.addMouseMotionListener(this);
        this.fFrame.addComponentListener(this);
    }

    protected void uninstallListeners() {
        this.fFrame.removeComponentListener(this);
        this.fDesktopIcon.removeMouseMotionListener(this);
        this.fDesktopIcon.removeMouseListener(this);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(32, 32);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(128, 128);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(64, 64);
    }

    public Insets getInsets(JComponent c) {
        return new Insets(0, 0, 0, 0);
    }

    void updateIcon() {
        this.fIconPane.updateIcon();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fTrackingIcon = this.fIconPane.mouseInIcon(e);
        if (this.fTrackingIcon) {
            this.fIconPane.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.fFrame.isIconifiable() && this.fFrame.isIcon() && this.fTrackingIcon) {
            this.fTrackingIcon = false;
            if (this.fIconPane.mouseInIcon(e)) {
                if (this.fDockLabel != null) {
                    this.fDockLabel.hide();
                }
                try {
                    this.fFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.fIconPane.repaint();
            }
        }
        if (this.fDockLabel != null && !this.fIconPane.getBounds().contains(e.getX(), e.getY())) {
            this.fDockLabel.hide();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            return;
        }
        String title = this.fFrame.getTitle();
        if (title == null || title.equals("")) {
            title = "Untitled";
        }
        this.fDockLabel = new DockLabel(title);
        this.fDockLabel.show(this.fDesktopIcon);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.fDockLabel != null && (e.getModifiers() & 0x10) == 0) {
            this.fDockLabel.hide();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.fFrame.putClientProperty(CACHED_FRAME_ICON_KEY, null);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.fFrame.putClientProperty(CACHED_FRAME_ICON_KEY, null);
    }

    class DockLabel
    extends JLabel {
        static final int NUB_HEIGHT = 7;
        static final int ROUND_ADDITIONAL_HEIGHT = 8;
        static final int ROUND_ADDITIONAL_WIDTH = 12;

        DockLabel(String text) {
            super(text);
            this.setBorder(null);
            this.setOpaque(false);
            this.setFont(AquaFonts.getDockIconFont());
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.setSize(SwingUtilities.computeStringWidth(metrics, this.getText()) + 24, metrics.getAscent() + 7 + 8);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d;
            int width = this.getWidth();
            int height = this.getHeight();
            Font font = this.getFont();
            FontMetrics metrics = this.getFontMetrics(font);
            g.setFont(font);
            String text = this.getText().trim();
            int ascent = metrics.getAscent();
            Rectangle2D stringBounds = metrics.getStringBounds(text, g);
            int halfway = width / 2;
            int x = halfway - (int)stringBounds.getWidth() / 2;
            Graphics2D graphics2D = g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            if (g2d != null) {
                g.setColor(UIManager.getColor("DesktopIcon.labelBackground"));
                Object origAA = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int roundHeight = height - 8 + 1;
                g.fillRoundRect(0, 0, width, roundHeight, roundHeight, roundHeight);
                int[] xpts = new int[]{halfway, halfway + 7, halfway - 7};
                int[] ypts = new int[]{height, height - 7, height - 7};
                g.fillPolygon(xpts, ypts, 3);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAA);
            }
            g.setColor(Color.black);
            SwingUtilities2.drawString((JComponent)this, g, text, x, 2 + ascent);
            g.setColor(Color.white);
            SwingUtilities2.drawString((JComponent)this, g, text, x, 1 + ascent);
        }

        public void show(Component invoker) {
            Serializable p;
            int desiredLocationX = (invoker.getWidth() - this.getWidth()) / 2;
            int desiredLocationY = -(this.getHeight() + 6);
            Container parent = invoker.getParent();
            for (p = parent; p != null; p = ((Component)p).getParent()) {
                if (!(p instanceof JRootPane) || ((Component)p).getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                for (p = parent.getParent(); p != null && !(p instanceof Window); p = ((Component)p).getParent()) {
                }
                break;
            }
            p = SwingUtilities.convertPoint(invoker, desiredLocationX, desiredLocationY, parent);
            this.setLocation(((Point)p).x, ((Point)p).y);
            if (parent instanceof JLayeredPane) {
                ((JLayeredPane)parent).add(this, JLayeredPane.POPUP_LAYER, 0);
            }
        }

        @Override
        public void hide() {
            Container parent = this.getParent();
            Rectangle r = this.getBounds();
            if (parent == null) {
                return;
            }
            parent.remove(this);
            parent.repaint(r.x, r.y, r.width, r.height);
        }
    }

    class ScaledImageLabel
    extends JLabel {
        ScaledImageLabel() {
            super(null, null, 0);
        }

        void updateIcon() {
            Object priorIcon = AquaInternalFrameDockIconUI.this.fFrame.getClientProperty(AquaInternalFrameDockIconUI.CACHED_FRAME_ICON_KEY);
            if (priorIcon instanceof ImageIcon) {
                this.setIcon((ImageIcon)priorIcon);
                return;
            }
            int width = AquaInternalFrameDockIconUI.this.fFrame.getWidth();
            int height = AquaInternalFrameDockIconUI.this.fFrame.getHeight();
            if (width <= 0 || height <= 0) {
                width = 128;
                height = 128;
            }
            BufferedImage fImage = new BufferedImage(width, height, 3);
            Graphics g = ((Image)fImage).getGraphics();
            AquaInternalFrameDockIconUI.this.fFrame.paint(g);
            g.dispose();
            float scale = (float)AquaInternalFrameDockIconUI.this.fDesktopIcon.getWidth() / (float)Math.max(width, height) * 0.89f;
            ImageIcon icon = new ImageIcon(fImage.getScaledInstance((int)((float)width * scale), -1, 4));
            AquaInternalFrameDockIconUI.this.fFrame.putClientProperty(AquaInternalFrameDockIconUI.CACHED_FRAME_ICON_KEY, icon);
            this.setIcon(icon);
        }

        @Override
        public void paint(Graphics g) {
            if (this.getIcon() == null) {
                this.updateIcon();
            }
            g.translate(0, 2);
            if (!AquaInternalFrameDockIconUI.this.fTrackingIcon) {
                super.paint(g);
                return;
            }
            ImageIcon prev = (ImageIcon)this.getIcon();
            ImageIcon pressedIcon = new ImageIcon(AquaUtils.generateSelectedDarkImage(prev.getImage()));
            this.setIcon(pressedIcon);
            super.paint(g);
            this.setIcon(prev);
        }

        boolean mouseInIcon(MouseEvent e) {
            return this.getBounds().contains(e.getX(), e.getY());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(64, 64);
        }
    }
}

