/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaInternalFrameDockIconUI;
import com.apple.laf.AquaInternalFrameManager;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class AquaInternalFramePaneUI
extends BasicDesktopPaneUI
implements MouseListener {
    JComponent fDock;
    DockLayoutManager fLayoutMgr;

    public static ComponentUI createUI(JComponent c) {
        return new AquaInternalFramePaneUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            super.update(g, c);
            return;
        }
        this.paint(g, c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.fLayoutMgr = new DockLayoutManager();
        c.setLayout(this.fLayoutMgr);
        c.addMouseListener(this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this);
        if (this.fDock != null) {
            c.remove(this.fDock);
            this.fDock = null;
        }
        if (this.fLayoutMgr != null) {
            c.setLayout(null);
            this.fLayoutMgr = null;
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new AquaDockingDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    @Override
    protected void uninstallDesktopManager() {
        DesktopManager manager = this.desktop.getDesktopManager();
        if (manager instanceof AquaDockingDesktopManager) {
            this.desktop.setDesktopManager(null);
        }
    }

    JComponent getDock() {
        if (this.fDock == null) {
            this.fDock = new Dock(this.desktop);
            this.desktop.add((Component)this.fDock, new Integer(399));
        }
        return this.fDock;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JInternalFrame selectedFrame = this.desktop.getSelectedFrame();
        if (selectedFrame != null) {
            try {
                selectedFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.desktop.getDesktopManager().deactivateFrame(selectedFrame);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class AquaDockingDesktopManager
    extends AquaInternalFrameManager {
        AquaDockingDesktopManager() {
        }

        @Override
        public void openFrame(JInternalFrame f) {
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            Container dock = desktopIcon.getParent();
            if (dock == null) {
                return;
            }
            if (dock.getParent() != null) {
                dock.getParent().add(f);
            }
            this.removeIconFor(f);
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            Container dock = desktopIcon.getParent();
            if (dock == null) {
                return;
            }
            if (dock.getParent() != null) {
                dock.getParent().add(f);
            }
            this.removeIconFor(f);
            f.moveToFront();
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            ((AquaInternalFrameDockIconUI)desktopIcon.getUI()).updateIcon();
            super.iconifyFrame(f);
        }

        @Override
        void addIcon(Container c, JInternalFrame.JDesktopIcon desktopIcon) {
            DesktopPaneUI ui = ((JDesktopPane)c).getUI();
            ((AquaInternalFramePaneUI)ui).getDock().add(desktopIcon);
        }
    }

    class Dock
    extends JComponent
    implements Border {
        static final int DOCK_EDGE_SLACK = 8;

        Dock(JComponent parent) {
            this.setBorder(this);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setVisible(false);
        }

        @Override
        public void removeNotify() {
            AquaInternalFramePaneUI.this.fDock = null;
            super.removeNotify();
        }

        void updateSize() {
            Dimension d = this.getPreferredSize();
            this.setBounds((this.getParent().getWidth() - d.width) / 2, this.getParent().getHeight() - d.height, d.width, d.height);
        }

        @Override
        public Component add(Component c) {
            super.add(c);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.updateSize();
            this.validate();
            return c;
        }

        @Override
        public void remove(Component c) {
            super.remove(c);
            if (this.getComponentCount() == 0) {
                this.setVisible(false);
            } else {
                this.updateSize();
                this.validate();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 8, 0, 8);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            Object priorAA = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(UIManager.getColor("DesktopIcon.borderColor"));
            g2d.fillRoundRect(4, 4, width - 9, height + 8, 8, 8);
            g2d.setColor(UIManager.getColor("DesktopIcon.borderRimColor"));
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawRoundRect(4, 4, width - 9, height + 8, 8, 8);
            if (priorAA != null) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, priorAA);
            }
        }
    }

    class DockLayoutManager
    implements LayoutManager {
        DockLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AquaInternalFramePaneUI.this.fDock != null) {
                ((Dock)AquaInternalFramePaneUI.this.fDock).updateSize();
            }
        }
    }
}

