/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaInternalFrameBorder;
import com.apple.laf.AquaLookAndFeel;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class AquaInternalFrameUI
extends BasicInternalFrameUI
implements SwingConstants {
    protected static final String IS_PALETTE_PROPERTY = "JInternalFrame.isPalette";
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    private static final String NORMAL_FRAME = "normal";
    private static final String PALETTE_FRAME = "palette";
    private static final String OPTION_DIALOG = "optionDialog";
    PropertyChangeListener fPropertyListener;
    protected Color fSelectedTextColor;
    protected Color fNotSelectedTextColor;
    AquaInternalFrameBorder fAquaBorder;
    boolean fMouseOverPressedButton;
    int fWhichButtonPressed = -1;
    boolean fRollover = false;
    boolean fDocumentEdited = false;
    boolean fIsPallet;
    static final AquaUtils.RecyclableSingleton<Icon> closeIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX);
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> minimizeIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX);
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> zoomIcon = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaInternalFrameButtonIcon(JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX);
        }
    };
    protected ResizeBox resizeBox;
    static final InternalFrameShadow documentWindowShadow = new InternalFrameShadow(){

        @Override
        Border getForegroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    g.setColor(new Color(0, 0, 0, 196));
                    g.fillRoundRect(x, y, w, h, 16, 16);
                    g.fillRect(x, y + h - 16, w, 16);
                }
            }, new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    g.setColor(new Color(0, 0, 0, 64));
                    g.drawLine(x + 2, y - 8, x + w - 2, y - 8);
                }
            }, 0, 7, 1.1f, 1.0f, 24, 51, 51, 25, 25, 25, 25);
        }

        @Override
        Border getBackgroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    g.setColor(new Color(0, 0, 0, 128));
                    g.fillRoundRect(x - 3, y - 8, w + 6, h, 16, 16);
                    g.fillRect(x - 3, y + h - 20, w + 6, 19);
                }
            }, new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    g.setColor(new Color(0, 0, 0, 32));
                    g.drawLine(x, y - 11, x + w - 1, y - 11);
                }
            }, 0, 0, 3.0f, 1.0f, 10, 51, 51, 25, 25, 25, 25);
        }
    };
    static final InternalFrameShadow paletteWindowShadow = new InternalFrameShadow(){

        @Override
        Border getForegroundShadowBorder() {
            return new AquaUtils.SlicedShadowBorder(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    g.setColor(new Color(0, 0, 0, 128));
                    g.fillRect(x, y + 3, w, h - 3);
                }
            }, null, 0, 3, 1.0f, 1.0f, 10, 25, 25, 12, 12, 12, 12);
        }

        @Override
        Border getBackgroundShadowBorder() {
            return this.getForegroundShadowBorder();
        }
    };
    static final AquaUtils.RecyclableSingleton<Icon> RESIZE_ICON = new AquaUtils.RecyclableSingleton<Icon>(){

        @Override
        protected Icon getInstance() {
            return new AquaIcon.ScalingJRSUIIcon(11, 11){

                @Override
                public void initIconPainter(AquaPainter<JRSUIState> iconState) {
                    ((JRSUIState)iconState.state).set(JRSUIConstants.Widget.GROW_BOX_TEXTURED);
                    ((JRSUIState)iconState.state).set(JRSUIConstants.WindowType.UTILITY);
                }
            };
        }
    };

    public int getWhichButtonPressed() {
        return this.fWhichButtonPressed;
    }

    public boolean getMouseOverPressedButton() {
        return this.fMouseOverPressedButton;
    }

    public boolean getRollover() {
        return this.fRollover;
    }

    public static ComponentUI createUI(JComponent b) {
        return new AquaInternalFrameUI((JInternalFrame)b);
    }

    public AquaInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        this.frame = (JInternalFrame)c;
        this.frame.add((Component)this.frame.getRootPane(), "Center");
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        Object paletteProp = c.getClientProperty(IS_PALETTE_PROPERTY);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        } else {
            paletteProp = c.getClientProperty(FRAME_TYPE);
            if (paletteProp != null) {
                this.setFrameType((String)paletteProp);
            } else {
                this.setFrameType(NORMAL_FRAME);
            }
        }
        this.frame.setMinimumSize(new Dimension(this.fIsPallet ? 120 : 150, this.fIsPallet ? 39 : 65));
        this.frame.setOpaque(false);
        c.setBorder(new CompoundUIBorder(this.fIsPallet ? (Border)paletteWindowShadow.get() : (Border)documentWindowShadow.get(), c.getBorder()));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.fSelectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.fNotSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    @Override
    public void setSouthPane(JComponent c) {
        if (this.southPane != null) {
            this.frame.remove(this.southPane);
            this.deinstallMouseHandlers(this.southPane);
        }
        if (c != null) {
            this.frame.add(c);
            this.installMouseHandlers(c);
        }
        this.southPane = c;
    }

    public static Icon exportCloseIcon() {
        return closeIcon.get();
    }

    public static Icon exportMinimizeIcon() {
        return minimizeIcon.get();
    }

    public static Icon exportZoomIcon() {
        return zoomIcon.get();
    }

    @Override
    protected void installKeyboardActions() {
    }

    @Override
    protected void installComponents() {
        JLayeredPane layeredPane = this.frame.getLayeredPane();
        if (this.resizeBox != null) {
            this.resizeBox.removeListeners();
            layeredPane.removeComponentListener(this.resizeBox);
            layeredPane.remove(this.resizeBox);
            this.resizeBox = null;
        }
        this.resizeBox = new ResizeBox(layeredPane);
        this.resizeBox.repositionResizeBox();
        layeredPane.add(this.resizeBox);
        layeredPane.setLayer(this.resizeBox, JLayeredPane.DRAG_LAYER);
        layeredPane.addComponentListener(this.resizeBox);
        this.resizeBox.addListeners();
        this.resizeBox.setVisible(this.frame.isResizable());
    }

    @Override
    protected void installListeners() {
        this.fPropertyListener = new PropertyListener();
        this.frame.addPropertyChangeListener(this.fPropertyListener);
        super.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(this.fPropertyListener);
    }

    @Override
    protected void uninstallKeyboardActions() {
    }

    @Override
    protected void installMouseHandlers(JComponent c) {
        c.addMouseListener(this.borderListener);
        c.addMouseMotionListener(this.borderListener);
    }

    @Override
    protected void deinstallMouseHandlers(JComponent c) {
        c.removeMouseListener(this.borderListener);
        c.removeMouseMotionListener(this.borderListener);
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        AquaLookAndFeel lf = (AquaLookAndFeel)UIManager.getLookAndFeel();
        ActionMap audioMap = lf.getAudioActionMap();
        map.setParent(audioMap);
        return map;
    }

    @Override
    public Dimension getPreferredSize(JComponent x) {
        Dimension preferredSize = super.getPreferredSize(x);
        Dimension minimumSize = this.frame.getMinimumSize();
        if (preferredSize.width < minimumSize.width) {
            preferredSize.width = minimumSize.width;
        }
        if (preferredSize.height < minimumSize.height) {
            preferredSize.height = minimumSize.height;
        }
        return preferredSize;
    }

    @Override
    public void setNorthPane(JComponent c) {
        this.replacePane(this.northPane, c);
        this.northPane = c;
    }

    @Override
    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this.frame.remove(currentPane);
        }
        if (newPane != null) {
            this.frame.add(newPane);
            this.installMouseHandlers(newPane);
        }
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new AquaBorderListener();
    }

    void setFrameType(String frameType) {
        Color bg = this.frame.getBackground();
        boolean replaceColor = bg == null || bg instanceof UIResource;
        Font font = this.frame.getFont();
        boolean replaceFont = font == null || font instanceof UIResource;
        boolean isPalette = false;
        if (frameType.equals(OPTION_DIALOG)) {
            this.fAquaBorder = AquaInternalFrameBorder.dialog();
            if (replaceColor) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.optionDialogBackground"));
            }
            if (replaceFont) {
                this.frame.setFont(UIManager.getFont("InternalFrame.optionDialogTitleFont"));
            }
        } else if (frameType.equals(PALETTE_FRAME)) {
            this.fAquaBorder = AquaInternalFrameBorder.utility();
            if (replaceColor) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.paletteBackground"));
            }
            if (replaceFont) {
                this.frame.setFont(UIManager.getFont("InternalFrame.paletteTitleFont"));
            }
            isPalette = true;
        } else {
            this.fAquaBorder = AquaInternalFrameBorder.window();
            if (replaceColor) {
                this.frame.setBackground(UIManager.getColor("InternalFrame.background"));
            }
            if (replaceFont) {
                this.frame.setFont(UIManager.getFont("InternalFrame.titleFont"));
            }
        }
        this.fAquaBorder.setColors(this.fSelectedTextColor, this.fNotSelectedTextColor);
        this.frame.setBorder(this.fAquaBorder);
        this.fIsPallet = isPalette;
    }

    public void setPalette(boolean isPalette) {
        this.setFrameType(isPalette ? PALETTE_FRAME : NORMAL_FRAME);
    }

    public boolean isDocumentEdited() {
        return this.fDocumentEdited;
    }

    public void setDocumentEdited(boolean flag) {
        this.fDocumentEdited = flag;
    }

    static void updateComponentTreeUIActivation(Component c, Object active) {
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty("Frame.active", active);
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component element : children) {
                AquaInternalFrameUI.updateComponentTreeUIActivation(element, active);
            }
        }
    }

    class ResizeBox
    extends JLabel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    ComponentListener,
    PropertyChangeListener,
    UIResource {
        final JLayeredPane layeredPane;
        Dimension originalSize;
        Point originalLocation;

        public ResizeBox(JLayeredPane layeredPane) {
            super(RESIZE_ICON.get());
            this.setSize(11, 11);
            this.layeredPane = layeredPane;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        void addListeners() {
            AquaInternalFrameUI.this.frame.addPropertyChangeListener("resizable", this);
        }

        void removeListeners() {
            AquaInternalFrameUI.this.frame.removePropertyChangeListener("resizable", this);
        }

        void repositionResizeBox() {
            if (AquaInternalFrameUI.this.frame == null) {
                this.setSize(0, 0);
            } else {
                this.setSize(11, 11);
            }
            this.setLocation(this.layeredPane.getWidth() - 12, this.layeredPane.getHeight() - 12);
        }

        void resizeInternalFrame(Point pt) {
            if (this.originalLocation == null || AquaInternalFrameUI.this.frame == null) {
                return;
            }
            Container parent = AquaInternalFrameUI.this.frame.getParent();
            if (!(parent instanceof JDesktopPane)) {
                return;
            }
            Point newPoint = SwingUtilities.convertPoint(this, pt, AquaInternalFrameUI.this.frame);
            int deltaX = this.originalLocation.x - newPoint.x;
            int deltaY = this.originalLocation.y - newPoint.y;
            Dimension min = AquaInternalFrameUI.this.frame.getMinimumSize();
            Dimension max = AquaInternalFrameUI.this.frame.getMaximumSize();
            int newX = AquaInternalFrameUI.this.frame.getX();
            int newY = AquaInternalFrameUI.this.frame.getY();
            int newW = AquaInternalFrameUI.this.frame.getWidth();
            int newH = AquaInternalFrameUI.this.frame.getHeight();
            Rectangle parentBounds = parent.getBounds();
            if (this.originalSize.width - deltaX < min.width) {
                deltaX = this.originalSize.width - min.width;
            } else if (this.originalSize.width - deltaX > max.width) {
                deltaX = -(max.width - this.originalSize.width);
            }
            if (newX + this.originalSize.width - deltaX > parentBounds.width) {
                deltaX = newX + this.originalSize.width - parentBounds.width;
            }
            if (this.originalSize.height - deltaY < min.height) {
                deltaY = this.originalSize.height - min.height;
            } else if (this.originalSize.height - deltaY > max.height) {
                deltaY = -(max.height - this.originalSize.height);
            }
            if (newY + this.originalSize.height - deltaY > parentBounds.height) {
                deltaY = newY + this.originalSize.height - parentBounds.height;
            }
            newW = this.originalSize.width - deltaX;
            newH = this.originalSize.height - deltaY;
            AquaInternalFrameUI.this.getDesktopManager().resizeFrame(AquaInternalFrameUI.this.frame, newX, newY, newW, newH);
        }

        boolean testGrowboxPoint(int x, int y, int w, int h) {
            return w - x + (h - y) < 12;
        }

        void forwardEventToFrame(MouseEvent e) {
            Point pt = new Point();
            Component c = this.getComponentToForwardTo(e, pt);
            if (c == null) {
                return;
            }
            c.dispatchEvent(new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), pt.x, pt.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        Component getComponentToForwardTo(MouseEvent e, Point dst) {
            if (AquaInternalFrameUI.this.frame == null) {
                return null;
            }
            Container contentPane = AquaInternalFrameUI.this.frame.getContentPane();
            if (contentPane == null) {
                return null;
            }
            Point pt = SwingUtilities.convertPoint(this, e.getPoint(), contentPane);
            Component c = SwingUtilities.getDeepestComponentAt(contentPane, pt.x, pt.y);
            if (c == null) {
                return null;
            }
            pt = SwingUtilities.convertPoint(contentPane, pt, c);
            if (dst != null) {
                dst.setLocation(pt);
            }
            return c;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEventToFrame(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (AquaInternalFrameUI.this.frame == null) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isResizable() && !AquaInternalFrameUI.this.frame.isMaximum() && this.testGrowboxPoint(e.getX(), e.getY(), this.getWidth(), this.getHeight())) {
                this.originalLocation = SwingUtilities.convertPoint(this, e.getPoint(), AquaInternalFrameUI.this.frame);
                this.originalSize = AquaInternalFrameUI.this.frame.getSize();
                AquaInternalFrameUI.this.getDesktopManager().beginResizingFrame(AquaInternalFrameUI.this.frame, 4);
                return;
            }
            this.forwardEventToFrame(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.originalLocation != null) {
                this.resizeInternalFrame(e.getPoint());
                this.originalLocation = null;
                AquaInternalFrameUI.this.getDesktopManager().endResizingFrame(AquaInternalFrameUI.this.frame);
                return;
            }
            this.forwardEventToFrame(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.resizeInternalFrame(e.getPoint());
            this.repositionResizeBox();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Point pt = new Point();
            Component c = this.getComponentToForwardTo(e, pt);
            if (c == null) {
                return;
            }
            c.dispatchEvent(new MouseWheelEvent(c, e.getID(), e.getWhen(), e.getModifiers(), pt.x, pt.y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation()));
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.repositionResizeBox();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.repositionResizeBox();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.repositionResizeBox();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"resizable".equals(evt.getPropertyName())) {
                return;
            }
            this.setVisible(Boolean.TRUE.equals(evt.getNewValue()));
        }
    }

    static abstract class InternalFrameShadow
    extends AquaUtils.RecyclableSingleton<Border> {
        InternalFrameShadow() {
        }

        abstract Border getForegroundShadowBorder();

        abstract Border getBackgroundShadowBorder();

        @Override
        protected Border getInstance() {
            final Border fgShadow = this.getForegroundShadowBorder();
            final Border bgShadow = this.getBackgroundShadowBorder();
            return new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return fgShadow.getBorderInsets(c);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                    if (((JInternalFrame)c).isSelected()) {
                        fgShadow.paintBorder(c, g, x, y, w, h);
                    } else {
                        bgShadow.paintBorder(c, g, x, y, w, h);
                    }
                }
            };
        }
    }

    static class CompoundUIBorder
    extends CompoundBorder
    implements UIResource {
        public CompoundUIBorder(Border inside, Border outside) {
            super(inside, outside);
        }
    }

    class PropertyListener
    implements PropertyChangeListener {
        PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (AquaInternalFrameUI.FRAME_TYPE.equals(name)) {
                if (e.getNewValue() instanceof String) {
                    AquaInternalFrameUI.this.setFrameType((String)e.getNewValue());
                }
            } else if (AquaInternalFrameUI.IS_PALETTE_PROPERTY.equals(name)) {
                if (e.getNewValue() != null) {
                    AquaInternalFrameUI.this.setPalette((Boolean)e.getNewValue());
                } else {
                    AquaInternalFrameUI.this.setPalette(false);
                }
            } else if ("windowModified".equals(name) || "Window.documentModified".equals(name)) {
                AquaInternalFrameUI.this.setDocumentEdited((Boolean)e.getNewValue());
                AquaInternalFrameUI.this.frame.repaint(0, 0, AquaInternalFrameUI.this.frame.getWidth(), ((AquaInternalFrameUI)AquaInternalFrameUI.this).frame.getBorder().getBorderInsets((Component)((AquaInternalFrameUI)AquaInternalFrameUI.this).frame).top);
            } else if ("resizable".equals(name) || "state".equals(name) || "iconable".equals(name) || "maximizable".equals(name) || "closable".equals(name)) {
                if ("resizable".equals(name)) {
                    AquaInternalFrameUI.this.frame.revalidate();
                }
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("title".equals(name)) {
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("componentOrientation".equals(name)) {
                AquaInternalFrameUI.this.frame.revalidate();
                AquaInternalFrameUI.this.frame.repaint();
            } else if ("selected".equals(name)) {
                Component source = (Component)e.getSource();
                AquaInternalFrameUI.updateComponentTreeUIActivation(source, AquaInternalFrameUI.this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    protected class AquaBorderListener
    extends MouseInputAdapter {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        boolean fDraggingFrame;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        boolean isTryingToForwardEvent = false;

        protected AquaBorderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.didForwardEvent(e)) {
                return;
            }
            if (e.getClickCount() <= 1 || e.getSource() != AquaInternalFrameUI.this.getNorthPane()) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isIconifiable() && AquaInternalFrameUI.this.frame.isIcon()) {
                try {
                    AquaInternalFrameUI.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (AquaInternalFrameUI.this.frame.isMaximizable()) {
                if (!AquaInternalFrameUI.this.frame.isMaximum()) {
                    try {
                        AquaInternalFrameUI.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        AquaInternalFrameUI.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public void updateRollover(MouseEvent e) {
            boolean oldRollover = AquaInternalFrameUI.this.fRollover;
            Insets i = AquaInternalFrameUI.this.frame.getInsets();
            boolean bl = AquaInternalFrameUI.this.fRollover = this.isTitleBarDraggableArea(e) && AquaInternalFrameUI.this.fAquaBorder.getWithinRolloverArea(i, e.getX(), e.getY());
            if (AquaInternalFrameUI.this.fRollover != oldRollover) {
                this.repaintButtons();
            }
        }

        public void repaintButtons() {
            AquaInternalFrameUI.this.fAquaBorder.repaintButtonArea(AquaInternalFrameUI.this.frame);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.didForwardEvent(e)) {
                return;
            }
            this.fDraggingFrame = false;
            if (AquaInternalFrameUI.this.fWhichButtonPressed != -1) {
                int newButton = AquaInternalFrameUI.this.fAquaBorder.getWhichButtonHit(AquaInternalFrameUI.this.frame, e.getX(), e.getY());
                int buttonPresed = AquaInternalFrameUI.this.fWhichButtonPressed;
                AquaInternalFrameUI.this.fWhichButtonPressed = -1;
                AquaInternalFrameUI.this.fMouseOverPressedButton = false;
                if (buttonPresed == newButton) {
                    AquaInternalFrameUI.this.fMouseOverPressedButton = false;
                    AquaInternalFrameUI.this.fRollover = false;
                    AquaInternalFrameUI.this.fAquaBorder.doButtonAction(AquaInternalFrameUI.this.frame, buttonPresed);
                }
                this.updateRollover(e);
                this.repaintButtons();
                return;
            }
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                AquaInternalFrameUI.this.getDesktopManager().endDraggingFrame(AquaInternalFrameUI.this.frame);
            } else {
                Container c = AquaInternalFrameUI.this.frame.getTopLevelAncestor();
                if (c instanceof JFrame) {
                    ((JFrame)AquaInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JFrame)AquaInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setVisible(false);
                } else if (c instanceof JApplet) {
                    ((JApplet)c).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JApplet)c).getGlassPane().setVisible(false);
                } else if (c instanceof JWindow) {
                    ((JWindow)c).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JWindow)c).getGlassPane().setVisible(false);
                } else if (c instanceof JDialog) {
                    ((JDialog)c).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JDialog)c).getGlassPane().setVisible(false);
                }
                AquaInternalFrameUI.this.getDesktopManager().endResizingFrame(AquaInternalFrameUI.this.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.didForwardEvent(e)) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.__x = e.getX();
            this.__y = e.getY();
            this._x = p.x;
            this._y = p.y;
            this.startingBounds = AquaInternalFrameUI.this.frame.getBounds();
            this.resizeDir = 0;
            if (this.updatePressed(e)) {
                return;
            }
            if (!AquaInternalFrameUI.this.frame.isSelected()) {
                try {
                    AquaInternalFrameUI.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (this.isTitleBarDraggableArea(e)) {
                AquaInternalFrameUI.this.getDesktopManager().beginDraggingFrame(AquaInternalFrameUI.this.frame);
                this.fDraggingFrame = true;
                return;
            }
            if (e.getSource() == AquaInternalFrameUI.this.getNorthPane()) {
                AquaInternalFrameUI.this.getDesktopManager().beginDraggingFrame(AquaInternalFrameUI.this.frame);
                return;
            }
            if (!AquaInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (e.getSource() == AquaInternalFrameUI.this.frame) {
                this.discardRelease = true;
                return;
            }
        }

        public boolean updatePressed(MouseEvent e) {
            AquaInternalFrameUI.this.fWhichButtonPressed = this.getButtonHit(e);
            AquaInternalFrameUI.this.fMouseOverPressedButton = true;
            this.repaintButtons();
            return AquaInternalFrameUI.this.fWhichButtonPressed >= 0;
        }

        public int getButtonHit(MouseEvent e) {
            return AquaInternalFrameUI.this.fAquaBorder.getWhichButtonHit(AquaInternalFrameUI.this.frame, e.getX(), e.getY());
        }

        public boolean isTitleBarDraggableArea(MouseEvent e) {
            if (e.getSource() != AquaInternalFrameUI.this.frame) {
                return false;
            }
            Point point = e.getPoint();
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            if (point.y < insets.top - AquaInternalFrameUI.this.fAquaBorder.getTitleHeight()) {
                return false;
            }
            if (point.y > insets.top) {
                return false;
            }
            if (point.x < insets.left) {
                return false;
            }
            return point.x <= AquaInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingBounds == null) {
                return;
            }
            if (AquaInternalFrameUI.this.fWhichButtonPressed != -1) {
                int newButton = this.getButtonHit(e);
                AquaInternalFrameUI.this.fMouseOverPressedButton = AquaInternalFrameUI.this.fWhichButtonPressed == newButton;
                this.repaintButtons();
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int deltaX = this._x - p.x;
            int deltaY = this._y - p.y;
            if (!this.fDraggingFrame && e.getSource() != AquaInternalFrameUI.this.getNorthPane()) {
                return;
            }
            if (AquaInternalFrameUI.this.frame.isMaximum() || (e.getModifiers() & 0x10) != 16) {
                return;
            }
            Dimension s = AquaInternalFrameUI.this.frame.getParent().getSize();
            int pWidth = s.width;
            int pHeight = s.height;
            Insets i = AquaInternalFrameUI.this.frame.getInsets();
            int newX = this.startingBounds.x - deltaX;
            int newY = this.startingBounds.y - deltaY;
            if (newX + i.left <= -this.__x) {
                newX = -this.__x - i.left;
            }
            if (newY + i.top <= -this.__y) {
                newY = -this.__y - i.top;
            }
            if (newX + this.__x + i.right > pWidth) {
                newX = pWidth - this.__x - i.right;
            }
            if (newY + this.__y + i.bottom > pHeight) {
                newY = pHeight - this.__y - i.bottom;
            }
            AquaInternalFrameUI.this.getDesktopManager().dragFrame(AquaInternalFrameUI.this.frame, newX, newY);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.didForwardEvent(e)) {
                return;
            }
            this.updateRollover(e);
        }

        boolean didForwardEvent(MouseEvent e) {
            if (this.isTryingToForwardEvent) {
                return true;
            }
            this.isTryingToForwardEvent = true;
            boolean didForwardEvent = this.didForwardEventInternal(e);
            this.isTryingToForwardEvent = false;
            return didForwardEvent;
        }

        boolean didForwardEventInternal(MouseEvent e) {
            if (this.fDraggingFrame) {
                return false;
            }
            Point originalPoint = e.getPoint();
            if (!this.isEventInWindowShadow(originalPoint)) {
                return false;
            }
            Container parent = AquaInternalFrameUI.this.frame.getParent();
            if (!(parent instanceof JDesktopPane)) {
                return false;
            }
            JDesktopPane pane = (JDesktopPane)parent;
            Point parentPoint = SwingUtilities.convertPoint(AquaInternalFrameUI.this.frame, originalPoint, parent);
            Component hitComponent = this.findComponentToHitBehindMe(pane, parentPoint);
            if (hitComponent == null || hitComponent == AquaInternalFrameUI.this.frame) {
                return false;
            }
            Point hitComponentPoint = SwingUtilities.convertPoint(pane, parentPoint, hitComponent);
            hitComponent.dispatchEvent(new MouseEvent(hitComponent, e.getID(), e.getWhen(), e.getModifiers(), hitComponentPoint.x, hitComponentPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            return true;
        }

        Component findComponentToHitBehindMe(JDesktopPane pane, Point parentPoint) {
            JInternalFrame[] allFrames = pane.getAllFrames();
            boolean foundSelf = false;
            for (JInternalFrame f : allFrames) {
                Rectangle bounds;
                if (f == AquaInternalFrameUI.this.frame) {
                    foundSelf = true;
                    continue;
                }
                if (!foundSelf || !(bounds = f.getBounds()).contains(parentPoint)) continue;
                return f;
            }
            return pane;
        }

        boolean isEventInWindowShadow(Point point) {
            Rectangle bounds = AquaInternalFrameUI.this.frame.getBounds();
            Insets insets = AquaInternalFrameUI.this.frame.getInsets();
            insets.top -= AquaInternalFrameUI.this.fAquaBorder.getTitleHeight();
            if (point.x < insets.left) {
                return true;
            }
            if (point.x > bounds.width - insets.right) {
                return true;
            }
            if (point.y < insets.top) {
                return true;
            }
            return point.y > bounds.height - insets.bottom;
        }
    }

    static class AquaInternalFrameButtonIcon
    extends AquaIcon.JRSUIIcon {
        public AquaInternalFrameButtonIcon(JRSUIConstants.Widget widget) {
            ((JRSUIState)this.painter.state).set(widget);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ((JRSUIState)this.painter.state).set(this.getStateFor(c));
            super.paintIcon(c, g, x, y);
        }

        JRSUIConstants.State getStateFor(Component c) {
            return JRSUIConstants.State.ROLLOVER;
        }

        @Override
        public int getIconWidth() {
            return 19;
        }

        @Override
        public int getIconHeight() {
            return 19;
        }
    }
}

