/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class AquaKeyBindings {
    static final AquaUtils.RecyclableSingleton<AquaKeyBindings> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaKeyBindings>(AquaKeyBindings.class);
    final DefaultEditorKit.DefaultKeyTypedAction defaultKeyTypedAction = new DefaultEditorKit.DefaultKeyTypedAction();
    static final String upMultilineAction = "aqua-move-up";
    static final String downMultilineAction = "aqua-move-down";
    static final String pageUpMultiline = "aqua-page-up";
    static final String pageDownMultiline = "aqua-page-down";
    final String[] commonTextEditorBindings = new String[]{"ENTER", "notify-field-accept", "COPY", "copy-to-clipboard", "CUT", "cut-to-clipboard", "PASTE", "paste-from-clipboard", "meta A", "select-all", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta X", "cut-to-clipboard", "meta BACK_SLASH", "unselect", "DELETE", "delete-next", "alt DELETE", "delete-next-word", "BACK_SPACE", "delete-previous", "alt BACK_SPACE", "delete-previous-word", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "shift meta LEFT", "selection-begin-line", "shift meta KP_LEFT", "selection-begin-line", "shift meta RIGHT", "selection-end-line", "shift meta KP_RIGHT", "selection-end-line", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "shift alt LEFT", "selection-previous-word", "shift alt KP_LEFT", "selection-previous-word", "shift alt RIGHT", "selection-next-word", "shift alt KP_RIGHT", "selection-next-word", "control A", "caret-begin-line", "control B", "caret-backward", "control D", "delete-next", "control E", "caret-end-line", "control F", "caret-forward", "control H", "delete-previous", "control W", "delete-previous-word", "control shift O", "toggle-componentOrientation", "END", "caret-end", "HOME", "caret-begin", "shift END", "selection-end", "shift HOME", "selection-begin", "PAGE_DOWN", "aqua-page-down", "PAGE_UP", "aqua-page-up", "shift PAGE_DOWN", "selection-page-down", "shift PAGE_UP", "selection-page-up", "meta shift PAGE_DOWN", "selection-page-right", "meta shift PAGE_UP", "selection-page-left", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "shift meta DOWN", "selection-end", "shift meta KP_DOWN", "selection-end", "shift meta UP", "selection-begin", "shift meta KP_UP", "selection-begin"};
    final TextAction moveUpMultilineAction = new AquaMultilineAction("aqua-move-up", "caret-up", "caret-begin");
    final TextAction moveDownMultilineAction = new AquaMultilineAction("aqua-move-down", "caret-down", "caret-end");
    final TextAction pageUpMultilineAction = new AquaMultilineAction("aqua-page-up", "page-up", "caret-begin");
    final TextAction pageDownMultilineAction = new AquaMultilineAction("aqua-page-down", "page-down", "caret-end");

    static AquaKeyBindings instance() {
        return instance.get();
    }

    void setDefaultAction(String keymapName) {
        Keymap map = JTextComponent.getKeymap(keymapName);
        map.setDefaultAction(this.defaultKeyTypedAction);
    }

    LateBoundInputMap getTextFieldInputMap() {
        return new LateBoundInputMap(new SimpleBinding(this.commonTextEditorBindings), new SimpleBinding(new String[]{"DOWN", "caret-end-line", "KP_DOWN", "caret-end-line", "UP", "caret-begin-line", "KP_UP", "caret-begin-line", "shift DOWN", "selection-end-line", "shift KP_DOWN", "selection-end-line", "shift UP", "selection-begin-line", "shift KP_UP", "selection-begin-line", "control P", "caret-begin", "control N", "caret-end", "control V", "caret-end"}));
    }

    LateBoundInputMap getPasswordFieldInputMap() {
        return new LateBoundInputMap(new SimpleBinding(this.getTextFieldInputMap().getBindings()), new SimpleBinding(new String[]{"alt LEFT", null, "alt KP_LEFT", null, "alt RIGHT", null, "alt KP_RIGHT", null, "shift alt LEFT", null, "shift alt KP_LEFT", null, "shift alt RIGHT", null, "shift alt KP_RIGHT", null}));
    }

    LateBoundInputMap getMultiLineTextInputMap() {
        return new LateBoundInputMap(new SimpleBinding(this.commonTextEditorBindings), new SimpleBinding(new String[]{"ENTER", "insert-break", "DOWN", downMultilineAction, "KP_DOWN", downMultilineAction, "UP", upMultilineAction, "KP_UP", upMultilineAction, "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "alt shift DOWN", "selection-end-paragraph", "alt shift KP_DOWN", "selection-end-paragraph", "alt shift UP", "selection-begin-paragraph", "alt shift KP_UP", "selection-begin-paragraph", "control P", "caret-up", "control N", "caret-down", "control V", pageDownMultiline, "TAB", "insert-tab", "meta SPACE", "activate-link-action", "meta T", "next-link-action", "meta shift T", "previous-link-action", "END", "caret-end", "HOME", "caret-begin", "shift END", "selection-end", "shift HOME", "selection-begin", "PAGE_DOWN", pageDownMultiline, "PAGE_UP", pageUpMultiline, "shift PAGE_DOWN", "selection-page-down", "shift PAGE_UP", "selection-page-up", "meta shift PAGE_DOWN", "selection-page-right", "meta shift PAGE_UP", "selection-page-left"}));
    }

    LateBoundInputMap getFormattedTextFieldInputMap() {
        return new LateBoundInputMap(this.getTextFieldInputMap(), new SimpleBinding(new String[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement", "ESCAPE", "reset-field-edit"}));
    }

    LateBoundInputMap getComboBoxInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"ESCAPE", "aquaHidePopup", "PAGE_UP", "aquaSelectPageUp", "PAGE_DOWN", "aquaSelectPageDown", "HOME", "aquaSelectHome", "END", "aquaSelectEnd", "ENTER", "enterPressed", "UP", "aquaSelectPrevious", "KP_UP", "aquaSelectPrevious", "DOWN", "aquaSelectNext", "KP_DOWN", "aquaSelectNext", "SPACE", "aquaSpacePressed"}));
    }

    LateBoundInputMap getListInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "meta A", "selectAll", "HOME", "aquaHome", "shift HOME", "selectFirstRowExtendSelection", "END", "aquaEnd", "shift END", "selectLastRowExtendSelection", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection"}));
    }

    LateBoundInputMap getScrollBarInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}));
    }

    LateBoundInputMap getScrollBarRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}));
    }

    LateBoundInputMap getScrollPaneInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "HOME", "scrollHome", "END", "scrollEnd"}));
    }

    LateBoundInputMap getSliderInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}));
    }

    LateBoundInputMap getSliderRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}));
    }

    LateBoundInputMap getSpinnerInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}));
    }

    LateBoundInputMap getTableInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "meta A", "selectAll", "ESCAPE", "cancel", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "alt TAB", "focusHeader", "alt shift TAB", "focusHeader"}));
    }

    LateBoundInputMap getTableRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}));
    }

    LateBoundInputMap getTreeInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "aquaExpandNode", "KP_RIGHT", "aquaExpandNode", "LEFT", "aquaCollapseNode", "KP_LEFT", "aquaCollapseNode", "shift RIGHT", "aquaExpandNode", "shift KP_RIGHT", "aquaExpandNode", "shift LEFT", "aquaCollapseNode", "shift KP_LEFT", "aquaCollapseNode", "ctrl LEFT", "aquaCollapseNode", "ctrl KP_LEFT", "aquaCollapseNode", "ctrl RIGHT", "aquaExpandNode", "ctrl KP_RIGHT", "aquaExpandNode", "alt RIGHT", "aquaFullyExpandNode", "alt KP_RIGHT", "aquaFullyExpandNode", "alt LEFT", "aquaFullyCollapseNode", "alt KP_LEFT", "aquaFullyCollapseNode", "meta A", "selectAll", "RETURN", "startEditing"}));
    }

    LateBoundInputMap getTreeRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "aquaCollapseNode", "KP_RIGHT", "aquaCollapseNode", "LEFT", "aquaExpandNode", "KP_LEFT", "aquaExpandNode", "shift RIGHT", "aquaCollapseNode", "shift KP_RIGHT", "aquaCollapseNode", "shift LEFT", "aquaExpandNode", "shift KP_LEFT", "aquaExpandNode", "ctrl LEFT", "aquaExpandNode", "ctrl KP_LEFT", "aquaExpandNode", "ctrl RIGHT", "aquaCollapseNode", "ctrl KP_RIGHT", "aquaCollapseNode"}));
    }

    void installAquaUpDownActions(JTextComponent component) {
        ActionMap actionMap = component.getActionMap();
        actionMap.put(upMultilineAction, this.moveUpMultilineAction);
        actionMap.put(downMultilineAction, this.moveDownMultilineAction);
        actionMap.put(pageUpMultiline, this.pageUpMultilineAction);
        actionMap.put(pageDownMultiline, this.pageDownMultilineAction);
    }

    static class AquaMultilineAction
    extends TextAction {
        final String targetActionName;
        final String proxyActionName;

        public AquaMultilineAction(String actionName, String targetActionName, String proxyActionName) {
            super(actionName);
            this.targetActionName = targetActionName;
            this.proxyActionName = proxyActionName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            ActionMap actionMap = c.getActionMap();
            Action targetAction = actionMap.get(this.targetActionName);
            int startPosition = c.getCaretPosition();
            targetAction.actionPerformed(e);
            if (startPosition != c.getCaretPosition()) {
                return;
            }
            Action proxyAction = actionMap.get(this.proxyActionName);
            proxyAction.actionPerformed(e);
        }
    }

    static abstract class DeleteWordAction
    extends TextAction {
        public DeleteWordAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e == null) {
                return;
            }
            JTextComponent target = this.getTextComponent(e);
            if (target == null) {
                return;
            }
            if (!target.isEditable() || !target.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
                return;
            }
            try {
                int start = target.getSelectionStart();
                Element line = Utilities.getParagraphElement(target, start);
                int end = this.getEnd(target, line, start);
                int offs = Math.min(start, end);
                int len = Math.abs(end - start);
                if (offs >= 0) {
                    target.getDocument().remove(offs, len);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            UIManager.getLookAndFeel().provideErrorFeedback(target);
        }

        abstract int getEnd(JTextComponent var1, Element var2, int var3) throws BadLocationException;
    }

    static class LateBoundInputMap
    implements UIDefaults.LazyValue,
    BindingsProvider {
        private final BindingsProvider[] providerList;
        private String[] mergedBindings;

        public LateBoundInputMap(BindingsProvider ... providerList) {
            this.providerList = providerList;
        }

        @Override
        public Object createValue(UIDefaults table) {
            return LookAndFeel.makeInputMap(this.getBindings());
        }

        @Override
        public String[] getBindings() {
            if (this.mergedBindings != null) {
                return this.mergedBindings;
            }
            String[][] bindingsList = new String[this.providerList.length][];
            int size = 0;
            for (int i = 0; i < this.providerList.length; ++i) {
                bindingsList[i] = this.providerList[i].getBindings();
                size += bindingsList[i].length;
            }
            if (bindingsList.length == 1) {
                this.mergedBindings = bindingsList[0];
                return this.mergedBindings;
            }
            ArrayList<String> unifiedList = new ArrayList<String>(size);
            Collections.addAll(unifiedList, bindingsList[0]);
            for (int i = 1; i < this.providerList.length; ++i) {
                LateBoundInputMap.mergeBindings(unifiedList, bindingsList[i]);
            }
            this.mergedBindings = unifiedList.toArray(new String[unifiedList.size()]);
            return this.mergedBindings;
        }

        static void mergeBindings(ArrayList<String> unifiedList, String[] overrides) {
            for (int i = 0; i < overrides.length; i += 2) {
                String key = overrides[i];
                String value = overrides[i + 1];
                int keyIndex = unifiedList.indexOf(key);
                if (keyIndex == -1) {
                    unifiedList.add(key);
                    unifiedList.add(value);
                    continue;
                }
                unifiedList.set(keyIndex, key);
                unifiedList.set(keyIndex + 1, value);
            }
        }
    }

    static class SimpleBinding
    implements BindingsProvider {
        final String[] bindings;

        public SimpleBinding(String[] bindings) {
            this.bindings = bindings;
        }

        @Override
        public String[] getBindings() {
            return this.bindings;
        }
    }

    static interface BindingsProvider {
        public String[] getBindings();
    }
}

