/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class AquaLabelUI
extends BasicLabelUI {
    protected static final AquaUtils.RecyclableSingleton<AquaLabelUI> aquaLabelUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaLabelUI>(AquaLabelUI.class);
    static final String DISABLED_COLOR_KEY = "Label.disabledForegroundColor";

    public static ComponentUI createUI(JComponent c) {
        return aquaLabelUI.get();
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        AquaUtilControlSize.addSizePropertyListener(c);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        AquaUtilControlSize.removeSizePropertyListener(c);
        super.uninstallListeners(c);
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (AquaMnemonicHandler.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        g.setColor(l.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        Color background;
        int accChar = l.getDisplayedMnemonicIndex();
        if (AquaMnemonicHandler.isMnemonicHidden()) {
            accChar = -1;
        }
        if ((background = l.getBackground()) instanceof UIResource) {
            g.setColor(this.getDisabledLabelColor(l));
            SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX, textY);
        } else {
            super.paintDisabledText(l, g, s, textX, textY);
        }
    }

    protected Color getDisabledLabelColor(JLabel label) {
        Color fg = label.getForeground();
        Object colorProperty = label.getClientProperty(DISABLED_COLOR_KEY);
        if (colorProperty instanceof Color) {
            Color disabledColor = (Color)colorProperty;
            if (fg.getRGB() << 8 == disabledColor.getRGB() << 8) {
                return disabledColor;
            }
        }
        Color newDisabledColor = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
        label.putClientProperty(DISABLED_COLOR_KEY, newDisabledColor);
        return newDisabledColor;
    }
}

