/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaMenuPainter {
    static final byte kShiftGlyph = 5;
    static final byte kOptionGlyph = 7;
    static final byte kControlGlyph = 6;
    static final byte kPencilGlyph = 15;
    static final byte kCommandMark = 17;
    static final char kUBlackDiamond = '\u25c6';
    static final char kUCheckMark = '\u2713';
    static final char kUControlGlyph = '\u2303';
    static final char kUOptionGlyph = '\u2325';
    static final char kUEnterGlyph = '\u2324';
    static final char kUCommandGlyph = '\u2318';
    static final char kULeftDeleteGlyph = '\u232b';
    static final char kURightDeleteGlyph = '\u2326';
    static final char kUShiftGlyph = '\u21e7';
    static final char kUCapsLockGlyph = '\u21ea';
    static final int ALT_GRAPH_MASK = 32;
    static final int sUnsupportedModifiersMask = -48;
    static final AquaUtils.RecyclableSingleton<AquaMenuPainter> sPainter = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaMenuPainter>(AquaMenuPainter.class);
    static final int defaultMenuItemGap = 2;
    static final int kAcceleratorArrowSpace = 16;
    protected final RecyclableBorder menuBarPainter = new RecyclableBorder("MenuBar.backgroundPainter");
    protected final RecyclableBorder selectedMenuBarItemPainter = new RecyclableBorder("MenuBar.selectedBackgroundPainter");
    protected final RecyclableBorder selectedMenuItemPainter = new RecyclableBorder("MenuItem.selectedBackgroundPainter");

    static String getKeyModifiersText(int modifiers, boolean isLeftToRight) {
        return AquaMenuPainter.getKeyModifiersUnicode(modifiers, isLeftToRight);
    }

    private static String getKeyModifiersUnicode(int modifiers, boolean isLeftToRight) {
        StringBuilder buf = new StringBuilder(2);
        if (isLeftToRight) {
            if ((modifiers & 2) != 0) {
                buf.append('\u2303');
            }
            if ((modifiers & 0x28) != 0) {
                buf.append('\u2325');
            }
            if ((modifiers & 1) != 0) {
                buf.append('\u21e7');
            }
            if ((modifiers & 4) != 0) {
                buf.append('\u2318');
            }
        } else {
            if ((modifiers & 4) != 0) {
                buf.append('\u2318');
            }
            if ((modifiers & 1) != 0) {
                buf.append('\u21e7');
            }
            if ((modifiers & 0x28) != 0) {
                buf.append('\u2325');
            }
            if ((modifiers & 2) != 0) {
                buf.append('\u2303');
            }
        }
        return buf.toString();
    }

    static AquaMenuPainter instance() {
        return sPainter.get();
    }

    public void paintMenuBarBackground(Graphics g, int width, int height, JComponent c) {
        g.setColor(c == null ? Color.white : c.getBackground());
        g.fillRect(0, 0, width, height);
        ((Border)this.menuBarPainter.get()).paintBorder(null, g, 0, 0, width, height);
    }

    public void paintSelectedMenuTitleBackground(Graphics g, int width, int height) {
        ((Border)this.selectedMenuBarItemPainter.get()).paintBorder(null, g, -1, 0, width + 2, height);
    }

    public void paintSelectedMenuItemBackground(Graphics g, int width, int height) {
        ((Border)this.selectedMenuItemPainter.get()).paintBorder(null, g, 0, 0, width, height);
    }

    protected void paintMenuItem(Client client, Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, Color disabledForeground, Color selectionForeground, int defaultTextIconGap, Font acceleratorFont) {
        Container ancestor;
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(0, 0, menuWidth, menuHeight);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Font holdf = g.getFont();
        Color holdc = g.getColor();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(acceleratorFont);
        if (c.isOpaque()) {
            client.paintBackground(g, c, menuWidth, menuHeight);
        }
        KeyStroke accelerator = b.getAccelerator();
        String modifiersString = "";
        String keyString = "";
        boolean leftToRight = AquaUtils.isLeftToRight(c);
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                modifiersString = AquaMenuPainter.getKeyModifiersText(modifiers, leftToRight);
            }
            keyString = (keyCode = accelerator.getKeyCode()) != 0 ? KeyEvent.getKeyText(keyCode) : keyString + accelerator.getKeyChar();
        }
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle acceleratorRect = new Rectangle();
        Rectangle checkIconRect = new Rectangle();
        Rectangle arrowIconRect = new Rectangle();
        String text = this.layoutMenuItem(b, fm, b.getText(), fmAccel, keyString, modifiersString, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        Container parent = b.getParent();
        boolean parentIsMenuBar = parent instanceof JMenuBar;
        for (ancestor = parent; ancestor != null && !(ancestor instanceof JPopupMenu); ancestor = ancestor.getParent()) {
        }
        boolean isEnabled = model.isEnabled() && (ancestor == null || ancestor.isVisible());
        boolean isSelected = false;
        if (!isEnabled) {
            g.setColor(disabledForeground);
        } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
            g.setColor(selectionForeground);
            isSelected = true;
        } else {
            g.setColor(parentIsMenuBar ? parent.getForeground() : b.getForeground());
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect, isEnabled);
        }
        if (checkIcon != null) {
            this.paintCheck(g, b, checkIcon, checkIconRect);
        }
        if (keyString != null && !keyString.equals("")) {
            int yAccel = acceleratorRect.y + fm.getAscent();
            if (modifiersString.equals("")) {
                SwingUtilities2.drawString(c, g, keyString, acceleratorRect.x, yAccel);
            } else {
                int modifiers = accelerator.getModifiers();
                int underlinedChar = 0;
                if ((modifiers & 0x20) > 0) {
                    underlinedChar = 8997;
                }
                int emWidth = Math.max(fm.charWidth('M'), SwingUtilities.computeStringWidth(fm, keyString));
                if (leftToRight) {
                    g.setFont(acceleratorFont);
                    this.drawString(g, c, modifiersString, underlinedChar, acceleratorRect.x, yAccel, isEnabled, isSelected);
                    g.setFont(f);
                    SwingUtilities2.drawString(c, g, keyString, acceleratorRect.x + acceleratorRect.width - emWidth, yAccel);
                } else {
                    int xAccel = acceleratorRect.x + emWidth;
                    g.setFont(acceleratorFont);
                    this.drawString(g, c, modifiersString, underlinedChar, xAccel, yAccel, isEnabled, isSelected);
                    g.setFont(f);
                    SwingUtilities2.drawString(c, g, keyString, xAccel - fm.stringWidth(keyString), yAccel);
                }
            }
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemonic = AquaMnemonicHandler.isMnemonicHidden() ? -1 : model.getMnemonic();
                this.drawString(g, c, text, mnemonic, textRect.x, textRect.y + fm.getAscent(), isEnabled, isSelected);
            }
        }
        if (arrowIcon != null) {
            this.paintArrow(g, b, model, arrowIcon, arrowIconRect);
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, Font acceleratorFont) {
        Insets insets;
        boolean acceleratorTextIsEmpty;
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String keyString = "";
        String modifiersString = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                modifiersString = AquaMenuPainter.getKeyModifiersText(modifiers, true);
            }
            keyString = (keyCode = accelerator.getKeyCode()) != 0 ? KeyEvent.getKeyText(keyCode) : keyString + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(acceleratorFont);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle acceleratorRect = new Rectangle();
        Rectangle checkIconRect = new Rectangle();
        Rectangle arrowIconRect = new Rectangle();
        Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        this.layoutMenuItem(b, fm, text, fmAccel, keyString, modifiersString, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        Rectangle r = new Rectangle();
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(iconRect.x, iconRect.y, iconRect.width, iconRect.height, r);
        boolean bl = acceleratorTextIsEmpty = keyString == null || keyString.equals("");
        if (!acceleratorTextIsEmpty) {
            r.width += acceleratorRect.width;
        }
        if (!AquaMenuPainter.isTopLevelMenu(b)) {
            r.width += checkIconRect.width;
            r.width += defaultTextIconGap;
            r.width += defaultTextIconGap;
            r.width += arrowIconRect.width;
        }
        if ((insets = b.getInsets()) != null) {
            r.width += insets.left + insets.right;
            r.height += insets.top + insets.bottom;
        }
        r.width += 4 + defaultTextIconGap;
        r.height = Math.max(r.height, 18);
        return r.getSize();
    }

    protected void paintCheck(Graphics g, JMenuItem item, Icon checkIcon, Rectangle checkIconRect) {
        if (AquaMenuPainter.isTopLevelMenu(item) || !item.isSelected()) {
            return;
        }
        if (item.isArmed() && checkIcon instanceof AquaIcon.InvertableIcon) {
            ((AquaIcon.InvertableIcon)checkIcon).getInvertedIcon().paintIcon(item, g, checkIconRect.x, checkIconRect.y);
        } else {
            checkIcon.paintIcon(item, g, checkIconRect.x, checkIconRect.y);
        }
    }

    protected void paintIcon(Graphics g, JMenuItem c, Rectangle localIconRect, boolean isEnabled) {
        Icon icon;
        ButtonModel model = c.getModel();
        if (!isEnabled) {
            icon = c.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = c.getPressedIcon();
            if (icon == null) {
                icon = c.getIcon();
            }
        } else {
            icon = c.getIcon();
        }
        if (icon != null) {
            icon.paintIcon(c, g, localIconRect.x, localIconRect.y);
        }
    }

    protected void paintArrow(Graphics g, JMenuItem c, ButtonModel model, Icon arrowIcon, Rectangle arrowIconRect) {
        if (AquaMenuPainter.isTopLevelMenu(c)) {
            return;
        }
        if (c instanceof JMenu && (model.isArmed() || model.isSelected()) && arrowIcon instanceof AquaIcon.InvertableIcon) {
            ((AquaIcon.InvertableIcon)arrowIcon).getInvertedIcon().paintIcon(c, g, arrowIconRect.x, arrowIconRect.y);
        } else {
            arrowIcon.paintIcon(c, g, arrowIconRect.x, arrowIconRect.y);
        }
    }

    public void drawString(Graphics g, JComponent c, String text, int underlinedChar, int x, int y, boolean isEnabled, boolean isSelected) {
        int index = -1;
        if (underlinedChar != 0) {
            char uc = Character.toUpperCase((char)underlinedChar);
            char lc = Character.toLowerCase((char)underlinedChar);
            int uci = text.indexOf(uc);
            int lci = text.indexOf(lc);
            index = uci == -1 ? lci : (lci == -1 ? uci : (lci < uci ? lci : uci));
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, index, x, y);
    }

    private static boolean isTopLevelMenu(JMenuItem menuItem) {
        return menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu();
    }

    private String layoutMenuItem(JMenuItem menuItem, FontMetrics fm, String text, FontMetrics fmAccel, String keyString, String modifiersString, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, Rectangle acceleratorR, Rectangle checkIconR, Rectangle arrowIconR, int textIconGap, int menuItemGap) {
        boolean acceleratorTextIsEmpty;
        SwingUtilities.layoutCompoundLabel(menuItem, fm, text, icon, verticalAlignment, 2, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
        boolean bl = acceleratorTextIsEmpty = keyString == null || keyString.equals("");
        if (acceleratorTextIsEmpty) {
            acceleratorR.height = 0;
            acceleratorR.width = 0;
            keyString = "";
        } else {
            acceleratorR.width = SwingUtilities.computeStringWidth(fmAccel, modifiersString);
            acceleratorR.width += Math.max(fm.charWidth('M'), SwingUtilities.computeStringWidth(fm, keyString));
            acceleratorR.height = fmAccel.getHeight();
        }
        boolean isTopLevelMenu = AquaMenuPainter.isTopLevelMenu(menuItem);
        if (!isTopLevelMenu) {
            if (checkIcon != null) {
                checkIconR.width = checkIcon.getIconWidth();
                checkIconR.height = checkIcon.getIconHeight();
            } else {
                checkIconR.height = 16;
                checkIconR.width = 16;
            }
            if (arrowIcon != null) {
                arrowIconR.width = arrowIcon.getIconWidth();
                arrowIconR.height = arrowIcon.getIconHeight();
            } else {
                arrowIconR.height = 16;
                arrowIconR.width = 16;
            }
            textR.x += 12;
            iconR.x += 12;
        }
        Rectangle labelR = iconR.union(textR);
        acceleratorR.x += viewR.width - arrowIconR.width - acceleratorR.width;
        acceleratorR.y = viewR.y + viewR.height / 2 - acceleratorR.height / 2;
        if (!isTopLevelMenu) {
            arrowIconR.x = viewR.width - arrowIconR.width + 1;
            arrowIconR.y = viewR.y + labelR.height / 2 - arrowIconR.height / 2 + 1;
            checkIconR.y = viewR.y + labelR.height / 2 - checkIconR.height / 2;
            checkIconR.x = 5;
            textR.width += 8;
        }
        if (!AquaUtils.isLeftToRight(menuItem)) {
            int w = viewR.width;
            checkIconR.x = w - (checkIconR.x + checkIconR.width);
            iconR.x = w - (iconR.x + iconR.width);
            textR.x = w - (textR.x + textR.width);
            acceleratorR.x = w - (acceleratorR.x + acceleratorR.width);
            arrowIconR.x = w - (arrowIconR.x + arrowIconR.width);
        }
        textR.x += menuItemGap;
        iconR.x += menuItemGap;
        return text;
    }

    public static Border getMenuBarPainter() {
        AquaBorder.Default border = new AquaBorder.Default();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.MENU_BAR);
        return border;
    }

    public static Border getSelectedMenuBarItemPainter() {
        AquaBorder.Default border = new AquaBorder.Default();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.MENU_TITLE);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.State.PRESSED);
        return border;
    }

    public static Border getSelectedMenuItemPainter() {
        AquaBorder.Default border = new AquaBorder.Default();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.MENU_ITEM);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.State.PRESSED);
        return border;
    }

    static class RecyclableBorder
    extends AquaUtils.RecyclableSingleton<Border> {
        final String borderName;

        RecyclableBorder(String borderName) {
            this.borderName = borderName;
        }

        @Override
        protected Border getInstance() {
            return UIManager.getBorder(this.borderName);
        }
    }

    static interface Client {
        public void paintBackground(Graphics var1, JComponent var2, int var3, int var4);
    }
}

