/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class AquaMenuUI
extends BasicMenuUI
implements AquaMenuPainter.Client {
    public static ComponentUI createUI(JComponent x) {
        return new AquaMenuUI();
    }

    @Override
    protected ChangeListener createChangeListener(JComponent c) {
        return new BasicMenuUI.ChangeHandler((JMenu)c, this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(133);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon localCheckIcon, Icon localArrowIcon, Color background, Color foreground, int localDefaultTextIconGap) {
        AquaMenuPainter.instance().paintMenuItem(this, g, c, localCheckIcon, localArrowIcon, background, foreground, this.disabledForeground, this.selectionForeground, localDefaultTextIconGap, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon localCheckIcon, Icon localArrowIcon, int localDefaultTextIconGap) {
        Dimension d = AquaMenuPainter.instance().getPreferredMenuItemSize(c, localCheckIcon, localArrowIcon, localDefaultTextIconGap, this.acceleratorFont);
        if (c.getParent() instanceof JMenuBar) {
            d.height = Math.max(d.height, 21);
        }
        return d;
    }

    @Override
    public void paintBackground(Graphics g, JComponent c, int menuWidth, int menuHeight) {
        Container parent = c.getParent();
        boolean parentIsMenuBar = parent instanceof JMenuBar;
        ButtonModel model = ((JMenuItem)c).getModel();
        if (model.isArmed() || model.isSelected()) {
            if (parentIsMenuBar) {
                AquaMenuPainter.instance().paintSelectedMenuTitleBackground(g, menuWidth, menuHeight);
            } else {
                AquaMenuPainter.instance().paintSelectedMenuItemBackground(g, menuWidth, menuHeight);
            }
        } else if (parentIsMenuBar) {
            AquaMenuPainter.instance().paintMenuBarBackground(g, menuWidth, menuHeight, c);
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new AquaMouseInputHandler();
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    static void appendPath(MenuElement[] path, MenuElement elem) {
        MenuElement[] newPath = new MenuElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = elem;
        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
    }

    protected class AquaMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected AquaMouseInputHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)AquaMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!(selectedPath.length > 0 && selectedPath[selectedPath.length - 1] == menu.getPopupMenu() || menu.isTopLevelMenu() && (selectedPath.length <= 0 || selectedPath[0] != menu.getParent()))) {
                if (menu.getDelay() == 0) {
                    AquaMenuUI.appendPath(AquaMenuUI.this.getPath(), menu.getPopupMenu());
                } else {
                    manager.setSelectedPath(AquaMenuUI.this.getPath());
                    AquaMenuUI.this.setupPostTimer(menu);
                }
            }
        }
    }

    class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!AquaMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < AquaMenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < AquaMenuUI.this.menuItem.getHeight()) {
                JMenu menu = (JMenu)AquaMenuUI.this.menuItem;
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        AquaMenuUI.appendPath(path, menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(path);
                        AquaMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }
}

