/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import sun.swing.SwingUtilities2;

public class AquaProgressBarUI
extends ProgressBarUI
implements ChangeListener,
PropertyChangeListener,
AncestorListener,
AquaUtilControlSize.Sizeable {
    private static final boolean ADJUSTTIMER = true;
    protected static final AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor> sizeDescriptor = new AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(146, 20)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant v) {
                    v.alterMinSize(0, -6);
                    return super.deriveSmall(v);
                }
            };
        }
    };
    protected JRSUIConstants.Size sizeVariant = JRSUIConstants.Size.REGULAR;
    protected Color selectionForeground;
    private Animator animator;
    protected boolean isAnimating;
    protected boolean isCircular;
    protected final AquaPainter<JRSUIState.ValueState> painter = AquaPainter.create(JRSUIStateFactory.getProgressBar());
    protected JProgressBar progressBar;
    private final Rectangle fUpdateArea = new Rectangle(0, 0, 0, 0);
    private final Dimension fLastSize = new Dimension(0, 0);

    static AquaUtilControlSize.SizeDescriptor getSizeDescriptor() {
        return sizeDescriptor.get();
    }

    public static ComponentUI createUI(JComponent x) {
        return new AquaProgressBarUI();
    }

    protected AquaProgressBarUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.progressBar = (JProgressBar)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(false);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.progressBar.addChangeListener(this);
        this.progressBar.addPropertyChangeListener(this);
        this.progressBar.addAncestorListener(this);
        AquaUtilControlSize.addSizePropertyListener(this.progressBar);
    }

    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.progressBar);
        this.progressBar.removeAncestorListener(this);
        this.progressBar.removePropertyChangeListener(this);
        this.progressBar.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.progressBar.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("indeterminate".equals(prop)) {
            if (!this.progressBar.isIndeterminate()) {
                return;
            }
            this.stopAnimationTimer();
            if (this.progressBar.isDisplayable()) {
                this.startAnimationTimer();
            }
        }
        if ("JProgressBar.style".equals(prop)) {
            this.isCircular = "circular".equalsIgnoreCase(e.getNewValue() + "");
            this.progressBar.repaint();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
        this.stopAnimationTimer();
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        if (!this.progressBar.isIndeterminate()) {
            return;
        }
        if (this.progressBar.isDisplayable()) {
            this.startAnimationTimer();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.revalidateAnimationTimers();
        ((JRSUIState.ValueState)this.painter.state).set(this.getState(c));
        ((JRSUIState.ValueState)this.painter.state).set(this.isHorizontal() ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL);
        ((JRSUIState.ValueState)this.painter.state).set(this.isAnimating ? JRSUIConstants.Animating.YES : JRSUIConstants.Animating.NO);
        if (this.progressBar.isIndeterminate()) {
            if (this.isCircular) {
                ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_SPINNER);
                this.painter.paint(g, c, 2, 2, 16, 16);
                return;
            }
            ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR);
            this.paint(g);
            return;
        }
        ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_BAR);
        ((JRSUIState.ValueState)this.painter.state).setValue(AquaProgressBarUI.checkValue(this.progressBar.getPercentComplete()));
        this.paint(g);
    }

    static double checkValue(double value) {
        return Double.isNaN(value) ? 0.0 : value;
    }

    protected void paint(Graphics g) {
        Insets i = this.progressBar.getInsets();
        int width = this.progressBar.getWidth() - (i.right + i.left);
        int height = this.progressBar.getHeight() - (i.bottom + i.top);
        this.painter.paint(g, this.progressBar, i.left, i.top, width, height);
        if (this.progressBar.isStringPainted() && !this.progressBar.isIndeterminate()) {
            this.paintString(g, i.left, i.top, width, height);
        }
    }

    protected JRSUIConstants.State getState(JComponent c) {
        if (!c.isEnabled()) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!AquaFocusHandler.isActive(c)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected void paintString(Graphics g, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.isHorizontal()) {
            g2.setColor(this.selectionForeground);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
        } else {
            AffineTransform savedAT = g2.getTransform();
            g2.transform(AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0));
            g2.translate(-this.progressBar.getHeight(), 0);
            g2.setColor(this.selectionForeground);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
            g2.setTransform(savedAT);
        }
        g2.setClip(oldClip);
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (!this.isHorizontal()) {
            int oldH = height;
            height = width;
            width = oldH;
            int oldX = x;
            x = y;
            y = oldX;
        }
        return new Point(x + Math.round(width / 2 - stringWidth / 2), y + (height + fontSizer.getAscent() - fontSizer.getLeading() - fontSizer.getDescent()) / 2 - 1);
    }

    static Dimension getCircularPreferredSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        FontMetrics metrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        Dimension size = this.isHorizontal() ? this.getPreferredHorizontalSize(metrics) : this.getPreferredVerticalSize(metrics);
        Insets insets = this.progressBar.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    protected Dimension getPreferredHorizontalSize(FontMetrics metrics) {
        int stringHeight;
        AquaUtilControlSize.SizeVariant variant = AquaProgressBarUI.getSizeDescriptor().get(this.sizeVariant);
        Dimension size = new Dimension(variant.w, variant.h);
        if (!this.progressBar.isStringPainted()) {
            return size;
        }
        String progString = this.progressBar.getString();
        int stringWidth = metrics.stringWidth(progString);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = metrics.getHeight() + metrics.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        return size;
    }

    protected Dimension getPreferredVerticalSize(FontMetrics metrics) {
        int stringWidth;
        AquaUtilControlSize.SizeVariant variant = AquaProgressBarUI.getSizeDescriptor().get(this.sizeVariant);
        Dimension size = new Dimension(variant.h, variant.w);
        if (!this.progressBar.isStringPainted()) {
            return size;
        }
        String progString = this.progressBar.getString();
        int stringHeight = metrics.getHeight() + metrics.getDescent();
        if (stringHeight > size.width) {
            size.width = stringHeight;
        }
        if ((stringWidth = metrics.stringWidth(progString)) > size.height) {
            size.height = stringWidth;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            pref.width = 10;
        } else {
            pref.height = 10;
        }
        return pref;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            pref.width = Short.MAX_VALUE;
        } else {
            pref.height = Short.MAX_VALUE;
        }
        return pref;
    }

    @Override
    public void applySizeFor(JComponent c, JRSUIConstants.Size size) {
        this.sizeVariant = size == JRSUIConstants.Size.MINI ? JRSUIConstants.Size.SMALL : this.sizeVariant;
        ((JRSUIState.ValueState)this.painter.state).set(this.sizeVariant);
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start();
        this.isAnimating = true;
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.isAnimating = false;
    }

    protected Rectangle getRepaintRect() {
        int height = this.progressBar.getHeight();
        int width = this.progressBar.getWidth();
        if (this.isCircular) {
            return new Rectangle(20, 20);
        }
        if (this.fLastSize.height == height && this.fLastSize.width == width) {
            return this.fUpdateArea;
        }
        int x = 0;
        int y = 0;
        this.fLastSize.height = height;
        this.fLastSize.width = width;
        int maxHeight = this.getMaxProgressBarHeight();
        if (this.isHorizontal()) {
            int excessHeight = height - maxHeight;
            y += excessHeight / 2;
            height = maxHeight;
        } else {
            int excessHeight = width - maxHeight;
            x += excessHeight / 2;
            width = maxHeight;
        }
        this.fUpdateArea.setBounds(x, y, width, height);
        return this.fUpdateArea;
    }

    protected int getMaxProgressBarHeight() {
        return AquaProgressBarUI.getSizeDescriptor().get((JRSUIConstants.Size)this.sizeVariant).h;
    }

    protected boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    protected void revalidateAnimationTimers() {
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        if (!this.isAnimating) {
            this.startAnimationTimer();
            return;
        }
        BoundedRangeModel model = this.progressBar.getModel();
        double currentValue = model.getValue();
        if (currentValue == (double)model.getMaximum() || currentValue == (double)model.getMinimum()) {
            this.stopAnimationTimer();
        }
    }

    protected void repaint() {
        Rectangle repaintRect = this.getRepaintRect();
        if (repaintRect == null) {
            this.progressBar.repaint();
            return;
        }
        this.progressBar.repaint(repaintRect);
    }

    protected class Animator
    implements ActionListener {
        private static final int MINIMUM_DELAY = 5;
        private Timer timer;
        private long previousDelay;
        private long lastCall;
        private int repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");

        public Animator() {
            if (this.repaintInterval <= 0) {
                this.repaintInterval = 100;
            }
        }

        protected void start() {
            this.previousDelay = this.repaintInterval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(this.repaintInterval, this);
            } else {
                this.timer.setDelay(this.repaintInterval);
            }
            this.timer.setRepeats(false);
            this.timer.setCoalesce(false);
            this.timer.start();
        }

        protected void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long time = System.currentTimeMillis();
            if (this.lastCall > 0L) {
                int nextDelay = (int)(this.previousDelay - time + this.lastCall + (long)this.repaintInterval);
                if (nextDelay < 5) {
                    nextDelay = 5;
                }
                this.timer.setInitialDelay(nextDelay);
                this.previousDelay = nextDelay;
            }
            this.timer.start();
            this.lastCall = time;
            AquaProgressBarUI.this.repaint();
        }
    }
}

