/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class AquaSliderUI
extends BasicSliderUI
implements AquaUtilControlSize.Sizeable {
    protected static final AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor> roundThumbDescriptor = new AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 25)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveSmall(v.alterMinSize(-2, -2));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveMini(v.alterMinSize(-2, -2));
                }
            };
        }
    };
    protected static final AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor> pointingThumbDescriptor = new AquaUtils.RecyclableSingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(23, 26)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveSmall(v.alterMinSize(-2, -2));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant v) {
                    return super.deriveMini(v.alterMinSize(-2, -2));
                }
            };
        }
    };
    static final AquaPainter<JRSUIState> trackPainter = AquaPainter.create(JRSUIStateFactory.getSliderTrack(), new JRSUIUtils.NineSliceMetricsProvider(){

        @Override
        public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState state) {
            if (state.is(JRSUIConstants.Orientation.VERTICAL)) {
                return new AquaImageFactory.NineSliceMetrics(5, 7, 0, 0, 3, 3, true, false, true);
            }
            return new AquaImageFactory.NineSliceMetrics(7, 5, 3, 3, 0, 0, true, true, false);
        }
    });
    final AquaPainter<JRSUIState> thumbPainter = AquaPainter.create(JRSUIStateFactory.getSliderThumb());
    protected Color tickColor;
    protected Color disabledTickColor;
    protected transient boolean fIsDragging = false;
    static final int kTickWidth = 3;
    static final int kTickLength = 8;

    public static ComponentUI createUI(JComponent c) {
        return new AquaSliderUI((JSlider)c);
    }

    public AquaSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.tickColor = UIManager.getColor("Slider.tickColor");
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider s) {
        return new TrackListener();
    }

    @Override
    protected void installListeners(JSlider s) {
        super.installListeners(s);
        AquaFocusHandler.install(s);
        AquaUtilControlSize.addSizePropertyListener(s);
    }

    @Override
    protected void uninstallListeners(JSlider s) {
        AquaUtilControlSize.removeSizePropertyListener(s);
        AquaFocusHandler.uninstall(s);
        super.uninstallListeners(s);
    }

    @Override
    public void applySizeFor(JComponent c, JRSUIConstants.Size size) {
        ((JRSUIState)this.thumbPainter.state).set(size);
        ((JRSUIState)AquaSliderUI.trackPainter.state).set(size);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.recalculateIfInsetsChanged();
        Rectangle clip = g.getClipBounds();
        JRSUIConstants.Orientation orientation = this.slider.getOrientation() == 0 ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL;
        JRSUIConstants.State state = this.getState();
        if (this.slider.getPaintTrack()) {
            boolean trackIntersectsClip = clip.intersects(this.trackRect);
            if (!trackIntersectsClip) {
                this.calculateGeometry();
            }
            if (trackIntersectsClip || clip.intersects(this.thumbRect)) {
                this.paintTrack(g, c, orientation, state);
            }
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g, c, orientation, state);
        }
    }

    public void paintTrack(Graphics g, JComponent c, JRSUIConstants.Orientation orientation, JRSUIConstants.State state) {
        ((JRSUIState)AquaSliderUI.trackPainter.state).set(orientation);
        ((JRSUIState)AquaSliderUI.trackPainter.state).set(state);
        trackPainter.paint(g, c, this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
    }

    public void paintThumb(Graphics g, JComponent c, JRSUIConstants.Orientation orientation, JRSUIConstants.State state) {
        ((JRSUIState)this.thumbPainter.state).set(orientation);
        ((JRSUIState)this.thumbPainter.state).set(state);
        ((JRSUIState)this.thumbPainter.state).set(this.slider.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        ((JRSUIState)this.thumbPainter.state).set(this.getDirection(orientation));
        this.thumbPainter.paint(g, c, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
    }

    JRSUIConstants.Direction getDirection(JRSUIConstants.Orientation orientation) {
        if (this.shouldUseArrowThumb()) {
            return orientation == JRSUIConstants.Orientation.HORIZONTAL ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.RIGHT;
        }
        return JRSUIConstants.Direction.NONE;
    }

    JRSUIConstants.State getState() {
        if (!this.slider.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.fIsDragging) {
            return JRSUIConstants.State.PRESSED;
        }
        if (!AquaFocusHandler.isActive(this.slider)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    public void paintTicks(Graphics g) {
        if (this.slider.isEnabled()) {
            g.setColor(this.tickColor);
        } else {
            if (this.disabledTickColor == null) {
                this.disabledTickColor = new Color(this.tickColor.getRed(), this.tickColor.getGreen(), this.tickColor.getBlue(), this.tickColor.getAlpha() / 2);
            }
            g.setColor(this.disabledTickColor);
        }
        super.paintTicks(g);
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.shouldUseArrowThumb()) {
            boolean isHorizonatal = this.slider.getOrientation() == 0;
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(this.slider);
            if (size == JRSUIConstants.Size.REGULAR) {
                if (isHorizonatal) {
                    this.thumbRect.y += 3;
                } else {
                    this.thumbRect.x += 2;
                }
                return;
            }
            if (size == JRSUIConstants.Size.SMALL) {
                if (isHorizonatal) {
                    this.thumbRect.y += 2;
                } else {
                    this.thumbRect.x += 2;
                }
                return;
            }
            if (size == JRSUIConstants.Size.MINI) {
                if (isHorizonatal) {
                    ++this.thumbRect.y;
                }
                return;
            }
        }
    }

    @Override
    protected void calculateThumbSize() {
        AquaUtilControlSize.SizeDescriptor descriptor = this.shouldUseArrowThumb() ? pointingThumbDescriptor.get() : roundThumbDescriptor.get();
        AquaUtilControlSize.SizeVariant variant = descriptor.get(this.slider);
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.setSize(variant.w, variant.h);
        } else {
            this.thumbRect.setSize(variant.h, variant.w);
        }
    }

    protected boolean shouldUseArrowThumb() {
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return true;
        }
        Object shouldPaintArrowThumbProperty = this.slider.getClientProperty("Slider.paintThumbArrowShape");
        if (shouldPaintArrowThumbProperty != null && shouldPaintArrowThumbProperty instanceof Boolean) {
            return (Boolean)shouldPaintArrowThumbProperty;
        }
        return false;
    }

    @Override
    protected void calculateTickRect() {
        int tickLength;
        int n = tickLength = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        if (this.slider.getOrientation() == 0) {
            this.tickRect.height = tickLength;
            this.tickRect.x = this.trackRect.x + this.trackBuffer;
            this.tickRect.y = this.trackRect.y + this.trackRect.height - this.tickRect.height / 2;
            this.tickRect.width = this.trackRect.width - this.trackBuffer * 2;
        } else {
            this.tickRect.width = tickLength;
            this.tickRect.x = this.trackRect.x + this.trackRect.width - this.tickRect.width / 2;
            this.tickRect.y = this.trackRect.y + this.trackBuffer;
            this.tickRect.height = this.trackRect.height - this.trackBuffer * 2;
        }
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(190, 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, 190);
    }

    @Override
    protected ChangeListener createChangeListener(JSlider s) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AquaSliderUI.this.fIsDragging) {
                    return;
                }
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.slider.repaint();
            }
        };
    }

    int getScale() {
        if (!this.slider.getSnapToTicks()) {
            return 1;
        }
        int scale = this.slider.getMinorTickSpacing();
        if (scale < 1) {
            scale = this.slider.getMajorTickSpacing();
        }
        if (scale < 1) {
            return 1;
        }
        return scale;
    }

    class TrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        TrackListener() {
            super(AquaSliderUI.this);
            this.currentMouseX = -1;
            this.currentMouseY = -1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = -1;
            this.currentMouseY = -1;
            this.offset = 0;
            AquaSliderUI.this.scrollTimer.stop();
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.fIsDragging = false;
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                AquaSliderUI.this.fIsDragging = false;
            }
            AquaSliderUI.this.slider.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            AquaSliderUI.this.calculateGeometry();
            boolean firstClick = this.currentMouseX == -1 && this.currentMouseY == -1;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (AquaSliderUI.this.slider.isRequestFocusEnabled()) {
                AquaSliderUI.this.slider.requestFocus();
            }
            boolean isMouseEventInThumb = AquaSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY);
            if (!firstClick || !isMouseEventInThumb) {
                AquaSliderUI.this.slider.setValueIsAdjusting(true);
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                isMouseEventInThumb = true;
            }
            if (isMouseEventInThumb) {
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((AquaSliderUI)AquaSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((AquaSliderUI)AquaSliderUI.this).thumbRect.x;
                    }
                }
                AquaSliderUI.this.fIsDragging = true;
                return;
            }
            AquaSliderUI.this.fIsDragging = false;
        }

        @Override
        public boolean shouldScroll(int direction) {
            Rectangle r = AquaSliderUI.this.thumbRect;
            if (AquaSliderUI.this.slider.getOrientation() == 1 ? ((AquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((AquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && AquaSliderUI.this.slider.getValue() + AquaSliderUI.this.slider.getExtent() >= AquaSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || AquaSliderUI.this.slider.getValue() > AquaSliderUI.this.slider.getMinimum();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.slider.setValueIsAdjusting(true);
            switch (AquaSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((AquaSliderUI)AquaSliderUI.this).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = ((AquaSliderUI)AquaSliderUI.this).trackRect.y;
                    int trackBottom = ((AquaSliderUI)AquaSliderUI.this).trackRect.y + (((AquaSliderUI)AquaSliderUI.this).trackRect.height - 1);
                    int vMax = AquaSliderUI.this.yPositionForValue(AquaSliderUI.this.slider.getMaximum() - AquaSliderUI.this.slider.getExtent());
                    if (AquaSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((AquaSliderUI)AquaSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = ((AquaSliderUI)AquaSliderUI.this).trackRect.x;
                    int trackRight = ((AquaSliderUI)AquaSliderUI.this).trackRect.x + (((AquaSliderUI)AquaSliderUI.this).trackRect.width - 1);
                    int hMax = AquaSliderUI.this.xPositionForValue(AquaSliderUI.this.slider.getMaximum() - AquaSliderUI.this.slider.getExtent());
                    if (AquaSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    AquaSliderUI.this.setThumbLocation(thumbLeft, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

