/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.InternationalFormatter;

public class AquaSpinnerUI
extends SpinnerUI {
    private static final AquaUtils.RecyclableSingleton<? extends PropertyChangeListener> propertyChangeListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<PropertyChangeHandler>(PropertyChangeHandler.class);
    private static final AquaUtils.RecyclableSingleton<ArrowButtonHandler> nextButtonHandler = new AquaUtils.RecyclableSingleton<ArrowButtonHandler>(){

        @Override
        protected ArrowButtonHandler getInstance() {
            return new ArrowButtonHandler("increment", true);
        }
    };
    private static final AquaUtils.RecyclableSingleton<ArrowButtonHandler> previousButtonHandler = new AquaUtils.RecyclableSingleton<ArrowButtonHandler>(){

        @Override
        protected ArrowButtonHandler getInstance() {
            return new ArrowButtonHandler("decrement", false);
        }
    };
    JSpinner spinner;
    SpinPainter spinPainter;
    boolean wasOpaque;

    static PropertyChangeListener getPropertyChangeListener() {
        return propertyChangeListener.get();
    }

    static ArrowButtonHandler getNextButtonHandler() {
        return nextButtonHandler.get();
    }

    static ArrowButtonHandler getPreviousButtonHandler() {
        return previousButtonHandler.get();
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaSpinnerUI();
    }

    private void maybeAdd(Component c, String s) {
        if (c != null) {
            this.spinner.add(c, s);
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.spinner = (JSpinner)c;
        this.installDefaults();
        this.installListeners();
        TransparentButton next = this.createNextButton();
        TransparentButton prev = this.createPreviousButton();
        this.spinPainter = new SpinPainter(next, prev);
        this.maybeAdd(next, "Next");
        this.maybeAdd(prev, "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.maybeAdd(this.spinPainter, "Painter");
        this.updateEnabledState();
        this.installKeyboardActions();
        this.wasOpaque = this.spinner.isOpaque();
        this.spinner.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner.setOpaque(this.wasOpaque);
        this.spinner = null;
        c.removeAll();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(AquaSpinnerUI.getPropertyChangeListener());
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(AquaSpinnerUI.getPropertyChangeListener());
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected TransparentButton createPreviousButton() {
        TransparentButton b = new TransparentButton();
        b.addActionListener(AquaSpinnerUI.getPreviousButtonHandler());
        b.addMouseListener(AquaSpinnerUI.getPreviousButtonHandler());
        b.setInheritsPopupMenu(true);
        return b;
    }

    protected TransparentButton createNextButton() {
        TransparentButton b = new TransparentButton();
        b.addActionListener(AquaSpinnerUI.getNextButtonHandler());
        b.addMouseListener(AquaSpinnerUI.getNextButtonHandler());
        b.setInheritsPopupMenu(true);
        return b;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        super.getBaseline(c, width, height);
        JComponent editor = this.spinner.getEditor();
        Insets insets = this.spinner.getInsets();
        width = width - insets.left - insets.right;
        height = height - insets.top - insets.bottom;
        if (width >= 0 && height >= 0 && (baseline = editor.getBaseline(width, height)) >= 0) {
            return insets.top + baseline;
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return this.spinner.getEditor().getBaselineResizeBehavior();
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.fixupEditor(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.fixupEditor(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    protected void fixupEditor(JComponent editor) {
        KeyStroke[] keys;
        JFormattedTextField editorTextField;
        if (!(editor instanceof JSpinner.DefaultEditor)) {
            return;
        }
        editor.setOpaque(false);
        editor.setInheritsPopupMenu(true);
        if (editor.getFont() instanceof UIResource) {
            editor.setFont(this.spinner.getFont());
        }
        if ((editorTextField = ((JSpinner.DefaultEditor)editor).getTextField()).getFont() instanceof UIResource) {
            editorTextField.setFont(this.spinner.getFont());
        }
        InputMap spinnerInputMap = this.getInputMap(1);
        InputMap editorInputMap = editorTextField.getInputMap();
        for (KeyStroke k : keys = spinnerInputMap.keys()) {
            editorInputMap.put(k, spinnerInputMap.get(k));
        }
    }

    void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container c, boolean enabled) {
        for (int counter = c.getComponentCount() - 1; counter >= 0; --counter) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (!(child instanceof Container)) continue;
            this.updateEnabledState((Container)child, enabled);
        }
    }

    private void installKeyboardActions() {
        InputMap iMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, iMap);
        SwingUtilities.replaceUIActionMap(this.spinner, this.getActionMap());
    }

    private InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Spinner.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("Spinner.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Spinner.actionMap", map);
        }
        return map;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("increment", AquaSpinnerUI.getNextButtonHandler());
        map.put("decrement", AquaSpinnerUI.getPreviousButtonHandler());
        return map;
    }

    void updateToolTipTextForChildren(JComponent spinnerComponent) {
        Component[] children;
        String toolTipText = spinnerComponent.getToolTipText();
        for (Component element : children = spinnerComponent.getComponents()) {
            if (element instanceof JSpinner.DefaultEditor) {
                JFormattedTextField tf = ((JSpinner.DefaultEditor)element).getTextField();
                if (tf == null) continue;
                tf.setToolTipText(toolTipText);
                continue;
            }
            if (!(element instanceof JComponent)) continue;
            ((JComponent)element).setToolTipText(toolTipText);
        }
    }

    static class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JSpinner spinner = (JSpinner)e.getSource();
            SpinnerUI spinnerUI = spinner.getUI();
            if (spinnerUI instanceof AquaSpinnerUI) {
                JFormattedTextField tf;
                JComponent editor;
                AquaSpinnerUI ui = (AquaSpinnerUI)spinnerUI;
                if ("editor".equals(propertyName)) {
                    JComponent oldEditor = (JComponent)e.getOldValue();
                    JComponent newEditor = (JComponent)e.getNewValue();
                    ui.replaceEditor(oldEditor, newEditor);
                    ui.updateEnabledState();
                } else if ("enabled".equals(propertyName)) {
                    ui.updateEnabledState();
                } else if ("ToolTipText".equals(propertyName)) {
                    ui.updateToolTipTextForChildren(spinner);
                } else if ("font".equals(propertyName) && (editor = spinner.getEditor()) != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null && tf.getFont() instanceof UIResource) {
                    tf.setFont(spinner.getFont());
                }
            }
        }
    }

    static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;
        private Component painter = null;

        SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            } else if ("Painter".equals(name)) {
                this.painter = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                c = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            } else if (c == this.painter) {
                this.painter = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? new Dimension(0, 0) : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension editorD = this.preferredSize(this.editor);
            Dimension painterD = this.preferredSize(this.painter);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, Math.max(painterD.height, editorD.height));
            size.width += painterD.width;
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorX;
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            int availHeight = parent.getHeight() - (insets.top + insets.bottom);
            Dimension painterD = this.preferredSize(this.painter);
            int nextHeight = availHeight / 2;
            int previousHeight = availHeight - nextHeight;
            int buttonsWidth = painterD.width;
            int editorWidth = availWidth - buttonsWidth;
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                buttonsX = editorX + editorWidth;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonsWidth;
            }
            int previousY = insets.top + nextHeight;
            int painterTop = previousY - painterD.height / 2;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, availHeight);
            this.setBounds(this.nextButton, buttonsX, insets.top, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
            this.setBounds(this.painter, buttonsX, painterTop, buttonsWidth, painterD.height);
        }
    }

    class SpinPainter
    extends JComponent {
        final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIStateFactory.getSpinnerArrows());
        ButtonModel fTopModel;
        ButtonModel fBottomModel;
        boolean fPressed = false;
        boolean fTopPressed = false;
        Dimension kPreferredSize = new Dimension(15, 24);

        public SpinPainter(AbstractButton top, AbstractButton bottom) {
            if (top != null) {
                this.fTopModel = top.getModel();
            }
            if (bottom != null) {
                this.fBottomModel = bottom.getModel();
            }
        }

        @Override
        public void paint(Graphics g) {
            if (AquaSpinnerUI.this.spinner.isOpaque()) {
                g.setColor(AquaSpinnerUI.this.spinner.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            AquaUtilControlSize.applySizeForControl(AquaSpinnerUI.this.spinner, this.painter);
            if (this.isEnabled()) {
                if (this.fTopModel != null && this.fTopModel.isPressed()) {
                    ((JRSUIState)this.painter.state).set(JRSUIConstants.State.PRESSED);
                    ((JRSUIState)this.painter.state).set(JRSUIConstants.BooleanValue.NO);
                } else if (this.fBottomModel != null && this.fBottomModel.isPressed()) {
                    ((JRSUIState)this.painter.state).set(JRSUIConstants.State.PRESSED);
                    ((JRSUIState)this.painter.state).set(JRSUIConstants.BooleanValue.YES);
                } else {
                    ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE);
                }
            } else {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.State.DISABLED);
            }
            Rectangle bounds = this.getBounds();
            this.painter.paint(g, AquaSpinnerUI.this.spinner, 0, 0, bounds.width, bounds.height);
        }

        @Override
        public Dimension getPreferredSize() {
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(this);
            if (size == JRSUIConstants.Size.MINI) {
                return new Dimension(this.kPreferredSize.width, this.kPreferredSize.height - 8);
            }
            return this.kPreferredSize;
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Timer)) {
                this.spinner = this.eventToSpinner(e);
            }
            if (this.spinner == null) {
                return;
            }
            try {
                Object value;
                int calendarField = this.getCalendarField(this.spinner);
                this.spinner.commitEdit();
                if (calendarField != -1) {
                    ((SpinnerDateModel)this.spinner.getModel()).setCalendarField(calendarField);
                }
                Object object = value = this.isNext ? this.spinner.getNextValue() : this.spinner.getPreviousValue();
                if (value != null) {
                    this.spinner.setValue(value);
                    this.select(this.spinner);
                }
            }
            catch (IllegalArgumentException iae) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
            }
            catch (ParseException pe) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
            }
        }

        private void select(JSpinner spinnerComponent) {
            Object value;
            JComponent editor = spinnerComponent.getEditor();
            if (!(editor instanceof JSpinner.DateEditor)) {
                return;
            }
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
            JFormattedTextField ftf = dateEditor.getTextField();
            SimpleDateFormat format = dateEditor.getFormat();
            if (format == null || (value = spinnerComponent.getValue()) == null) {
                return;
            }
            SpinnerDateModel model = dateEditor.getModel();
            DateFormat.Field field = DateFormat.Field.ofCalendarField(model.getCalendarField());
            if (field == null) {
                return;
            }
            try {
                AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                    this.select(ftf, iterator, DateFormat.Field.HOUR1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinnerComponent) {
            Format.Field[] fields;
            JComponent editor = spinnerComponent.getEditor();
            if (!(editor instanceof JSpinner.DateEditor)) {
                return -1;
            }
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
            JFormattedTextField ftf = dateEditor.getTextField();
            int start = ftf.getSelectionStart();
            JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
            if (!(formatter instanceof InternationalFormatter)) {
                return -1;
            }
            for (Format.Field element : fields = ((InternationalFormatter)formatter).getFields(start)) {
                int calendarField;
                if (!(element instanceof DateFormat.Field) || (calendarField = element == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)element).getCalendarField()) == -1) continue;
                return calendarField;
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !e.getComponent().isEnabled()) {
                return;
            }
            this.spinner = this.eventToSpinner(e);
            this.autoRepeatTimer.start();
            this.focusSpinnerIfNecessary();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (!this.spinner.isRequestFocusEnabled() || fo != null && SwingUtilities.isDescendingFrom(fo, this.spinner)) {
                return;
            }
            Container root = this.spinner;
            if (!root.isFocusCycleRoot()) {
                root = root.getFocusCycleRootAncestor();
            }
            if (root == null) {
                return;
            }
            FocusTraversalPolicy ftp = root.getFocusTraversalPolicy();
            Component child = ftp.getComponentAfter(root, this.spinner);
            if (child != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                child.requestFocus();
            }
        }
    }

    class TransparentButton
    extends JButton
    implements SwingConstants {
        boolean interceptRepaints = false;

        public TransparentButton() {
            this.setFocusable(false);
            this.interceptRepaints = true;
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void repaint() {
            if (this.interceptRepaints) {
                if (AquaSpinnerUI.this.spinPainter == null) {
                    return;
                }
                AquaSpinnerUI.this.spinPainter.repaint();
            }
            super.repaint();
        }
    }
}

