/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaSplitPaneUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class AquaSplitPaneDividerUI
extends BasicSplitPaneDivider {
    final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIStateFactory.getSplitPaneDivider());
    static final AquaUtils.LazyKeyedSingleton<Integer, Image> directionArrows = new AquaUtils.LazyKeyedSingleton<Integer, Image>(){

        @Override
        protected Image getInstance(Integer direction) {
            Image arrowImage = AquaImageFactory.getArrowImageForDirection(direction);
            int h = arrowImage.getHeight(null) * 5 / 7;
            int w = arrowImage.getWidth(null) * 5 / 7;
            return AquaUtils.generateLightenedImage(arrowImage.getScaledInstance(w, h, 4), 50);
        }
    };
    static final int kMaxPopupArrowSize = 9;

    public AquaSplitPaneDividerUI(AquaSplitPaneUI ui) {
        super(ui);
        this.setLayout(new DividerLayout());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.splitPane) {
            String propName = e.getPropertyName();
            if ("enabled".equals(propName)) {
                boolean enabled = this.splitPane.isEnabled();
                if (this.leftButton != null) {
                    this.leftButton.setEnabled(enabled);
                }
                if (this.rightButton != null) {
                    this.rightButton.setEnabled(enabled);
                }
            } else if ("orientation".equals(propName)) {
                if (this.rightButton != null) {
                    this.remove(this.rightButton);
                    this.rightButton = null;
                }
                if (this.leftButton != null) {
                    this.remove(this.leftButton);
                    this.leftButton = null;
                }
                this.oneTouchExpandableChanged();
            }
        }
        super.propertyChange(e);
    }

    public int getMaxDividerSize() {
        return 10;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        int x = 0;
        int y = 0;
        boolean horizontal = this.splitPane.getOrientation() == 0;
        int maxSize = this.getMaxDividerSize();
        boolean doPaint = true;
        if (horizontal) {
            if (size.height > maxSize) {
                int diff = size.height - maxSize;
                y = diff / 2;
                size.height = maxSize;
            }
            if (size.height < 4) {
                doPaint = false;
            }
        } else {
            if (size.width > maxSize) {
                int diff = size.width - maxSize;
                x = diff / 2;
                size.width = maxSize;
            }
            if (size.width < 4) {
                doPaint = false;
            }
        }
        if (doPaint) {
            ((JRSUIState)this.painter.state).set(this.getState());
            this.painter.paint(g, this.splitPane, x, y, size.width, size.height);
        }
        super.paint(g);
    }

    protected JRSUIConstants.State getState() {
        return this.splitPane.isEnabled() ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.DISABLED;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return AquaSplitPaneDividerUI.createButtonForDirection(this.getDirection(true));
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return AquaSplitPaneDividerUI.createButtonForDirection(this.getDirection(false));
    }

    static JButton createButtonForDirection(int direction) {
        JButton button = new JButton(new ImageIcon(directionArrows.get(direction)));
        button.setCursor(Cursor.getPredefinedCursor(0));
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return button;
    }

    int getDirection(boolean isLeft) {
        if (this.splitPane.getOrientation() == 1) {
            return isLeft ? 7 : 3;
        }
        return isLeft ? 1 : 5;
    }

    public static Border getHorizontalSplitDividerGradientVariant() {
        return HorizontalSplitDividerGradientPainter.instance();
    }

    static class HorizontalSplitDividerGradientPainter
    implements Border {
        private static final AquaUtils.RecyclableSingleton<HorizontalSplitDividerGradientPainter> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<HorizontalSplitDividerGradientPainter>(HorizontalSplitDividerGradientPainter.class);
        final Color startColor = Color.white;
        final Color endColor = new Color(217, 217, 217);
        final Color borderLines = Color.lightGray;

        HorizontalSplitDividerGradientPainter() {
        }

        static HorizontalSplitDividerGradientPainter instance() {
            return instance.get();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, height, this.endColor));
            g2d.fillRect(x, y, width, height);
            g2d.setColor(this.borderLines);
            g2d.drawLine(x, y, x + width, y);
            g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
            g2d.setColor(oldColor);
        }
    }

    protected class DividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected DividerLayout() {
            super(AquaSplitPaneDividerUI.this);
        }

        @Override
        public void layoutContainer(Container c) {
            int maxSize = AquaSplitPaneDividerUI.this.getMaxDividerSize();
            Dimension size = AquaSplitPaneDividerUI.this.getSize();
            if (AquaSplitPaneDividerUI.this.leftButton == null || AquaSplitPaneDividerUI.this.rightButton == null || c != AquaSplitPaneDividerUI.this) {
                return;
            }
            if (!AquaSplitPaneDividerUI.this.splitPane.isOneTouchExpandable()) {
                AquaSplitPaneDividerUI.this.leftButton.setBounds(-5, -5, 1, 1);
                AquaSplitPaneDividerUI.this.rightButton.setBounds(-5, -5, 1, 1);
                return;
            }
            int blockSize = Math.min(AquaSplitPaneDividerUI.this.getDividerSize(), 9);
            if (AquaSplitPaneDividerUI.this.orientation == 0) {
                int yPosition = 0;
                if (size.height > maxSize) {
                    int diff = size.height - maxSize;
                    yPosition = diff / 2;
                }
                int xPosition = 11;
                AquaSplitPaneDividerUI.this.rightButton.setBounds(xPosition, yPosition, 9, blockSize);
                AquaSplitPaneDividerUI.this.leftButton.setBounds(xPosition -= 11, yPosition, 9, blockSize);
            } else {
                int xPosition = 0;
                if (size.width > maxSize) {
                    int diff = size.width - maxSize;
                    xPosition = diff / 2;
                }
                int yPosition = 11;
                AquaSplitPaneDividerUI.this.rightButton.setBounds(xPosition, yPosition, blockSize, 9);
                AquaSplitPaneDividerUI.this.leftButton.setBounds(xPosition, yPosition -= 11, blockSize, 9);
            }
        }
    }
}

