/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaUtilControlSize;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaTextAreaUI
extends BasicTextAreaUI {
    AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTextAreaUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        this.handler = new AquaFocusHandler();
        c.addFocusListener(this.handler);
        c.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(c);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        AquaUtilControlSize.removeSizePropertyListener(c);
        c.removeFocusListener(this.handler);
        c.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings bindings = AquaKeyBindings.instance();
        bindings.setDefaultAction(this.getKeymapName());
        JTextComponent c = this.getComponent();
        bindings.installAquaUpDownActions(c);
    }

    @Override
    protected Caret createCaret() {
        JTextComponent c = this.getComponent();
        Window owningWindow = SwingUtilities.getWindowAncestor(c);
        AquaCaret returnValue = new AquaCaret(owningWindow, c);
        return returnValue;
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

