/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class AquaTextFieldBorder
extends AquaBorder {
    protected static final AquaUtils.RecyclableSingleton<AquaTextFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaTextFieldBorder>(AquaTextFieldBorder.class);

    public static AquaTextFieldBorder getTextFieldBorder() {
        return instance.get();
    }

    public AquaTextFieldBorder() {
        this(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 7, 6, 7).alterInsets(3, 3, 3, 3)));
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.FRAME_TEXT_FIELD);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.FrameOnly.YES);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Size.LARGE);
    }

    public AquaTextFieldBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        super(sizeDescriptor);
    }

    public AquaTextFieldBorder(AquaTextFieldBorder other) {
        super(other);
    }

    @Override
    protected void setSize(JRSUIConstants.Size size) {
        super.setSize(size);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.Size.LARGE);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JTextComponent)) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Focused.NO);
            this.painter.paint(g, c, x, y, width, height);
            return;
        }
        JTextComponent jc = (JTextComponent)c;
        JRSUIConstants.State state = AquaTextFieldBorder.getStateFor(jc);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE == state && jc.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        if (jc.isOpaque()) {
            this.painter.paint(g, c, x, y, width, height);
            return;
        }
        int shrinkage = AquaTextFieldBorder.getShrinkageFor(jc, height);
        Insets subInsets = this.getSubInsets(shrinkage);
        x += subInsets.left;
        y += subInsets.top;
        width -= subInsets.left + subInsets.right;
        height -= subInsets.top + subInsets.bottom;
        if (shrinkage > 0) {
            Rectangle clipBounds = g.getClipBounds();
            clipBounds.x += shrinkage;
            clipBounds.width -= shrinkage * 2;
            g.setClip(clipBounds);
        }
        this.painter.paint(g, c, x, y, width, height);
    }

    static int getShrinkageFor(JTextComponent jc, int height) {
        if (jc == null) {
            return 0;
        }
        TextUI ui = jc.getUI();
        if (ui == null) {
            return 0;
        }
        Dimension size = ui.getPreferredSize(jc);
        if (size == null) {
            return 0;
        }
        int shrinkage = size.height - height;
        return shrinkage < 0 ? 0 : (shrinkage > 3 ? 3 : shrinkage);
    }

    protected Insets getSubInsets(int shrinkage) {
        Insets insets = this.sizeVariant.insets;
        if (shrinkage > 0) {
            return new InsetsUIResource(insets.top - shrinkage, insets.left, insets.bottom - shrinkage, insets.right);
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (!(c instanceof JTextComponent) || c.isOpaque()) {
            return new InsetsUIResource(3, 7, 3, 7);
        }
        return new InsetsUIResource(5, 5, 5, 5);
    }

    protected static JRSUIConstants.State getStateFor(JTextComponent jc) {
        if (!AquaFocusHandler.isActive(jc)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!jc.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!jc.isEditable()) {
            return JRSUIConstants.State.DISABLED;
        }
        return JRSUIConstants.State.ACTIVE;
    }
}

