/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaTextFieldBorder;
import com.apple.laf.AquaTextFieldUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class AquaTextFieldSearch {
    private static final String VARIANT_KEY = "JTextField.variant";
    private static final String SEARCH_VARIANT_VALUE = "search";
    private static final String FIND_POPUP_KEY = "JTextField.Search.FindPopup";
    private static final String FIND_ACTION_KEY = "JTextField.Search.FindAction";
    private static final String CANCEL_ACTION_KEY = "JTextField.Search.CancelAction";
    private static final String PROMPT_KEY = "JTextField.Search.Prompt";
    private static final SearchFieldPropertyListener SEARCH_FIELD_PROPERTY_LISTENER = new SearchFieldPropertyListener();
    protected static final AquaUtils.RecyclableSingleton<SearchFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<SearchFieldBorder>(SearchFieldBorder.class);

    protected static void installSearchFieldListener(JTextComponent c) {
        c.addPropertyChangeListener(SEARCH_FIELD_PROPERTY_LISTENER);
    }

    protected static void uninstallSearchFieldListener(JTextComponent c) {
        c.removePropertyChangeListener(SEARCH_FIELD_PROPERTY_LISTENER);
    }

    protected static boolean wantsToBeASearchField(JTextComponent c) {
        return SEARCH_VARIANT_VALUE.equals(c.getClientProperty(VARIANT_KEY));
    }

    protected static boolean hasPopupMenu(JTextComponent c) {
        return c.getClientProperty(FIND_POPUP_KEY) instanceof JPopupMenu;
    }

    public static SearchFieldBorder getSearchTextFieldBorder() {
        return instance.get();
    }

    protected static void installSearchField(JTextComponent c) {
        SearchFieldBorder border = AquaTextFieldSearch.getSearchTextFieldBorder();
        c.setBorder(border);
        c.setLayout(border.getCustomLayout());
        c.add((Component)AquaTextFieldSearch.getFindButton(c), "West");
        c.add((Component)AquaTextFieldSearch.getCancelButton(c), "East");
        c.add(AquaTextFieldSearch.getPromptLabel(c), "Center");
        TextUI ui = c.getUI();
        if (ui instanceof AquaTextFieldUI) {
            ((AquaTextFieldUI)ui).setPaintingDelegate(border);
        }
    }

    protected static void uninstallSearchField(JTextComponent c) {
        c.setBorder(UIManager.getBorder("TextField.border"));
        c.removeAll();
        TextUI ui = c.getUI();
        if (ui instanceof AquaTextFieldUI) {
            ((AquaTextFieldUI)ui).setPaintingDelegate(null);
        }
    }

    protected static AquaIcon.DynamicallySizingJRSUIIcon getFindIcon(JTextComponent text) {
        return text.getClientProperty(FIND_POPUP_KEY) == null ? new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 22).alterMargins(0, 4, 0, -5))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
            }
        } : new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 22).alterMargins(0, 4, 0, 2))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_FIND);
            }
        };
    }

    protected static AquaIcon.DynamicallySizingJRSUIIcon getCancelIcon() {
        return new AquaIcon.DynamicallySizingJRSUIIcon(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(22, 22).alterMargins(0, 0, 0, 4))){

            @Override
            public void initJRSUIState() {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_SEARCH_FIELD_CANCEL);
            }
        };
    }

    protected static JRSUIConstants.State getState(JButton b) {
        if (!AquaFocusHandler.isActive(b)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (b.getModel().isPressed()) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected static JButton createButton(final JTextComponent c, final AquaIcon.DynamicallySizingJRSUIIcon icon) {
        final JButton b = new JButton();
        Insets i = icon.sizeVariant.margins;
        b.setBorder(BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, i.right));
        b.setIcon(icon);
        b.setBorderPainted(false);
        b.setFocusable(false);
        b.setCursor(new Cursor(0));
        b.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((JRSUIState)icon.painter.state).set(AquaTextFieldSearch.getState(b));
            }
        });
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                c.requestFocusInWindow();
            }
        });
        return b;
    }

    protected static JButton getFindButton(final JTextComponent c) {
        Object findAction;
        AquaIcon.DynamicallySizingJRSUIIcon findIcon = AquaTextFieldSearch.getFindIcon(c);
        final JButton b = AquaTextFieldSearch.createButton(c, findIcon);
        b.setName("find");
        final Object findPopup = c.getClientProperty(FIND_POPUP_KEY);
        if (findPopup instanceof JPopupMenu) {
            ((JRSUIState)findIcon.painter.state).set(JRSUIConstants.Variant.MENU_GLYPH);
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ((JPopupMenu)findPopup).show(b, 8, b.getHeight() - 2);
                    c.requestFocusInWindow();
                    c.repaint();
                }
            });
        }
        if ((findAction = c.getClientProperty(FIND_ACTION_KEY)) instanceof ActionListener) {
            b.addActionListener((ActionListener)findAction);
        }
        return b;
    }

    private static Component getPromptLabel(final JTextComponent c) {
        final JLabel label = new JLabel();
        label.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        c.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }
        });
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void focusLost(FocusEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }
        });
        AquaTextFieldSearch.updatePromptLabel(label, c);
        return label;
    }

    static void updatePromptLabel(final JLabel label, final JTextComponent text) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updatePromptLabelOnEDT(label, text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updatePromptLabelOnEDT(label, text);
                }
            });
        }
    }

    static void updatePromptLabelOnEDT(JLabel label, JTextComponent text) {
        Object prompt;
        String promptText = " ";
        if (!text.hasFocus() && "".equals(text.getText()) && (prompt = text.getClientProperty(PROMPT_KEY)) != null) {
            promptText = prompt.toString();
        }
        label.setText(promptText);
    }

    protected static JButton getCancelButton(final JTextComponent c) {
        final JButton b = AquaTextFieldSearch.createButton(c, AquaTextFieldSearch.getCancelIcon());
        b.setName("cancel");
        Object cancelAction = c.getClientProperty(CANCEL_ACTION_KEY);
        if (cancelAction instanceof ActionListener) {
            b.addActionListener((ActionListener)cancelAction);
        }
        b.addActionListener(new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                c.setText("");
            }
        });
        c.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }
        });
        AquaTextFieldSearch.updateCancelIcon(b, c);
        return b;
    }

    static void updateCancelIcon(final JButton button, final JTextComponent text) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updateCancelIconOnEDT(button, text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updateCancelIconOnEDT(button, text);
                }
            });
        }
    }

    static void updateCancelIconOnEDT(JButton button, JTextComponent text) {
        button.setVisible(!"".equals(text.getText()));
    }

    static class SearchFieldBorder
    extends AquaTextFieldBorder
    implements AquaUtils.JComponentPainter {
        protected boolean reallyPaintBorder;
        protected boolean doingLayout;

        public SearchFieldBorder() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 31, 6, 24).alterInsets(3, 3, 3, 3)));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.FRAME_TEXT_FIELD_ROUND);
        }

        public SearchFieldBorder(SearchFieldBorder other) {
            super(other);
        }

        @Override
        public void paint(JComponent c, Graphics g, int x, int y, int w, int h) {
            this.reallyPaintBorder = true;
            this.paintBorder(c, g, x, y, w, h);
            this.reallyPaintBorder = false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.reallyPaintBorder) {
                return;
            }
            super.paintBorder(c, g, x, y - height % 2, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.doingLayout) {
                return new Insets(0, 0, 0, 0);
            }
            if (!AquaTextFieldSearch.hasPopupMenu((JTextComponent)c)) {
                return new Insets(this.sizeVariant.margins.top, this.sizeVariant.margins.left - 7, this.sizeVariant.margins.bottom, this.sizeVariant.margins.right);
            }
            return this.sizeVariant.margins;
        }

        protected LayoutManager getCustomLayout() {
            return new BorderLayout(0, 0){

                @Override
                public void layoutContainer(Container target) {
                    doingLayout = true;
                    super.layoutContainer(target);
                    doingLayout = false;
                }
            };
        }
    }

    static class SearchFieldPropertyListener
    implements PropertyChangeListener {
        SearchFieldPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof JTextComponent)) {
                return;
            }
            String propertyName = evt.getPropertyName();
            if (!(AquaTextFieldSearch.VARIANT_KEY.equals(propertyName) || AquaTextFieldSearch.FIND_POPUP_KEY.equals(propertyName) || AquaTextFieldSearch.FIND_ACTION_KEY.equals(propertyName) || AquaTextFieldSearch.CANCEL_ACTION_KEY.equals(propertyName) || AquaTextFieldSearch.PROMPT_KEY.equals(propertyName))) {
                return;
            }
            JTextComponent c = (JTextComponent)source;
            if (AquaTextFieldSearch.wantsToBeASearchField(c)) {
                AquaTextFieldSearch.uninstallSearchField(c);
                AquaTextFieldSearch.installSearchField(c);
            } else {
                AquaTextFieldSearch.uninstallSearchField(c);
            }
        }
    }
}

