/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaTextFieldBorder;
import com.apple.laf.AquaTextFieldSearch;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaTextFieldUI
extends BasicTextFieldUI {
    protected AquaUtils.JComponentPainter delegate;
    protected AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTextFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = new AquaFocusHandler();
        JTextComponent c = this.getComponent();
        c.addFocusListener(this.handler);
        c.addPropertyChangeListener(this.handler);
        LookAndFeel.installProperty(c, "opaque", UIManager.getBoolean(this.getPropertyPrefix() + "opaque"));
        AquaUtilControlSize.addSizePropertyListener(c);
        AquaTextFieldSearch.installSearchFieldListener(c);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        AquaTextFieldSearch.uninstallSearchFieldListener(c);
        AquaUtilControlSize.removeSizePropertyListener(c);
        c.removeFocusListener(this.handler);
        c.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings.instance().setDefaultAction(this.getKeymapName());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect == null) {
            return null;
        }
        if (!this.getComponent().isOpaque()) {
            rect.y -= 3;
            rect.height += 6;
        }
        return rect;
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackgroundSafely(g);
        super.paintSafely(g);
    }

    protected void paintBackgroundSafely(Graphics g) {
        JTextComponent c = this.getComponent();
        int width = c.getWidth();
        int height = c.getHeight();
        if (this.delegate != null) {
            this.delegate.paint(c, g, 0, 0, width, height);
            return;
        }
        boolean isOpaque = c.isOpaque();
        if (!(c.getBorder() instanceof AquaTextFieldBorder)) {
            if (!isOpaque && AquaUtils.hasOpaqueBeenExplicitlySet(c)) {
                return;
            }
            g.setColor(c.getBackground());
            g.fillRect(0, 0, width, height);
            return;
        }
        g.setColor(c.getBackground());
        if (isOpaque) {
            g.fillRect(0, 0, width, height);
            return;
        }
        Insets margin = c.getMargin();
        Insets insets = c.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (margin != null) {
            insets.top -= margin.top;
            insets.left -= margin.left;
            insets.bottom -= margin.bottom;
            insets.right -= margin.right;
        }
        int shrinkage = AquaTextFieldBorder.getShrinkageFor(c, height);
        g.fillRect(insets.left - 2, insets.top - shrinkage - 1, width - insets.right - insets.left + 4, height - insets.bottom - insets.top + shrinkage * 2 + 2);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    protected Caret createCaret() {
        JTextComponent c = this.getComponent();
        Window owningWindow = SwingUtilities.getWindowAncestor(c);
        return new AquaCaret(owningWindow, c);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }

    protected void setPaintingDelegate(AquaUtils.JComponentPainter delegate) {
        this.delegate = delegate;
    }
}

