/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class AquaToolBarUI
extends BasicToolBarUI
implements SwingConstants {
    private static AquaUtils.RecyclableSingleton<ToolBarBorder> toolBarBorder = new AquaUtils.RecyclableSingletonFromDefaultConstructor<ToolBarBorder>(ToolBarBorder.class);

    public static Border getToolBarBorder() {
        return toolBarBorder.get();
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaToolBarUI();
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        RootPaneContainer window = super.createFloatingWindow(toolbar);
        window.getRootPane().putClientProperty("Window.style", "small");
        return window;
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c);
        }
        this.paint(g, c);
    }

    static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        ToolBarBorder() {
        }

        protected void fillHandle(Graphics g, int x1, int y1, int x2, int y2, boolean horizontal) {
            g.setColor(UIManager.getColor("ToolBar.borderHandleColor"));
            if (horizontal) {
                int h = y2 - y1 - 2;
                g.fillRect(x1 + 2, y1 + 1, 1, h);
                g.fillRect(x1 + 5, y1 + 1, 1, h);
            } else {
                int w = x2 - x1 - 2;
                g.fillRect(x1 + 1, y1 + 2, w, 1);
                g.fillRect(x1 + 1, y1 + 5, w, 1);
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean horizontal;
            g.translate(x, y);
            if (c.isOpaque()) {
                AquaUtils.fillRect(g, c, c.getBackground(), 0, 0, w - 1, h - 1);
            }
            Color oldColor = g.getColor();
            JToolBar jtb = (JToolBar)c;
            ComponentOrientation orient = jtb.getComponentOrientation();
            boolean bl = horizontal = jtb.getOrientation() == 0;
            if (jtb.isFloatable()) {
                if (horizontal) {
                    if (orient.isLeftToRight()) {
                        this.fillHandle(g, 2, 2, 10, h - 2, true);
                    } else {
                        this.fillHandle(g, w - 10, 2, w - 2, h - 2, true);
                    }
                } else {
                    this.fillHandle(g, 2, 2, w - 2, 10, false);
                }
            }
            g.setColor(oldColor);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets borderInsets = new Insets(5, 5, 5, 5);
            return this.getBorderInsets(c, borderInsets);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets margin;
            borderInsets.left = 4;
            borderInsets.right = 4;
            borderInsets.top = 2;
            borderInsets.bottom = 2;
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    borderInsets.left = 12;
                } else {
                    borderInsets.top = 12;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                borderInsets.left += margin.left;
                borderInsets.top += margin.top;
                borderInsets.right += margin.right;
                borderInsets.bottom += margin.bottom;
            }
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

