/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class AquaTreeUI
extends BasicTreeUI {
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private final PropertyChangeListener lineStyleListener = new LineListener();
    protected TreePath fTrackingPath;
    protected boolean fIsPressed = false;
    protected boolean fIsInBounds = false;
    protected int fAnimationFrame = -1;
    protected TreeArrowMouseInputHandler fMouseHandler;
    protected final AquaPainter<JRSUIState.AnimationFrameState> painter = AquaPainter.create(JRSUIStateFactory.getDisclosureTriangle());

    public static ComponentUI createUI(JComponent c) {
        return new AquaTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object lineStyleFlag = c.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(lineStyleFlag);
        c.addPropertyChangeListener(this.lineStyleListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(c);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
        if (lineStyleFlag == null || NO_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 0;
            return;
        }
        if (LEG_LINE_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 2;
        } else if (HORIZ_STYLE_STRING.equals(lineStyleFlag)) {
            this.lineStyle = 1;
        }
    }

    @Override
    public TreePath getClosestPathForLocation(JTree treeLocal, int x, int y) {
        if (treeLocal == null || this.treeState == null) {
            return null;
        }
        Insets i = treeLocal.getInsets();
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        return this.treeState.getPathClosestTo(x - i.left, y - i.top);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(g, c);
        }
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
        g.setColor(UIManager.getColor("Tree.line"));
        Rectangle clipBounds = g.getClipBounds();
        int beginRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y));
        int endRow = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clipBounds.y + clipBounds.height - 1));
        if (beginRow <= -1 || endRow <= -1) {
            return;
        }
        for (int i = beginRow; i <= endRow; ++i) {
            Rectangle rowBounds;
            TreePath path = this.getPathForRow(this.tree, i);
            if (path == null || path.getPathCount() != 2 || (rowBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
            g.drawLine(clipBounds.x, rowBounds.y, clipBounds.x + clipBounds.width, rowBounds.y);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Icon icon;
        Object value = path.getLastPathComponent();
        if (isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0) {
            return;
        }
        boolean isLeftToRight = AquaUtils.isLeftToRight(this.tree);
        JRSUIConstants.State state = this.getState(path);
        if (this.fAnimationFrame == -1 && state != JRSUIConstants.State.PRESSED) {
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            return;
        }
        Icon icon2 = icon = isExpanded ? this.getExpandedIcon() : this.getCollapsedIcon();
        if (!(icon instanceof UIResource)) {
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            return;
        }
        int middleXOfKnob = isLeftToRight ? bounds.x - (this.getRightChildIndent() - 1) : clipBounds.x + clipBounds.width / 2;
        int middleYOfKnob = bounds.y + bounds.height / 2;
        int x = middleXOfKnob - icon.getIconWidth() / 2;
        int y = middleYOfKnob - icon.getIconHeight() / 2;
        int height = icon.getIconHeight();
        int width = 20;
        this.setupPainter(state, isExpanded, isLeftToRight);
        this.painter.paint(g, this.tree, x, y, 20, height);
    }

    @Override
    public Icon getCollapsedIcon() {
        Icon icon = super.getCollapsedIcon();
        if (AquaUtils.isLeftToRight(this.tree)) {
            return icon;
        }
        if (!(icon instanceof UIResource)) {
            return icon;
        }
        return UIManager.getIcon("Tree.rightToLeftCollapsedIcon");
    }

    protected void setupPainter(JRSUIConstants.State state, boolean isExpanded, boolean leftToRight) {
        if (!this.fIsInBounds && state == JRSUIConstants.State.PRESSED) {
            state = JRSUIConstants.State.ACTIVE;
        }
        ((JRSUIState.AnimationFrameState)this.painter.state).set(state);
        if (JRSUIUtils.Tree.useLegacyTreeKnobs()) {
            if (this.fAnimationFrame == -1) {
                ((JRSUIState.AnimationFrameState)this.painter.state).set(isExpanded ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.RIGHT);
            } else {
                ((JRSUIState.AnimationFrameState)this.painter.state).set(JRSUIConstants.Direction.NONE);
                ((JRSUIState.AnimationFrameState)this.painter.state).setAnimationFrame(this.fAnimationFrame - 1);
            }
        } else {
            ((JRSUIState.AnimationFrameState)this.painter.state).set(this.getDirection(isExpanded, leftToRight));
            ((JRSUIState.AnimationFrameState)this.painter.state).setAnimationFrame(this.fAnimationFrame);
        }
    }

    protected JRSUIConstants.Direction getDirection(boolean isExpanded, boolean isLeftToRight) {
        if (isExpanded && this.fAnimationFrame == -1) {
            return JRSUIConstants.Direction.DOWN;
        }
        return isLeftToRight ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT;
    }

    protected JRSUIConstants.State getState(TreePath path) {
        if (!this.tree.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.fIsPressed && this.fTrackingPath.equals(path)) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.fMouseHandler = new TreeArrowMouseInputHandler(path);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isMetaDown();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MacPropertyChangeHandler();
    }

    protected int getRowForPath(TreePath path) {
        return this.treeState.getRowForPath(path);
    }

    protected Rectangle getPathArrowBounds(TreePath path) {
        int boxLeftX;
        Rectangle bounds = this.getPathBounds(this.tree, path);
        Insets i = this.tree.getInsets();
        bounds.width = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
        int n = boxLeftX = i != null ? i.left : 0;
        boxLeftX = AquaUtils.isLeftToRight(this.tree) ? (boxLeftX += (path.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - bounds.width / 2) : (boxLeftX += this.tree.getWidth() - 1 - (path.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - bounds.width / 2);
        bounds.x = boxLeftX;
        return bounds;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getActionMap().put("aquaExpandNode", new KeyboardExpandCollapseAction(true, false));
        this.tree.getActionMap().put("aquaCollapseNode", new KeyboardExpandCollapseAction(false, false));
        this.tree.getActionMap().put("aquaFullyExpandNode", new KeyboardExpandCollapseAction(true, true));
        this.tree.getActionMap().put("aquaFullyCollapseNode", new KeyboardExpandCollapseAction(false, true));
    }

    void expandNode(int row, boolean recursive) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path == null) {
            return;
        }
        this.tree.expandPath(path);
        if (!recursive) {
            return;
        }
        this.expandAllNodes(path, row + 1);
    }

    void expandAllNodes(TreePath parent, int initialRow) {
        int i = initialRow;
        TreePath path;
        while (parent.isDescendant(path = this.getPathForRow(this.tree, i))) {
            this.tree.expandPath(path);
            ++i;
        }
        return;
    }

    void collapseNode(int row, boolean recursive) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path == null) {
            return;
        }
        if (recursive) {
            this.collapseAllNodes(path, row + 1);
        }
        this.tree.collapsePath(path);
    }

    void collapseAllNodes(TreePath parent, int initialRow) {
        TreePath path;
        int lastRow = -1;
        int i = initialRow;
        while (lastRow == -1) {
            path = this.getPathForRow(this.tree, i);
            if (!parent.isDescendant(path)) {
                lastRow = i - 1;
            }
            ++i;
        }
        for (i = lastRow; i >= initialRow; --i) {
            path = this.getPathForRow(this.tree, i);
            this.tree.collapsePath(path);
        }
    }

    class KeyboardExpandCollapseAction
    extends AbstractAction {
        final boolean expand;
        final boolean recursive;

        public KeyboardExpandCollapseAction(boolean expand, boolean recursive) {
            this.expand = expand;
            this.recursive = recursive;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AquaTreeUI.this.tree == null || 0 > AquaTreeUI.this.getRowCount(AquaTreeUI.this.tree)) {
                return;
            }
            TreePath[] selectionPaths = AquaTreeUI.this.tree.getSelectionPaths();
            if (selectionPaths == null) {
                return;
            }
            for (int i = selectionPaths.length - 1; i >= 0; --i) {
                TreePath path = selectionPaths[i];
                if (this.expand) {
                    AquaTreeUI.this.expandNode(AquaTreeUI.this.tree.getRowForPath(path), this.recursive);
                    continue;
                }
                if (selectionPaths.length == 1 && AquaTreeUI.this.tree.isCollapsed(path)) {
                    TreePath parentPath = path.getParentPath();
                    if (parentPath == null || parentPath.getParentPath() == null && !AquaTreeUI.this.tree.isRootVisible()) continue;
                    AquaTreeUI.this.tree.scrollPathToVisible(parentPath);
                    AquaTreeUI.this.tree.setSelectionPath(parentPath);
                    continue;
                }
                AquaTreeUI.this.collapseNode(AquaTreeUI.this.tree.getRowForPath(path), this.recursive);
            }
        }

        @Override
        public boolean isEnabled() {
            return AquaTreeUI.this.tree != null && AquaTreeUI.this.tree.isEnabled();
        }
    }

    class TreeArrowMouseInputHandler
    extends MouseInputAdapter {
        protected Rectangle fPathBounds = new Rectangle();
        protected boolean fIsLeaf;
        protected boolean fIsExpanded;
        protected boolean fHasBeenExpanded;
        protected Rectangle fBounds;
        protected Rectangle fVisibleRect;
        int fTrackingRow;
        Insets fInsets;
        Color fBackground;

        TreeArrowMouseInputHandler(TreePath path) {
            Container p;
            AquaTreeUI.this.fTrackingPath = path;
            AquaTreeUI.this.fIsPressed = true;
            AquaTreeUI.this.fIsInBounds = true;
            this.fPathBounds = AquaTreeUI.this.getPathArrowBounds(path);
            AquaTreeUI.this.tree.addMouseListener(this);
            AquaTreeUI.this.tree.addMouseMotionListener(this);
            this.fBackground = AquaTreeUI.this.tree.getBackground();
            if (!AquaTreeUI.this.tree.isOpaque() && (p = AquaTreeUI.this.tree.getParent()) != null) {
                this.fBackground = p.getBackground();
            }
            this.fVisibleRect = AquaTreeUI.this.tree.getVisibleRect();
            this.fInsets = AquaTreeUI.this.tree.getInsets();
            if (this.fInsets == null) {
                this.fInsets = new Insets(0, 0, 0, 0);
            }
            this.fIsLeaf = AquaTreeUI.this.treeModel.isLeaf(path.getLastPathComponent());
            if (this.fIsLeaf) {
                this.fHasBeenExpanded = false;
                this.fIsExpanded = false;
            } else {
                this.fIsExpanded = AquaTreeUI.this.treeState.getExpandedState(path);
                this.fHasBeenExpanded = AquaTreeUI.this.tree.hasBeenExpanded(path);
            }
            Rectangle boundsBuffer = new Rectangle();
            this.fBounds = AquaTreeUI.this.treeState.getBounds(AquaTreeUI.this.fTrackingPath, boundsBuffer);
            this.fBounds.x += this.fInsets.left;
            this.fBounds.y += this.fInsets.top;
            this.fTrackingRow = AquaTreeUI.this.getRowForPath(AquaTreeUI.this.fTrackingPath);
            this.paintOneControl();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(e.getX(), e.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(e.getX(), e.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            if (AquaTreeUI.this.fIsPressed) {
                boolean wasInBounds = AquaTreeUI.this.fIsInBounds;
                AquaTreeUI.this.fIsPressed = false;
                AquaTreeUI.this.fIsInBounds = false;
                if (wasInBounds) {
                    this.fIsExpanded = !this.fIsExpanded;
                    this.paintAnimation(this.fIsExpanded);
                    if (e.isAltDown()) {
                        if (this.fIsExpanded) {
                            AquaTreeUI.this.expandNode(this.fTrackingRow, true);
                        } else {
                            AquaTreeUI.this.collapseNode(this.fTrackingRow, true);
                        }
                    } else {
                        AquaTreeUI.this.toggleExpandState(AquaTreeUI.this.fTrackingPath);
                    }
                }
            }
            AquaTreeUI.this.fTrackingPath = null;
            this.removeFromSource();
        }

        protected void paintAnimation(boolean expanding) {
            if (expanding) {
                this.paintAnimationFrame(1);
                this.paintAnimationFrame(2);
                this.paintAnimationFrame(3);
            } else {
                this.paintAnimationFrame(3);
                this.paintAnimationFrame(2);
                this.paintAnimationFrame(1);
            }
            AquaTreeUI.this.fAnimationFrame = -1;
        }

        protected void paintAnimationFrame(int frame) {
            AquaTreeUI.this.fAnimationFrame = frame;
            this.paintOneControl();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void paintOneControl() {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            Graphics g = AquaTreeUI.this.tree.getGraphics();
            if (g == null) {
                return;
            }
            try {
                g.setClip(this.fVisibleRect);
                g.setColor(this.fBackground);
                g.fillRect(this.fPathBounds.x, this.fPathBounds.y, this.fPathBounds.width, this.fPathBounds.height);
                if (AquaTreeUI.this.fTrackingPath == null) {
                    return;
                }
                TreePath parentPath = AquaTreeUI.this.fTrackingPath.getParentPath();
                if (parentPath != null) {
                    AquaTreeUI.this.paintVerticalPartOfLeg(g, this.fPathBounds, this.fInsets, parentPath);
                    AquaTreeUI.this.paintHorizontalPartOfLeg(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                } else if (AquaTreeUI.this.isRootVisible() && this.fTrackingRow == 0) {
                    AquaTreeUI.this.paintHorizontalPartOfLeg(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                }
                AquaTreeUI.this.paintExpandControl(g, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
            }
            finally {
                g.dispose();
            }
        }

        protected void removeFromSource() {
            AquaTreeUI.this.tree.removeMouseListener(this);
            AquaTreeUI.this.tree.removeMouseMotionListener(this);
        }
    }

    public class MacPropertyChangeHandler
    extends BasicTreeUI.PropertyChangeHandler {
        public MacPropertyChangeHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("Frame.active")) {
                AquaBorder.repaintBorder(AquaTreeUI.this.tree);
                AquaFocusHandler.swapSelectionColors("Tree", AquaTreeUI.this.tree, e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }
    }

    class FocusHandler
    extends BasicTreeUI.FocusHandler {
        FocusHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            AquaBorder.repaintBorder(AquaTreeUI.this.tree);
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            AquaBorder.repaintBorder(AquaTreeUI.this.tree);
        }
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(AquaTreeUI.LINE_STYLE)) {
                AquaTreeUI.this.decodeLineStyle(e.getNewValue());
            }
        }
    }
}

