/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFonts;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import sun.security.action.GetPropertyAction;

public class AquaUtilControlSize {
    protected static final String CLIENT_PROPERTY_KEY = "JComponent.sizeVariant";
    protected static final String SYSTEM_PROPERTY_KEY = "swing.component.sizevariant";
    protected static final AquaUtils.RecyclableSingleton<PropertySizeListener> sizeListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<PropertySizeListener>(PropertySizeListener.class);
    protected static final JRSUIConstants.Size defaultSize = AquaUtilControlSize.getDefaultSize();

    protected static PropertySizeListener getSizeListener() {
        return sizeListener.get();
    }

    protected static void addSizePropertyListener(JComponent c) {
        c.addPropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
        PropertySizeListener.applyComponentSize(c, c.getClientProperty(CLIENT_PROPERTY_KEY));
    }

    protected static void removeSizePropertyListener(JComponent c) {
        c.removePropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
    }

    private static JRSUIConstants.Size getSizeFromString(String name) {
        if ("regular".equalsIgnoreCase(name)) {
            return JRSUIConstants.Size.REGULAR;
        }
        if ("small".equalsIgnoreCase(name)) {
            return JRSUIConstants.Size.SMALL;
        }
        if ("mini".equalsIgnoreCase(name)) {
            return JRSUIConstants.Size.MINI;
        }
        if ("large".equalsIgnoreCase(name)) {
            return JRSUIConstants.Size.LARGE;
        }
        return null;
    }

    private static JRSUIConstants.Size getDefaultSize() {
        String sizeProperty = AccessController.doPrivileged(new GetPropertyAction(SYSTEM_PROPERTY_KEY));
        JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(sizeProperty);
        if (size != null) {
            return size;
        }
        return JRSUIConstants.Size.REGULAR;
    }

    protected static JRSUIConstants.Size getUserSizeFrom(JComponent c) {
        Object sizeProp = c.getClientProperty(CLIENT_PROPERTY_KEY);
        if (sizeProp == null) {
            return defaultSize;
        }
        JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(sizeProp.toString());
        if (size == null) {
            return JRSUIConstants.Size.REGULAR;
        }
        return size;
    }

    protected static JRSUIConstants.Size applySizeForControl(JComponent c, AquaPainter<? extends JRSUIState> painter) {
        JRSUIConstants.Size sizeFromUser = AquaUtilControlSize.getUserSizeFrom(c);
        JRSUIConstants.Size size = sizeFromUser == null ? JRSUIConstants.Size.REGULAR : sizeFromUser;
        ((JRSUIState)painter.state).set(size);
        return size;
    }

    protected static Font getFontForSize(Component c, JRSUIConstants.Size size) {
        Font initialFont = c.getFont();
        if (size == null || !(initialFont instanceof UIResource)) {
            return initialFont;
        }
        if (size == JRSUIConstants.Size.MINI) {
            return initialFont.deriveFont(AquaFonts.getMiniControlTextFont().getSize2D());
        }
        if (size == JRSUIConstants.Size.SMALL) {
            return initialFont.deriveFont(AquaFonts.getSmallControlTextFont().getSize2D());
        }
        return initialFont.deriveFont(AquaFonts.getControlTextFont().getSize2D());
    }

    private static void applyBorderForSize(JComponent c, JRSUIConstants.Size size) {
        Border border = c.getBorder();
        if (!(border instanceof AquaBorder)) {
            return;
        }
        AquaBorder aquaBorder = (AquaBorder)border;
        if (aquaBorder.sizeVariant.size == size) {
            return;
        }
        AquaBorder derivedBorder = aquaBorder.deriveBorderForSize(size);
        if (derivedBorder == null) {
            return;
        }
        c.setBorder(derivedBorder);
    }

    private static void applyUISizing(JComponent c, JRSUIConstants.Size size) {
        try {
            Class<?> clazz = c.getClass();
            Method getUIMethod = clazz.getMethod("getUI", new Class[0]);
            Object ui = getUIMethod.invoke(c, new Object[0]);
            if (!(ui instanceof Sizeable)) {
                return;
            }
            Sizeable sizeable = (Sizeable)ui;
            sizeable.applySizeFor(c, size);
        }
        finally {
            return;
        }
    }

    public static class SizeVariant {
        JRSUIConstants.Size size = JRSUIConstants.Size.REGULAR;
        Insets insets = new InsetsUIResource(0, 0, 0, 0);
        Insets margins = new InsetsUIResource(0, 0, 0, 0);
        Float fontSize;
        int w = 0;
        int h = 0;

        public SizeVariant() {
        }

        public SizeVariant(int minWidth, int minHeight) {
            this.w = minWidth;
            this.h = minHeight;
        }

        public SizeVariant(SizeVariant desc) {
            this.size = desc.size;
            this.insets = new InsetsUIResource(desc.insets.top, desc.insets.left, desc.insets.bottom, desc.insets.right);
            this.margins = new InsetsUIResource(desc.margins.top, desc.margins.left, desc.margins.bottom, desc.margins.right);
            this.fontSize = desc.fontSize;
            this.w = desc.w;
            this.h = desc.h;
        }

        public SizeVariant replaceInsets(String insetName) {
            this.insets = UIManager.getInsets(insetName);
            return this;
        }

        public SizeVariant replaceInsets(Insets i) {
            this.insets = new InsetsUIResource(i.top, i.left, i.bottom, i.right);
            return this;
        }

        public SizeVariant alterInsets(int top, int left, int bottom, int right) {
            this.insets = SizeVariant.generateInsets(this.insets, top, left, bottom, right);
            return this;
        }

        public SizeVariant replaceMargins(String marginName) {
            this.margins = UIManager.getInsets(marginName);
            return this;
        }

        public SizeVariant alterMargins(int top, int left, int bottom, int right) {
            this.margins = SizeVariant.generateInsets(this.margins, top, left, bottom, right);
            return this;
        }

        public SizeVariant alterFontSize(float newSize) {
            float oldSize = this.fontSize == null ? 0.0f : this.fontSize.floatValue();
            this.fontSize = new Float(newSize + oldSize);
            return this;
        }

        public SizeVariant alterMinSize(int width, int height) {
            this.w += width;
            this.h += height;
            return this;
        }

        static Insets generateInsets(Insets i, int top, int left, int bottom, int right) {
            if (i == null) {
                return new InsetsUIResource(top, left, bottom, right);
            }
            i.top += top;
            i.left += left;
            i.bottom += bottom;
            i.right += right;
            return i;
        }

        public String toString() {
            return "insets:" + this.insets + ", margins:" + this.margins + ", fontSize:" + this.fontSize;
        }
    }

    public static class SizeDescriptor {
        SizeVariant regular;
        SizeVariant small;
        SizeVariant mini;

        public SizeDescriptor(SizeVariant variant) {
            this.regular = this.deriveRegular(variant);
            this.small = this.deriveSmall(new SizeVariant(this.regular));
            this.mini = this.deriveMini(new SizeVariant(this.small));
        }

        public SizeVariant deriveRegular(SizeVariant v) {
            v.size = JRSUIConstants.Size.REGULAR;
            return v;
        }

        public SizeVariant deriveSmall(SizeVariant v) {
            v.size = JRSUIConstants.Size.SMALL;
            return v;
        }

        public SizeVariant deriveMini(SizeVariant v) {
            v.size = JRSUIConstants.Size.MINI;
            return v;
        }

        public SizeVariant get(JComponent c) {
            if (c == null) {
                return this.regular;
            }
            return this.get(AquaUtilControlSize.getUserSizeFrom(c));
        }

        public SizeVariant get(JRSUIConstants.Size size) {
            if (size == JRSUIConstants.Size.REGULAR) {
                return this.regular;
            }
            if (size == JRSUIConstants.Size.SMALL) {
                return this.small;
            }
            if (size == JRSUIConstants.Size.MINI) {
                return this.mini;
            }
            return this.regular;
        }

        public String toString() {
            return "regular[" + this.regular + "] small[" + this.small + "] mini[" + this.mini + "]";
        }
    }

    protected static class PropertySizeListener
    implements PropertyChangeListener {
        protected PropertySizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String key = evt.getPropertyName();
            if (!AquaUtilControlSize.CLIENT_PROPERTY_KEY.equalsIgnoreCase(key)) {
                return;
            }
            Object source = evt.getSource();
            if (!(source instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)source;
            PropertySizeListener.applyComponentSize(c, evt.getNewValue());
        }

        protected static void applyComponentSize(JComponent c, Object value) {
            JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(value == null ? null : value.toString());
            if (size == null && (size = AquaUtilControlSize.getUserSizeFrom(c)) == JRSUIConstants.Size.REGULAR) {
                return;
            }
            AquaUtilControlSize.applyBorderForSize(c, size);
            AquaUtilControlSize.applyUISizing(c, size);
            Font priorFont = c.getFont();
            if (!(priorFont instanceof FontUIResource)) {
                return;
            }
            c.setFont(AquaUtilControlSize.getFontForSize(c, size));
        }
    }

    static interface Sizeable {
        public void applySizeFor(JComponent var1, JRSUIConstants.Size var2);
    }
}

