/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaIcon;
import com.apple.laf.ScreenMenuItem;
import com.apple.laf.ScreenMenuItemCheckbox;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.Component;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuComponentPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import sun.awt.SunToolkit;
import sun.lwawt.LWToolkit;
import sun.lwawt.macosx.CMenu;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.LWCToolkit;

final class ScreenMenu
extends Menu
implements ContainerListener,
ComponentListener,
ScreenMenuPropertyHandler {
    private transient long fModelPtr;
    private final Hashtable<Component, MenuItem> fItems;
    private final JMenu fInvoker;
    private Component fLastMouseEventTarget;
    private Rectangle fLastTargetRect;
    private volatile Rectangle[] fItemBounds;
    private ScreenMenuPropertyListener fPropertyListener;
    private int[] childHashArray;

    private static native long addMenuListeners(ScreenMenu var0, long var1);

    private static native void removeMenuListeners(long var0);

    ScreenMenu(JMenu invoker) {
        super(invoker.getText());
        this.fInvoker = invoker;
        int count = this.fInvoker.getMenuComponentCount();
        if (count < 5) {
            count = 5;
        }
        this.fItems = new Hashtable(count);
        this.setEnabled(this.fInvoker.isEnabled());
        this.updateItems();
    }

    private static boolean needsUpdate(Component[] items, int[] childHashArray) {
        if (items == null || childHashArray == null) {
            return true;
        }
        if (childHashArray.length != items.length) {
            return true;
        }
        for (int i = 0; i < items.length; ++i) {
            int hashCode = ScreenMenu.getHashCode(items[i]);
            if (hashCode == childHashArray[i]) continue;
            return true;
        }
        return false;
    }

    private void updateItems() {
        int count = this.fInvoker.getMenuComponentCount();
        Component[] items = this.fInvoker.getMenuComponents();
        if (ScreenMenu.needsUpdate(items, this.childHashArray)) {
            this.removeAll();
            this.fItems.clear();
            if (count <= 0) {
                return;
            }
            this.childHashArray = new int[count];
            for (int i = 0; i < count; ++i) {
                this.addItem(items[i]);
                this.childHashArray[i] = ScreenMenu.getHashCode(items[i]);
            }
        }
    }

    public void invokeOpenLater() {
        final JMenu invoker = this.fInvoker;
        if (invoker == null) {
            System.err.println("invoker is null!");
            return;
        }
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    invoker.setSelected(true);
                    invoker.validate();
                    ScreenMenu.this.updateItems();
                    ScreenMenu.access$102(ScreenMenu.this, new Rectangle[invoker.getMenuComponentCount()]);
                }
            }, (Component)invoker);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void invokeMenuClosing() {
        final JMenu invoker = this.fInvoker;
        if (invoker == null) {
            return;
        }
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    invoker.setSelected(false);
                    if (ScreenMenu.this.fItemBounds != null) {
                        for (int i = 0; i < ScreenMenu.this.fItemBounds.length; ++i) {
                            ((ScreenMenu)ScreenMenu.this).fItemBounds[i] = null;
                        }
                    }
                    ScreenMenu.access$102(ScreenMenu.this, null);
                }
            }, (Component)invoker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleItemTargeted(int inWhichItem, int itemRectTop, int itemRectLeft, int itemRectBottom, int itemRectRight) {
        Rectangle itemRect;
        if (this.fItemBounds == null || inWhichItem < 0 || inWhichItem > this.fItemBounds.length - 1) {
            return;
        }
        this.fItemBounds[inWhichItem] = itemRect = new Rectangle(itemRectLeft, itemRectTop, itemRectRight - itemRectLeft, itemRectBottom - itemRectTop);
    }

    public void handleMouseEvent(final int kind, final int x, final int y, final int modifiers, final long when) {
        if (kind == 0) {
            return;
        }
        if (this.fItemBounds == null) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(this.fInvoker, new Runnable(){

            @Override
            public void run() {
                Component target = null;
                Rectangle targetRect = null;
                for (int i = 0; i < ScreenMenu.this.fItemBounds.length; ++i) {
                    Rectangle testRect = ScreenMenu.this.fItemBounds[i];
                    if (testRect == null || !testRect.contains(x, y)) continue;
                    target = ScreenMenu.this.fInvoker.getMenuComponent(i);
                    targetRect = testRect;
                    break;
                }
                if (target == null && ScreenMenu.this.fLastMouseEventTarget == null) {
                    return;
                }
                if (target != ScreenMenu.this.fLastMouseEventTarget) {
                    if (ScreenMenu.this.fLastMouseEventTarget != null) {
                        LWToolkit.postEvent(new MouseEvent(ScreenMenu.this.fLastMouseEventTarget, 505, when, modifiers, x - ((ScreenMenu)ScreenMenu.this).fLastTargetRect.x, y - ((ScreenMenu)ScreenMenu.this).fLastTargetRect.y, 0, false));
                    }
                    if (target != null) {
                        LWToolkit.postEvent(new MouseEvent(target, 504, when, modifiers, x - targetRect.x, y - targetRect.y, 0, false));
                    }
                    ScreenMenu.this.fLastMouseEventTarget = target;
                    ScreenMenu.this.fLastTargetRect = targetRect;
                }
                if (target == null) {
                    return;
                }
                LWToolkit.postEvent(new MouseEvent(target, kind, when, modifiers, x - targetRect.x, y - targetRect.y, 0, false));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (this.fModelPtr == 0L) {
                MenuComponentPeer peer;
                String tooltipText;
                this.fInvoker.getPopupMenu().addContainerListener(this);
                this.fInvoker.addComponentListener(this);
                this.fPropertyListener = new ScreenMenuPropertyListener(this);
                this.fInvoker.addPropertyChangeListener(this.fPropertyListener);
                Icon icon = this.fInvoker.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                if ((tooltipText = this.fInvoker.getToolTipText()) != null) {
                    this.setToolTipText(tooltipText);
                }
                if ((peer = this.getPeer()) instanceof CMenu) {
                    CMenu menu = (CMenu)peer;
                    long nativeMenu = menu.getNativeMenu();
                    this.fModelPtr = ScreenMenu.addMenuListeners(this, nativeMenu);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            this.fItems.clear();
            if (this.fModelPtr != 0L) {
                ScreenMenu.removeMenuListeners(this.fModelPtr);
                this.fModelPtr = 0L;
                this.fInvoker.getPopupMenu().removeContainerListener(this);
                this.fInvoker.removeComponentListener(this);
                this.fInvoker.removePropertyChangeListener(this.fPropertyListener);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.addItem(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        MenuItem sm = this.fItems.remove(child);
        if (sm == null) {
            return;
        }
        this.remove(sm);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setVisible(false);
    }

    private void setVisible(boolean b) {
        MenuContainer parent = this.getParent();
        if (parent != null && parent instanceof ScreenMenu) {
            ScreenMenu sm = (ScreenMenu)parent;
            sm.setChildVisible(this.fInvoker, b);
        }
    }

    @Override
    public void setChildVisible(JMenuItem child, boolean b) {
        this.fItems.remove(child);
        this.updateItems();
    }

    @Override
    public void setAccelerator(KeyStroke ks) {
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public void setToolTipText(String text) {
        MenuComponentPeer peer = this.getPeer();
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        cmi.setToolTipText(text);
    }

    @Override
    public void setIcon(Icon i) {
        MenuComponentPeer peer = this.getPeer();
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        Image img = null;
        if (i != null && i.getIconWidth() > 0 && i.getIconHeight() > 0) {
            img = AquaIcon.getImageForIcon(i);
        }
        cmi.setImage(img);
    }

    private static int getHashCode(Component m) {
        int hashCode = m.hashCode();
        if (m instanceof JMenuItem) {
            KeyStroke ks;
            Action action;
            Icon disabledIcon;
            Icon icon;
            JMenuItem mi = (JMenuItem)m;
            String text = mi.getText();
            if (text != null) {
                hashCode ^= text.hashCode();
            }
            if ((icon = mi.getIcon()) != null) {
                hashCode ^= icon.hashCode();
            }
            if ((disabledIcon = mi.getDisabledIcon()) != null) {
                hashCode ^= disabledIcon.hashCode();
            }
            if ((action = mi.getAction()) != null) {
                hashCode ^= action.hashCode();
            }
            if ((ks = mi.getAccelerator()) != null) {
                hashCode ^= ks.hashCode();
            }
            hashCode ^= Boolean.valueOf(mi.isVisible()).hashCode();
            hashCode ^= Boolean.valueOf(mi.isEnabled()).hashCode();
            hashCode ^= Boolean.valueOf(mi.isSelected()).hashCode();
        } else if (m instanceof JSeparator) {
            hashCode ^= "-".hashCode();
        }
        return hashCode;
    }

    private void addItem(Component m) {
        if (!m.isVisible()) {
            return;
        }
        MenuItem sm = this.fItems.get(m);
        if (sm == null) {
            if (m instanceof JMenu) {
                sm = new ScreenMenu((JMenu)m);
            } else if (m instanceof JCheckBoxMenuItem) {
                sm = new ScreenMenuItemCheckbox((JCheckBoxMenuItem)m);
            } else if (m instanceof JRadioButtonMenuItem) {
                sm = new ScreenMenuItemCheckbox((JRadioButtonMenuItem)m);
            } else if (m instanceof JMenuItem) {
                sm = new ScreenMenuItem((JMenuItem)m);
            } else if (m instanceof JPopupMenu.Separator || m instanceof JSeparator) {
                sm = new MenuItem("-");
            }
            if (sm != null) {
                this.fItems.put(m, sm);
            }
        }
        if (sm != null) {
            this.add(sm);
        }
    }

    static /* synthetic */ Rectangle[] access$102(ScreenMenu x0, Rectangle[] x1) {
        x0.fItemBounds = x1;
        return x1;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
    }
}

