/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.ScreenMenu;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import sun.lwawt.macosx.CMenuBar;

public class ScreenMenuBar
extends MenuBar
implements ContainerListener,
ScreenMenuPropertyHandler,
ComponentListener {
    static boolean sJMenuBarHasHelpMenus = false;
    JMenuBar fSwingBar;
    Hashtable<JMenu, ScreenMenu> fSubmenus;
    ScreenMenuPropertyListener fPropertyListener;
    ScreenMenuPropertyListener fAccessibleListener;
    private static Field[] stolenFields = null;

    public ScreenMenuBar(JMenuBar swingBar) {
        this.fSwingBar = swingBar;
        this.fSubmenus = new Hashtable(this.fSwingBar.getMenuCount());
    }

    @Override
    public void addNotify() {
        JMenu m;
        super.addNotify();
        this.fSwingBar.addContainerListener(this);
        this.fPropertyListener = new ScreenMenuPropertyListener(this);
        this.fSwingBar.addPropertyChangeListener(this.fPropertyListener);
        this.fAccessibleListener = new ScreenMenuPropertyListener(this);
        this.fSwingBar.getAccessibleContext().addPropertyChangeListener(this.fAccessibleListener);
        int count = this.fSwingBar.getMenuCount();
        for (int i = 0; i < count; ++i) {
            m = this.fSwingBar.getMenu(i);
            if (m == null) continue;
            this.addSubmenu(m);
        }
        Enumeration<JMenu> e = this.fSubmenus.keys();
        while (e.hasMoreElements()) {
            m = e.nextElement();
            if (this.fSwingBar.getComponentIndex(m) != -1) continue;
            this.removeSubmenu(m);
        }
    }

    @Override
    public void removeNotify() {
        if (this.fSwingBar != null) {
            this.fSwingBar.removePropertyChangeListener(this.fPropertyListener);
            this.fSwingBar.getAccessibleContext().removePropertyChangeListener(this.fAccessibleListener);
            this.fSwingBar.removeContainerListener(this);
        }
        this.fPropertyListener = null;
        this.fAccessibleListener = null;
        if (this.fSubmenus != null) {
            Enumeration<JMenu> e = this.fSubmenus.keys();
            while (e.hasMoreElements()) {
                JMenu m = e.nextElement();
                m.removeComponentListener(this);
            }
        }
        super.removeNotify();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component child = e.getChild();
        if (!(child instanceof JMenu)) {
            return;
        }
        this.addSubmenu((JMenu)child);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        if (!(child instanceof JMenu)) {
            return;
        }
        this.removeSubmenu((JMenu)child);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JMenuItem)) {
            return;
        }
        this.setChildVisible((JMenuItem)source, true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JMenuItem)) {
            return;
        }
        this.setChildVisible((JMenuItem)source, false);
    }

    @Override
    public void setChildVisible(JMenuItem child, boolean b) {
        if (child instanceof JMenu) {
            if (b) {
                this.addSubmenu((JMenu)child);
            } else {
                ScreenMenu sm = this.fSubmenus.get(child);
                if (sm != null) {
                    this.remove(sm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int nitems = this.getMenuCount();
            for (int i = nitems - 1; i >= 0; --i) {
                this.remove(i);
            }
        }
    }

    @Override
    public void setIcon(Icon i) {
    }

    @Override
    public void setLabel(String s) {
    }

    @Override
    public void setEnabled(boolean b) {
        int count = this.fSwingBar.getMenuCount();
        for (int i = 0; i < count; ++i) {
            this.fSwingBar.getMenu(i).setEnabled(b);
        }
    }

    @Override
    public void setAccelerator(KeyStroke ks) {
    }

    @Override
    public void setToolTipText(String tooltip) {
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    ScreenMenu addSubmenu(JMenu m) {
        ScreenMenu sm = this.fSubmenus.get(m);
        if (sm == null) {
            sm = new ScreenMenu(m);
            m.addComponentListener(this);
            this.fSubmenus.put(m, sm);
        }
        sm.setEnabled(m.isEnabled());
        if (m.isVisible() && sm.getParent() == null) {
            int newIndex = 0;
            int currVisibleIndex = 0;
            JMenu menu = null;
            int menuCount = this.fSwingBar.getMenuCount();
            for (int i = 0; i < menuCount; ++i) {
                menu = this.fSwingBar.getMenu(i);
                if (menu == m) {
                    newIndex = currVisibleIndex;
                    break;
                }
                if (menu == null || !menu.isVisible()) continue;
                ++currVisibleIndex;
            }
            this.add(sm, newIndex);
        }
        return sm;
    }

    private void removeSubmenu(JMenu menu) {
        ScreenMenu screenMenu = this.fSubmenus.get(menu);
        if (screenMenu == null) {
            return;
        }
        menu.removeComponentListener(this);
        this.remove(screenMenu);
        this.fSubmenus.remove(menu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(Menu m, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (m.getParent() != null) {
                m.getParent().remove(m);
            }
            try {
                if (stolenFields == null) {
                    return m;
                }
                Vector menus = (Vector)stolenFields[0].get(this);
                menus.insertElementAt(m, index);
                stolenFields[1].set(m, this);
                CMenuBar peer = (CMenuBar)this.getPeer();
                if (peer == null) {
                    return m;
                }
                peer.setNextInsertionIndex(index);
                if (m.getPeer() == null) {
                    m.addNotify();
                }
                peer.setNextInsertionIndex(-1);
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace(System.err);
            }
            return m;
        }
    }

    static {
        stolenFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                try {
                    AccessibleObject[] localFields = new Field[]{MenuBar.class.getDeclaredField("menus"), MenuComponent.class.getDeclaredField("parent")};
                    AccessibleObject.setAccessible(localFields, true);
                    return localFields;
                }
                catch (NoSuchFieldException nsf) {
                    nsf.printStackTrace(System.err);
                    return null;
                }
            }
        });
    }
}

