/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuItemUI;
import com.apple.laf.ScreenMenuPropertyHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleState;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class ScreenMenuPropertyListener
implements PropertyChangeListener {
    ScreenMenuPropertyHandler fMenu;

    ScreenMenuPropertyListener(ScreenMenuPropertyHandler mc) {
        this.fMenu = mc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("enabled".equals(propertyName)) {
            this.fMenu.setEnabled((Boolean)e.getNewValue());
            return;
        }
        if ("AccessibleState".equals(propertyName)) {
            if (e.getNewValue() == AccessibleState.ENABLED || e.getOldValue() == AccessibleState.ENABLED) {
                Object newValue = e.getNewValue();
                this.fMenu.setEnabled(newValue == AccessibleState.ENABLED);
            }
            return;
        }
        if ("accelerator".equals(propertyName)) {
            this.fMenu.setAccelerator((KeyStroke)e.getNewValue());
            return;
        }
        if ("text".equals(propertyName)) {
            this.fMenu.setLabel((String)e.getNewValue());
            return;
        }
        if ("icon".equals(propertyName)) {
            this.fMenu.setIcon((Icon)e.getNewValue());
            return;
        }
        if ("ToolTipText".equals(propertyName)) {
            this.fMenu.setToolTipText((String)e.getNewValue());
            return;
        }
        if ("JMenuItem.selectedState".equals(propertyName)) {
            this.fMenu.setIndeterminate(AquaMenuItemUI.IndeterminateListener.isIndeterminate((JMenuItem)e.getSource()));
            return;
        }
    }
}

