/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import sun.awt.image.IntegerComponentRaster;

class GradientPaintContext
implements PaintContext {
    static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    static ColorModel xbgrmodel = new DirectColorModel(24, 255, 65280, 0xFF0000);
    static ColorModel cachedModel;
    static WeakReference<Raster> cached;
    double x1;
    double y1;
    double dx;
    double dy;
    boolean cyclic;
    int[] interp;
    Raster saved;
    ColorModel model;

    static synchronized Raster getCachedRaster(ColorModel cm, int w, int h) {
        Raster ras;
        if (cm == cachedModel && cached != null && (ras = (Raster)cached.get()) != null && ras.getWidth() >= w && ras.getHeight() >= h) {
            cached = null;
            return ras;
        }
        return cm.createCompatibleWritableRaster(w, h);
    }

    static synchronized void putCachedRaster(ColorModel cm, Raster ras) {
        Raster cras;
        if (cached != null && (cras = (Raster)cached.get()) != null) {
            int cw = cras.getWidth();
            int ch = cras.getHeight();
            int iw = ras.getWidth();
            int ih = ras.getHeight();
            if (cw >= iw && ch >= ih) {
                return;
            }
            if (cw * ch >= iw * ih) {
                return;
            }
        }
        cachedModel = cm;
        cached = new WeakReference<Raster>(ras);
    }

    public GradientPaintContext(ColorModel cm, Point2D p1, Point2D p2, AffineTransform xform, Color c1, Color c2, boolean cyclic) {
        Point2D.Double xvec = new Point2D.Double(1.0, 0.0);
        Point2D.Double yvec = new Point2D.Double(0.0, 1.0);
        try {
            AffineTransform inverse = xform.createInverse();
            inverse.deltaTransform(xvec, xvec);
            inverse.deltaTransform(yvec, yvec);
        }
        catch (NoninvertibleTransformException e) {
            ((Point2D)xvec).setLocation(0.0, 0.0);
            ((Point2D)yvec).setLocation(0.0, 0.0);
        }
        double udx = p2.getX() - p1.getX();
        double udy = p2.getY() - p1.getY();
        double ulenSq = udx * udx + udy * udy;
        if (ulenSq <= Double.MIN_VALUE) {
            this.dx = 0.0;
            this.dy = 0.0;
        } else {
            this.dx = (((Point2D)xvec).getX() * udx + ((Point2D)xvec).getY() * udy) / ulenSq;
            this.dy = (((Point2D)yvec).getX() * udx + ((Point2D)yvec).getY() * udy) / ulenSq;
            if (cyclic) {
                this.dx %= 1.0;
                this.dy %= 1.0;
            } else if (this.dx < 0.0) {
                Point2D p = p1;
                p1 = p2;
                p2 = p;
                Color c = c1;
                c1 = c2;
                c2 = c;
                this.dx = -this.dx;
                this.dy = -this.dy;
            }
        }
        Point2D dp1 = xform.transform(p1, null);
        this.x1 = dp1.getX();
        this.y1 = dp1.getY();
        this.cyclic = cyclic;
        int rgb1 = c1.getRGB();
        int rgb2 = c2.getRGB();
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        if (a1 == 255 && da == 0) {
            DirectColorModel dcm;
            int tmp;
            this.model = xrgbmodel;
            if (cm instanceof DirectColorModel && ((tmp = (dcm = (DirectColorModel)cm).getAlphaMask()) == 0 || tmp == 255) && dcm.getRedMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 0xFF0000) {
                this.model = xbgrmodel;
                tmp = r1;
                r1 = b1;
                b1 = tmp;
                tmp = dr;
                dr = db;
                db = tmp;
            }
        } else {
            this.model = ColorModel.getRGBdefault();
        }
        this.interp = new int[cyclic ? 513 : 257];
        for (int i = 0; i <= 256; ++i) {
            int rgb;
            float rel = (float)i / 256.0f;
            this.interp[i] = rgb = (int)((float)a1 + (float)da * rel) << 24 | (int)((float)r1 + (float)dr * rel) << 16 | (int)((float)g1 + (float)dg * rel) << 8 | (int)((float)b1 + (float)db * rel);
            if (!cyclic) continue;
            this.interp[512 - i] = rgb;
        }
    }

    @Override
    public void dispose() {
        if (this.saved != null) {
            GradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        double rowrel = ((double)x - this.x1) * this.dx + ((double)y - this.y1) * this.dy;
        Raster rast = this.saved;
        if (rast == null || rast.getWidth() < w || rast.getHeight() < h) {
            this.saved = rast = GradientPaintContext.getCachedRaster(this.model, w, h);
        }
        IntegerComponentRaster irast = (IntegerComponentRaster)rast;
        int off = irast.getDataOffset(0);
        int adjust = irast.getScanlineStride() - w;
        int[] pixels = irast.getDataStorage();
        if (this.cyclic) {
            this.cycleFillRaster(pixels, off, adjust, w, h, rowrel, this.dx, this.dy);
        } else {
            this.clipFillRaster(pixels, off, adjust, w, h, rowrel, this.dx, this.dy);
        }
        irast.markDirty();
        return rast;
    }

    void cycleFillRaster(int[] pixels, int off, int adjust, int w, int h, double rowrel, double dx, double dy) {
        int irowrel = (int)((rowrel %= 2.0) * 1.073741824E9) << 1;
        int idx = (int)(-dx * -2.147483648E9);
        int idy = (int)(-dy * -2.147483648E9);
        while (--h >= 0) {
            int icolrel = irowrel;
            for (int j = w; j > 0; --j) {
                pixels[off++] = this.interp[icolrel >>> 23];
                icolrel += idx;
            }
            off += adjust;
            irowrel += idy;
        }
    }

    void clipFillRaster(int[] pixels, int off, int adjust, int w, int h, double rowrel, double dx, double dy) {
        while (--h >= 0) {
            int rgb;
            double colrel = rowrel;
            int j = w;
            if (colrel <= 0.0) {
                rgb = this.interp[0];
                do {
                    pixels[off++] = rgb;
                } while (--j > 0 && (colrel += dx) <= 0.0);
            }
            while (colrel < 1.0 && --j >= 0) {
                pixels[off++] = this.interp[(int)(colrel * 256.0)];
                colrel += dx;
            }
            if (j > 0) {
                rgb = this.interp[256];
                do {
                    pixels[off++] = rgb;
                } while (--j > 0);
            }
            off += adjust;
            rowrel += dy;
        }
    }
}

