/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.NetworkInterface;
import java.util.Enumeration;

class DefaultInterface {
    private static final NetworkInterface defaultInterface = DefaultInterface.chooseDefaultInterface();

    DefaultInterface() {
    }

    static NetworkInterface getDefault() {
        return defaultInterface;
    }

    private static NetworkInterface chooseDefaultInterface() {
        Enumeration<NetworkInterface> nifs;
        try {
            nifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (IOException ignore) {
            return null;
        }
        NetworkInterface ppp = null;
        NetworkInterface loopback = null;
        while (nifs.hasMoreElements()) {
            NetworkInterface ni = nifs.nextElement();
            try {
                if (!ni.isUp() || !ni.supportsMulticast()) continue;
                boolean isLoopback = ni.isLoopback();
                boolean isPPP = ni.isPointToPoint();
                if (!isLoopback && !isPPP) {
                    return ni;
                }
                if (ppp == null && isPPP) {
                    ppp = ni;
                }
                if (loopback != null || !isLoopback) continue;
                loopback = ni;
            }
            catch (IOException iOException) {}
        }
        return ppp != null ? ppp : loopback;
    }
}

