/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.util.logging.PlatformLogger;

public class Attributes
implements Map<Object, Object>,
Cloneable {
    protected Map<Object, Object> map;

    public Attributes() {
        this(11);
    }

    public Attributes(int size) {
        this.map = new HashMap<Object, Object>(size);
    }

    public Attributes(Attributes attr) {
        this.map = new HashMap<Object, Object>(attr);
    }

    @Override
    public Object get(Object name) {
        return this.map.get(name);
    }

    public String getValue(String name) {
        return (String)this.get(new Name(name));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    @Override
    public Object put(Object name, Object value) {
        return this.map.put((Name)name, (String)value);
    }

    public String putValue(String name, String value) {
        return (String)this.put(new Name(name), value);
    }

    @Override
    public Object remove(Object name) {
        return this.map.remove(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object name) {
        return this.map.containsKey(name);
    }

    @Override
    public void putAll(Map<?, ?> attr) {
        if (!Attributes.class.isInstance(attr)) {
            throw new ClassCastException();
        }
        for (Map.Entry<?, ?> me : attr.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream os) throws IOException {
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            StringBuffer buffer = new StringBuffer(((Name)e.getKey()).toString());
            buffer.append(": ");
            String value = (String)e.getValue();
            if (value != null) {
                byte[] vb = value.getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
            }
            buffer.append(value);
            buffer.append("\r\n");
            Manifest.make72Safe(buffer);
            os.writeBytes(buffer.toString());
        }
        os.writeBytes("\r\n");
    }

    void writeMain(DataOutputStream out) throws IOException {
        String vername = Name.MANIFEST_VERSION.toString();
        String version = this.getValue(vername);
        if (version == null) {
            vername = Name.SIGNATURE_VERSION.toString();
            version = this.getValue(vername);
        }
        if (version != null) {
            out.writeBytes(vername + ": " + version + "\r\n");
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            String name = ((Name)e.getKey()).toString();
            if (version == null || name.equalsIgnoreCase(vername)) continue;
            StringBuffer buffer = new StringBuffer(name);
            buffer.append(": ");
            String value = (String)e.getValue();
            if (value != null) {
                byte[] vb = value.getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
            }
            buffer.append(value);
            buffer.append("\r\n");
            Manifest.make72Safe(buffer);
            out.writeBytes(buffer.toString());
        }
        out.writeBytes("\r\n");
    }

    void read(Manifest.FastInputStream is, byte[] lbuf) throws IOException {
        int len;
        String name = null;
        String value = null;
        byte[] lastline = null;
        while ((len = is.readLine(lbuf)) != -1) {
            boolean lineContinued = false;
            if (lbuf[--len] != 10) {
                throw new IOException("line too long");
            }
            if (len > 0 && lbuf[len - 1] == 13) {
                --len;
            }
            if (len == 0) break;
            int i = 0;
            if (lbuf[0] == 32) {
                if (name == null) {
                    throw new IOException("misplaced continuation line");
                }
                lineContinued = true;
                byte[] buf = new byte[lastline.length + len - 1];
                System.arraycopy(lastline, 0, buf, 0, lastline.length);
                System.arraycopy(lbuf, 1, buf, lastline.length, len - 1);
                if (is.peek() == 32) {
                    lastline = buf;
                    continue;
                }
                value = new String(buf, 0, buf.length, "UTF8");
                lastline = null;
            } else {
                while (lbuf[i++] != 58) {
                    if (i < len) continue;
                    throw new IOException("invalid header field");
                }
                if (lbuf[i++] != 32) {
                    throw new IOException("invalid header field");
                }
                name = new String(lbuf, 0, 0, i - 2);
                if (is.peek() == 32) {
                    lastline = new byte[len - i];
                    System.arraycopy(lbuf, i, lastline, 0, len - i);
                    continue;
                }
                value = new String(lbuf, i, len - i, "UTF8");
            }
            try {
                if (this.putValue(name, value) == null || lineContinued) continue;
                PlatformLogger.getLogger("java.util.jar").warning("Duplicate name in Manifest: " + name + ".\nEnsure that the manifest does not have duplicate entries, and\nthat blank lines separate individual sections in both your\nmanifest and in the META-INF/MANIFEST.MF entry in the jar file.");
            }
            catch (IllegalArgumentException e) {
                throw new IOException("invalid header field name: " + name);
            }
        }
    }

    public static class Name {
        private String name;
        private int hashCode = -1;
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name SEALED = new Name("Sealed");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        @Deprecated
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        @Deprecated
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        @Deprecated
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-URL");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");

        public Name(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (!Name.isValid(name)) {
                throw new IllegalArgumentException(name);
            }
            this.name = name.intern();
        }

        private static boolean isValid(String name) {
            int len = name.length();
            if (len > 70 || len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (Name.isValid(name.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isValid(char c) {
            return Name.isAlpha(c) || Name.isDigit(c) || c == '_' || c == '-';
        }

        private static boolean isAlpha(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        public boolean equals(Object o) {
            if (o instanceof Name) {
                Comparator<String> c = ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER;
                return c.compare(this.name, ((Name)o).name) == 0;
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = ASCIICaseInsensitiveComparator.lowerCaseHashCode(this.name);
            }
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

