/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.util.Objects;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.MacOSXPreferencesFile;
import java.util.prefs.Preferences;

class MacOSXPreferences
extends AbstractPreferences {
    private static final String defaultAppName = "com.apple.java.util.prefs";
    private final boolean isUser;
    private final boolean isRoot;
    private final MacOSXPreferencesFile file;
    private final String path;
    private static volatile MacOSXPreferences userRoot;
    private static volatile MacOSXPreferences systemRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Preferences getUserRoot() {
        MacOSXPreferences root = userRoot;
        if (root != null) return root;
        Class<MacOSXPreferences> clazz = MacOSXPreferences.class;
        synchronized (MacOSXPreferences.class) {
            root = userRoot;
            if (root != null) return root;
            userRoot = root = new MacOSXPreferences(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Preferences getSystemRoot() {
        MacOSXPreferences root = systemRoot;
        if (root != null) return root;
        Class<MacOSXPreferences> clazz = MacOSXPreferences.class;
        synchronized (MacOSXPreferences.class) {
            root = systemRoot;
            if (root != null) return root;
            systemRoot = root = new MacOSXPreferences(false);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return root;
        }
    }

    private MacOSXPreferences(boolean newIsUser) {
        this(null, "", false, true, newIsUser);
    }

    private MacOSXPreferences(MacOSXPreferences parent, String name) {
        this(parent, name, false, false, false);
    }

    private MacOSXPreferences(MacOSXPreferences parent, String name, boolean isNew) {
        this(parent, name, isNew, false, false);
    }

    private MacOSXPreferences(MacOSXPreferences parent, String name, boolean isNew, boolean isRoot, boolean isUser) {
        super(parent, name);
        this.isRoot = isRoot;
        this.isUser = isRoot ? isUser : this.isUserNode();
        this.path = isRoot ? this.absolutePath() : this.absolutePath() + "/";
        this.file = this.cfFileForNode(this.isUser);
        this.newNode = isNew ? isNew : this.file.addNode(this.path);
    }

    private MacOSXPreferencesFile cfFileForNode(boolean isUser) {
        String name = this.path;
        boolean componentCount = false;
        int pos = -1;
        for (int i = 0; i < 4 && (pos = name.indexOf(47, pos + 1)) != -1; ++i) {
        }
        if (pos == -1) {
            name = defaultAppName;
        } else {
            name = name.substring(1, pos);
            name = name.replace('/', '.');
            name = name.toLowerCase();
        }
        return MacOSXPreferencesFile.getFile(name, isUser);
    }

    @Override
    protected void putSpi(String key, String value) {
        this.file.addKeyToNode(this.path, key, value);
    }

    @Override
    protected String getSpi(String key) {
        return this.file.getKeyFromNode(this.path, key);
    }

    @Override
    protected void removeSpi(String key) {
        Objects.requireNonNull(key, "Specified key cannot be null");
        this.file.removeKeyFromNode(this.path, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            ((MacOSXPreferences)this.parent()).removeChild(this.name());
            this.file.removeNode(this.path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void removeChild(String child) {
        this.file.removeChildFromNode(this.path, child);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        String[] result = this.file.getChildrenForNode(this.path);
        if (result == null) {
            throw new BackingStoreException("Couldn't get list of children for node '" + this.path + "'");
        }
        return result;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        String[] result = this.file.getKeysForNode(this.path);
        if (result == null) {
            throw new BackingStoreException("Couldn't get list of keys for node '" + this.path + "'");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPreferences childSpi(String name) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            boolean isNew = this.file.addChildToNode(this.path, name);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new MacOSXPreferences(this, name, isNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isUser ? !MacOSXPreferencesFile.flushUser() : !MacOSXPreferencesFile.flushWorld()) {
                throw new BackingStoreException("Synchronization failed for node '" + this.path + "'");
            }
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node has been removed");
            }
            if (this.isUser ? !MacOSXPreferencesFile.syncUser() : !MacOSXPreferencesFile.syncWorld()) {
                throw new BackingStoreException("Synchronization failed for node '" + this.path + "'");
            }
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

