/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

class MacOSXPreferencesFile {
    private static HashMap<String, WeakReference<MacOSXPreferencesFile>> cachedFiles;
    private static HashSet<MacOSXPreferencesFile> changedFiles;
    private static Timer timer;
    private static FlushTask flushTimerTask;
    private static long flushDelay;
    private static long syncInterval;
    private String appName;
    private long user;
    private long host;
    private static long cfCurrentUser;
    private static long cfAnyUser;
    private static long cfCurrentHost;
    private static long cfAnyHost;

    String name() {
        return this.appName;
    }

    long user() {
        return this.user;
    }

    long host() {
        return this.host;
    }

    private MacOSXPreferencesFile(String newName, long newUser, long newHost) {
        this.appName = newName;
        this.user = newUser;
        this.host = newHost;
    }

    static synchronized MacOSXPreferencesFile getFile(String newName, boolean isUser) {
        String hashkey;
        WeakReference<MacOSXPreferencesFile> hashvalue;
        MacOSXPreferencesFile result = null;
        if (cachedFiles == null) {
            cachedFiles = new HashMap();
        }
        if ((hashvalue = cachedFiles.get(hashkey = newName + String.valueOf(isUser))) != null) {
            result = (MacOSXPreferencesFile)hashvalue.get();
        }
        if (result == null) {
            result = new MacOSXPreferencesFile(newName, isUser ? cfCurrentUser : cfAnyUser, isUser ? cfAnyHost : cfCurrentHost);
            cachedFiles.put(hashkey, new WeakReference<MacOSXPreferencesFile>(result));
        }
        MacOSXPreferencesFile.initSyncTimerIfNeeded();
        return result;
    }

    static synchronized boolean syncWorld() {
        boolean ok = true;
        if (cachedFiles != null && !cachedFiles.isEmpty()) {
            Iterator<WeakReference<MacOSXPreferencesFile>> iter = cachedFiles.values().iterator();
            while (iter.hasNext()) {
                WeakReference<MacOSXPreferencesFile> ref = iter.next();
                MacOSXPreferencesFile f = (MacOSXPreferencesFile)ref.get();
                if (f != null) {
                    if (f.synchronize()) continue;
                    ok = false;
                    continue;
                }
                iter.remove();
            }
        }
        if (flushTimerTask != null) {
            flushTimerTask.cancel();
            flushTimerTask = null;
        }
        if (changedFiles != null) {
            changedFiles.clear();
        }
        return ok;
    }

    static synchronized boolean syncUser() {
        boolean ok = true;
        if (cachedFiles != null && !cachedFiles.isEmpty()) {
            Iterator<WeakReference<MacOSXPreferencesFile>> iter = cachedFiles.values().iterator();
            while (iter.hasNext()) {
                WeakReference<MacOSXPreferencesFile> ref = iter.next();
                MacOSXPreferencesFile f = (MacOSXPreferencesFile)ref.get();
                if (f != null && f.user == cfCurrentUser) {
                    if (f.synchronize()) continue;
                    ok = false;
                    continue;
                }
                iter.remove();
            }
        }
        if (changedFiles != null) {
            Iterator<MacOSXPreferencesFile> iterChanged = changedFiles.iterator();
            while (iterChanged.hasNext()) {
                MacOSXPreferencesFile f = iterChanged.next();
                if (f == null || f.user != cfCurrentUser) continue;
                iterChanged.remove();
            }
        }
        return ok;
    }

    static synchronized boolean flushUser() {
        boolean ok = true;
        if (changedFiles != null && !changedFiles.isEmpty()) {
            Iterator<MacOSXPreferencesFile> iterator = changedFiles.iterator();
            while (iterator.hasNext()) {
                MacOSXPreferencesFile f = iterator.next();
                if (f.user != cfCurrentUser) continue;
                if (!f.synchronize()) {
                    ok = false;
                    continue;
                }
                iterator.remove();
            }
        }
        return ok;
    }

    static synchronized boolean flushWorld() {
        boolean ok = true;
        if (changedFiles != null && !changedFiles.isEmpty()) {
            for (MacOSXPreferencesFile f : changedFiles) {
                if (f.synchronize()) continue;
                ok = false;
            }
            changedFiles.clear();
        }
        if (flushTimerTask != null) {
            flushTimerTask.cancel();
            flushTimerTask = null;
        }
        return ok;
    }

    private void markChanged() {
        if (changedFiles == null) {
            changedFiles = new HashSet();
        }
        changedFiles.add(this);
        if (flushTimerTask == null) {
            flushTimerTask = new FlushTask();
            MacOSXPreferencesFile.timer().schedule((TimerTask)flushTimerTask, MacOSXPreferencesFile.flushDelay() * 1000L);
        }
    }

    private static synchronized long flushDelay() {
        if (flushDelay == -1L) {
            try {
                flushDelay = Math.max(5, Integer.parseInt(System.getProperty("java.util.prefs.flushDelay", "60")));
            }
            catch (NumberFormatException e) {
                flushDelay = 60L;
            }
        }
        return flushDelay;
    }

    private static synchronized void initSyncTimerIfNeeded() {
        if (syncInterval == -1L) {
            try {
                syncInterval = Integer.parseInt(System.getProperty("java.util.prefs.syncInterval", "-2"));
                syncInterval = syncInterval >= 0L ? Math.max(5L, syncInterval) : -2L;
            }
            catch (NumberFormatException e) {
                syncInterval = -2L;
            }
            if (syncInterval > 0L) {
                MacOSXPreferencesFile.timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MacOSXPreferencesFile.syncWorld();
                    }
                }, syncInterval * 1000L, syncInterval * 1000L);
            }
        }
    }

    private static synchronized Timer timer() {
        if (timer == null) {
            timer = new Timer(true);
            Thread flushThread = new Thread(){

                @Override
                public void run() {
                    MacOSXPreferencesFile.flushWorld();
                }
            };
            flushThread.setContextClassLoader(null);
            Runtime.getRuntime().addShutdownHook(flushThread);
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addNode(String path) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.addNode(path, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(String path) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeNode(path, this.appName, this.user, this.host);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addChildToNode(String path, String child) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MacOSXPreferencesFile.addChildToNode(path, child + "/", this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildFromNode(String path, String child) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeChildFromNode(path, child + "/", this.appName, this.user, this.host);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKeyToNode(String path, String key, String value) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.addKeyToNode(path, key, value, this.appName, this.user, this.host);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKeyFromNode(String path, String key) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            this.markChanged();
            MacOSXPreferencesFile.removeKeyFromNode(path, key, this.appName, this.user, this.host);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getKeyFromNode(String path, String key) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MacOSXPreferencesFile.getKeyFromNode(path, key, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getChildrenForNode(String path) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.getChildrenForNode(path, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getKeysForNode(String path) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return MacOSXPreferencesFile.getKeysForNode(path, this.appName, this.user, this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean synchronize() {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MacOSXPreferencesFile.synchronize(this.appName, this.user, this.host);
        }
    }

    private static final native boolean addNode(String var0, String var1, long var2, long var4);

    private static final native void removeNode(String var0, String var1, long var2, long var4);

    private static final native boolean addChildToNode(String var0, String var1, String var2, long var3, long var5);

    private static final native void removeChildFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native void addKeyToNode(String var0, String var1, String var2, String var3, long var4, long var6);

    private static final native void removeKeyFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native String getKeyFromNode(String var0, String var1, String var2, long var3, long var5);

    private static final native String[] getChildrenForNode(String var0, String var1, long var2, long var4);

    private static final native String[] getKeysForNode(String var0, String var1, long var2, long var4);

    private static final native boolean synchronize(String var0, long var1, long var3);

    private static final native long currentUser();

    private static final native long anyUser();

    private static final native long currentHost();

    private static final native long anyHost();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osx");
                return null;
            }
        });
        timer = null;
        flushTimerTask = null;
        flushDelay = -1L;
        syncInterval = -1L;
        cfCurrentUser = MacOSXPreferencesFile.currentUser();
        cfAnyUser = MacOSXPreferencesFile.anyUser();
        cfCurrentHost = MacOSXPreferencesFile.currentHost();
        cfAnyHost = MacOSXPreferencesFile.anyHost();
    }

    private class SyncTask
    extends TimerTask {
        private SyncTask() {
        }

        @Override
        public void run() {
            MacOSXPreferencesFile.syncWorld();
        }
    }

    private class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            MacOSXPreferencesFile.flushWorld();
        }
    }
}

