/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import sun.awt.CGraphicsDevice;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWGraphicsConfig;
import sun.lwawt.macosx.CPlatformView;

public abstract class CGraphicsConfig
extends GraphicsConfiguration
implements LWGraphicsConfig {
    private final CGraphicsDevice device;
    private ColorModel colorModel;

    protected CGraphicsConfig(CGraphicsDevice device) {
        this.device = device;
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static native Rectangle2D nativeGetBounds(int var0);

    @Override
    public Rectangle getBounds() {
        Rectangle2D nativeBounds = CGraphicsConfig.nativeGetBounds(this.device.getCGDisplayID());
        return nativeBounds.getBounds();
    }

    @Override
    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.getColorModel(1);
        }
        return this.colorModel;
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    public CGraphicsDevice getDevice() {
        return this.device;
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        double xscale = this.device.getXResolution() / 72.0;
        double yscale = this.device.getYResolution() / 72.0;
        return new AffineTransform(xscale, 0.0, 0.0, yscale, 0.0, 0.0);
    }

    public abstract SurfaceData createSurfaceData(CPlatformView var1);

    public abstract SurfaceData createSurfaceData(CGLLayer var1);

    @Override
    public final boolean isTranslucencyCapable() {
        return true;
    }
}

