/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Window;
import java.util.Objects;
import sun.awt.DisplayChangedListener;
import sun.awt.FullScreenCapable;
import sun.java2d.opengl.CGLGraphicsConfig;

public final class CGraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    private volatile int displayID;
    private volatile double xResolution;
    private volatile double yResolution;
    private volatile int scale;
    private final GraphicsConfiguration[] configs;
    private final int DEFAULT_CONFIG = 0;
    private static AWTPermission fullScreenExclusivePermission;
    private DisplayMode originalMode;

    public CGraphicsDevice(int displayID) {
        this.displayID = displayID;
        this.configs = new GraphicsConfiguration[]{CGLGraphicsConfig.getConfig(this, 0)};
    }

    public int getCGDisplayID() {
        return this.displayID;
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configs.clone();
    }

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configs[0];
    }

    @Override
    public String getIDstring() {
        return "Display " + this.displayID;
    }

    @Override
    public int getType() {
        return 0;
    }

    public double getXResolution() {
        return this.xResolution;
    }

    public double getYResolution() {
        return this.yResolution;
    }

    public Insets getScreenInsets() {
        return CGraphicsDevice.nativeGetScreenInsets(this.displayID);
    }

    public int getScaleFactor() {
        return this.scale;
    }

    public void invalidate(int defaultDisplayID) {
        this.displayID = defaultDisplayID;
    }

    @Override
    public void displayChanged() {
        this.xResolution = CGraphicsDevice.nativeGetXResolution(this.displayID);
        this.yResolution = CGraphicsDevice.nativeGetYResolution(this.displayID);
        this.scale = (int)CGraphicsDevice.nativeGetScaleFactor(this.displayID);
    }

    @Override
    public void paletteChanged() {
    }

    @Override
    public synchronized void setFullScreenWindow(Window w) {
        Window old = this.getFullScreenWindow();
        if (w == old) {
            return;
        }
        boolean fsSupported = this.isFullScreenSupported();
        if (fsSupported && old != null) {
            CGraphicsDevice.exitFullScreenExclusive(old);
            if (this.originalMode != null) {
                this.setDisplayMode(this.originalMode);
                this.originalMode = null;
            }
        }
        super.setFullScreenWindow(w);
        if (fsSupported && w != null) {
            if (this.isDisplayChangeSupported()) {
                this.originalMode = this.getDisplayMode();
            }
            CGraphicsDevice.enterFullScreenExclusive(w);
        }
    }

    @Override
    public boolean isFullScreenSupported() {
        return CGraphicsDevice.isFSExclusiveModeAllowed();
    }

    private static boolean isFSExclusiveModeAllowed() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                security.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    private static void enterFullScreenExclusive(Window w) {
        FullScreenCapable peer = (FullScreenCapable)((Object)w.getPeer());
        if (peer != null) {
            peer.enterFullScreenMode();
        }
    }

    private static void exitFullScreenExclusive(Window w) {
        FullScreenCapable peer = (FullScreenCapable)((Object)w.getPeer());
        if (peer != null) {
            peer.exitFullScreenMode();
        }
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return true;
    }

    @Override
    public void setDisplayMode(DisplayMode dm) {
        if (dm == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (!Objects.equals(dm, this.getDisplayMode())) {
            CGraphicsDevice.nativeSetDisplayMode(this.displayID, dm.getWidth(), dm.getHeight(), dm.getBitDepth(), dm.getRefreshRate());
            if (this.isFullScreenSupported() && this.getFullScreenWindow() != null) {
                this.getFullScreenWindow().setSize(dm.getWidth(), dm.getHeight());
            }
        }
    }

    @Override
    public DisplayMode getDisplayMode() {
        return CGraphicsDevice.nativeGetDisplayMode(this.displayID);
    }

    @Override
    public DisplayMode[] getDisplayModes() {
        return CGraphicsDevice.nativeGetDisplayModes(this.displayID);
    }

    private static native double nativeGetScaleFactor(int var0);

    private static native void nativeSetDisplayMode(int var0, int var1, int var2, int var3, int var4);

    private static native DisplayMode nativeGetDisplayMode(int var0);

    private static native DisplayMode[] nativeGetDisplayModes(int var0);

    private static native double nativeGetXResolution(int var0);

    private static native double nativeGetYResolution(int var0);

    private static native Insets nativeGetScreenInsets(int var0);
}

