/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTError;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.awt.CGraphicsDevice;
import sun.java2d.MacosxSurfaceManagerFactory;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceManagerFactory;

public final class CGraphicsEnvironment
extends SunGraphicsEnvironment {
    private final Map<Integer, CGraphicsDevice> devices = new HashMap<Integer, CGraphicsDevice>(5);
    private final long displayReconfigContext;
    static String[] sLogicalFonts;

    private static native void initCocoa();

    private static native int[] getDisplayIDs();

    private static native int getMainDisplayID();

    public static void init() {
    }

    private native long registerDisplayReconfiguration();

    private native void deregisterDisplayReconfiguration(long var1);

    public CGraphicsEnvironment() {
        if (CGraphicsEnvironment.isHeadless()) {
            this.displayReconfigContext = 0L;
            return;
        }
        this.initDevices();
        this.displayReconfigContext = this.registerDisplayReconfiguration();
        if (this.displayReconfigContext == 0L) {
            throw new RuntimeException("Could not register CoreGraphics display reconfiguration callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _displayReconfiguration(int displayId, boolean removed) {
        CGraphicsEnvironment cGraphicsEnvironment = this;
        synchronized (cGraphicsEnvironment) {
            if (removed && this.devices.containsKey(displayId)) {
                CGraphicsDevice gd = this.devices.remove(displayId);
                gd.invalidate(CGraphicsEnvironment.getMainDisplayID());
                gd.displayChanged();
            }
        }
        this.initDevices();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.deregisterDisplayReconfiguration(this.displayReconfigContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDevices() {
        CGraphicsEnvironment cGraphicsEnvironment = this;
        synchronized (cGraphicsEnvironment) {
            HashMap<Integer, CGraphicsDevice> old = new HashMap<Integer, CGraphicsDevice>(this.devices);
            this.devices.clear();
            int mainID = CGraphicsEnvironment.getMainDisplayID();
            if (!old.containsKey(mainID)) {
                old.put(mainID, new CGraphicsDevice(mainID));
            }
            for (int id : CGraphicsEnvironment.getDisplayIDs()) {
                this.devices.put(id, old.containsKey(id) ? (CGraphicsDevice)old.get(id) : new CGraphicsDevice(id));
            }
        }
        this.displayChanged();
    }

    @Override
    public synchronized GraphicsDevice getDefaultScreenDevice() throws HeadlessException {
        int mainDisplayID = CGraphicsEnvironment.getMainDisplayID();
        CGraphicsDevice d = this.devices.get(mainDisplayID);
        if (d == null) {
            this.initDevices();
            d = this.devices.get(mainDisplayID);
            if (d == null) {
                throw new AWTError("no screen devices");
            }
        }
        return d;
    }

    @Override
    public synchronized GraphicsDevice[] getScreenDevices() throws HeadlessException {
        return this.devices.values().toArray(new CGraphicsDevice[this.devices.values().size()]);
    }

    public synchronized GraphicsDevice getScreenDevice(int displayID) {
        return this.devices.get(displayID);
    }

    @Override
    protected synchronized int getNumScreens() {
        return this.devices.size();
    }

    @Override
    protected GraphicsDevice makeScreenDevice(int screennum) {
        throw new UnsupportedOperationException("This method is unused and should not be called in this implementation");
    }

    @Override
    public boolean isDisplayLocal() {
        return true;
    }

    @Override
    public Font[] getAllFonts() {
        Font[] superFonts = super.getAllFonts();
        int numLogical = sLogicalFonts.length;
        int numOtherFonts = superFonts.length;
        Font[] newFonts = new Font[numOtherFonts + numLogical];
        System.arraycopy(superFonts, 0, newFonts, numLogical, numOtherFonts);
        for (int i = 0; i < numLogical; ++i) {
            newFonts[i] = new Font(sLogicalFonts[i], 0, 1);
        }
        return newFonts;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("awt");
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (GraphicsEnvironment.isHeadless()) {
                    return null;
                }
                CGraphicsEnvironment.initCocoa();
                return null;
            }
        });
        SurfaceManagerFactory.setInstance(new MacosxSurfaceManagerFactory());
        sLogicalFonts = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    }
}

