/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import sun.font.CFont;
import sun.font.CharToGlyphMapper;
import sun.font.FontUtilities;

public class CCharToGlyphMapper
extends CharToGlyphMapper {
    private Cache cache = new Cache();
    CFont fFont;
    int numGlyphs = -1;

    private static native int countGlyphs(long var0);

    public CCharToGlyphMapper(CFont font) {
        this.fFont = font;
        this.missingGlyph = 0;
    }

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = CCharToGlyphMapper.countGlyphs(this.fFont.getNativeFontPtr());
        }
        return this.numGlyphs;
    }

    @Override
    public boolean canDisplay(char ch) {
        int glyph = this.charToGlyph(ch);
        return glyph != this.missingGlyph;
    }

    @Override
    public boolean canDisplay(int cp) {
        int glyph = this.charToGlyph(cp);
        return glyph != this.missingGlyph;
    }

    @Override
    public synchronized boolean charsToGlyphsNS(int count, char[] unicodes, int[] glyphs) {
        this.charsToGlyphs(count, unicodes, glyphs);
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i + 1] = 65535;
            }
            if (code < 768) continue;
            if (FontUtilities.isComplexCharCode(code)) {
                return true;
            }
            if (code < 65536) continue;
            ++i;
        }
        return false;
    }

    @Override
    public synchronized int charToGlyph(char unicode) {
        int glyph = this.cache.get(unicode);
        if (glyph != 0) {
            return glyph;
        }
        char[] unicodeArray = new char[]{unicode};
        int[] glyphArray = new int[1];
        CCharToGlyphMapper.nativeCharsToGlyphs(this.fFont.getNativeFontPtr(), 1, unicodeArray, glyphArray);
        this.cache.put(unicode, glyphArray[0]);
        return glyphArray[0];
    }

    @Override
    public synchronized int charToGlyph(int unicode) {
        if (unicode >= 65536) {
            int[] glyphs = new int[2];
            char[] surrogates = new char[2];
            int base = unicode - 65536;
            surrogates[0] = (char)((base >>> 10) + 55296);
            surrogates[1] = (char)(base % 1024 + 56320);
            this.charsToGlyphs(2, surrogates, glyphs);
            return glyphs[0];
        }
        return this.charToGlyph((char)unicode);
    }

    @Override
    public synchronized void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        this.cache.get(count, unicodes, glyphs);
    }

    @Override
    public synchronized void charsToGlyphs(int count, int[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            glyphs[i] = this.charToGlyph(unicodes[i]);
        }
    }

    private static native void nativeCharsToGlyphs(long var0, int var2, char[] var3, int[] var4);

    private class Cache {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final int[] firstLayerCache = new int[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Integer> generalCache;

        Cache() {
            this.firstLayerCache[1] = 1;
        }

        public synchronized int get(int index) {
            if (index < 256) {
                return this.firstLayerCache[index];
            }
            if (index < 16384) {
                if (this.secondLayerCache == null) {
                    return 0;
                }
                return this.secondLayerCache.get(index);
            }
            if (this.generalCache == null) {
                return 0;
            }
            Integer value = this.generalCache.get(index);
            if (value == null) {
                return 0;
            }
            return value;
        }

        public synchronized void put(int index, int value) {
            if (index < 256) {
                this.firstLayerCache[index] = value;
                return;
            }
            if (index < 16384) {
                if (this.secondLayerCache == null) {
                    this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                }
                this.secondLayerCache.put(index, value);
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(index, value);
        }

        public synchronized void get(int count, char[] indicies, int[] values) {
            int missed = 0;
            char[] unmappedChars = null;
            int[] unmappedCharIndices = null;
            for (int i = 0; i < count; ++i) {
                int value;
                char low;
                int code = indicies[i];
                if (code >= 55296 && code <= 56319 && i < count - 1 && (low = indicies[i + 1]) >= '\udc00' && low <= '\udfff') {
                    code = (code - 55296) * 1024 + low - 56320 + 65536;
                }
                if ((value = this.get(code)) != 0 && value != -1) {
                    values[i] = value;
                    if (code < 65536) continue;
                    values[i + 1] = 65535;
                    ++i;
                    continue;
                }
                values[i] = 0;
                this.put(code, -1);
                if (unmappedChars == null) {
                    unmappedChars = new char[indicies.length];
                    unmappedCharIndices = new int[indicies.length];
                }
                unmappedChars[missed] = indicies[i];
                unmappedCharIndices[missed] = i++;
                if (code >= 65536) {
                    unmappedChars[++missed] = indicies[i];
                }
                ++missed;
            }
            if (missed == 0) {
                return;
            }
            int[] glyphCodes = new int[missed];
            CCharToGlyphMapper.nativeCharsToGlyphs(CCharToGlyphMapper.this.fFont.getNativeFontPtr(), missed, unmappedChars, glyphCodes);
            for (int m = 0; m < missed; ++m) {
                char low;
                void i = unmappedCharIndices[m];
                void code = unmappedChars[m];
                if (code >= 55296 && code <= 56319 && m < missed - 1 && (low = indicies[m + 1]) >= '\udc00' && low <= '\udfff') {
                    code = (code - 55296) * 1024 + low - 56320 + 65536;
                }
                values[i] = glyphCodes[m];
                this.put((int)code, values[i]);
                if (code < 65536) continue;
                ++m;
                values[i + true] = 65535;
            }
        }

        private class SparseBitShiftingTwoLayerArray {
            final int[][] cache;
            final int shift;
            final int secondLayerLength;

            public SparseBitShiftingTwoLayerArray(int size, int shift) {
                this.shift = shift;
                this.cache = new int[1 << shift][];
                this.secondLayerLength = size >> shift;
            }

            public int get(int index) {
                int firstIndex = index >> this.shift;
                int[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    return 0;
                }
                return firstLayerRow[index - firstIndex * (1 << this.shift)];
            }

            public void put(int index, int value) {
                int firstIndex = index >> this.shift;
                int[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    firstLayerRow = new int[this.secondLayerLength];
                    this.cache[firstIndex] = firstLayerRow;
                }
                firstLayerRow[index - firstIndex * (1 << this.shift)] = value;
            }
        }
    }
}

