/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.CompositeFont;
import sun.font.CompositeGlyphMapper;
import sun.font.FontUtilities;

public final class CCompositeGlyphMapper
extends CompositeGlyphMapper {
    private CompositeFont font;
    private CharToGlyphMapper[] slotMappers;

    public CCompositeGlyphMapper(CompositeFont compFont) {
        super(compFont);
        this.font = compFont;
        this.slotMappers = new CharToGlyphMapper[this.font.numSlots];
        this.missingGlyph = 0;
    }

    private CharToGlyphMapper getSlotMapper(int slot) {
        CharToGlyphMapper mapper = this.slotMappers[slot];
        if (mapper == null) {
            this.slotMappers[slot] = mapper = this.font.getSlotFont(slot).getMapper();
        }
        return mapper;
    }

    @Override
    public boolean canDisplay(char ch) {
        int glyph = this.charToGlyph(ch);
        return glyph != this.missingGlyph;
    }

    private int convertToGlyph(int unicode) {
        for (int slot = 0; slot < this.font.numSlots; ++slot) {
            CharToGlyphMapper mapper = this.getSlotMapper(slot);
            int glyphCode = mapper.charToGlyph(unicode);
            if (glyphCode <= 0) continue;
            glyphCode = this.compositeGlyphCode(slot, glyphCode);
            return glyphCode;
        }
        return this.missingGlyph;
    }

    @Override
    public int getNumGlyphs() {
        int numGlyphs = 0;
        for (int slot = 0; slot < 1; ++slot) {
            CharToGlyphMapper mapper = this.slotMappers[slot];
            if (mapper == null) {
                this.slotMappers[slot] = mapper = this.font.getSlotFont(slot).getMapper();
            }
            numGlyphs += mapper.getNumGlyphs();
        }
        return numGlyphs;
    }

    @Override
    public int charToGlyph(int unicode) {
        return this.convertToGlyph(unicode);
    }

    @Override
    public int charToGlyph(char unicode) {
        return this.convertToGlyph(unicode);
    }

    @Override
    public boolean charsToGlyphsNS(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i + 1] = 65535;
            }
            glyphs[i] = this.convertToGlyph(code);
            if (code < 768) continue;
            if (FontUtilities.isComplexCharCode(code)) {
                return true;
            }
            if (code < 65536) continue;
            ++i;
        }
        return false;
    }

    @Override
    public void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i] = this.convertToGlyph(code);
                glyphs[++i] = 65535;
                continue;
            }
            glyphs[i] = this.convertToGlyph(code);
        }
    }

    @Override
    public void charsToGlyphs(int count, int[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            glyphs[i] = this.convertToGlyph(unicodes[i]);
        }
    }
}

