/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;
import sun.awt.FontConfiguration;
import sun.awt.HeadlessToolkit;
import sun.font.CFont;
import sun.font.CFontConfiguration;
import sun.font.CreatedFontTracker;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.FontConfigManager;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.lwawt.macosx.LWCToolkit;
import sun.misc.ThreadGroupUtils;

public final class CFontManager
extends SunFontManager {
    private FontConfigManager fcManager = null;
    private static Hashtable<String, Font2D> genericFonts = new Hashtable();
    Object waitForFontsToBeLoaded = new Object();
    private boolean loadedAllFonts = false;

    @Override
    protected FontConfiguration createFontConfiguration() {
        CFontConfiguration fc = new CFontConfiguration(this);
        fc.init();
        return fc;
    }

    @Override
    public FontConfiguration createFontConfiguration(boolean preferLocaleFonts, boolean preferPropFonts) {
        return new CFontConfiguration(this, preferLocaleFonts, preferPropFonts);
    }

    @Override
    protected String[] getDefaultPlatformFont() {
        return new String[]{"Lucida Grande", "/System/Library/Fonts/LucidaGrande.ttc"};
    }

    public static Font2D[] getGenericFonts() {
        return genericFonts.values().toArray(new Font2D[0]);
    }

    public Font2D registerGenericFont(Font2D f) {
        return this.registerGenericFont(f, false);
    }

    public Font2D registerGenericFont(Font2D f, boolean logicalFont) {
        int rank = 4;
        String fontName = f.fullName;
        String familyName = f.familyName;
        if (fontName == null || "".equals(fontName)) {
            return null;
        }
        if (logicalFont || !genericFonts.containsKey(fontName)) {
            FontFamily family;
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().info("Add to Family " + familyName + ", Font " + fontName + " rank=" + rank);
            }
            if ((family = FontFamily.getFamily(familyName)) == null) {
                family = new FontFamily(familyName, false, rank);
                family.setFont(f, f.style);
            } else if (family.getRank() >= rank) {
                family.setFont(f, f.style);
            }
            if (!logicalFont) {
                genericFonts.put(fontName, f);
                this.fullNameToFont.put(fontName.toLowerCase(Locale.ENGLISH), f);
            }
            return f;
        }
        return genericFonts.get(fontName);
    }

    @Override
    public Font2D[] getRegisteredFonts() {
        Font2D[] regFonts = super.getRegisteredFonts();
        Font2D[] genericFonts = CFontManager.getGenericFonts();
        Font2D[] allFonts = new Font2D[regFonts.length + genericFonts.length];
        System.arraycopy(regFonts, 0, allFonts, 0, regFonts.length);
        System.arraycopy(genericFonts, 0, allFonts, regFonts.length, genericFonts.length);
        return allFonts;
    }

    @Override
    protected void addNativeFontFamilyNames(TreeMap<String, String> familyNames, Locale requestedLocale) {
        Font2D[] genericfonts = CFontManager.getGenericFonts();
        for (int i = 0; i < genericfonts.length; ++i) {
            if (genericfonts[i] instanceof NativeFont) continue;
            String name = genericfonts[i].getFamilyName(requestedLocale);
            familyNames.put(name.toLowerCase(requestedLocale), name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Font2D createFont2D(File fontFile, int fontFormat, boolean isCopy, CreatedFontTracker tracker) throws FontFormatException {
        String fontFilePath = fontFile.getPath();
        FileFont font2D = null;
        final File fFile = fontFile;
        final CreatedFontTracker _tracker = tracker;
        try {
            switch (fontFormat) {
                case 0: {
                    font2D = new TrueTypeFont(fontFilePath, null, 0, true);
                    break;
                }
                case 1: {
                    font2D = new Type1Font(fontFilePath, null, isCopy);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException e) {
            if (!isCopy) throw e;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (_tracker != null) {
                        _tracker.subBytes((int)fFile.length());
                    }
                    fFile.delete();
                    return null;
                }
            });
            throw e;
        }
        if (!isCopy) return font2D;
        FileFont.setFileToRemove(font2D, fontFile, tracker);
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (this.tmpFontFiles == null) {
                this.tmpFontFiles = new Vector();
            }
            this.tmpFontFiles.add(fontFile);
            if (this.fileCloser != null) return font2D;
            Runnable fileCloserRunnable = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            for (int i = 0; i < 20; ++i) {
                                if (CFontManager.this.fontFileCache[i] == null) continue;
                                try {
                                    CFontManager.this.fontFileCache[i].close();
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (CFontManager.this.tmpFontFiles != null) {
                                File[] files = new File[CFontManager.this.tmpFontFiles.size()];
                                files = CFontManager.this.tmpFontFiles.toArray(files);
                                for (int f = 0; f < files.length; ++f) {
                                    try {
                                        files[f].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(() -> {
                ThreadGroup rootTG = ThreadGroupUtils.getRootThreadGroup();
                this.fileCloser = new Thread(rootTG, fileCloserRunnable);
                this.fileCloser.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(this.fileCloser);
                return null;
            });
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return font2D;
        }
    }

    @Override
    protected void registerFontsInDir(String dirName, boolean useJavaRasterizer, int fontRank, boolean defer, boolean resolveSymLinks) {
        this.loadNativeDirFonts(dirName);
        super.registerFontsInDir(dirName, useJavaRasterizer, fontRank, defer, resolveSymLinks);
    }

    private native void loadNativeDirFonts(String var1);

    private native void loadNativeFonts();

    void registerFont(String fontName, String fontFamilyName) {
        CFont font = new CFont(fontName, fontFamilyName);
        this.registerGenericFont(font);
    }

    void registerItalicDerived() {
        FontFamily[] famArr = FontFamily.getAllFontFamilies();
        for (int i = 0; i < famArr.length; ++i) {
            Font2D f2dBoldItalic;
            Font2D f2dItalic;
            Font2D f2dBold;
            FontFamily family = famArr[i];
            Font2D f2dPlain = family.getFont(0);
            if (f2dPlain != null && !(f2dPlain instanceof CFont) || (f2dBold = family.getFont(1)) != null && !(f2dBold instanceof CFont) || (f2dItalic = family.getFont(2)) != null && !(f2dItalic instanceof CFont) || (f2dBoldItalic = family.getFont(3)) != null && !(f2dBoldItalic instanceof CFont)) continue;
            CFont plain2 = (CFont)f2dPlain;
            CFont bold = (CFont)f2dBold;
            CFont italic = (CFont)f2dItalic;
            CFont boldItalic = (CFont)f2dBoldItalic;
            if (bold == null) {
                bold = plain2;
            }
            if (plain2 == null && bold == null || italic != null && boldItalic != null) continue;
            if (plain2 != null && italic == null) {
                this.registerGenericFont(plain2.createItalicVariant(), true);
            }
            if (bold == null || boldItalic != null) continue;
            this.registerGenericFont(bold.createItalicVariant(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFonts() {
        Object object = this.waitForFontsToBeLoaded;
        synchronized (object) {
            super.loadFonts();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (!CFontManager.this.loadedAllFonts) {
                        CFontManager.this.loadNativeFonts();
                        CFontManager.this.registerItalicDerived();
                        CFontManager.this.loadedAllFonts = true;
                    }
                    return null;
                }
            });
            String defaultFont = "Lucida Grande";
            String defaultFallback = "Lucida Sans";
            this.setupLogicalFonts("Dialog", defaultFont, defaultFallback);
            this.setupLogicalFonts("Serif", "Times", "Lucida Bright");
            this.setupLogicalFonts("SansSerif", defaultFont, defaultFallback);
            this.setupLogicalFonts("Monospaced", "Menlo", "Lucida Sans Typewriter");
            this.setupLogicalFonts("DialogInput", defaultFont, defaultFallback);
        }
    }

    protected void setupLogicalFonts(String logicalName, String realName, String fallbackName) {
        FontFamily realFamily = this.getFontFamilyWithExtraTry(logicalName, realName, fallbackName);
        this.cloneStyledFont(realFamily, logicalName, 0);
        this.cloneStyledFont(realFamily, logicalName, 1);
        this.cloneStyledFont(realFamily, logicalName, 2);
        this.cloneStyledFont(realFamily, logicalName, 3);
    }

    protected FontFamily getFontFamilyWithExtraTry(String logicalName, String realName, String fallbackName) {
        FontFamily family = this.getFontFamily(realName, fallbackName);
        if (family != null) {
            return family;
        }
        super.loadFonts();
        family = this.getFontFamily(realName, fallbackName);
        if (family != null) {
            return family;
        }
        System.err.println("Warning: the fonts \"" + realName + "\" and \"" + fallbackName + "\" are not available for the Java logical font \"" + logicalName + "\", which may have unexpected appearance or behavior. Re-enable the \"" + realName + "\" font to remove this warning.");
        return null;
    }

    protected FontFamily getFontFamily(String realName, String fallbackName) {
        FontFamily family = FontFamily.getFamily(realName);
        if (family != null) {
            return family;
        }
        family = FontFamily.getFamily(fallbackName);
        if (family != null) {
            System.err.println("Warning: the font \"" + realName + "\" is not available, so \"" + fallbackName + "\" has been substituted, but may have unexpected appearance or behavor. Re-enable the \"" + realName + "\" font to remove this warning.");
            return family;
        }
        return null;
    }

    protected boolean cloneStyledFont(FontFamily realFamily, String logicalFamilyName, int style) {
        if (realFamily == null) {
            return false;
        }
        Font2D realFont = realFamily.getFontWithExactStyleMatch(style);
        if (realFont == null || !(realFont instanceof CFont)) {
            return false;
        }
        CFont newFont = new CFont((CFont)realFont, logicalFamilyName);
        this.registerGenericFont(newFont, true);
        return true;
    }

    @Override
    public String getFontPath(boolean noType1Fonts) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof HeadlessToolkit) {
            tk = ((HeadlessToolkit)tk).getUnderlyingToolkit();
        }
        if (tk instanceof LWCToolkit) {
            return "";
        }
        return "/Library/Fonts";
    }

    @Override
    protected FontUIResource getFontConfigFUIR(String family, int style, int size) {
        String mappedName = FontUtilities.mapFcName(family);
        if (mappedName == null) {
            mappedName = "sansserif";
        }
        return new FontUIResource(mappedName, style, size);
    }

    @Override
    protected void populateFontFileNameMap(HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap, Locale locale) {
    }
}

