/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sun.font.CFont;
import sun.font.CStrikeDisposer;
import sun.font.Font2D;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

public final class CStrike
extends PhysicalStrike {
    private final CFont nativeFont;
    private AffineTransform invDevTx;
    private final GlyphInfoCache glyphInfoCache;
    private final GlyphAdvanceCache glyphAdvanceCache;
    private long nativeStrikePtr;

    private static native long createNativeStrikePtr(long var0, double[] var2, double[] var3, int var4, int var5);

    private static native void disposeNativeStrikePtr(long var0);

    private static native StrikeMetrics getFontMetrics(long var0);

    private static native void getGlyphImagePtrsNative(long var0, long[] var2, int[] var3, int var4);

    private static native float getNativeGlyphAdvance(long var0, int var2);

    private static native GeneralPath getNativeGlyphOutline(long var0, int var2, double var3, double var5);

    private static native void getNativeGlyphImageBounds(long var0, int var2, Rectangle2D.Float var3, double var4, double var6);

    CStrike(CFont font, FontStrikeDesc inDesc) {
        this.nativeFont = font;
        this.desc = inDesc;
        this.glyphInfoCache = new GlyphInfoCache(font, this.desc);
        this.glyphAdvanceCache = new GlyphAdvanceCache();
        this.disposer = this.glyphInfoCache;
        if (inDesc.devTx != null && !inDesc.devTx.isIdentity()) {
            try {
                this.invDevTx = inDesc.devTx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNativeStrikePtr() {
        if (this.nativeStrikePtr != 0L) {
            return this.nativeStrikePtr;
        }
        double[] glyphTx = new double[6];
        this.desc.glyphTx.getMatrix(glyphTx);
        double[] invDevTxMatrix = new double[6];
        if (this.invDevTx == null) {
            invDevTxMatrix[0] = 1.0;
            invDevTxMatrix[3] = 1.0;
        } else {
            this.invDevTx.getMatrix(invDevTxMatrix);
        }
        int aaHint = this.desc.aaHint;
        int fmHint = this.desc.fmHint;
        CStrike cStrike = this;
        synchronized (cStrike) {
            if (this.nativeStrikePtr != 0L) {
                return this.nativeStrikePtr;
            }
            this.nativeStrikePtr = CStrike.createNativeStrikePtr(this.nativeFont.getNativeFontPtr(), glyphTx, invDevTxMatrix, aaHint, fmHint);
        }
        return this.nativeStrikePtr;
    }

    protected synchronized void finalize() throws Throwable {
        if (this.nativeStrikePtr != 0L) {
            CStrike.disposeNativeStrikePtr(this.nativeStrikePtr);
        }
        this.nativeStrikePtr = 0L;
    }

    @Override
    public int getNumGlyphs() {
        return this.nativeFont.getNumGlyphs();
    }

    @Override
    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            StrikeMetrics metrics = CStrike.getFontMetrics(this.getNativeStrikePtr());
            if (this.invDevTx != null) {
                metrics.convertToUserSpace(this.invDevTx);
            }
            metrics.convertToUserSpace(this.desc.glyphTx);
            this.strikeMetrics = metrics;
        }
        return this.strikeMetrics;
    }

    @Override
    float getGlyphAdvance(int glyphCode) {
        return this.getCachedNativeGlyphAdvance(glyphCode);
    }

    @Override
    float getCodePointAdvance(int cp) {
        return this.getGlyphAdvance(this.nativeFont.getMapper().charToGlyph(cp));
    }

    @Override
    Point2D.Float getCharMetrics(char ch) {
        return this.getGlyphMetrics(this.nativeFont.getMapper().charToGlyph(ch));
    }

    @Override
    Point2D.Float getGlyphMetrics(int glyphCode) {
        return new Point2D.Float(this.getGlyphAdvance(glyphCode), 0.0f);
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(int glyphCode) {
        Rectangle2D.Float r2df;
        GeneralPath gp = this.getGlyphOutline(glyphCode, 0.0f, 0.0f);
        Rectangle2D r2d = gp.getBounds2D();
        if (r2d instanceof Rectangle2D.Float) {
            r2df = (Rectangle2D.Float)r2d;
        } else {
            float x = (float)r2d.getX();
            float y = (float)r2d.getY();
            float w = (float)r2d.getWidth();
            float h = (float)r2d.getHeight();
            r2df = new Rectangle2D.Float(x, y, w, h);
        }
        return r2df;
    }

    @Override
    void getGlyphImageBounds(int glyphCode, Point2D.Float pt, Rectangle result) {
        Rectangle2D.Float floatRect = new Rectangle2D.Float();
        if (this.invDevTx != null) {
            this.invDevTx.transform(pt, pt);
        }
        this.getGlyphImageBounds(glyphCode, pt.x, pt.y, floatRect);
        if (floatRect.width == 0.0f && floatRect.height == 0.0f) {
            result.setRect(0.0, 0.0, -1.0, -1.0);
            return;
        }
        result.setRect(floatRect.x + pt.x, floatRect.y + pt.y, floatRect.width, floatRect.height);
    }

    private void getGlyphImageBounds(int glyphCode, float x, float y, Rectangle2D.Float floatRect) {
        CStrike.getNativeGlyphImageBounds(this.getNativeStrikePtr(), glyphCode, floatRect, x, y);
    }

    @Override
    GeneralPath getGlyphOutline(int glyphCode, float x, float y) {
        return CStrike.getNativeGlyphOutline(this.getNativeStrikePtr(), glyphCode, x, y);
    }

    @Override
    GeneralPath getGlyphVectorOutline(int[] glyphs, float x, float y) {
        throw new Error("not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getGlyphImagePtr(int glyphCode) {
        GlyphInfoCache glyphInfoCache = this.glyphInfoCache;
        synchronized (glyphInfoCache) {
            long ptr = this.glyphInfoCache.get(glyphCode);
            if (ptr != 0L) {
                return ptr;
            }
            long[] ptrs = new long[1];
            int[] codes = new int[]{glyphCode};
            this.getGlyphImagePtrs(codes, ptrs, 1);
            ptr = ptrs[0];
            this.glyphInfoCache.put(glyphCode, ptr);
            return ptr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getGlyphImagePtrs(int[] glyphCodes, long[] images, int len) {
        GlyphInfoCache glyphInfoCache = this.glyphInfoCache;
        synchronized (glyphInfoCache) {
            int missed = 0;
            for (int i = 0; i < len; ++i) {
                int code = glyphCodes[i];
                long ptr = this.glyphInfoCache.get(code);
                if (ptr != 0L) {
                    images[i] = ptr;
                    continue;
                }
                images[i] = 0L;
                ++missed;
            }
            if (missed == 0) {
                return;
            }
            int[] filteredCodes = new int[missed];
            int[] filteredIndicies = new int[missed];
            int j = 0;
            int dupes = 0;
            for (int i = 0; i < len; ++i) {
                if (images[i] != 0L) continue;
                int code = glyphCodes[i];
                if (this.glyphInfoCache.get(code) == -1L) {
                    filteredIndicies[j] = -1;
                    ++dupes;
                    ++j;
                    continue;
                }
                int k = j - dupes;
                filteredCodes[k] = code;
                this.glyphInfoCache.put(code, -1L);
                filteredIndicies[j] = k;
                ++j;
            }
            int filteredRunLen = j - dupes;
            long[] filteredImages = new long[filteredRunLen];
            this.getFilteredGlyphImagePtrs(filteredImages, filteredCodes, filteredRunLen);
            j = 0;
            for (int i = 0; i < len; ++i) {
                if (images[i] != 0L && images[i] != -1L) continue;
                int k = filteredIndicies[j];
                int code = glyphCodes[i];
                if ((long)k == -1L) {
                    images[i] = this.glyphInfoCache.get(code);
                } else {
                    long ptr;
                    images[i] = ptr = filteredImages[k];
                    this.glyphInfoCache.put(code, ptr);
                }
                ++j;
            }
        }
    }

    private void getFilteredGlyphImagePtrs(long[] glyphInfos, int[] uniCodes, int len) {
        CStrike.getGlyphImagePtrsNative(this.getNativeStrikePtr(), glyphInfos, uniCodes, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getCachedNativeGlyphAdvance(int glyphCode) {
        GlyphAdvanceCache glyphAdvanceCache = this.glyphAdvanceCache;
        synchronized (glyphAdvanceCache) {
            float advance = this.glyphAdvanceCache.get(glyphCode);
            if (advance != 0.0f) {
                return advance;
            }
            advance = CStrike.getNativeGlyphAdvance(this.getNativeStrikePtr(), glyphCode);
            this.glyphAdvanceCache.put(glyphCode, advance);
            return advance;
        }
    }

    private static class GlyphAdvanceCache {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final float[] firstLayerCache = new float[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Float> generalCache;

        GlyphAdvanceCache() {
        }

        public synchronized float get(int index) {
            if (index < 0) {
                if (-index < 16384) {
                    if (this.secondLayerCache == null) {
                        return 0.0f;
                    }
                    return this.secondLayerCache.get(-index);
                }
            } else if (index < 256) {
                return this.firstLayerCache[index];
            }
            if (this.generalCache == null) {
                return 0.0f;
            }
            Float value = this.generalCache.get(new Integer(index));
            if (value == null) {
                return 0.0f;
            }
            return value.floatValue();
        }

        public synchronized void put(int index, float value) {
            if (index < 0) {
                if (-index < 16384) {
                    if (this.secondLayerCache == null) {
                        this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                    }
                    this.secondLayerCache.put(-index, value);
                    return;
                }
            } else if (index < 256) {
                this.firstLayerCache[index] = value;
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(new Integer(index), new Float(value));
        }

        private static class SparseBitShiftingTwoLayerArray {
            final float[][] cache;
            final int shift;
            final int secondLayerLength;

            SparseBitShiftingTwoLayerArray(int size, int shift) {
                this.shift = shift;
                this.cache = new float[1 << shift][];
                this.secondLayerLength = size >> shift;
            }

            public float get(int index) {
                int firstIndex = index >> this.shift;
                float[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    return 0.0f;
                }
                return firstLayerRow[index - firstIndex * (1 << this.shift)];
            }

            public void put(int index, float value) {
                int firstIndex = index >> this.shift;
                float[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    firstLayerRow = new float[this.secondLayerLength];
                    this.cache[firstIndex] = firstLayerRow;
                }
                firstLayerRow[index - firstIndex * (1 << this.shift)] = value;
            }
        }
    }

    private static class GlyphInfoCache
    extends CStrikeDisposer {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private boolean disposed = false;
        private final long[] firstLayerCache = new long[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Long> generalCache;

        GlyphInfoCache(Font2D nativeFont, FontStrikeDesc desc) {
            super(nativeFont, desc);
        }

        public synchronized long get(int index) {
            if (index < 0) {
                if (-index < 16384) {
                    if (this.secondLayerCache == null) {
                        return 0L;
                    }
                    return this.secondLayerCache.get(-index);
                }
            } else if (index < 256) {
                return this.firstLayerCache[index];
            }
            if (this.generalCache == null) {
                return 0L;
            }
            Long value = this.generalCache.get(new Integer(index));
            if (value == null) {
                return 0L;
            }
            return value;
        }

        public synchronized void put(int index, long value) {
            if (index < 0) {
                if (-index < 16384) {
                    if (this.secondLayerCache == null) {
                        this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                    }
                    this.secondLayerCache.put(-index, value);
                    return;
                }
            } else if (index < 256) {
                this.firstLayerCache[index] = value;
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(new Integer(index), new Long(value));
        }

        @Override
        public synchronized void dispose() {
            if (this.disposed) {
                return;
            }
            super.dispose();
            GlyphInfoCache.disposeLongArray(this.firstLayerCache);
            if (this.secondLayerCache != null) {
                long[][] secondLayerLongArrayArray = this.secondLayerCache.cache;
                for (int i = 0; i < secondLayerLongArrayArray.length; ++i) {
                    long[] longArray = secondLayerLongArrayArray[i];
                    if (longArray == null) continue;
                    GlyphInfoCache.disposeLongArray(longArray);
                }
            }
            if (this.generalCache != null) {
                for (long longValue : this.generalCache.values()) {
                    if (longValue == -1L || longValue == 0L) continue;
                    GlyphInfoCache.removeGlyphInfoFromCache(longValue);
                    StrikeCache.freeLongPointer(longValue);
                }
            }
            this.disposed = true;
        }

        private static void disposeLongArray(long[] longArray) {
            for (int i = 0; i < longArray.length; ++i) {
                long ptr = longArray[i];
                if (ptr == 0L || ptr == -1L) continue;
                GlyphInfoCache.removeGlyphInfoFromCache(ptr);
                StrikeCache.freeLongPointer(ptr);
            }
        }

        private static class SparseBitShiftingTwoLayerArray {
            final long[][] cache;
            final int shift;
            final int secondLayerLength;

            SparseBitShiftingTwoLayerArray(int size, int shift) {
                this.shift = shift;
                this.cache = new long[1 << shift][];
                this.secondLayerLength = size >> shift;
            }

            public long get(int index) {
                int firstIndex = index >> this.shift;
                long[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    return 0L;
                }
                return firstLayerRow[index - firstIndex * (1 << this.shift)];
            }

            public void put(int index, long value) {
                int firstIndex = index >> this.shift;
                long[] firstLayerRow = this.cache[firstIndex];
                if (firstLayerRow == null) {
                    firstLayerRow = new long[this.secondLayerLength];
                    this.cache[firstIndex] = firstLayerRow;
                }
                firstLayerRow[index - firstIndex * (1 << this.shift)] = value;
            }
        }
    }
}

