/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.java2d.OSXOffScreenSurfaceData;
import sun.java2d.OSXSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.lwawt.macosx.CPrinterSurfaceData;

public class CRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe {
    Line2D lineToShape;
    Rectangle2D rectToShape;
    RoundRectangle2D roundrectToShape;
    Ellipse2D ovalToShape;
    Arc2D arcToShape;

    static native void init();

    native void doLine(SurfaceData var1, float var2, float var3, float var4, float var5);

    @Override
    public void drawLine(SunGraphics2D sg2d, int x1, int y1, int x2, int y2) {
        this.drawLine(sg2d, (float)x1, (float)y1, (float)x2, (float)y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sg2d, float x1, float y1, float x2, float y2) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doLine(this, sg2d, x1, y1, x2, y2);
        } else {
            Object object;
            if (this.lineToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.lineToShape == null) {
                        this.lineToShape = new Line2D.Float();
                    }
                }
            }
            object = this.lineToShape;
            synchronized (object) {
                this.lineToShape.setLine(x1, y1, x2, y2);
                this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(this.lineToShape), true, true);
            }
        }
    }

    native void doRect(SurfaceData var1, float var2, float var3, float var4, float var5, boolean var6);

    @Override
    public void drawRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.drawRect(sg2d, (float)x, (float)y, (float)width, (float)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sg2d, float x, float y, float width, float height) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doRect(this, sg2d, x, y, width, height, false);
        } else {
            Object object;
            if (this.rectToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.rectToShape == null) {
                        this.rectToShape = new Rectangle2D.Float();
                    }
                }
            }
            object = this.rectToShape;
            synchronized (object) {
                this.rectToShape.setRect(x, y, width, height);
                this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(this.rectToShape), true, true);
            }
        }
    }

    @Override
    public void fillRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.fillRect(sg2d, (float)x, (float)y, (float)width, (float)height);
    }

    public void fillRect(SunGraphics2D sg2d, float x, float y, float width, float height) {
        if (width >= 0.0f && height >= 0.0f) {
            OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
            surfaceData.doRect(this, sg2d, x, y, width, height, true);
        }
    }

    native void doRoundRect(SurfaceData var1, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    @Override
    public void drawRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect(sg2d, (float)x, (float)y, (float)width, (float)height, (float)arcWidth, (float)arcHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(SunGraphics2D sg2d, float x, float y, float width, float height, float arcWidth, float arcHeight) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doRoundRect(this, sg2d, x, y, width, height, arcWidth, arcHeight, false);
        } else {
            Object object;
            if (this.roundrectToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.roundrectToShape == null) {
                        this.roundrectToShape = new RoundRectangle2D.Float();
                    }
                }
            }
            object = this.roundrectToShape;
            synchronized (object) {
                this.roundrectToShape.setRoundRect(x, y, width, height, arcWidth, arcHeight);
                this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(this.roundrectToShape), true, true);
            }
        }
    }

    @Override
    public void fillRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect(sg2d, (float)x, (float)y, (float)width, (float)height, (float)arcWidth, (float)arcHeight);
    }

    public void fillRoundRect(SunGraphics2D sg2d, float x, float y, float width, float height, float arcWidth, float arcHeight) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        surfaceData.doRoundRect(this, sg2d, x, y, width, height, arcWidth, arcHeight, true);
    }

    native void doOval(SurfaceData var1, float var2, float var3, float var4, float var5, boolean var6);

    @Override
    public void drawOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.drawOval(sg2d, (float)x, (float)y, (float)width, (float)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(SunGraphics2D sg2d, float x, float y, float width, float height) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doOval(this, sg2d, x, y, width, height, false);
        } else {
            Object object;
            if (this.ovalToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.ovalToShape == null) {
                        this.ovalToShape = new Ellipse2D.Float();
                    }
                }
            }
            object = this.ovalToShape;
            synchronized (object) {
                this.ovalToShape.setFrame(x, y, width, height);
                this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(this.ovalToShape), true, true);
            }
        }
    }

    @Override
    public void fillOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.fillOval(sg2d, (float)x, (float)y, (float)width, (float)height);
    }

    public void fillOval(SunGraphics2D sg2d, float x, float y, float width, float height) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        surfaceData.doOval(this, sg2d, x, y, width, height, true);
    }

    native void doArc(SurfaceData var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, boolean var9);

    @Override
    public void drawArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(sg2d, x, y, width, height, startAngle, arcAngle, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(SunGraphics2D sg2d, float x, float y, float width, float height, float startAngle, float arcAngle, int type) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doArc(this, sg2d, x, y, width, height, startAngle, arcAngle, type, false);
        } else {
            Object object;
            if (this.arcToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.arcToShape == null) {
                        this.arcToShape = new Arc2D.Float();
                    }
                }
            }
            object = this.arcToShape;
            synchronized (object) {
                this.arcToShape.setArc(x, y, width, height, startAngle, arcAngle, type);
                this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(this.arcToShape), true, true);
            }
        }
    }

    @Override
    public void fillArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fillArc(sg2d, x, y, width, height, startAngle, arcAngle, 2);
    }

    public void fillArc(SunGraphics2D sg2d, float x, float y, float width, float height, float startAngle, float arcAngle, int type) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        surfaceData.doArc(this, sg2d, x, y, width, height, startAngle, arcAngle, type, true);
    }

    native void doPoly(SurfaceData var1, int[] var2, int[] var3, int var4, boolean var5, boolean var6);

    @Override
    public void drawPolyline(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doPolygon(this, sg2d, xpoints, ypoints, npoints, false, false);
        } else {
            GeneralPath polyToShape = new GeneralPath();
            polyToShape.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                polyToShape.lineTo(xpoints[i], ypoints[i]);
            }
            this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(polyToShape), true, true);
        }
    }

    @Override
    public void drawPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            surfaceData.doPolygon(this, sg2d, xpoints, ypoints, npoints, true, false);
        } else {
            GeneralPath polyToShape = new GeneralPath();
            polyToShape.moveTo(xpoints[0], ypoints[0]);
            for (int i = 1; i < npoints; ++i) {
                polyToShape.lineTo(xpoints[i], ypoints[i]);
            }
            polyToShape.lineTo(xpoints[0], ypoints[0]);
            this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(polyToShape), true, true);
        }
    }

    @Override
    public void fillPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        surfaceData.doPolygon(this, sg2d, xpoints, ypoints, npoints, true, true);
    }

    native void doShape(SurfaceData var1, int var2, FloatBuffer var3, IntBuffer var4, int var5, boolean var6, boolean var7);

    void drawfillShape(SunGraphics2D sg2d, Shape s, boolean isfill, boolean shouldApplyOffset) {
        if (s == null) {
            throw new NullPointerException();
        }
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        boolean sOptimizeShapes = true;
        if (sOptimizeShapes && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            if (s instanceof Rectangle2D) {
                Rectangle2D rectangle = (Rectangle2D)s;
                float x = (float)rectangle.getX();
                float y = (float)rectangle.getY();
                float w = (float)rectangle.getWidth();
                float h = (float)rectangle.getHeight();
                if (isfill) {
                    this.fillRect(sg2d, x, y, w, h);
                } else {
                    this.drawRect(sg2d, x, y, w, h);
                }
            } else if (s instanceof Ellipse2D) {
                Ellipse2D ellipse = (Ellipse2D)s;
                float x = (float)ellipse.getX();
                float y = (float)ellipse.getY();
                float w = (float)ellipse.getWidth();
                float h = (float)ellipse.getHeight();
                if (isfill) {
                    this.fillOval(sg2d, x, y, w, h);
                } else {
                    this.drawOval(sg2d, x, y, w, h);
                }
            } else if (s instanceof Arc2D) {
                Arc2D arc = (Arc2D)s;
                float x = (float)arc.getX();
                float y = (float)arc.getY();
                float w = (float)arc.getWidth();
                float h = (float)arc.getHeight();
                float as = (float)arc.getAngleStart();
                float ae = (float)arc.getAngleExtent();
                if (isfill) {
                    this.fillArc(sg2d, x, y, w, h, as, ae, arc.getArcType());
                } else {
                    this.drawArc(sg2d, x, y, w, h, as, ae, arc.getArcType());
                }
            } else if (s instanceof RoundRectangle2D) {
                RoundRectangle2D roundrect = (RoundRectangle2D)s;
                float x = (float)roundrect.getX();
                float y = (float)roundrect.getY();
                float w = (float)roundrect.getWidth();
                float h = (float)roundrect.getHeight();
                float aw = (float)roundrect.getArcWidth();
                float ah = (float)roundrect.getArcHeight();
                if (isfill) {
                    this.fillRoundRect(sg2d, x, y, w, h, aw, ah);
                } else {
                    this.drawRoundRect(sg2d, x, y, w, h, aw, ah);
                }
            } else if (s instanceof Line2D) {
                Line2D line = (Line2D)s;
                float x1 = (float)line.getX1();
                float y1 = (float)line.getY1();
                float x2 = (float)line.getX2();
                float y2 = (float)line.getY2();
                this.drawLine(sg2d, x1, y1, x2, y2);
            } else if (s instanceof Point2D) {
                Point2D point = (Point2D)((Object)s);
                float x = (float)point.getX();
                float y = (float)point.getY();
                this.drawLine(sg2d, x, y, x, y);
            } else {
                GeneralPath gp = s instanceof GeneralPath ? (GeneralPath)s : new GeneralPath(s);
                PathIterator pi = gp.getPathIterator(null);
                if (!pi.isDone()) {
                    surfaceData.drawfillShape(this, sg2d, gp, isfill, shouldApplyOffset);
                }
            }
        } else {
            GeneralPath gp = s instanceof GeneralPath ? (GeneralPath)s : new GeneralPath(s);
            PathIterator pi = gp.getPathIterator(null);
            if (!pi.isDone()) {
                surfaceData.drawfillShape(this, sg2d, gp, isfill, shouldApplyOffset);
            }
        }
    }

    @Override
    public void draw(SunGraphics2D sg2d, Shape s) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        if (sg2d.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sg2d.paint)) {
            this.drawfillShape(sg2d, s, false, true);
        } else {
            this.drawfillShape(sg2d, sg2d.stroke.createStrokedShape(s), true, true);
        }
    }

    @Override
    public void fill(SunGraphics2D sg2d, Shape s) {
        this.drawfillShape(sg2d, s, true, false);
    }

    native void doImage(SurfaceData var1, SurfaceData var2, boolean var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    public boolean scaleImage(SunGraphics2D sg2d, Image img, int x, int y, int width, int height, Color bgColor) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        int sx = 0;
        int sy = 0;
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        return this.scaleImage(sg2d, img, x, y, x + width, y + height, sx, sy, sx + iw, sy + ih, bgColor);
    }

    public boolean scaleImage(SunGraphics2D sg2d, Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor) {
        int dstY;
        int dstH;
        int dstX;
        int dstW;
        int srcY;
        int srcH;
        int srcX;
        int srcW;
        boolean srcWidthFlip = false;
        boolean srcHeightFlip = false;
        boolean dstWidthFlip = false;
        boolean dstHeightFlip = false;
        if (sx2 > sx1) {
            srcW = sx2 - sx1;
            srcX = sx1;
        } else {
            srcWidthFlip = true;
            srcW = sx1 - sx2;
            srcX = sx2;
        }
        if (sy2 > sy1) {
            srcH = sy2 - sy1;
            srcY = sy1;
        } else {
            srcHeightFlip = true;
            srcH = sy1 - sy2;
            srcY = sy2;
        }
        if (dx2 > dx1) {
            dstW = dx2 - dx1;
            dstX = dx1;
        } else {
            dstW = dx1 - dx2;
            dstWidthFlip = true;
            dstX = dx2;
        }
        if (dy2 > dy1) {
            dstH = dy2 - dy1;
            dstY = dy1;
        } else {
            dstH = dy1 - dy2;
            dstHeightFlip = true;
            dstY = dy2;
        }
        if (srcW <= 0 || srcH <= 0) {
            return true;
        }
        boolean flipv = srcHeightFlip != dstHeightFlip;
        boolean fliph = srcWidthFlip != dstWidthFlip;
        return this.blitImage(sg2d, img, fliph, flipv, srcX, srcY, srcW, srcH, dstX, dstY, dstW, dstH, bgColor);
    }

    protected boolean blitImage(SunGraphics2D sg2d, Image img, boolean fliph, boolean flipv, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, Color bgColor) {
        CPrinterSurfaceData surfaceData = (CPrinterSurfaceData)sg2d.getSurfaceData();
        OSXOffScreenSurfaceData imgSurfaceData = OSXOffScreenSurfaceData.createNewSurface((BufferedImage)img);
        surfaceData.blitImage(this, sg2d, imgSurfaceData, fliph, flipv, sx, sy, sw, sh, dx, dy, dw, dh, bgColor);
        return true;
    }

    protected boolean copyImage(SunGraphics2D sg2d, Image img, int dx, int dy, Color bgColor) {
        if (img == null) {
            return true;
        }
        int sx = 0;
        int sy = 0;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        return this.blitImage(sg2d, img, false, false, sx, sy, width, height, dx, dy, width, height, bgColor);
    }

    protected boolean copyImage(SunGraphics2D sg2d, Image img, int dx, int dy, int sx, int sy, int width, int height, Color bgColor) {
        return this.blitImage(sg2d, img, false, false, sx, sy, width, height, dx, dy, width, height, bgColor);
    }

    protected void transformImage(SunGraphics2D sg2d, Image img, int x, int y, BufferedImageOp op, AffineTransform xf, Color bgColor) {
        if (img != null) {
            int iw = img.getWidth(null);
            int ih = img.getHeight(null);
            if (op != null && img instanceof BufferedImage) {
                if (((BufferedImage)img).getType() == 0) {
                    BufferedImage dest = null;
                    dest = new BufferedImage(iw, ih, 3);
                    Graphics2D g = dest.createGraphics();
                    g.drawImage(img, 0, 0, null);
                    g.dispose();
                    img = op.filter(dest, null);
                } else {
                    img = op.filter((BufferedImage)img, null);
                }
                iw = img.getWidth(null);
                ih = img.getHeight(null);
            }
            if (xf != null) {
                AffineTransform reset = sg2d.getTransform();
                sg2d.transform(xf);
                this.scaleImage(sg2d, img, x, y, x + iw, y + ih, 0, 0, iw, ih, bgColor);
                sg2d.setTransform(reset);
            } else {
                this.scaleImage(sg2d, img, x, y, x + iw, y + ih, 0, 0, iw, ih, bgColor);
            }
        } else {
            throw new NullPointerException();
        }
    }

    protected boolean imageReady(ToolkitImage sunimg, ImageObserver observer) {
        if (sunimg.hasError()) {
            if (observer != null) {
                observer.imageUpdate(sunimg, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean copyImage(SunGraphics2D sg2d, Image img, int x, int y, Color bgColor, ImageObserver observer) {
        if (img == null) {
            throw new NullPointerException();
        }
        if (!(img instanceof ToolkitImage)) {
            return this.copyImage(sg2d, img, x, y, bgColor);
        }
        ToolkitImage sunimg = (ToolkitImage)img;
        if (!this.imageReady(sunimg, observer)) {
            return false;
        }
        ImageRepresentation ir = sunimg.getImageRep();
        return ir.drawToBufImage(sg2d, sunimg, x, y, bgColor, observer);
    }

    @Override
    public boolean copyImage(SunGraphics2D sg2d, Image img, int dx, int dy, int sx, int sy, int width, int height, Color bgColor, ImageObserver observer) {
        if (img == null) {
            throw new NullPointerException();
        }
        if (!(img instanceof ToolkitImage)) {
            return this.copyImage(sg2d, img, dx, dy, sx, sy, width, height, bgColor);
        }
        ToolkitImage sunimg = (ToolkitImage)img;
        if (!this.imageReady(sunimg, observer)) {
            return false;
        }
        ImageRepresentation ir = sunimg.getImageRep();
        return ir.drawToBufImage(sg2d, sunimg, dx, dy, dx + width, dy + height, sx, sy, sx + width, sy + height, null, observer);
    }

    @Override
    public boolean scaleImage(SunGraphics2D sg2d, Image img, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        if (img == null) {
            throw new NullPointerException();
        }
        if (!(img instanceof ToolkitImage)) {
            return this.scaleImage(sg2d, img, x, y, width, height, bgColor);
        }
        ToolkitImage sunimg = (ToolkitImage)img;
        if (!this.imageReady(sunimg, observer)) {
            return false;
        }
        ImageRepresentation ir = sunimg.getImageRep();
        return ir.drawToBufImage(sg2d, sunimg, x, y, width, height, bgColor, observer);
    }

    @Override
    public boolean scaleImage(SunGraphics2D sg2d, Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver observer) {
        if (img == null) {
            throw new NullPointerException();
        }
        if (!(img instanceof ToolkitImage)) {
            return this.scaleImage(sg2d, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgColor);
        }
        ToolkitImage sunimg = (ToolkitImage)img;
        if (!this.imageReady(sunimg, observer)) {
            return false;
        }
        ImageRepresentation ir = sunimg.getImageRep();
        return ir.drawToBufImage(sg2d, sunimg, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgColor, observer);
    }

    @Override
    public boolean transformImage(SunGraphics2D sg2d, Image img, AffineTransform atfm, ImageObserver observer) {
        if (img == null) {
            throw new NullPointerException();
        }
        if (!(img instanceof ToolkitImage)) {
            this.transformImage(sg2d, img, 0, 0, null, atfm, null);
            return true;
        }
        ToolkitImage sunimg = (ToolkitImage)img;
        if (!this.imageReady(sunimg, observer)) {
            return false;
        }
        ImageRepresentation ir = sunimg.getImageRep();
        return ir.drawToBufImage(sg2d, sunimg, atfm, observer);
    }

    @Override
    public void transformImage(SunGraphics2D sg2d, BufferedImage img, BufferedImageOp op, int x, int y) {
        if (img == null) {
            throw new NullPointerException();
        }
        this.transformImage(sg2d, img, x, y, op, null, null);
    }

    public CRenderer traceWrap() {
        return new Tracer();
    }

    static {
        CRenderer.init();
    }

    public static class Tracer
    extends CRenderer {
        @Override
        void doLine(SurfaceData sData, float x1, float y1, float x2, float y2) {
            GraphicsPrimitive.tracePrimitive("QuartzLine");
            super.doLine(sData, x1, y1, x2, y2);
        }

        @Override
        void doRect(SurfaceData sData, float x, float y, float width, float height, boolean isfill) {
            GraphicsPrimitive.tracePrimitive("QuartzRect");
            super.doRect(sData, x, y, width, height, isfill);
        }

        @Override
        void doRoundRect(SurfaceData sData, float x, float y, float width, float height, float arcW, float arcH, boolean isfill) {
            GraphicsPrimitive.tracePrimitive("QuartzRoundRect");
            super.doRoundRect(sData, x, y, width, height, arcW, arcH, isfill);
        }

        @Override
        void doOval(SurfaceData sData, float x, float y, float width, float height, boolean isfill) {
            GraphicsPrimitive.tracePrimitive("QuartzOval");
            super.doOval(sData, x, y, width, height, isfill);
        }

        @Override
        void doArc(SurfaceData sData, float x, float y, float width, float height, float angleStart, float angleExtent, int type, boolean isfill) {
            GraphicsPrimitive.tracePrimitive("QuartzArc");
            super.doArc(sData, x, y, width, height, angleStart, angleExtent, type, isfill);
        }

        @Override
        void doPoly(SurfaceData sData, int[] xpoints, int[] ypoints, int npoints, boolean ispolygon, boolean isfill) {
            GraphicsPrimitive.tracePrimitive("QuartzDoPoly");
            super.doPoly(sData, xpoints, ypoints, npoints, ispolygon, isfill);
        }

        @Override
        void doShape(SurfaceData sData, int length, FloatBuffer coordinates, IntBuffer types, int windingRule, boolean isfill, boolean shouldApplyOffset) {
            GraphicsPrimitive.tracePrimitive("QuartzFillOrDrawShape");
            super.doShape(sData, length, coordinates, types, windingRule, isfill, shouldApplyOffset);
        }

        @Override
        void doImage(SurfaceData sData, SurfaceData img, boolean fliph, boolean flipv, int w, int h, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawImage");
            super.doImage(sData, img, fliph, flipv, w, h, sx, sy, sw, sh, dx, dy, dw, dh);
        }
    }
}

