/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.CRenderer;
import sun.java2d.OSXSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public class CompositeCRenderer
extends CRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe,
TextPipe {
    static final int fPadding = 4;
    static final int fPaddingHalf = 2;
    private static AffineTransform sIdentityMatrix = new AffineTransform();
    AffineTransform ShapeTM = new AffineTransform();
    Rectangle2D ShapeBounds = new Rectangle2D.Float();
    Line2D line = new Line2D.Float();
    Rectangle2D rectangle = new Rectangle2D.Float();
    RoundRectangle2D roundrectangle = new RoundRectangle2D.Float();
    Ellipse2D ellipse = new Ellipse2D.Float();
    Arc2D arc = new Arc2D.Float();

    @Override
    public synchronized void drawLine(SunGraphics2D sg2d, int x1, int y1, int x2, int y2) {
        this.line.setLine(x1, y1, x2, y2);
        this.draw(sg2d, this.line);
    }

    @Override
    public synchronized void drawRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.rectangle.setRect(x, y, width, height);
        this.draw(sg2d, this.rectangle);
    }

    @Override
    public synchronized void drawRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.roundrectangle.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(sg2d, this.roundrectangle);
    }

    @Override
    public synchronized void drawOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.ellipse.setFrame(x, y, width, height);
        this.draw(sg2d, this.ellipse);
    }

    @Override
    public synchronized void drawArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.arc.setArc(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(sg2d, this.arc);
    }

    @Override
    public synchronized void drawPolyline(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.doPolygon(sg2d, xpoints, ypoints, npoints, false, false);
    }

    @Override
    public synchronized void drawPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.doPolygon(sg2d, xpoints, ypoints, npoints, true, false);
    }

    @Override
    public synchronized void fillRect(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.rectangle.setRect(x, y, width, height);
        this.fill(sg2d, this.rectangle);
    }

    @Override
    public synchronized void fillRoundRect(SunGraphics2D sg2d, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.roundrectangle.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(sg2d, this.roundrectangle);
    }

    @Override
    public synchronized void fillOval(SunGraphics2D sg2d, int x, int y, int width, int height) {
        this.ellipse.setFrame(x, y, width, height);
        this.fill(sg2d, this.ellipse);
    }

    @Override
    public synchronized void fillArc(SunGraphics2D sg2d, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.arc.setArc(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(sg2d, this.arc);
    }

    @Override
    public synchronized void fillPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints) {
        this.doPolygon(sg2d, xpoints, ypoints, npoints, true, true);
    }

    public synchronized void doPolygon(SunGraphics2D sg2d, int[] xpoints, int[] ypoints, int npoints, boolean ispolygon, boolean isfill) {
        GeneralPath gp = new GeneralPath(1, npoints);
        gp.moveTo(xpoints[0], ypoints[0]);
        for (int i = 1; i < npoints; ++i) {
            gp.lineTo(xpoints[i], ypoints[i]);
        }
        if (ispolygon && (xpoints[0] != xpoints[npoints - 1] || ypoints[0] != ypoints[npoints - 1])) {
            gp.lineTo(xpoints[0], ypoints[0]);
        }
        this.doShape(sg2d, (OSXSurfaceData)sg2d.getSurfaceData(), gp, isfill);
    }

    @Override
    public synchronized void draw(SunGraphics2D sg2d, Shape shape) {
        this.doShape(sg2d, (OSXSurfaceData)sg2d.getSurfaceData(), shape, false);
    }

    @Override
    public synchronized void fill(SunGraphics2D sg2d, Shape shape) {
        this.doShape(sg2d, (OSXSurfaceData)sg2d.getSurfaceData(), shape, true);
    }

    void doShape(SunGraphics2D sg2d, OSXSurfaceData surfaceData, Shape shape, boolean isfill) {
        Rectangle2D shapeBounds = shape.getBounds2D();
        if (shapeBounds.getWidth() < 0.0 || shapeBounds.getHeight() < 0.0) {
            return;
        }
        Rectangle2D compositingBounds = this.padBounds(sg2d, shape);
        this.clipBounds(sg2d, compositingBounds);
        if (!compositingBounds.isEmpty()) {
            BufferedImage srcPixels = surfaceData.getCompositingSrcImage((int)compositingBounds.getWidth(), (int)compositingBounds.getHeight());
            Graphics2D g = srcPixels.createGraphics();
            this.ShapeTM.setToTranslation(-compositingBounds.getX(), -compositingBounds.getY());
            this.ShapeTM.concatenate(sg2d.transform);
            g.setTransform(this.ShapeTM);
            g.setRenderingHints(sg2d.getRenderingHints());
            g.setPaint(sg2d.getPaint());
            g.setStroke(sg2d.getStroke());
            if (isfill) {
                g.fill(shape);
            } else {
                g.draw(shape);
            }
            g.dispose();
            this.composite(sg2d, surfaceData, srcPixels, compositingBounds);
        }
    }

    @Override
    public synchronized void drawString(SunGraphics2D sg2d, String str, double x, double y) {
        this.drawGlyphVector(sg2d, sg2d.getFont().createGlyphVector(sg2d.getFontRenderContext(), str), x, y);
    }

    @Override
    public synchronized void drawChars(SunGraphics2D sg2d, char[] data, int offset, int length, int x, int y) {
        this.drawString(sg2d, new String(data, offset, length), x, y);
    }

    public synchronized void drawGlyphVector(SunGraphics2D sg2d, GlyphVector glyphVector, double x, double y) {
        this.drawGlyphVector(sg2d, glyphVector, (float)x, (float)y);
    }

    @Override
    public synchronized void drawGlyphVector(SunGraphics2D sg2d, GlyphVector glyphVector, float x, float y) {
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        Shape shape = glyphVector.getOutline(x, y);
        Rectangle2D compositingBounds = this.padBounds(sg2d, shape);
        this.clipBounds(sg2d, compositingBounds);
        if (!compositingBounds.isEmpty()) {
            BufferedImage srcPixels = surfaceData.getCompositingSrcImage((int)compositingBounds.getWidth(), (int)compositingBounds.getHeight());
            Graphics2D g = srcPixels.createGraphics();
            this.ShapeTM.setToTranslation(-compositingBounds.getX(), -compositingBounds.getY());
            this.ShapeTM.concatenate(sg2d.transform);
            g.setTransform(this.ShapeTM);
            g.setPaint(sg2d.getPaint());
            g.setStroke(sg2d.getStroke());
            g.setFont(sg2d.getFont());
            g.setRenderingHints(sg2d.getRenderingHints());
            g.drawGlyphVector(glyphVector, x, y);
            g.dispose();
            this.composite(sg2d, surfaceData, srcPixels, compositingBounds);
        }
    }

    @Override
    protected boolean blitImage(SunGraphics2D sg2d, Image img, boolean fliph, boolean flipv, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, Color bgColor) {
        boolean complexTransform;
        OSXSurfaceData surfaceData = (OSXSurfaceData)sg2d.getSurfaceData();
        dx = !flipv ? dx : dx - dw;
        dy = !fliph ? dy : dy - dh;
        this.ShapeBounds.setFrame(dx, dy, dw, dh);
        Rectangle2D compositingBounds = this.ShapeBounds;
        boolean bl = complexTransform = sg2d.transformState >= 3;
        if (!complexTransform) {
            double newX = Math.floor(compositingBounds.getX() + (double)sg2d.transX);
            double newY = Math.floor(compositingBounds.getY() + (double)sg2d.transY);
            double newW = Math.ceil(compositingBounds.getWidth()) + (double)(newX < compositingBounds.getX() ? 1 : 0);
            double newH = Math.ceil(compositingBounds.getHeight()) + (double)(newY < compositingBounds.getY() ? 1 : 0);
            compositingBounds.setRect(newX, newY, newW, newH);
        } else {
            Shape transformedShape = sg2d.transform.createTransformedShape(compositingBounds);
            compositingBounds = transformedShape.getBounds2D();
            double newX = Math.floor(compositingBounds.getX());
            double newY = Math.floor(compositingBounds.getY());
            double newW = Math.ceil(compositingBounds.getWidth()) + (double)(newX < compositingBounds.getX() ? 1 : 0);
            double newH = Math.ceil(compositingBounds.getHeight()) + (double)(newY < compositingBounds.getY() ? 1 : 0);
            compositingBounds.setRect(newX, newY, newW, newH);
        }
        this.clipBounds(sg2d, compositingBounds);
        if (!compositingBounds.isEmpty()) {
            BufferedImage srcPixels = surfaceData.getCompositingSrcImage((int)compositingBounds.getWidth(), (int)compositingBounds.getHeight());
            Graphics2D g = srcPixels.createGraphics();
            this.ShapeTM.setToTranslation(-compositingBounds.getX(), -compositingBounds.getY());
            this.ShapeTM.concatenate(sg2d.transform);
            g.setTransform(this.ShapeTM);
            g.setRenderingHints(sg2d.getRenderingHints());
            g.setComposite(AlphaComposite.Src);
            int sx2 = !flipv ? sx + sw : sx - sw;
            int sy2 = !fliph ? sy + sh : sy - sh;
            g.drawImage(img, dx, dy, dx + dw, dy + dh, sx, sy, sx2, sy2, null);
            g.dispose();
            this.composite(sg2d, surfaceData, srcPixels, compositingBounds);
        }
        return true;
    }

    Rectangle2D padBounds(SunGraphics2D sg2d, Shape shape) {
        shape = sg2d.transformShape(shape);
        int paddingHalf = 2;
        int padding = 4;
        if (sg2d.stroke != null) {
            if (sg2d.stroke instanceof BasicStroke) {
                int width = (int)(((BasicStroke)sg2d.stroke).getLineWidth() + 0.5f);
                int widthHalf = width / 2 + 1;
                paddingHalf += widthHalf;
                padding += 2 * widthHalf;
            } else {
                shape = sg2d.stroke.createStrokedShape(shape);
            }
        }
        Rectangle2D bounds = shape.getBounds2D();
        bounds.setRect(bounds.getX() - (double)paddingHalf, bounds.getY() - (double)paddingHalf, bounds.getWidth() + (double)padding, bounds.getHeight() + (double)padding);
        double newX = Math.floor(bounds.getX());
        double newY = Math.floor(bounds.getY());
        double newW = Math.ceil(bounds.getWidth()) + (double)(newX < bounds.getX() ? 1 : 0);
        double newH = Math.ceil(bounds.getHeight()) + (double)(newY < bounds.getY() ? 1 : 0);
        bounds.setRect(newX, newY, newW, newH);
        return bounds;
    }

    void clipBounds(SunGraphics2D sg2d, Rectangle2D bounds) {
        Region intersection = sg2d.clipRegion.getIntersectionXYWH((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        bounds.setRect(intersection.getLoX(), intersection.getLoY(), intersection.getWidth(), intersection.getHeight());
    }

    BufferedImage getSurfacePixels(SunGraphics2D sg2d, OSXSurfaceData surfaceData, int x, int y, int w, int h) {
        BufferedImage dstInPixels = surfaceData.getCompositingDstInImage(w, h);
        return surfaceData.copyArea(sg2d, x, y, w, h, dstInPixels);
    }

    void composite(SunGraphics2D sg2d, OSXSurfaceData surfaceData, BufferedImage srcPixels, Rectangle2D compositingBounds) {
        int x = (int)compositingBounds.getX();
        int y = (int)compositingBounds.getY();
        int w = (int)compositingBounds.getWidth();
        int h = (int)compositingBounds.getHeight();
        boolean succeded = false;
        Composite composite = sg2d.getComposite();
        if (composite instanceof XORComposite) {
            try {
                succeded = surfaceData.xorSurfacePixels(sg2d, srcPixels, x, y, w, h, ((XORComposite)composite).getXorColor().getRGB());
            }
            catch (Exception e) {
                succeded = false;
            }
        }
        if (!succeded) {
            BufferedImage dstInPixels = this.getSurfacePixels(sg2d, surfaceData, x, y, w, h);
            BufferedImage dstOutPixels = null;
            if (composite instanceof XORComposite) {
                try {
                    OSXSurfaceData osxsd = (OSXSurfaceData)BufImgSurfaceData.createData(dstInPixels);
                    succeded = osxsd.xorSurfacePixels(sg2d, srcPixels, 0, 0, w, h, ((XORComposite)composite).getXorColor().getRGB());
                    dstOutPixels = dstInPixels;
                }
                catch (Exception e) {
                    succeded = false;
                }
            }
            if (!succeded) {
                dstOutPixels = surfaceData.getCompositingDstOutImage(w, h);
                WritableRaster srcRaster = srcPixels.getRaster();
                WritableRaster dstInRaster = dstInPixels.getRaster();
                WritableRaster dstOutRaster = dstOutPixels.getRaster();
                CompositeContext compositeContext = composite.createContext(srcPixels.getColorModel(), dstOutPixels.getColorModel(), sg2d.getRenderingHints());
                compositeContext.compose(srcRaster, dstInRaster, dstOutRaster);
                compositeContext.dispose();
            }
            Composite savedComposite = sg2d.getComposite();
            AffineTransform savedTM = sg2d.getTransform();
            int savedCX = sg2d.constrainX;
            int savedCY = sg2d.constrainY;
            sg2d.setComposite(AlphaComposite.SrcOver);
            sg2d.constrainX = 0;
            sg2d.constrainY = 0;
            sg2d.setTransform(sIdentityMatrix);
            sg2d.drawImage(dstOutPixels, x, y, x + w, y + h, 0, 0, w, h, null);
            sg2d.constrainX = savedCX;
            sg2d.constrainY = savedCY;
            sg2d.setTransform(savedTM);
            sg2d.setComposite(savedComposite);
        }
    }
}

