/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.image.DataBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public final class DataBufferNIOInt
extends DataBuffer {
    IntBuffer data;
    IntBuffer[] bankdata;

    public DataBufferNIOInt(int size) {
        super(3, size);
        this.data = this.getBufferOfSize(size * 4).asIntBuffer();
        this.bankdata = new IntBuffer[1];
        this.bankdata[0] = this.data;
    }

    public IntBuffer getBuffer() {
        return this.data;
    }

    public IntBuffer getBuffer(int bank) {
        return this.bankdata[bank];
    }

    public int[] getData() {
        return this.data.array();
    }

    public int[] getData(int bank) {
        return this.bankdata[bank].array();
    }

    public int[][] getBankData() {
        return null;
    }

    @Override
    public int getElem(int i) {
        return this.data.get(i + this.offset);
    }

    @Override
    public int getElem(int bank, int i) {
        return this.bankdata[bank].get(i + this.offsets[bank]);
    }

    @Override
    public void setElem(int i, int val) {
        this.data.put(i + this.offset, val);
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.bankdata[bank].put(i + this.offsets[bank], val);
    }

    ByteBuffer getBufferOfSize(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }
}

